/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hies.common.util.TemplateFormCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class TemplateAssignUserPlugin
extends HRBaseDataCommonEdit
implements BeforeF7SelectListener {
    public static final String FORM_DEPEMPF7QUERYLIST = "hrpi_depempf7querylist";
    public static final String FORM_BOS_USER = "bos_user";
    public static final String FORM_DIAETPLCONF = "hies_diaetplconf";
    public static final String ACTION_USEROBJ_HELP = "closeCallBack_userObj_Help";

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    private void addListener() {
        this.addItemClickListeners(new String[]{"toolbar_user"});
        Toolbar userToolBar = (Toolbar)this.getControl("toolbar_user");
        userToolBar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (itemKey.equals("user_new")) {
                    Set<String> rowIdSet = TemplateFormCommonUtil.getAllListIdSet(TemplateAssignUserPlugin.this.getModel(), "userlist", "user");
                    HashSet<Long> selectedUserIdSet = new HashSet<Long>(rowIdSet.size());
                    for (String rowId : rowIdSet) {
                        selectedUserIdSet.add(Long.parseLong(rowId));
                    }
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)TemplateAssignUserPlugin.FORM_BOS_USER, (boolean)true, (int)2);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)TemplateAssignUserPlugin.this, TemplateAssignUserPlugin.ACTION_USEROBJ_HELP));
                    List qFilters = lsp.getListFilterParameter().getQFilters();
                    qFilters.add(new QFilter("id", "not in", selectedUserIdSet));
                    String permissionStatus = "";
                    OperationStatus operationStatus = TemplateAssignUserPlugin.this.getView().getFormShowParameter().getStatus();
                    if (operationStatus == OperationStatus.ADDNEW) {
                        permissionStatus = "47156aff000000ac";
                    } else if (operationStatus == OperationStatus.EDIT) {
                        permissionStatus = "4715a0df000000ac";
                    }
                    QFilter resultQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), BizAppServiceHelp.getAppIdByFormNum((String)TemplateAssignUserPlugin.FORM_DIAETPLCONF), TemplateAssignUserPlugin.FORM_DIAETPLCONF, "user", permissionStatus, null, null});
                    if (Objects.nonNull(resultQFilter)) {
                        qFilters.add(resultQFilter);
                    }
                    TemplateAssignUserPlugin.this.getView().showForm((FormShowParameter)lsp);
                }
            }
        });
    }

    public void afterLoadData(EventObject e) {
        this.buildAndRestoreUser();
    }

    private void buildAndRestoreUser() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("userlist");
        List<Long> userIds = collection.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.get("user"))).map(dynamicObject -> ((DynamicObject)dynamicObject.get("user")).getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        Map<Long, Map<String, Object>> userMap = this.getUerMap(userIds);
        for (DynamicObject dynamicObject2 : collection) {
            Long userId = ((DynamicObject)dynamicObject2.get("user")).getLong("id");
            Map<String, Object> data = userMap.get(userId);
            dynamicObject2.set("position", data.get("position"));
            dynamicObject2.set("userorg", data.get("adminorg"));
            dynamicObject2.set("company", data.get("company"));
        }
        this.getView().updateView("userlist");
    }

    private Map<Long, Map<String, Object>> getUerMap(List<Long> userIds) {
        int size = userIds.size();
        HashMap<Long, Long> userPersonMap = new HashMap<Long, Long>(size);
        for (Long userId : userIds) {
            Map data;
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
            if (ObjectUtils.isEmpty((Object)result) || ObjectUtils.isEmpty((Object)(data = (Map)result.get("data")))) continue;
            Long person = (Long)data.get("person");
            userPersonMap.put(userId, person);
        }
        QFilter qFilter = new QFilter("hrpi_person.id", "in", userPersonMap.values());
        QFilter posstautsFilter = new QFilter("hrpi_empposorgrel.posstatus.number", "=", (Object)"1020_S");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personf7query");
        DataSet ds = serviceHelper.queryMultiEntityDataSet("hrpi_person.id,hrpi_empposorgrel.posstatus.name,hrpi_empposorgrel.posstatus.number,hrpi_empposorgrel.position.name,hrpi_empposorgrel.adminorg.name,hrpi_empposorgrel.company.name", new QFilter[]{qFilter, posstautsFilter}, null, false, 0, 100);
        RowMeta rowMeta = ds.getRowMeta();
        Iterator iter = ds.iterator();
        DynamicObjectCollection dynamicObjects = ORMUtil.toDynamicObjectCollection((Iterator)iter, (RowMeta)rowMeta, (String)"hrpi_personf7query");
        Map<Long, DynamicObject> personMap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("hrpi_person.id"), dynamicObject -> dynamicObject));
        HashMap<Long, Map<String, Object>> userInfoMap = new HashMap<Long, Map<String, Object>>(size);
        for (Long userId : userIds) {
            DynamicObject dynamicObject2;
            Long personId = (Long)userPersonMap.get(userId);
            String position = "";
            String adminorg = "";
            String company = "";
            if (Objects.nonNull(personId) && Objects.nonNull(dynamicObject2 = personMap.get(personId))) {
                position = dynamicObject2.getString("hrpi_empposorgrel.position.name");
                adminorg = dynamicObject2.getString("hrpi_empposorgrel.adminorg.name");
                company = dynamicObject2.getString("hrpi_empposorgrel.company.name");
            }
            HashMap<String, String> data = new HashMap<String, String>(5);
            data.put("position", position);
            data.put("adminorg", adminorg);
            data.put("company", company);
            userInfoMap.put(userId, data);
        }
        return userInfoMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (ACTION_USEROBJ_HELP.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            int size = lsrc.size();
            HashMap<Long, String> userInfos = new HashMap<Long, String>(size);
            for (ListSelectedRow listSelectedRow : lsrc) {
                Object pkValue = listSelectedRow.getPrimaryKeyValue();
                String dimObjName = listSelectedRow.getName();
                userInfos.put((Long)pkValue, dimObjName);
            }
            this.fillRoleObjList(userInfos);
        }
    }

    private void fillRoleObjList(Map<Long, String> userInfos) {
        if (CollectionUtils.isEmpty(userInfos)) {
            return;
        }
        int size = userInfos.size();
        HashMap<Long, Long> userPersonMap = new HashMap<Long, Long>(size);
        for (Long userId : userInfos.keySet()) {
            Map data;
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
            if (ObjectUtils.isEmpty((Object)result) || ObjectUtils.isEmpty((Object)(data = (Map)result.get("data")))) continue;
            Long person = (Long)data.get("person");
            userPersonMap.put(userId, person);
        }
        QFilter qFilter = new QFilter("hrpi_person.id", "in", userPersonMap.values());
        QFilter posstautsFilter = new QFilter("hrpi_empposorgrel.posstatus.number", "=", (Object)"1020_S");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personf7query");
        DataSet ds = serviceHelper.queryMultiEntityDataSet("hrpi_person.id,hrpi_empposorgrel.posstatus.name,hrpi_empposorgrel.posstatus.number,hrpi_empposorgrel.position.name,hrpi_empposorgrel.adminorg.name,hrpi_empposorgrel.company.name", new QFilter[]{qFilter, posstautsFilter}, null, false, 0, 100);
        RowMeta rowMeta = ds.getRowMeta();
        Iterator iter = ds.iterator();
        DynamicObjectCollection data = ORMUtil.toDynamicObjectCollection((Iterator)iter, (RowMeta)rowMeta, (String)"hrpi_personf7query");
        Map<Long, DynamicObject> personMap = data.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("hrpi_person.id"), dynamicObject -> dynamicObject, (k1, k2) -> k1));
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("user", new Object[0]);
        vs.addField("position", new Object[0]);
        vs.addField("userorg", new Object[0]);
        vs.addField("company", new Object[0]);
        for (Long userId : userInfos.keySet()) {
            DynamicObject dynamicObject2;
            Long person = (Long)userPersonMap.get(userId);
            String position = "";
            String adminorg = "";
            String company = "";
            if (Objects.nonNull(person) && Objects.nonNull(dynamicObject2 = personMap.get(person))) {
                position = dynamicObject2.getString("hrpi_empposorgrel.position.name");
                adminorg = dynamicObject2.getString("hrpi_empposorgrel.adminorg.name");
                company = dynamicObject2.getString("hrpi_empposorgrel.company.name");
            }
            vs.addRow(new Object[]{userId, position, adminorg, company});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("userlist", vs);
        this.getModel().endInit();
        this.getView().updateView("userlist");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String propertyName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }
}

