/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.CustomTabPage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class TemplateBDFieldSheetPlugin
extends AbstractFormPlugin {
    private static final String KEY_PANEL_SUFFIX = "panel";
    private static final String FCONTROL_TABPAGEAP = "tabap";
    public static final String PARAM_CUSTOM_TABPAGES = "customTabPages";
    public static final String TAB_PAGEKEY = "tabPageKey";
    public static final String TAB_PAGENAME = "tabPageName";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray customTabPages = (JSONArray)customParams.get(PARAM_CUSTOM_TABPAGES);
        if (customTabPages == null || customTabPages.isEmpty()) {
            return;
        }
        String selectFieldValues = (String)customParams.get("sheetbdfields");
        int tabSize = customTabPages.size();
        if (tabSize > 1) {
            Map selectFieldMap = new HashMap(tabSize);
            if (StringUtils.isNotBlank((CharSequence)selectFieldValues)) {
                selectFieldMap = (Map)JSON.parseObject((String)selectFieldValues, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
            }
            for (Object customTabPage : customTabPages) {
                JSONObject jsonObject = (JSONObject)customTabPage;
                String tabPageKey = jsonObject.getString(TAB_PAGEKEY);
                this.addTabPage(this.getView(), new CustomTabPage(tabPageKey, jsonObject.getString(TAB_PAGENAME)), (String)selectFieldMap.get(tabPageKey));
            }
        } else {
            JSONObject jsonObject = (JSONObject)customTabPages.get(0);
            String tabPageKey = jsonObject.getString(TAB_PAGEKEY);
            this.addTabPage(this.getView(), new CustomTabPage(tabPageKey, jsonObject.getString(TAB_PAGENAME)), selectFieldValues);
        }
    }

    public void addTabPage(IFormView formView, CustomTabPage tabPage, String selectFieldValues) {
        Container container = (Container)this.getView().getControl(FCONTROL_TABPAGEAP);
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setId(tabPage.getTabPageKey());
        tabPageAp.setKey(tabPage.getTabPageKey());
        tabPageAp.setName(new LocaleString(tabPage.getTabPageName()));
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(tabPage.getTabPageKey() + KEY_PANEL_SUFFIX);
        flexPanelAp.setId(tabPage.getTabPageKey() + KEY_PANEL_SUFFIX);
        flexPanelAp.createControl();
        tabPageAp.getItems().add(flexPanelAp);
        container.addControls((List)Lists.newArrayList((Object[])new Map[]{tabPageAp.createControl()}));
        formView.updateView(FCONTROL_TABPAGEAP);
        this.showFormInContainer(tabPage.getTabPageKey(), selectFieldValues);
    }

    public void showFormInContainer(String tabPageKey, String selectFieldValues) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("formId", "hies_basedatafield");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)10);
        customParams.put("baseDataKey", tabPageKey);
        customParams.put("sheetbdfields", selectFieldValues);
        showParameter.setCustomParams((Map)customParams);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(tabPageKey);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray customTabPages = (JSONArray)customParams.get(PARAM_CUSTOM_TABPAGES);
            if (customTabPages == null || customTabPages.isEmpty()) {
                return;
            }
            int baseDataTypeSize = customTabPages.size();
            LinkedHashMap selectFieldResult = new LinkedHashMap(baseDataTypeSize);
            LinkedHashMap selectFieldNameResult = new LinkedHashMap(baseDataTypeSize);
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
            HashSet<String> noSelectFieldTabs = new HashSet<String>(baseDataTypeSize);
            for (Object customTabPage : customTabPages) {
                JSONObject jSONObject = (JSONObject)customTabPage;
                String tabPageKey = jSONObject.getString(TAB_PAGEKEY);
                String selectFields = this.getPageCache().get(tabPageKey);
                if (StringUtils.isNotBlank((CharSequence)selectFields)) {
                    if (!CollectionUtils.isEmpty(noSelectFieldTabs)) continue;
                    Map selectFieldMap = (Map)JSON.parseObject((String)selectFields, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
                    selectFieldResult.put(tabPageKey, selectFieldMap.get("selectfieldvalue"));
                    selectFieldNameResult.put(jSONObject.getString(TAB_PAGENAME), selectFieldMap.get("selectfieldname"));
                    continue;
                }
                noSelectFieldTabs.add(jSONObject.getString(TAB_PAGENAME));
            }
            if (CollectionUtils.isNotEmpty(noSelectFieldTabs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)HiesCommonRes.TemplateBDFieldSheetPlugin_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                return;
            }
            if (MapUtils.isNotEmpty(selectFieldResult)) {
                if (baseDataTypeSize == 1) {
                    returnMap.put("selectfieldvalue", Joiner.on((String)",").join(selectFieldResult.values()));
                } else {
                    returnMap.put("selectfieldvalue", JSON.toJSONString(selectFieldResult));
                }
            }
            if (MapUtils.isNotEmpty(selectFieldNameResult)) {
                if (baseDataTypeSize == 1) {
                    returnMap.put("selectfieldname", Joiner.on((String)",").join(selectFieldNameResult.values()));
                } else {
                    ArrayList<String> selectFieldNames = new ArrayList<String>(selectFieldNameResult.size());
                    for (Map.Entry entry : selectFieldNameResult.entrySet()) {
                        selectFieldNames.add(((String)entry.getKey()).concat("\uff1a").concat((String)entry.getValue()));
                    }
                    String sign = "\u3002";
                    returnMap.put("selectfieldname", String.join((CharSequence)sign, selectFieldNames).concat(sign));
                }
            }
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }
}

