/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.CustomEventArgs;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.bo.ObjEntityRelation;
import kd.hr.hies.common.bo.ObjJoinEntity;
import kd.hr.hies.common.bo.ObjQueryField;
import kd.hr.hies.common.constant.VirEntityCfgConstants;
import kd.hr.hies.common.util.VirEntityCfgService;
import kd.hr.hies.formplugin.VirEntityCfgEdit;
import kd.hr.hies.formplugin.processor.VirEntityCfgCommonProcessor;

@ExcludeFromJacocoGeneratedReport
public class VirEntityCfgDataProcessor
extends VirEntityCfgCommonProcessor
implements VirEntityCfgConstants {
    public VirEntityCfgDataProcessor(VirEntityCfgEdit plugin) {
        super(plugin);
    }

    public void getAllData(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityNodes = dataMap.get("entityNodes");
        String joinEntitiesStr = SerializationUtils.toJsonString(entityNodes);
        this.getView().getPageCache().put("joinEntities", joinEntitiesStr);
        List<Object> entityRelationBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            List queryEntityBos = JSON.parseArray((String)joinEntitiesStr, ObjJoinEntity.class);
            List<EntityRelationCommonBo> entityRelationCommonBos = queryEntityBos.stream().map(JoinEntityCommonBo::getEntityRelation).filter(Objects::nonNull).collect(Collectors.toList());
            entityRelationBos = this.reverseEntityRelationBos(entityRelationCommonBos);
        }
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelationBos));
        Object queryFields = dataMap.get("queryFields");
        List<ObjQueryField> queryFieldBos = this.getSelectedQueryFields(queryFields);
        VirEntityCfgService.putPageCache(this.getView(), queryFieldBos);
        String operate = (String)dataMap.get("operate");
        if (HRStringUtils.equals((String)operate, (String)"save")) {
            this.getView().invokeOperation("save");
        }
    }

    public List<ObjEntityRelation> reverseEntityRelationBos(List<EntityRelationCommonBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), ObjEntityRelation.class);
    }

    public boolean validateFieldDefineData() {
        List joinEntities = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, ObjJoinEntity.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, ObjEntityRelation.class);
        }
        if (HRStringUtils.isEmpty((String)joinEntitiesStr) || joinEntities.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)HiesCommonRes.VirEntityCfgDataProcessor_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return false;
        }
        if (!this.validateEntityRelation(joinEntities, entityRelations)) {
            return false;
        }
        return this.validateFields();
    }

    private boolean validateFields() {
        String queryFieldsStr = VirEntityCfgService.getPageCache(this.getView());
        List queryFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, ObjQueryField.class);
        }
        if (queryFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)HiesCommonRes.VirEntityCfgDataProcessor_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateEntityRelation(List<ObjJoinEntity> joinEntities, List<ObjEntityRelation> entityRelations) {
        for (ObjJoinEntity joinEntity : joinEntities) {
            if (HRStringUtils.equals((String)joinEntity.getType(), (String)"main")) continue;
            Optional<ObjEntityRelation> relationOptional = entityRelations.stream().filter(relation -> relation != null && HRStringUtils.isNotEmpty((String)relation.getEntityAlias()) && HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny();
            boolean noSet = false;
            if (relationOptional.isPresent()) {
                EntityRelationCommonBo entityRelation;
                List conditions;
                if (HRStringUtils.equals((String)relationOptional.get().getJoinType(), (String)"none")) {
                    noSet = true;
                }
                if ((conditions = (entityRelation = (EntityRelationCommonBo)relationOptional.get()).getConditions()) == null || conditions.isEmpty() || HRStringUtils.isEmpty((String)entityRelation.getJoinType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u6761\u4ef6\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)HiesCommonRes.VirEntityCfgDataProcessor_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                    return false;
                }
            } else {
                noSet = true;
            }
            if (!noSet) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)HiesCommonRes.VirEntityCfgDataProcessor_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

