/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.opplugin.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hies.common.bo.ObjEntityRelation;
import kd.hr.hies.common.bo.ObjJoinEntity;
import kd.hr.hies.common.bo.ObjQueryField;
import kd.hr.hies.common.constant.VirEntityCfgConstants;
import kd.hr.hies.common.util.VirEntityCfgService;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class VirEntityCfgOp
extends HRDataBaseOp
implements VirEntityCfgConstants {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        if (HRStringUtils.equals((String)args.getOperationKey(), (String)"save")) {
            this.save(args);
        } else if (HRStringUtils.equals((String)args.getOperationKey(), (String)"delete")) {
            this.delete(args);
        }
    }

    private void save(BeginOperationTransactionArgs args) {
        String joinEntitiesStr = this.getOption().getVariableValue("joinEntities", "");
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        String entityRelationsStr = this.getOption().getVariableValue("entityRelations", "");
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, ObjJoinEntity.class);
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, ObjQueryField.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, ObjEntityRelation.class);
        }
        DynamicObject searchObj = args.getDataEntities()[0];
        Map<Object, DynamicObject> joinEntityLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> queryFieldLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> entityRelationLoadMap = Collections.emptyMap();
        boolean fromDatabase = searchObj.getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            VirEntityCfgService service = VirEntityCfgService.getInstance();
            DynamicObject[] joinEntityLoads = service.loadJoinEntities(searchObj.getLong("id"));
            joinEntityLoadMap = Arrays.stream(joinEntityLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] queryFieldLoads = service.loadQueryFields(searchObj.getLong("id"));
            queryFieldLoadMap = Arrays.stream(queryFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] entityRelationLoads = service.loadEntityRelations(searchObj.getLong("id"));
            entityRelationLoadMap = Arrays.stream(entityRelationLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        } else {
            long searchObjId = searchObj.getLong("id");
            if (searchObjId == 0L) {
                searchObjId = ORM.create().genLongId("hies_virentitycfg");
                searchObj.set("id", (Object)searchObjId);
            }
        }
        DynamicObject[] joinEntityCol = this.assembleAndSaveJoinEntities(searchObj, joinEntities, joinEntityLoadMap);
        this.assembleAndSaveQueryFields(searchObj, queryFields, queryFieldLoadMap);
        this.assembleAndSaveEntityRelations(searchObj, entityRelations, entityRelationLoadMap, joinEntityCol);
    }

    private void delete(BeginOperationTransactionArgs args) {
        List searchObjIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.get("id")).collect(Collectors.toList());
        QFilter anObjQFilter = new QFilter("virentitycfg", "in", searchObjIds);
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hies_virobjjoinentity");
        joinEntityHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hies_virobjqueryfield");
        queryFieldHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hies_virobjentityrel");
        entityRelationHelper.deleteByFilter(new QFilter[]{anObjQFilter});
    }

    private DynamicObject[] assembleAndSaveJoinEntities(DynamicObject searchObjDy, List<ObjJoinEntity> joinEntities, Map<Object, DynamicObject> joinEntityLoadMap) {
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hies_virobjjoinentity");
        DynamicObjectCollection joinEntityCol = new DynamicObjectCollection();
        Set<Long> ids = joinEntities.stream().map(joinEntityBo -> this.getLongId(joinEntityBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, joinEntityLoadMap);
        Set entityNums = joinEntities.stream().map(JoinEntityCommonBo::getEntityNumber).collect(Collectors.toSet());
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] entityDys = entityHelper.query("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, ILocaleString> entityNumMap = Arrays.stream(entityDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLocaleString("name")));
        for (ObjJoinEntity joinEntity : joinEntities) {
            DynamicObject joinDy = joinEntityLoadMap.get(this.getLongId(joinEntity.getId()));
            if (joinDy == null) {
                joinDy = joinEntityHelper.generateEmptyDynamicObject();
            }
            joinDy.set("virentitycfg", searchObjDy.get("id"));
            joinDy.set("index", (Object)joinEntity.getIndex());
            joinDy.set("longnumber", (Object)joinEntity.getLongNumber());
            joinDy.set("entitynumber", (Object)joinEntity.getEntityNumber());
            joinDy.set("entityalias", (Object)joinEntity.getEntityAlias());
            joinDy.set("type", (Object)joinEntity.getType());
            ILocaleString entityName = entityNumMap.get(joinEntity.getEntityNumber());
            joinDy.set("entityname", (Object)entityName);
            joinEntityCol.add((Object)joinDy);
        }
        joinEntityHelper.delete(deleteIds.toArray(new Object[0]));
        return (DynamicObject[])joinEntityHelper.save(joinEntityCol);
    }

    private void assembleAndSaveQueryFields(DynamicObject searchObjDy, List<ObjQueryField> queryFields, Map<Object, DynamicObject> queryFieldLoadMap) {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hies_virobjqueryfield");
        DynamicObjectCollection queryFieldCol = new DynamicObjectCollection();
        Set<Long> ids = queryFields.stream().map(queryFieldBo -> this.getLongId(queryFieldBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, queryFieldLoadMap);
        Map<String, DynamicObject> fieldAliasToFieldLoadMap = queryFieldLoadMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("fieldalias"), dy -> dy));
        long newIdCount = queryFields.stream().filter(field -> HRStringUtils.isEmpty((String)field.getId())).count();
        long[] newIds = new long[1];
        int idIndex = 0;
        if (newIdCount > 0L) {
            newIds = ID.genLongIds((int)Integer.parseInt(String.valueOf(newIdCount)));
        }
        HashMap<String, Integer> maxSuffixs = new HashMap<String, Integer>(queryFields.size());
        for (ObjQueryField queryField : queryFields) {
            String entityNumber;
            String fieldNumber = queryField.getFieldNumber();
            String fieldAlias = queryField.getFieldAlias();
            DynamicObject queryFieldDy = fieldAliasToFieldLoadMap.get(fieldAlias);
            if (queryFieldDy == null) {
                queryFieldDy = queryFieldHelper.generateEmptyDynamicObject();
                long newId = newIds[idIndex++];
                queryFieldDy.set("id", (Object)newId);
                this.dealComFields(queryFieldDy);
                queryField.setId(String.valueOf(newId));
                queryFieldDy.set("virentitycfg", searchObjDy.get("id"));
                entityNumber = queryField.getEntityNumber();
                queryFieldDy.set("entitynumber", (Object)entityNumber);
                queryFieldDy.set("fieldalias", (Object)fieldAlias);
                queryFieldDy.set("fieldpath", (Object)queryField.getFieldPath());
                queryFieldDy.set("valuetype", (Object)queryField.getValueType());
                queryFieldDy.set("complextype", (Object)queryField.getComplexType());
                queryFieldDy.set("controltype", (Object)queryField.getControlType());
                queryFieldDy.set("entity", (Object)entityNumber);
                queryFieldDy.set("isentryfield", (Object)queryField.getEntryFieldFlag());
                queryFieldDy.set("issubentryfield", (Object)queryField.getSubEntryFieldFlag());
                LocaleString oriFieldName = queryField.getOriFieldName();
                if (ObjectUtils.isEmpty((Object)oriFieldName)) {
                    queryFieldDy.set("orifieldname", (Object)queryField.getFieldName());
                } else {
                    int nullValCount = 0;
                    for (String langVal : oriFieldName.keySet()) {
                        if (!StringUtils.isBlank((CharSequence)((CharSequence)oriFieldName.getItem(langVal)))) continue;
                        ++nullValCount;
                    }
                    if (oriFieldName.size() == nullValCount) {
                        queryFieldDy.set("orifieldname", (Object)queryField.getFieldName());
                    } else {
                        queryFieldDy.set("orifieldname", (Object)oriFieldName);
                    }
                }
            } else {
                long id = queryFieldDy.getLong("id");
                if (id == 0L) {
                    long newId = newIds[idIndex++];
                    queryFieldDy.set("id", (Object)newId);
                }
                entityNumber = queryFieldDy.getString("entitynumber");
            }
            queryFieldDy.set("fieldname", (Object)queryField.getFieldName());
            queryFieldCol.add((Object)queryFieldDy);
            if (StringUtils.isBlank((CharSequence)fieldNumber)) continue;
            String prefix = entityNumber + ".";
            String tranFieldName = fieldAlias.startsWith(prefix) ? "hr_" + fieldAlias.substring(fieldAlias.indexOf(".") + 1) : "hr_" + fieldAlias;
            if (StringUtils.isBlank((CharSequence)(fieldNumber = fieldNumber.replace(tranFieldName = tranFieldName.replaceAll("\\.", "_"), "")))) {
                maxSuffixs.put(tranFieldName, 0);
                continue;
            }
            try {
                int curSuffix = Integer.parseInt(fieldNumber);
                Integer preSuffix = (Integer)maxSuffixs.get(tranFieldName);
                if (ObjectUtils.isEmpty((Object)preSuffix)) {
                    maxSuffixs.put(tranFieldName, curSuffix);
                    continue;
                }
                if (curSuffix <= preSuffix) continue;
                maxSuffixs.put(tranFieldName, curSuffix);
            }
            catch (Exception curSuffix) {}
        }
        for (DynamicObject queryFieldDy : queryFieldCol) {
            String entityNumber;
            String prefix;
            String fieldNumber = queryFieldDy.getString("fieldnumber");
            if (!StringUtils.isBlank((CharSequence)fieldNumber)) continue;
            String fieldAlias = queryFieldDy.getString("fieldalias");
            String tranFieldName = fieldAlias.startsWith(prefix = (entityNumber = queryFieldDy.getString("entitynumber")) + ".") ? "hr_" + fieldAlias.substring(fieldAlias.indexOf(".") + 1) : "hr_" + fieldAlias;
            Integer preSuffix = (Integer)maxSuffixs.get(tranFieldName = tranFieldName.replaceAll("\\.", "_"));
            if (ObjectUtils.isNotEmpty((Object)preSuffix)) {
                int curSuffix = preSuffix + 1;
                maxSuffixs.put(tranFieldName, curSuffix);
                queryFieldDy.set("fieldnumber", (Object)(tranFieldName + curSuffix));
                continue;
            }
            maxSuffixs.put(tranFieldName, 0);
            queryFieldDy.set("fieldnumber", (Object)tranFieldName);
        }
        queryFieldHelper.delete(deleteIds.toArray(new Object[0]));
        queryFieldHelper.save(queryFieldCol);
    }

    private void dealComFields(DynamicObject queryFieldDy) {
        queryFieldDy.set("status", (Object)"C");
        queryFieldDy.set("enable", (Object)"1");
        queryFieldDy.set("index", (Object)0);
        queryFieldDy.set("masterid", queryFieldDy.get("id"));
        queryFieldDy.set("disabler", (Object)0);
    }

    private void assembleAndSaveEntityRelations(DynamicObject searchObjDy, List<ObjEntityRelation> entityRelations, Map<Object, DynamicObject> entityRelationLoadMap, DynamicObject[] joinEntityCol) {
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hies_virobjentityrel");
        DynamicObjectCollection entityRelationCol = new DynamicObjectCollection();
        Set<Long> ids = entityRelations.stream().map(entityRelationBo -> this.getLongId(entityRelationBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, entityRelationLoadMap);
        Map<Object, DynamicObject> joinEntityMap = Arrays.stream(joinEntityCol).collect(Collectors.toMap(entity -> entity.get("entityalias"), entity -> entity));
        for (ObjEntityRelation entityRelation : entityRelations) {
            DynamicObject entityRelationDy = entityRelationLoadMap.get(this.getLongId(entityRelation.getId()));
            if (entityRelationDy == null) {
                entityRelationDy = entityRelationHelper.generateEmptyDynamicObject();
            }
            entityRelationDy.set("virentitycfg", searchObjDy.get("id"));
            DynamicObject entityDy = joinEntityMap.get(entityRelation.getEntityAlias());
            entityRelationDy.set("entityid", entityDy.getPkValue());
            entityRelationDy.set("jointype", (Object)entityRelation.getJoinType());
            DynamicObject joinEntityDy = joinEntityMap.get(entityRelation.getJoinEntityAlias());
            entityRelationDy.set("joinentityid", joinEntityDy.getPkValue());
            DynamicObjectCollection joinConditionCol = entityRelationHelper.generateEmptyEntryCollection(entityRelationDy, "joinconditions");
            List joinConditions = entityRelation.getConditions();
            int index = 0;
            for (JoinConditionBo joinCondition : joinConditions) {
                DynamicObject joinConditionDy = entityRelationHelper.generateEmptyEntryDynamicObject("joinconditions");
                joinConditionDy.set("seq", (Object)index++);
                joinConditionDy.set("leftprop", (Object)joinCondition.getLeftProp());
                joinConditionDy.set("comparetype", (Object)joinCondition.getCompareType());
                joinConditionDy.set("rightprop", (Object)joinCondition.getRightProp());
                joinConditionDy.set("rightproptype", (Object)joinCondition.getRightPropType());
                joinConditionDy.set("rightpropval", (Object)joinCondition.getRightPropVal());
                joinConditionDy.set("logictype", (Object)joinCondition.getLogicType());
                joinConditionCol.add((Object)joinConditionDy);
            }
            entityRelationDy.set("joinconditions", (Object)joinConditionCol);
            entityRelationCol.add((Object)entityRelationDy);
        }
        entityRelationHelper.delete(deleteIds.toArray(new Object[0]));
        entityRelationHelper.save(entityRelationCol);
    }

    private List<Object> getDeleteId(Set<Long> ids, Map<Object, DynamicObject> dyMap) {
        ArrayList deleteIds = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dy : dyMap.values()) {
            Long id = dy.getLong("id");
            if (ids.contains(id)) continue;
            deleteIds.add(id);
        }
        return deleteIds;
    }

    private Long getLongId(String strId) {
        if (HRStringUtils.isEmpty((String)strId)) {
            return 0L;
        }
        return Long.valueOf(strId);
    }
}

