/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.business.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.DataTypeHelper;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.hies.business.export.F7BdWriteFormat;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.plugin.BaseAfterQueryRefBdEventArgs;
import kd.hr.hies.common.plugin.BaseBeforeQueryRefBdEventArgs;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.TemplateExportAttrUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class ExportWriterBuilder {
    public static final String BIZOBJECT = "bizobject";
    private static final String NUMBER = "number";
    private static final Log log = LogFactory.getLog(ExportWriterBuilder.class);
    private static final String BASEDATA_KEY_IS_HR_PERSON = "isHRPerson";
    private static final String BASEDATA_KEY_NUMBER_FIELD = "numberField";
    private static final String BASEDATA_KEY_NAME_FIELD = "nameField";
    private static final String BASEDATA_KEY_RESULT_DY_OBJS = "resultDyObjs";
    private static final String BASEDATA_KEY_SELECTFIELDS = "selectFields";
    private static final String FLEX_PROP_GROUPS = "flexpropgroups";
    private String kdName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_0", (String)"hrmp-hies-import", (Object[])new Object[0]);
    private String kdCode = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)"hrmp-hies-import", (Object[])new Object[0]);
    private String kdId = ResManager.loadKDString((String)"\u5185\u7801", (String)"ExportWriterBuilder_2", (String)"hrmp-hies-import", (Object[])new Object[0]);

    public List<ExportHeaderWriterFormat> build(DynamicObject templateData, DynamicObject sysparam, Map<String, Object> mapParam) {
        String entitytype = templateData.getString("entitytype");
        String mainEntityName = templateData.getString("entity.id");
        HashMap fieldSetMapping = Maps.newHashMapWithExpectedSize((int)6);
        HashMap cusFieldMap = Maps.newHashMapWithExpectedSize((int)6);
        HashMap virtualFieldMap = Maps.newHashMapWithExpectedSize((int)6);
        HashMap entityHasFieldimportdesc = Maps.newHashMapWithExpectedSize((int)4);
        boolean isQueryEntity = false;
        String tmpltype = templateData.getString("tmpltype");
        mapParam.put("tmpltype", tmpltype);
        boolean isForImport = "IMPT".equalsIgnoreCase(tmpltype);
        String importtype = templateData.getString("importtype");
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        MainEntityType mianEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityName);
        entityTypes.add(mianEntityType);
        DynamicObjectCollection entityrelation = templateData.getDynamicObjectCollection("entityrelation");
        for (DynamicObject child : entityrelation) {
            MainEntityType childEntityType = EntityMetadataCache.getDataEntityType((String)child.getString("rentity.id"));
            entityTypes.add(childEntityType);
        }
        DynamicObjectCollection templateEntry = templateData.getDynamicObjectCollection("tpltreeentryentity");
        Map<Long, DynamicObject> entryIdField = templateEntry.stream().filter(item -> item.getString("fieldnumber").endsWith(".id")).collect(Collectors.toMap(dy -> dy.getLong("pid"), dy -> dy));
        Map<Long, DynamicObject> treeEntryPidField = templateEntry.stream().filter(item -> item.getString("fieldnumber").endsWith(".pid")).collect(Collectors.toMap(dy -> dy.getLong("pid"), dy -> dy));
        Map roleIdAndParentsList = templateEntry.stream().collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        String entityNumber = "";
        Iterator iterator = roleIdAndParentsList.entrySet().iterator();
        while (iterator.hasNext()) {
            LinkedHashMap<String, DynamicObject> fieldSet = new LinkedHashMap<String, DynamicObject>();
            LinkedHashMap<String, List> cusFieldSet = new LinkedHashMap<String, List>();
            LinkedHashMap<String, List> virtualFieldSet = new LinkedHashMap<String, List>();
            Map.Entry next = iterator.next();
            AtomicBoolean hasFieldimportdesc = new AtomicBoolean(false);
            for (DynamicObject row : next.getValue()) {
                String attr = row.getString("fieldnumber");
                long pid = row.getLong("pid");
                if (pid != 0L && row.getBoolean("isimport")) {
                    Optional<DynamicObject> pidObj;
                    if (row.getBoolean("iscusfield") && (pidObj = next.getValue().stream().filter(x -> x.getLong("id") == row.getLong("pid")).findFirst()).isPresent()) {
                        String pfieldnumber = pidObj.get().getString("fieldnumber");
                        if (StringUtils.isEmpty((CharSequence)pfieldnumber)) {
                            pfieldnumber = next.getKey();
                        }
                        List cusFields = cusFieldSet.computeIfAbsent(pfieldnumber, x -> new LinkedList());
                        cusFields.add(row);
                    }
                    if (row.getBoolean("isvirfield")) {
                        List virtualFields = virtualFieldSet.computeIfAbsent(next.getKey(), x -> new LinkedList());
                        virtualFields.add(row);
                    }
                    if (!hasFieldimportdesc.get() && StringUtils.isNotEmpty((CharSequence)row.getString("fieldimportdesc"))) {
                        hasFieldimportdesc.set(true);
                        entityHasFieldimportdesc.put(entityNumber, Boolean.TRUE);
                    }
                    this.dealEntryIdPIdField(importtype, entryIdField, treeEntryPidField, fieldSet, pid, hasFieldimportdesc);
                    fieldSet.put(attr, row);
                    continue;
                }
                if (pid != 0L) continue;
                entityNumber = attr;
                fieldSetMapping.put(entityNumber, fieldSet);
                cusFieldMap.put(entityNumber, cusFieldSet);
                virtualFieldMap.put(entityNumber, virtualFieldSet);
            }
        }
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        ArrayList<ExportHeaderWriterFormat> formatlist = new ArrayList<ExportHeaderWriterFormat>(10);
        for (MainEntityType entityType : entityTypes) {
            String enitytName = entityType.getName();
            Map fieldApMap = ExcelStyleUtil.getFieldControlApMap((String)enitytName);
            ExportHeaderWriterFormat writer = new ExportHeaderWriterFormat(enitytName, entityType.getDisplayName().toString(), 0);
            writer.setBelongEntityName(enitytName);
            if (enitytName.equals(mainEntityName)) {
                writer.setMainEntity(true);
                writer.setRowStartIndex(0);
            } else if ("MESS".equals(entitytype)) {
                writer.setRowStartIndex(1);
            }
            writer.setHasFieldimportdesc(entityHasFieldimportdesc.containsKey(enitytName));
            int flexGroups = this.getFlexPropGroups(enitytName);
            String appid = (String)mapParam.get("appId");
            boolean isPreView = "preView".equalsIgnoreCase((String)mapParam.get("source"));
            String entityRightAppPkId = !isPreView && enitytName.equalsIgnoreCase(mainEntityName) ? (StringUtils.isEmpty((CharSequence)appid) ? DataValidateServiceHelper.getPermAppIdPkid(null, enitytName, false) : DataValidateServiceHelper.getPermAppIdPkid(appid, enitytName, true)) : DataValidateServiceHelper.getPermAppIdPkid(null, enitytName, false);
            mapParam.put("entityRightAppPkId", entityRightAppPkId);
            log.info("ExportWriterBuilder_build,enitytName:{},appid:{},entityRightAppPkId:{}", new Object[]{enitytName, appid, entityRightAppPkId});
            HasPermOrgResult hasPermOrg = ImportServiceHelper.getEntityHasPermOrg(enitytName, entityRightAppPkId);
            Map fieldSet = (Map)fieldSetMapping.get(enitytName);
            if (fieldSet == null || fieldSet.size() == 0) {
                String importText = ResManager.loadKDString((String)"\u5bfc\u5165", (String)HiesCommonRes.TemplateSaveValidator_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
                String exportText = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)HiesCommonRes.TemplateSaveValidator_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
                String tip = "IMPT".equalsIgnoreCase(tmpltype) ? importText : exportText;
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6bcf\u4e2a\u5b9e\u4f53\u90fd\u5fc5\u987b\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a%1$s\u5b57\u6bb5\u3002", (String)"ExportWriterBuilder_29", (String)"hrmp-hies-import", (Object[])new Object[0]), tip));
            }
            HashSet<String> f7BDSheetNameSet = new HashSet<String>(16);
            this.parse(enitytName, fieldApMap, sysparam, (DynamicObjectType)entityType, fieldSet, writer, multiLangEnabledLang, isForImport, flexGroups, mapParam, hasPermOrg, f7BDSheetNameSet, (Map)cusFieldMap.get(enitytName), (Map)virtualFieldMap.get(enitytName));
            formatlist.add(writer.ready(MapUtils.isNotEmpty((Map)((Map)fieldSetMapping.get(enitytName))) ? ((Map)fieldSetMapping.get(enitytName)).keySet() : new HashSet(16)));
        }
        return formatlist;
    }

    private int getFlexPropGroups(String formId) {
        int groups = 16;
        DynamicObject billParameter = ParameterReader.getBillParameter((String)formId);
        if (null != billParameter && ((groups = billParameter.getInt(FLEX_PROP_GROUPS)) < 1 || groups > 50)) {
            return 16;
        }
        return groups;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getF7bdSheetName(String sheetName, String sheetNumber, Set<String> f7BDSheetNameSet) {
        if (f7BDSheetNameSet.isEmpty()) {
            f7BDSheetNameSet.add(sheetName);
            return sheetName;
        }
        if (f7BDSheetNameSet.contains(sheetName)) {
            f7BDSheetNameSet.add(sheetName + sheetNumber);
            return sheetName + sheetNumber;
        }
        f7BDSheetNameSet.add(sheetName);
        return sheetName;
    }

    /*
     * Unable to fully structure code
     */
    private int parse(String entityName, Map<String, ControlAp<?>> fieldApMap, DynamicObject sysparam, DynamicObjectType entityType, Map<String, DynamicObject> fieldSet, ExportHeaderWriterFormat writer, List<EnabledLang> enableLangs, boolean isForImport, int flexGroups, Map<String, Object> mapParam, HasPermOrgResult hasPermOrg, Set<String> f7BDSheetNameSet, Map<String, List<DynamicObject>> cusFieldMap, Map<String, List<DynamicObject>> virtualFieldMap) {
        col = writer.getStartColNumber();
        properties = entityType.getProperties();
        entityTypeName = entityType.getName();
        properties = new DataEntityPropertyCollection((List)properties, (IDataEntityType)entityType, false);
        this.addCustomFieldProperties(properties, cusFieldMap.get(entityTypeName));
        this.addCustomFieldProperties(properties, virtualFieldMap.get(entityTypeName));
        for (IDataEntityProperty prop : properties) {
            isID = "id".equalsIgnoreCase(prop.getName());
            isPID = entityType instanceof TreeEntryType != false && "pid".equalsIgnoreCase(prop.getName()) != false;
            fieldInfo = fieldSet.get(prop.getName());
            if (!isID && !isPID && (prop instanceof LongProp || prop instanceof AttachmentProp || prop instanceof DynamicLocaleProperty || prop instanceof IFieldHandle && !this.isFieldExportable(prop, isForImport) && fieldInfo != null && !fieldInfo.getBoolean("iscusfield") && !fieldInfo.getBoolean("isvirfield") || prop instanceof FlexProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((FlexProp)prop).getBasePropertyKey(), isForImport) || prop instanceof ItemClassProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((ItemClassProp)prop).getTypePropName(), isForImport))) continue;
            propName = prop.getName();
            if ((isID || isPID) && !(entityType instanceof MainEntityType)) {
                propName = prop.getParent().getName() + "." + propName;
            }
            if (prop instanceof LinkEntryProp) continue;
            if (prop instanceof EntryProp) {
                subWriter = new ExportHeaderWriterFormat(propName, (((EntryProp)prop).isEntryMustInput() != false ? "*" : "") + prop.getDisplayName().toString(), col + 1);
                subWriter.setBelongEntityName(writer.getBelongEntityName());
                subWriter.setMainEntity(writer.isMainEntity());
                subWriter.setEntryentity(true);
                if (subWriter.isMainEntity()) {
                    if (prop instanceof SubEntryProp) {
                        subWriter.setRowStartIndex(writer.getRowStartIndex());
                    } else {
                        subWriter.setRowStartIndex(writer.getRowStartIndex() + 1);
                    }
                } else {
                    subWriter.setRowStartIndex(writer.getRowStartIndex());
                }
                subWriter.setHasFieldimportdesc(writer.isHasFieldimportdesc());
                subCol = this.parse(entityName, fieldApMap, sysparam, ((EntryProp)prop).getDynamicCollectionItemPropertyType(), fieldSet, subWriter, enableLangs, isForImport, flexGroups, mapParam, hasPermOrg, f7BDSheetNameSet, cusFieldMap, virtualFieldMap);
                if (subCol - col >= 1 && subWriter.getFields().size() > 0) {
                    writer.getNext().add(subWriter);
                    col = subCol;
                    continue;
                }
                col += 2;
                continue;
            }
            if (!(prop instanceof IFieldHandle) || !isID && !isPID && !((IFieldHandle)prop).isImportable() && !((IFieldHandle)prop).isExportable() && (fieldInfo == null || !fieldInfo.getBoolean("iscusfield") && !fieldInfo.getBoolean("isvirfield")) || !fieldSet.isEmpty() && !fieldSet.containsKey(propName)) continue;
            currLang = RequestContext.getOrCreate().getLang().name();
            templateRow = fieldSet.get(propName);
            props = new LinkedList<String>();
            dataKeyProps = new LinkedList<String>();
            propDisplayNames = new LinkedList<String>();
            f7ReferAttrsProp = null;
            isBasedata = prop instanceof IBasedataField;
            isMultiLang = prop instanceof MuliLangTextProp;
            isLargeText = prop instanceof LargeTextProp;
            isRefBillProp = prop instanceof RefBillProp;
            if (isBasedata && templateRow != null) {
                if (isForImport) {
                    this.prepareImptBasedataProps(templateRow, props, dataKeyProps, propDisplayNames, prop, currLang);
                    isSheet = templateRow.getString("issheet");
                    if ("1".equals(isSheet)) {
                        baseProp = (IBasedataField)prop;
                        if (prop instanceof ItemClassProp) {
                            typePropFieldNubmer = ((ItemClassProp)prop).getTypePropName();
                            mainType = EntityMetadataCache.getDataEntityType((String)entityName);
                            typeProperty = (IDataEntityProperty)mainType.getAllFields().get(typePropFieldNubmer);
                            baseEntityIds = ((ItemClassTypeProp)typeProperty).getBaseEntityIds();
                            for (String baseEntityId : baseEntityIds) {
                                baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                                f7BdWriteFormat = new F7BdWriteFormat();
                                sheetName = baseProp.getDisplayName().getLocaleValue().concat("_").concat(baseEntityType.getDisplayName().getLocaleValue());
                                sheetName = this.getF7bdSheetName((String)sheetName, baseProp.getName(), f7BDSheetNameSet);
                                f7BdWriteFormat.setSheetName((String)sheetName);
                                f7BdWriteFormat.setNumber(baseProp.getName());
                                f7BdWriteFormat.setBaseEntityId(baseEntityId);
                                f7BdWriteFormat.setSeq(fieldInfo.getInt("seq"));
                                bdNumberNameText = MethodUtil.getBdNumberNameText((MainEntityType)baseEntityType);
                                f7BdWriteFormat.setHeadNameText((String)bdNumberNameText.get("name"));
                                f7BdWriteFormat.setHeadNumberText((String)bdNumberNameText.get("number"));
                                if ("number_name".equalsIgnoreCase(templateRow.getString("imptattr"))) {
                                    f7BdWriteFormat.setHeadNumberAndNameText(f7BdWriteFormat.getHeadNumberText().concat("##").concat(f7BdWriteFormat.getHeadNameText()));
                                }
                                if (StringUtils.isNotBlank((CharSequence)(sheetBDFields = templateRow.getString("sheetbdfields")))) {
                                    try {
                                        selectFieldMap = (Map)JSON.parseObject((String)sheetBDFields, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
                                        sheetBDFields = (String)selectFieldMap.get(baseEntityId);
                                    }
                                    catch (Exception selectFieldMap) {
                                        // empty catch block
                                    }
                                }
                                this.getSheetBaseData(entityName, f7BdWriteFormat, prop, mapParam, writer, prop.getName(), hasPermOrg, sheetBDFields);
                                writer.getF7BdWriteFormats().add(f7BdWriteFormat);
                            }
                        } else {
                            f7BdWriteFormat = new F7BdWriteFormat();
                            sheetName = this.getF7bdSheetName(baseProp.getDisplayName().getLocaleValue(), baseProp.getName(), f7BDSheetNameSet);
                            f7BdWriteFormat.setSheetName(sheetName);
                            f7BdWriteFormat.setNumber(baseProp.getName());
                            f7BdWriteFormat.setBaseEntityId(baseProp.getBaseEntityId());
                            f7BdWriteFormat.setSeq(fieldInfo.getInt("seq"));
                            bdNumberNameText = MethodUtil.getBdNumberNameText((IDataEntityProperty)prop);
                            f7BdWriteFormat.setHeadNameText((String)bdNumberNameText.get("name"));
                            f7BdWriteFormat.setHeadNumberText((String)bdNumberNameText.get("number"));
                            if ("number_name".equalsIgnoreCase(templateRow.getString("imptattr"))) {
                                f7BdWriteFormat.setHeadNumberAndNameText(f7BdWriteFormat.getHeadNumberText().concat("##").concat(f7BdWriteFormat.getHeadNameText()));
                            }
                            sheetBDFields = templateRow.getString("sheetbdfields");
                            predata = this.getSheetBaseData(entityName, f7BdWriteFormat, prop, mapParam, writer, prop.getName(), hasPermOrg, sheetBDFields);
                            writer.getF7BdWriteFormats().add(f7BdWriteFormat);
                        }
                    }
                } else {
                    f7ReferAttrsProp = TemplateExportAttrUtil.getF7ReferAttrsProp((IDataEntityProperty)prop);
                    this.prepareExptBasedataProps(templateRow, props, dataKeyProps, propDisplayNames, prop, f7ReferAttrsProp);
                }
            } else if (isLargeText) {
                this.prepareLargeTextProps(props, propDisplayNames, prop, propName);
            }
            property = new HashMap<String, Object>(16);
            property.put("Prop", prop);
            property.put("propName", propName);
            displayName = prop.getDisplayName();
            if (isID) {
                property.put("InputType", "id");
                displayName = new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ExportWriterBuilder_2", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder = new StringBuilder(ResManager.loadKDString((String)"1.\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\uff1b", (String)"ExportWriterBuilder_51", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"2.\u5982\u9700\u66f4\u65b0\u5206\u5f55\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u5185\u7801\uff1b\u65b0\u589e\u5206\u5f55\uff0c\u65e0\u9700\u586b\u5199\uff1b", (String)"ExportWriterBuilder_52", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"3.\u83b7\u53d6\u5185\u7801\u65b9\u5f0f\uff1a\u4f7f\u7528\u201c\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u201d\uff0c\u5219\u53ef\u5bfc\u51fa\u5206\u5f55\u7684\u5185\u7801\u3002", (String)"ExportWriterBuilder_53", (String)"hrmp-hies-import", (Object[])new Object[0]));
                property.put("InputDesc", builder.toString());
            } else if (isPID) {
                property.put("InputType", "pid");
                displayName = new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ExportWriterBuilder_4", (String)"hrmp-hies-import", (Object[])new Object[0]));
            } else if (isLargeText) {
                property.put("InputType", "largetext");
                property.put("DataKey", "largetext");
            } else if (isMultiLang) {
                property.put("InputType", "multilang");
                property.put("DataKey", currLang);
            } else if (prop instanceof TextProp || prop instanceof VarcharProp) {
                property.put("InputType", "varchar");
            } else if (prop instanceof AdminDivisionProp) {
                property.put("InputType", "varchar");
            } else if (isRefBillProp) {
                property.put("InputType", "varchar");
            } else if (prop instanceof DecimalProp) {
                property.put("InputType", "decimal");
                decimalformat = new HashMap<String, Integer>();
                decimalformat.put("precision", ((DecimalProp)prop).getScale());
                property.put("DecimalFormat", decimalformat);
            } else if (isBasedata) {
                property.put("InputType", prop instanceof FlexProp != false ? "flex" : "basedata");
                property.put("PropType", prop instanceof MulBasedataProp != false ? "MulBasedataProp" : "basedata");
                property.put("propKey", props);
                property.put("propName", propDisplayNames);
                property.put("f7Prop", f7ReferAttrsProp);
                bdEntityName = null;
                if (prop instanceof BasedataProp && !(prop instanceof ItemClassProp) && isForImport) {
                    bdEntityName = ((BasedataProp)prop).getComplexType().getName();
                    maxshownum = sysparam.getInt("maxshownum");
                    baseinfoformat = templateRow.getString("imptattr");
                    predata = this.getTopBaseData(entityName, bdEntityName, prop, baseinfoformat, maxshownum, mapParam, writer, prop.getName(), hasPermOrg);
                    property.put("DropdownValues", predata);
                } else if (prop instanceof MulBasedataProp) {
                    bdEntityName = ((MulBasedataProp)prop).getBaseEntityId();
                }
                property.put("BdEntityName", bdEntityName);
                property.put("imptattr", templateRow.getString("imptattr"));
                property.put("exptattr", templateRow.getString("exptattr"));
                mulDataKey = null;
                if (prop instanceof MulBasedataProp) {
                    mulDataKey = new ArrayList<String>(props.size());
                    for (String p : props) {
                        mulDataKey.add("fbasedataid." + p);
                    }
                }
                property.put("DataKey", mulDataKey == null ? dataKeyProps : mulDataKey);
            } else if (prop instanceof TimeProp) {
                mask = ExcelStyleUtil.getMask(fieldApMap, (IDataEntityProperty)prop);
                property.put("InputType", "time");
                property.put("InputDesc", String.format(ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a%s", (String)"ExportWriterBuilder_10", (String)"hrmp-hies-import", (Object[])new Object[0]), new Object[]{mask}));
            } else if (prop instanceof DateProp) {
                mask = ExcelStyleUtil.getMask(fieldApMap, (IDataEntityProperty)prop);
                property.put("InputType", "date");
                property.put("InputDesc", String.format(ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a%s", (String)"ExportWriterBuilder_11", (String)"hrmp-hies-import", (Object[])new Object[0]), new Object[]{mask}));
            } else if (prop instanceof DateTimeProp) {
                mask = ExcelStyleUtil.getMask(fieldApMap, (IDataEntityProperty)prop);
                property.put("InputType", "datetime");
                property.put("InputDesc", String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a%s", (String)"ExportWriterBuilder_12", (String)"hrmp-hies-import", (Object[])new Object[0]), new Object[]{mask}));
            } else if (prop instanceof BooleanProp) {
                property.put("InputType", "boolean");
                predata = new ArrayList<String>(2);
                predata.add(ResManager.loadKDString((String)"\u662f", (String)"ExportWriterBuilder_13", (String)"hrmp-hies-import", (Object[])new Object[0]));
                predata.add(ResManager.loadKDString((String)"\u5426", (String)"ExportWriterBuilder_14", (String)"hrmp-hies-import", (Object[])new Object[0]));
                property.put("DropdownValues", predata);
            } else if (prop instanceof ComboProp) {
                try {
                    itemList = new ArrayList<E>(((ComboProp)prop).getComboItems());
                    iterator = itemList.iterator();
                    while (iterator.hasNext()) {
                        next = (ValueMapItem)iterator.next();
                        if (next.isItemVisible()) continue;
                        iterator.remove();
                    }
                    items = new ArrayList<String>(itemList.size());
                    itemDesc = new String[itemList.size()];
                    for (index = 0; index < itemList.size(); ++index) {
                        name = ((ValueMapItem)itemList.get(index)).getName().toString();
                        items.add(name);
                        itemDesc[index] = name;
                    }
                    property.put("DropdownValues", items);
                    property.put("InputType", "dropdownList");
                    if (!(prop instanceof MulComboProp)) ** GOTO lbl271
                    property.put("PropType", "MulComboProp");
                    property.put("InputDesc", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a%s\uff0c\u586b\u5199\u591a\u4e2a\u503c\u65f6\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u3002", (String)"ExportWriterBuilder_16", (String)"hrmp-hies-import", (Object[])new Object[0]), new Object[]{String.join((CharSequence)"\u3001", itemDesc)}));
                }
                catch (Throwable e) {
                    ExportWriterBuilder.log.error(e);
                    throw new KDBizException("get combo item list ".concat(prop.getDisplayName().getLocaleValue()).concat("'s failed'\uff1akey=").concat(prop.getName()));
                }
            } else if (prop instanceof FlexProp) {
                property.put("DataKey", "value");
            }
lbl271:
            // 18 sources

            if (fieldSet.containsKey(propName)) {
                tprop = fieldSet.get(propName);
                property.put("MustInput", tprop.getBoolean("ismustinput"));
                property.put("EntityDescription", tprop.getString("EntityDescription"));
                fieldImportDesc = tprop.getString("fieldimportdesc");
                if (StringUtils.isNotBlank((CharSequence)fieldImportDesc)) {
                    property.put("fieldimportdesc", fieldImportDesc);
                    property.put("InputDesc", fieldImportDesc);
                }
            } else if (prop instanceof FieldProp) {
                property.put("MustInput", ((FieldProp)prop).isMustInput());
            } else if (prop instanceof BasedataProp) {
                property.put("MustInput", ((BasedataProp)prop).isMustInput());
            } else if (prop instanceof MulBasedataProp) {
                property.put("MustInput", ((MulBasedataProp)prop).isMustInput());
            }
            if (isBasedata || isMultiLang || isLargeText) {
                items = new ArrayList<String>();
                display = new ArrayList<String>();
                desc = new ArrayList<Object>();
                tprop = fieldSet.get(propName);
                fieldImportDesc = tprop.getString("fieldimportdesc");
                if (prop instanceof FlexProp) {
                    for (i = 0; i < flexGroups; ++i) {
                        items.add(propName);
                        display.add(prop.getDisplayName().getLocaleValue());
                        desc.add("");
                        items.add(propName + ".number");
                        display.add(this.codeToName("number"));
                        desc.add(fieldImportDesc);
                        items.add(propName + ".name");
                        display.add(this.codeToName("name"));
                        desc.add(fieldImportDesc);
                    }
                } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
                    isMulBasedata = prop instanceof MulBasedataProp;
                    basedataColumnKey = propName;
                    basedataColumnName = prop.getDisplayName().getLocaleValue();
                    if (!props.isEmpty()) {
                        for (String p : props) {
                            if (StringUtils.isNotEmpty((CharSequence)p)) {
                                items.add(basedataColumnKey + "." + p);
                                continue;
                            }
                            items.add(basedataColumnKey);
                        }
                        for (i = 0; i < propDisplayNames.size(); ++i) {
                            disname = (String)propDisplayNames.get(i);
                            if (StringUtils.isNotEmpty((CharSequence)disname)) {
                                display.add(basedataColumnName + disname);
                            } else {
                                display.add(basedataColumnName);
                            }
                            if (props.size() == 1 && StringUtils.isEmpty((CharSequence)((CharSequence)props.get(0)))) {
                                if (isMulBasedata) {
                                    exportWriterBuilder_22 = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7f16\u7801##\u540d\u79f0\uff0c\u4f8b\u5982100023##\u5f20\u4e09\uff0cT002##\u4ea7\u54c1\u8bbe\u8ba1\u3002\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u8bf7\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u3002", (String)"ExportWriterBuilder_22", (String)"hrmp-hies-import", (Object[])new Object[0]);
                                    if (StringUtils.isNotBlank((CharSequence)fieldImportDesc)) {
                                        sb = new StringBuilder(exportWriterBuilder_22);
                                        sb.append("\n");
                                        sb.append(fieldImportDesc);
                                        desc.add(sb.toString());
                                        continue;
                                    }
                                    desc.add(exportWriterBuilder_22);
                                    continue;
                                }
                                exportWriterBuilder_21 = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7f16\u7801##\u540d\u79f0\uff0c\u4f8b\u5982100023##\u5f20\u4e09\u3001T002##\u4ea7\u54c1\u8bbe\u8ba1\u3002", (String)"ExportWriterBuilder_21", (String)"hrmp-hies-import", (Object[])new Object[0]);
                                if (StringUtils.isNotBlank((CharSequence)fieldImportDesc)) {
                                    sb = new StringBuilder(exportWriterBuilder_21);
                                    sb.append("\n");
                                    sb.append(fieldImportDesc);
                                    desc.add(sb.toString());
                                    continue;
                                }
                                desc.add(exportWriterBuilder_21);
                                continue;
                            }
                            if (isMulBasedata) {
                                exportWriterBuilder_20 = ResManager.loadKDString((String)"\u586b\u5199\u591a\u4e2a\u503c\u65f6\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u3002", (String)"ExportWriterBuilder_20", (String)"hrmp-hies-import", (Object[])new Object[0]);
                                if (StringUtils.isNotBlank((CharSequence)fieldImportDesc)) {
                                    sb = new StringBuilder(exportWriterBuilder_20);
                                    sb.append("\n");
                                    sb.append(fieldImportDesc);
                                    desc.add(sb.toString());
                                    continue;
                                }
                                desc.add(exportWriterBuilder_20);
                                continue;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)fieldImportDesc)) continue;
                            desc.add(fieldImportDesc);
                        }
                    }
                } else if (isMultiLang) {
                    for (EnabledLang lang : enableLangs) {
                        if (lang.number.equals(currLang)) {
                            items.add(0, propName + "." + lang.number);
                            display.add(0, this.getDisplayName(prop) + "(" + lang.name + ")");
                            desc.add(0, tprop.getLocaleString("fieldimportdesc").getLocaleValue());
                            continue;
                        }
                        items.add(propName + "." + lang.number);
                        display.add(this.getDisplayName(prop) + "(" + lang.name + ")");
                        desc.add(tprop.getLocaleString("fieldimportdesc").get((Object)lang.getNumber()));
                    }
                } else if (isLargeText) {
                    for (String p : props) {
                        items.add(p);
                    }
                    for (i = 0; i < propDisplayNames.size(); ++i) {
                        display.add((String)propDisplayNames.get(i));
                        desc.add(fieldImportDesc);
                    }
                }
                writer.getFlexColumn().put(propName, items);
                writer.getFlexColumnDisplay().put(propName, display);
                writer.getFlexColumnDesc().put(propName, desc);
                col += items.size();
            } else {
                ++col;
            }
            property.put("DisplayName", displayName.toString());
            writer.getFields().add(propName);
            writer.getProperties().put(propName, property);
            if (!StringUtils.isEmpty((CharSequence)((String)property.get("InputType")))) continue;
            ExportWriterBuilder.log.error("field_property_InputType is null.propName:{}", (Object)propName);
        }
        writer.getF7BdWriteFormats().sort(Comparator.comparingInt((ToIntFunction<F7BdWriteFormat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getSeq(), (Lkd/hr/hies/business/export/F7BdWriteFormat;)I)()));
        return col;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addCustomFieldProperties(DataEntityPropertyCollection properties, List<DynamicObject> cusFields) {
        if (CollectionUtils.isEmpty(cusFields)) {
            return;
        }
        for (DynamicObject field : cusFields) {
            TextProp tp = new TextProp();
            tp.setName(field.getString("fieldnumber"));
            LocaleString displyName = new LocaleString();
            displyName.setLocaleValue(field.getLocaleString("fieldname").getLocaleValue());
            tp.setDisplayName(displyName);
            tp.setMustInput(field.getBoolean("ismustinput"));
            properties.add((Object)tp);
        }
    }

    private void prepareLargeTextProps(List<String> props, List<String> propDisplayNames, IDataEntityProperty prop, String propName) {
        props.add(propName);
        propDisplayNames.add(this.getDisplayName(prop));
        props.add(propName + "_tag");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_tag"))));
    }

    @ExcludeFromJacocoGeneratedReport
    private void prepareImptBasedataProps(DynamicObject templateRow, List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, IDataEntityProperty prop, String currLang) {
        IDataEntityProperty refprop;
        String numberField;
        String nameField;
        String imptPropName = "";
        String imptPropNumber = "";
        String imptPropId = "";
        String imptProp = "";
        boolean isHrQueryBd = false;
        boolean isItemClassBd = false;
        String baseinfoformat = templateRow.getString("imptattr");
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
        DataEntityPropertyCollection properties = refPropType.getProperties();
        if (prop instanceof IQueryProp || prop instanceof ItemClassProp) {
            if (prop instanceof IQueryProp) {
                isHrQueryBd = true;
            } else if (prop instanceof ItemClassProp) {
                isItemClassBd = true;
            }
            nameField = "name";
            numberField = NUMBER;
        } else {
            nameField = refPropType.getNameProperty();
            numberField = refPropType.getNumberProperty();
        }
        switch (baseinfoformat) {
            case "number": {
                imptPropNumber = numberField;
                if (numberField.equalsIgnoreCase(nameField)) break;
                imptPropName = nameField;
                break;
            }
            case "name": {
                imptPropName = nameField;
                break;
            }
            case "number_name": {
                imptProp = "number_name";
                break;
            }
            case "id": {
                imptPropId = "id";
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropNumber)) {
            refprop = (IDataEntityProperty)properties.get((Object)imptPropNumber);
            props.add(imptPropNumber);
            dataKeyProps.add(imptPropNumber);
            if (isHrQueryBd) {
                propDisplayNames.add(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExportWriterBuilder_27", (String)"hrmp-hies-import", (Object[])new Object[0]));
            } else if (isItemClassBd) {
                propDisplayNames.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)"hrmp-hies-import", (Object[])new Object[0]));
            } else {
                propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : imptPropNumber);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropName)) {
            refprop = (IDataEntityProperty)properties.get((Object)imptPropName);
            props.add(imptPropName);
            dataKeyProps.add(refprop instanceof MuliLangTextProp ? imptPropName + "." + currLang : imptPropName);
            if (isHrQueryBd) {
                propDisplayNames.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ExportWriterBuilder_28", (String)"hrmp-hies-import", (Object[])new Object[0]));
            } else if (isItemClassBd) {
                propDisplayNames.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
            } else {
                propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : imptPropName);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropId)) {
            refprop = (IDataEntityProperty)properties.get((Object)"id");
            props.add("id");
            dataKeyProps.add(imptPropId);
            propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : imptPropId);
        }
        if (StringUtils.isNotEmpty((CharSequence)imptProp)) {
            props.add("");
            dataKeyProps.add("");
            propDisplayNames.add("");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void prepareExptBasedataProps(DynamicObject templateRow, List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, IDataEntityProperty prop, Map<String, IDataEntityProperty> f7ReferAttrsProp) {
        String baseinfoformat = templateRow.getString("exptattr");
        String[] split = StringUtils.split((String)baseinfoformat, (String)",");
        List f7ReferAttrs = TemplateExportAttrUtil.getF7ReferAttrs((IDataEntityProperty)prop);
        for (String field : split) {
            boolean adapt = false;
            for (ComboItem item : f7ReferAttrs) {
                if (!field.equalsIgnoreCase(item.getValue())) continue;
                if (field.equalsIgnoreCase("number_name")) {
                    props.add("");
                    dataKeyProps.add("");
                    propDisplayNames.add("");
                } else {
                    props.add(field);
                    dataKeyProps.add(field);
                    LocaleString disp = item.getCaption();
                    propDisplayNames.add(StringUtils.isNotBlank((Object)disp) ? disp.toString() : item.getValue());
                }
                adapt = true;
            }
            if (adapt) continue;
            f7ReferAttrsProp.remove(field);
        }
    }

    private boolean isFieldExportable(IDataEntityProperty prop, boolean isForImport) {
        return isForImport ? ((IFieldHandle)prop).isImportable() : ((IFieldHandle)prop).isExportable();
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean isControlFieldExportable(IDataEntityType entityType, String propName, boolean isForImport) {
        if (StringUtils.isNotEmpty((CharSequence)propName)) {
            if (entityType == null) {
                return false;
            }
            IFieldHandle prop = (IFieldHandle)entityType.getProperties().get((Object)propName);
            if (prop == null) {
                return this.isControlFieldExportable(entityType.getParent(), propName, isForImport);
            }
            return isForImport ? prop.isImportable() : prop.isExportable();
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private String codeToName(String code) {
        String columnName = code;
        if (NUMBER.equals(code)) {
            columnName = this.kdCode;
        } else if ("name".equals(code)) {
            columnName = this.kdName;
        }
        return columnName;
    }

    private String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        if ("id".equals(prop.getName())) {
            return this.kdId;
        }
        LocaleString displayName = prop.getDisplayName();
        if (StringUtils.isBlank((CharSequence)displayName.getLocaleValue())) {
            return prop.getName();
        }
        return displayName.getLocaleValue();
    }

    private Map<String, String> getDefaultFieldNameMap() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", this.kdId);
        map.put("name", this.kdName);
        map.put(NUMBER, this.kdCode);
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, List<String>> getSheetBaseData(String entityName, F7BdWriteFormat f7BdWriteFormat, IDataEntityProperty prop, Map<String, Object> mapParam, ExportHeaderWriterFormat writer, String fieldId, HasPermOrgResult hasPermOrg, String sheetBDFields) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        String baseEntityId = f7BdWriteFormat.getBaseEntityId();
        Map<String, Object> result = this.getBaseDataFromDB(entityName, baseEntityId, prop, 0, mapParam, writer, fieldId, hasPermOrg, false, sheetBDFields);
        if (ObjectUtils.isEmpty(result)) {
            return new HashMap<String, List<String>>(0);
        }
        String nameField = (String)result.get(BASEDATA_KEY_NAME_FIELD);
        String numberField = (String)result.get(BASEDATA_KEY_NUMBER_FIELD);
        String selectFields = (String)result.get(BASEDATA_KEY_SELECTFIELDS);
        String[] selectFieldArray = selectFields.split(",");
        List extSelectFields = Arrays.stream(selectFieldArray).filter(item -> !item.equals(nameField) && !item.equals(numberField)).collect(Collectors.toList());
        boolean isExistExtCol = false;
        Map allFields = new HashMap(0);
        HashMap marksMap = new HashMap(0);
        Map sortF7fields = new HashMap(0);
        if (!CollectionUtils.isEmpty(extSelectFields)) {
            isExistExtCol = true;
            allFields = EntityMetadataCache.getDataEntityType((String)baseEntityId).getAllFields();
            sortF7fields = MethodUtil.getSortF7fields((String)baseEntityId);
        }
        boolean isShowNumberAndName = StringUtils.isNotEmpty((CharSequence)f7BdWriteFormat.getHeadNumberAndNameText());
        Object[] dynamicObjects = (DynamicObject[])result.get(BASEDATA_KEY_RESULT_DY_OBJS);
        boolean noDatas = ObjectUtils.isEmpty((Object[])dynamicObjects);
        int dynSize = noDatas ? 0 : dynamicObjects.length;
        ArrayList<String> numbers = new ArrayList<String>(dynSize);
        ArrayList<String> names = new ArrayList<String>(dynSize);
        ArrayList<String> numberAndNames = new ArrayList<String>(dynSize);
        HashMap<String, String> fieldMappingName = new HashMap<String, String>(extSelectFields.size());
        HashMap<String, IDataEntityProperty> fieldMappingProperty = new HashMap<String, IDataEntityProperty>(extSelectFields.size());
        LinkedHashMap extColMap = new LinkedHashMap(extSelectFields.size());
        f7BdWriteFormat.setNameValList(names);
        f7BdWriteFormat.setNumberValList(numbers);
        f7BdWriteFormat.setNumberAndNameValList(numberAndNames);
        f7BdWriteFormat.setExtColMap(extColMap);
        for (String extSelectField : extSelectFields) {
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(extSelectField);
            String fieldName = (String)sortF7fields.get(extSelectField);
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                fieldName = property.getDisplayName().getLocaleValue();
            }
            extColMap.put(fieldName, new ArrayList(dynSize));
            fieldMappingName.put(extSelectField, fieldName);
            fieldMappingProperty.put(extSelectField, property);
        }
        if (noDatas) {
            return new HashMap<String, List<String>>(0);
        }
        DataTypeHelper dataTypeHelper = new DataTypeHelper();
        if (isShowNumberAndName) {
            for (Object item2 : dynamicObjects) {
                String numberValue = "";
                String nameValue = "";
                if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                    numberValue = item2.getString(numberField);
                }
                if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                    nameValue = item2.getString(nameField);
                }
                numbers.add(numberValue);
                names.add(nameValue);
                numberValue = numberValue == null ? "" : numberValue;
                nameValue = nameValue == null ? "" : nameValue;
                numberAndNames.add(numberValue.concat("##").concat(nameValue));
                if (!isExistExtCol) continue;
                for (String extSelectField : extSelectFields) {
                    ((List)extColMap.get(fieldMappingName.get(extSelectField))).add(dataTypeHelper.formatValidate(extSelectField, item2.getString(extSelectField), (IDataEntityProperty)fieldMappingProperty.get(extSelectField), marksMap));
                }
            }
        } else {
            for (Object item3 : dynamicObjects) {
                String numberValue = "";
                String nameValue = "";
                if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                    numberValue = item3.getString(numberField);
                }
                if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                    nameValue = item3.getString(nameField);
                }
                numbers.add(numberValue);
                names.add(nameValue);
                if (!isExistExtCol) continue;
                for (String extSelectField : extSelectFields) {
                    ((List)extColMap.get(fieldMappingName.get(extSelectField))).add(dataTypeHelper.formatValidate(extSelectField, item3.getString(extSelectField), (IDataEntityProperty)fieldMappingProperty.get(extSelectField), marksMap));
                }
            }
        }
        return map;
    }

    private Map<String, Object> getBaseDataFromDB(String entityName, String bdEntityName, IDataEntityProperty prop, int maxshownum, Map<String, Object> mapParam, ExportHeaderWriterFormat writer, String fieldId, HasPermOrgResult hasPermOrg, boolean checkCount, String sheetBDFields) {
        DynamicObject[] dynamicObjects;
        QFilter f7BdCondQFilter;
        Set<String> fields;
        String numberField;
        String nameField;
        Map bdMainProp = MethodUtil.getBdMainProp((String)bdEntityName);
        String tmpltype = (String)mapParam.get("tmpltype");
        String logKey = entityName + "&" + bdEntityName + "&" + prop.getName() + "_" + System.currentTimeMillis();
        String tplSource = checkCount ? "dropdownList" : "sheetList";
        boolean isHrPersonField = false;
        if (prop instanceof IQueryProp) {
            isHrPersonField = true;
            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)bdEntityName);
            nameField = (String)hrPersonMainProp.get("name");
            numberField = (String)hrPersonMainProp.get(NUMBER);
        } else {
            nameField = (String)bdMainProp.get("name");
            numberField = (String)bdMainProp.get(NUMBER);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(bdEntityName);
        if (StringUtils.isNotBlank((CharSequence)sheetBDFields)) {
            fields = Arrays.stream(sheetBDFields.split(",")).collect(Collectors.toCollection(LinkedHashSet::new));
        } else {
            fields = new LinkedHashSet(16);
            if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                fields.add(nameField);
            }
            if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                fields.add(numberField);
            }
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("1", "=", (Object)1));
        QFilter f7BdAuthQFilter = DataValidateServiceHelper.getF7BdQFilter(entityName, (String)mapParam.get("entityRightAppPkId"), prop, hasPermOrg, bdMainProp);
        if (!ObjectUtils.isEmpty((Object)f7BdAuthQFilter)) {
            qFilterList.add(f7BdAuthQFilter);
        }
        if (!ObjectUtils.isEmpty((Object)(f7BdCondQFilter = MethodUtil.getF7BdCondQFilter((String)entityName, (IDataEntityProperty)prop)))) {
            qFilterList.add(f7BdCondQFilter);
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        MethodUtil.printQfilters((QFilter[])qFilters, (String)("getBaseDataFromDB_beforeQueryRefBdEventArgs_" + logKey + "_filter"));
        List userPlugins = (List)mapParam.get("userPlugins");
        BaseBeforeQueryRefBdEventArgs args = new BaseBeforeQueryRefBdEventArgs(null, null);
        if ("IMPT".equalsIgnoreCase(tmpltype)) {
            if (OprType.EXPORT.getValue().equalsIgnoreCase((String)mapParam.get("source"))) {
                args = (BaseBeforeQueryRefBdEventArgs)this.getExportBeforeQueryRefBdEventArgs((String)mapParam.get("extParam"), null, writer.getBelongEntityName(), fieldId, bdEntityName, qFilters, fields);
                if (args != null) {
                    args.setSource(tplSource);
                }
                this.fireExportUserPluginEvent(userPlugins, "beforeQueryRefBd", (AbstractEventArgs)args);
            } else {
                args = new BeforeQueryRefBdEventArgs((String)mapParam.get("extParam"), null);
                args.setEntityId(writer.getBelongEntityName());
                args.setBaseDataName(bdEntityName);
                args.setFieldId(fieldId);
                args.setFilters(qFilters);
                args.setSelectFields(fields);
                args.setSource(tplSource);
                this.fireImportUserPluginEvent(userPlugins, "beforeQueryRefBd", (AbstractEventArgs)args);
            }
            if (args == null) {
                args = new BaseBeforeQueryRefBdEventArgs(null, null);
            }
            qFilters = args.getFilters();
            String orderbys = args.getOrderbys();
            List sortF7OrderBys = MethodUtil.getSortF7OrderBys((String)bdEntityName);
            if (StringUtils.isNotBlank((CharSequence)orderbys)) {
                if (!CollectionUtils.isEmpty((Collection)sortF7OrderBys)) {
                    orderbys = orderbys.concat(",").concat(String.join((CharSequence)",", sortF7OrderBys));
                    args.setOrderbys(orderbys);
                }
            } else if (!CollectionUtils.isEmpty((Collection)sortF7OrderBys)) {
                orderbys = String.join((CharSequence)",", sortF7OrderBys);
                args.setOrderbys(orderbys);
            }
        }
        MethodUtil.printQfilters((QFilter[])qFilters, (String)("getBaseDataFromDB_" + logKey + "_filter"));
        int count = helper.count(bdEntityName, qFilters);
        if (checkCount) {
            log.info("getBaseDataFromDB_" + logKey + ",count=" + count);
            if (count > maxshownum) {
                return null;
            }
        }
        String selectFields = String.join((CharSequence)",", args.getSelectFields());
        log.info("getBaseDataFromDB_" + logKey + ",selectFields=" + selectFields);
        if (StringUtils.isNotEmpty((CharSequence)selectFields)) {
            DynamicObjectCollection collection;
            String orderBys = args.getOrderbys();
            if (count > 10000) {
                if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                    Set clearMultLevelOrderBys = Arrays.stream(orderBys.split(",")).filter(item -> !item.contains(".")).collect(Collectors.toSet());
                    orderBys = String.join((CharSequence)",", clearMultLevelOrderBys);
                    args.setOrderbys(orderBys);
                }
                collection = QueryServiceHelper.query((String)helper.getEntityName(), (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)100000);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            } else if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                dynamicObjects = helper.query(selectFields, qFilters, orderBys);
            } else {
                collection = helper.queryOriginalCollection(selectFields, qFilters, orderBys);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            }
        } else {
            dynamicObjects = (DynamicObject[])new DynamicObjectCollection().toArray((Object[])new DynamicObject[0]);
        }
        log.info("getBaseDataFromDB_" + logKey + ",count:{}", (Object)dynamicObjects.length);
        BaseAfterQueryRefBdEventArgs args2 = new BaseAfterQueryRefBdEventArgs(null, null, null);
        if ("IMPT".equalsIgnoreCase(tmpltype)) {
            if (OprType.EXPORT.getValue().equalsIgnoreCase((String)mapParam.get("source"))) {
                args2 = (BaseAfterQueryRefBdEventArgs)this.getExportAfterQueryRefBdEventArgs((String)mapParam.get("extParam"), bdEntityName, dynamicObjects);
                args2.setSource(tplSource);
                this.fireExportUserPluginEvent(userPlugins, "AfterQueryRefBd", (AbstractEventArgs)args2);
            } else {
                args2 = new AfterQueryRefBdEventArgs((String)mapParam.get("extParam"), bdEntityName, dynamicObjects);
                args2.setSource(tplSource);
                this.fireImportUserPluginEvent(userPlugins, "AfterQueryRefBd", (AbstractEventArgs)args2);
            }
        }
        log.info("getBaseDataFromDB_afterQueryRefBdEventArgs_" + logKey + ",count:{}", (Object)(args2.getDatas() != null ? args2.getDatas().length : 0));
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(BASEDATA_KEY_NAME_FIELD, nameField);
        result.put(BASEDATA_KEY_NUMBER_FIELD, numberField);
        result.put(BASEDATA_KEY_IS_HR_PERSON, isHrPersonField);
        result.put(BASEDATA_KEY_RESULT_DY_OBJS, args2.getDatas());
        result.put(BASEDATA_KEY_SELECTFIELDS, selectFields);
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, List<String>> getTopBaseData(String entityName, String bdEntityName, IDataEntityProperty prop, String baseinfoformat, int maxshownum, Map<String, Object> mapParam, ExportHeaderWriterFormat writer, String fieldId, HasPermOrgResult hasPermOrg) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if ("id".equalsIgnoreCase(baseinfoformat)) {
            return map;
        }
        Map<String, Object> result = this.getBaseDataFromDB(entityName, bdEntityName, prop, maxshownum, mapParam, writer, fieldId, hasPermOrg, true, null);
        if (ObjectUtils.isEmpty(result)) {
            return map;
        }
        String nameField = (String)result.get(BASEDATA_KEY_NAME_FIELD);
        String numberField = (String)result.get(BASEDATA_KEY_NUMBER_FIELD);
        boolean isHrPersonField = (Boolean)result.get(BASEDATA_KEY_IS_HR_PERSON);
        Object[] dynamicObjects = (DynamicObject[])result.get(BASEDATA_KEY_RESULT_DY_OBJS);
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            log.error("tmpltype is null, mapParam:{}", mapParam);
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>(dynamicObjects.length);
        ArrayList<String> names = new ArrayList<String>(dynamicObjects.length);
        block10: for (Object item : dynamicObjects) {
            switch (baseinfoformat) {
                case "number": {
                    if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                        numbers.add(item.getString(numberField));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)nameField)) continue block10;
                    names.add(item.getString(nameField));
                    continue block10;
                }
                case "name": {
                    if (!StringUtils.isNotEmpty((CharSequence)nameField)) continue block10;
                    names.add(item.getString(nameField));
                    continue block10;
                }
                case "number_name": {
                    if (!StringUtils.isNotEmpty((CharSequence)numberField) || !StringUtils.isNotEmpty((CharSequence)nameField)) continue block10;
                    numbers.add(item.getString(numberField).concat("##").concat(item.getString(nameField)));
                }
            }
        }
        map.put(isHrPersonField ? NUMBER : numberField, numbers);
        map.put(isHrPersonField ? "name" : nameField, names);
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private void fireImportUserPluginEvent(List userPlugins, String evt, AbstractEventArgs args) {
        if (CollectionUtils.isEmpty((Collection)userPlugins)) {
            return;
        }
        if (userPlugins.get(0) instanceof HRImportPlugin) {
            List hrTemplatePlugin = userPlugins;
            HRImpPluginEngine.fireImptPluginEvent(hrTemplatePlugin, evt, args);
        }
    }

    private AbstractEventArgs getExportBeforeQueryRefBdEventArgs(String extParams, ConcurrentHashMap<String, Object> customParams, String entityId, String fieldId, String baseDataName, QFilter[] filters, Set<String> selectFields) {
        try {
            Class<?> aClass0 = Class.forName("kd.hr.expt.common.plugin.BeforeQueryRefBdEventArgs");
            Constructor<?> constructor = aClass0.getConstructor(String.class, ConcurrentHashMap.class, String.class, String.class, String.class, QFilter[].class, Set.class);
            Object newInstance = constructor.newInstance(extParams, customParams, entityId, fieldId, baseDataName, filters, selectFields);
            return (AbstractEventArgs)newInstance;
        }
        catch (Throwable e) {
            log.error(e);
            return null;
        }
    }

    private AbstractEventArgs getExportAfterQueryRefBdEventArgs(String extParams, String baseDataName, DynamicObject[] datas) {
        try {
            Class<?> aClass0 = Class.forName("kd.hr.expt.common.plugin.AfterQueryRefBdEventArgs");
            Constructor<?> constructor = aClass0.getConstructor(String.class, String.class, DynamicObject[].class);
            Object newInstance = constructor.newInstance(extParams, baseDataName, datas);
            return (AbstractEventArgs)newInstance;
        }
        catch (Throwable e) {
            log.error(e);
            return new BaseAfterQueryRefBdEventArgs(null, null, null);
        }
    }

    private void fireExportUserPluginEvent(List userPlugins, String evt, AbstractEventArgs args) {
        if (CollectionUtils.isEmpty((Collection)userPlugins)) {
            return;
        }
        try {
            Class<?> aClass = Class.forName("kd.hr.expt.common.plugin.UserExportPluginEngine");
            Method fireUserPluginEvent = aClass.getMethod("fireUserPluginEvent", List.class, String.class, AbstractEventArgs.class);
            fireUserPluginEvent.invoke(null, userPlugins, evt, args);
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    private void dealEntryIdPIdField(String importtype, Map<Long, DynamicObject> entryIdField, Map<Long, DynamicObject> treeEntryPidField, Map<String, DynamicObject> fieldSet, long pid, AtomicBoolean hasFieldimportdesc) {
        DynamicObject pidObj = treeEntryPidField.get(pid);
        if (!"delete".equalsIgnoreCase(importtype) && ("update".equalsIgnoreCase(importtype) || "updateandnew".equalsIgnoreCase(importtype) || pidObj != null)) {
            StringBuilder builder;
            DynamicObject idObj = entryIdField.get(pid);
            if (idObj != null) {
                hasFieldimportdesc.set(true);
                builder = new StringBuilder(ResManager.loadKDString((String)"1.\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\uff1b", (String)"ExportWriterBuilder_51", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"2.\u5982\u9700\u66f4\u65b0\u5206\u5f55\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u5185\u7801\uff1b\u65b0\u589e\u5206\u5f55\uff0c\u65e0\u9700\u586b\u5199\uff1b", (String)"ExportWriterBuilder_52", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"3.\u83b7\u53d6\u5185\u7801\u65b9\u5f0f\uff1a\u4f7f\u7528\u201c\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u201d\uff0c\u5219\u53ef\u5bfc\u51fa\u5206\u5f55\u7684\u5185\u7801\u3002", (String)"ExportWriterBuilder_53", (String)"hrmp-hies-import", (Object[])new Object[0]));
                idObj.set("fieldimportdesc", (Object)builder.toString());
                fieldSet.put(idObj.getString("fieldnumber"), idObj);
                entryIdField.remove(pid);
            }
            if (pidObj != null) {
                builder = new StringBuilder(ResManager.loadKDString((String)"1. \u4e0a\u7ea7\u5185\u7801\u662f\u6811\u5f62\u5355\u636e\u4f53\u4e0a\u7ea7\u884c\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff1b", (String)"ExportWriterBuilder_30", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"2.\u5982\u5f53\u524d\u5206\u5f55\u884c\u4e0d\u662f\u4e00\u7ea7\u5206\u5f55\uff0c\u5219\u9700\u586b\u5199\u4e0a\u7ea7\u5185\u7801\uff1b", (String)"ExportWriterBuilder_31", (String)"hrmp-hies-import", (Object[])new Object[0]));
                builder.append('\n');
                builder.append(ResManager.loadKDString((String)"3.\u83b7\u53d6\u5185\u7801\u65b9\u5f0f\uff1a\u4f7f\u7528\u201c\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u201d\uff0c\u5219\u53ef\u5bfc\u51fa\u5206\u5f55\u7684\u5185\u7801\u3002", (String)"ExportWriterBuilder_32", (String)"hrmp-hies-import", (Object[])new Object[0]));
                pidObj.set("fieldimportdesc", (Object)builder.toString());
                fieldSet.put(pidObj.getString("fieldnumber"), pidObj);
                treeEntryPidField.remove(pid);
            }
        }
    }
}

