/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.common.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.impt.common.dto.ImportLog;

public class ImportRowErrorLog
implements Serializable {
    private static final long serialVersionUID = 8537879060759292506L;
    private static Log log = LogFactory.getLog(ImportRowErrorLog.class);
    @JsonIgnore
    @JSONField(serialize=false)
    private String sheetName;
    @JsonIgnore
    @JSONField(serialize=false)
    private int startIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private int endIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private int errorIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private ImportLog importLog;
    private Set<Integer> msgHashCode;

    public ImportRowErrorLog() {
    }

    public ImportRowErrorLog(String sheetName, int startIndex, int endIndex, String msg, ImportLog importLog) {
        this.initImportRowErrorLog(sheetName, startIndex, endIndex, startIndex, msg, importLog);
    }

    public ImportRowErrorLog(String sheetName, int startIndex, int endIndex, int errorIndex, String msg, ImportLog importLog) {
        this.initImportRowErrorLog(sheetName, startIndex, endIndex, errorIndex, msg, importLog);
    }

    public static String getExceptionInfoWithSys(Throwable throwable) {
        try {
            boolean showStackTrace = SystemParamServiceHelper.isShowStackTrace();
            if (showStackTrace) {
                return HIESUtil.formatException((Throwable)throwable);
            }
            String importErrMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportRowErrorLog_0", (String)"hrmp-hies-import", (Object[])new Object[0]);
            return importErrMsg + " traceId:" + RequestContext.get().getTraceId();
        }
        catch (Throwable e) {
            log.error(e);
            return null;
        }
    }

    public ImportLog getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLog importLog) {
        this.importLog = importLog;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public String getMsg() {
        Set<Integer> msgHashCode = this.getMsgHashCode();
        if (CollectionUtils.isEmpty(msgHashCode)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        AtomicInteger index = new AtomicInteger(1);
        msgHashCode.forEach(code -> {
            String info = this.importLog.getErrorInfos().get(code);
            builder.append(info);
            if (index.get() < msgHashCode.size()) {
                builder.append(HIESConstant.LINE_SEPARATOR);
            }
            index.getAndIncrement();
        });
        return builder.toString();
    }

    public void setMsg(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        int hashCode = msg.hashCode();
        String errorInfo = this.importLog.getErrorInfos().get(hashCode);
        if (StringUtils.isEmpty((String)errorInfo)) {
            this.importLog.getErrorInfos().put(hashCode, msg);
        }
        this.getMsgHashCode().add(hashCode);
    }

    public Set<Integer> getMsgHashCode() {
        return this.msgHashCode;
    }

    public void setMsgHashCode(Set<Integer> msgHashCode) {
        this.msgHashCode = msgHashCode;
    }

    private final void initImportRowErrorLog(String sheetName, int startIndex, int endIndex, int errorIndex, String msg, ImportLog importLog) {
        this.sheetName = sheetName;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.errorIndex = errorIndex;
        this.importLog = importLog;
        this.msgHashCode = new HashSet<Integer>(16);
        this.setMsg(msg);
    }
}

