/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.common.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.plugin.ImportBaseEventArgs;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic(scriptName="\u6570\u636e\u5305\u4e34\u65f6\u5b58\u50a8\u5165\u5e93\u524d\u4e8b\u4ef6\u53c2\u6570")
@ExcludeFromJacocoGeneratedReport
public class BeforeTempStoreInstoreArgs
extends ImportBaseEventArgs {
    private static final long serialVersionUID = -531156960410140639L;
    private Map<String, String> sheetEntityMap;
    private Map<String, DataSet> datas;
    private TempStoreDispatcher dispatcher;
    private Semaphore syncSemaphore;
    private Semaphore groupSemaphore;

    public BeforeTempStoreInstoreArgs(ImportContext context) {
        super(context);
    }

    public Map<String, String> getSheetEntityMap() {
        return this.sheetEntityMap;
    }

    @SdkInternal
    public void setSheetEntityMap(Map<String, String> sheetEntityMap) {
        this.sheetEntityMap = sheetEntityMap;
    }

    public Map<String, DataSet> getDatas() {
        return this.datas;
    }

    @SdkInternal
    public void setDatas(Map<String, DataSet> datas) {
        this.datas = datas;
    }

    @SdkInternal
    public void setDispatcher(TempStoreDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Semaphore getSyncSemaphore() {
        return this.syncSemaphore;
    }

    @SdkInternal
    public void setSyncSemaphore(Semaphore syncSemaphore) {
        this.syncSemaphore = syncSemaphore;
    }

    public Semaphore getGroupSemaphore() {
        return this.groupSemaphore;
    }

    @SdkInternal
    public void setGroupSemaphore(Semaphore groupSemaphore) {
        this.groupSemaphore = groupSemaphore;
    }

    public void pushInstore(List<ImportBillData> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            this.syncSemaphore.release();
            this.groupSemaphore.release();
        } else {
            this.dispatcher.putToOutQueue(dataList);
        }
    }

    public DataSet rebuildNewDsByKey(DataSet ds, String entityId, List<String> keys) {
        keys.add(0, "seq");
        String[] fileds = keys.toArray(new String[0]);
        keys.remove(0);
        ArrayList<LongType> typesList = new ArrayList<LongType>(keys.size() + 1);
        typesList.add(DataType.LongType);
        keys.forEach(key -> typesList.add((LongType)DataType.AnyType));
        DataType[] types = typesList.toArray(new DataType[0]);
        RowMeta meta = new RowMeta(fileds, types);
        DataSetBuilder builder = Algo.create((String)"import_".concat(UUID.randomUUID().toString())).createDataSetBuilder(meta);
        while (ds.hasNext()) {
            Row next1 = ds.next();
            Object seq = next1.get("seq");
            String json = (String)next1.get("data");
            ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
            ArrayList<Object> rowList = new ArrayList<Object>(keys.size() + 1);
            rowList.add(seq);
            JSONObject jsonObject = billData.getData().getJSONObject(entityId);
            keys.forEach(key -> rowList.add(jsonObject.get(key)));
            builder.append(rowList.toArray(new Object[0]));
        }
        return builder.build();
    }

    public String getInCondition(List<Object> vals) {
        StringBuilder builder = new StringBuilder("(");
        vals.forEach(id -> builder.append(id).append(","));
        String str = builder.toString();
        str = StringUtils.removeEnd((String)str, (String)",");
        return str + ")";
    }
}

