/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.common.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.DefaultImportPluginService;
import kd.hr.impt.common.plugin.AfterLoadUserPluginEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.HRImportPlugin;

@ExcludeFromJacocoGeneratedReport
public class UserImportPluginUtil {
    private static final Log logger = LogFactory.getLog(UserImportPluginUtil.class);

    public static List<HRImportPlugin> getHRImportPlugin(String opPlugins, String tplPlugins, List<HRImportPlugin> listPlugins, String extParams, ConcurrentHashMap<String, Object> customParams, List<String> entitys) {
        List<String> defaultPlugins = DefaultImportPluginService.getDefaultPlugins(entitys);
        logger.info("getHRImportPlugin_entitys:{} defaultPlugins:{}", entitys, defaultPlugins);
        List<HRImportPlugin> userPluginInstances = UserImportPluginUtil.initPlugin(HIESUtil.getGlobalPlugins(), defaultPlugins, opPlugins, tplPlugins, listPlugins, HRImportPlugin.class);
        if (CollectionUtils.isNotEmpty(userPluginInstances)) {
            List<HRImportPlugin> copyUserPluginInstances = userPluginInstances.stream().collect(Collectors.toList());
            AfterLoadUserPluginEventArgs args = new AfterLoadUserPluginEventArgs(extParams, customParams);
            args.setUserPlugin(userPluginInstances);
            HRImpPluginEngine.fireImptPluginEvent(copyUserPluginInstances, "afterLoadUserPlugin", (AbstractEventArgs)args);
            if (args.isRemoveHisModelPlugin()) {
                UserImportPluginUtil.removePlugin(userPluginInstances, "HisModelComHRImptPlugin");
            }
        }
        MethodUtil.printPlugins(userPluginInstances);
        return userPluginInstances;
    }

    private static void removePlugin(List<HRImportPlugin> userPluginInstances, String removePluginName) {
        HRImportPlugin plugin0 = null;
        for (HRImportPlugin plugin : userPluginInstances) {
            if (!plugin.getClass().getSimpleName().equalsIgnoreCase(removePluginName)) continue;
            plugin0 = plugin;
        }
        if (plugin0 != null) {
            userPluginInstances.remove(plugin0);
        }
    }

    private static <T> List<T> initPlugin(String globalPlugins, List<String> defaultPlugins, String opPlugins, String tplPlugins, List<T> listPlugins, Class<T> cls) {
        JSONArray jsonArray;
        LinkedList userPluginInstances = new LinkedList();
        LinkedList userPluginClassList = new LinkedList();
        if (StringUtils.isNotEmpty((CharSequence)globalPlugins)) {
            jsonArray = JSONObject.parseArray((String)globalPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserImportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (CollectionUtils.isNotEmpty(defaultPlugins)) {
            defaultPlugins.forEach(classPath -> UserImportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)opPlugins)) {
            Arrays.stream(opPlugins.split(",")).distinct().forEach(classPath -> UserImportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (HRCollUtil.isNotEmpty(listPlugins)) {
            listPlugins.forEach(plugin -> {
                String className = plugin.getClass().getCanonicalName();
                if (userPluginClassList.contains(className)) {
                    return;
                }
                userPluginClassList.add(className);
                userPluginInstances.add(plugin);
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)tplPlugins)) {
            jsonArray = JSONObject.parseArray((String)tplPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserImportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        return userPluginInstances;
    }

    private static <T> void setPluginInstance(List<T> userPluginInstances, List<String> userPluginClassList, String classPath, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return;
        }
        if (userPluginClassList.contains(classPath)) {
            return;
        }
        userPluginClassList.add(classPath);
        try {
            Object instance = TypesContainer.createInstance((String)classPath);
            if (cls.getSimpleName().equalsIgnoreCase(HRImportPlugin.class.getSimpleName()) && instance instanceof HRImportPlugin) {
                userPluginInstances.add(instance);
            }
        }
        catch (Throwable ex) {
            logger.error("setPluginInstances {} createInstance error.", (Object)classPath, (Object)ex);
        }
    }
}

