/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.end;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.core.end.Reporter;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.SheetHandler;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.xml.sax.SAXException;

public class ExcelImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(ExcelImportFailedSheetHandler.class);
    private final SXSSFWorkbook sxssfWorkbookOfErr;
    private final Map<String, SXSSFSheet> sheetsMap = new HashMap<String, SXSSFSheet>();
    private final Map<String, SXSSFSheet> sheetsOfErrMap = new HashMap<String, SXSSFSheet>();
    private final Map<String, SXSSFRow> nameRowsMap = new HashMap<String, SXSSFRow>();
    private final Map<Integer, CellStyle> stylesOfAllMap = new ConcurrentHashMap<Integer, CellStyle>();
    private final Map<Integer, CellStyle> stylesOfErrMap = new ConcurrentHashMap<Integer, CellStyle>();
    private final Map<String, Set<Integer>> errIndexOfSheet = new ConcurrentHashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> errHeadIndexOfSheet = new ConcurrentHashMap<String, Set<Integer>>();
    private final Reporter importWorker;
    private final boolean isOnlyErrorReport;
    private String templateNum;
    private SXSSFWorkbook sxssfWorkbook = null;
    private int curErrorLineNum = 0;
    private boolean isFirstSheet = true;
    private boolean currentSheetNeedErrorColum = true;

    public ExcelImportFailedSheetHandler(Reporter reporter, StylesTable stylesTable) {
        this.importWorker = reporter;
        ImportContext importContext = reporter.getImportStart().getImportContext();
        this.templateNum = importContext.getTpl().getString("number");
        if ("full".equalsIgnoreCase(importContext.getTpl().getString("source"))) {
            this.templateNum = this.templateNum.substring(0, this.templateNum.lastIndexOf("_"));
        }
        this.sxssfWorkbookOfErr = new SXSSFWorkbook(null, 5000, false, true);
        ThreadPools.executeOnce((String)"ExcelImportFailedSheetHandler.initCellStyleOfErr", () -> {
            for (int index = 0; index < stylesTable.getNumCellStyles(); ++index) {
                if (this.stylesOfErrMap.get(index) != null) continue;
                CellStyle cellStyle = this.sxssfWorkbookOfErr.createCellStyle();
                cellStyle.cloneStyleFrom((CellStyle)stylesTable.getStyleAt(index));
                this.stylesOfErrMap.put(index, cellStyle);
            }
        });
        this.initStylesMap(this.sxssfWorkbookOfErr, this.stylesOfErrMap);
        int successedBillCount = importContext.getSuccessedBillCount().get();
        if (importContext.isSerialModel()) {
            int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
            int totalBillCount = importContext.getTotalBillCount();
            this.isOnlyErrorReport = 0 < successedValidateBillCount && successedValidateBillCount < totalBillCount ? false : successedValidateBillCount != totalBillCount || successedBillCount == 0;
        } else {
            boolean bl = this.isOnlyErrorReport = successedBillCount == 0;
        }
        if (!this.isOnlyErrorReport) {
            this.sxssfWorkbook = new SXSSFWorkbook(null, 5000, false, true);
            ThreadPools.executeOnce((String)"ExcelImportFailedSheetHandler.initCellStyleOfAll", () -> {
                for (int index = 0; index < stylesTable.getNumCellStyles(); ++index) {
                    if (this.stylesOfAllMap.get(index) != null) continue;
                    CellStyle cellStyle = this.sxssfWorkbook.createCellStyle();
                    cellStyle.cloneStyleFrom((CellStyle)stylesTable.getStyleAt(index));
                    this.stylesOfAllMap.put(index, cellStyle);
                }
            });
            this.initStylesMap(this.sxssfWorkbook, this.stylesOfAllMap);
        }
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        if (parsedRow.getRowNum() % 50000 == 0) {
            LOGGER.info("Reporter_handleRow_rowNumber:{}", (Object)parsedRow.getRowNum());
        }
        if (!this.isOnlyErrorReport) {
            this.initBook(this.sxssfWorkbook, this.sheetsMap, this.stylesOfAllMap, parsedRow, true);
        }
        this.initBook(this.sxssfWorkbookOfErr, this.sheetsOfErrMap, this.stylesOfErrMap, parsedRow, false);
    }

    @Override
    public void handleSheet(SheetHandler.ParsedRow parsedRow, SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, boolean isAllData) {
        ImportLog importLog = this.importWorker.getImportStart().getImportContext().getImportLog();
        ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog = importLog.getRowErrors().get(this.getCurrentSheetName());
        HashSet errIndex = this.errIndexOfSheet.get(this.getCurrentSheetName());
        HashSet errHeadIndex = this.errHeadIndexOfSheet.get(this.getCurrentSheetName());
        if (errIndex == null) {
            errIndex = Sets.newHashSetWithExpectedSize((int)errorLog.size());
            errHeadIndex = Sets.newHashSetWithExpectedSize((int)errorLog.size());
            HashSet finalErrIndex = errIndex;
            HashSet finalErrHeadIndex = errHeadIndex;
            errorLog.values().forEach(log -> {
                for (int index = log.getStartIndex(); index <= log.getEndIndex(); ++index) {
                    finalErrIndex.add(index);
                }
                finalErrHeadIndex.add(log.getStartIndex());
            });
            this.errIndexOfSheet.putIfAbsent(this.getCurrentSheetName(), finalErrIndex);
            this.errHeadIndexOfSheet.putIfAbsent(this.getCurrentSheetName(), finalErrHeadIndex);
        }
        this.currentSheetNeedErrorColum = isAllData || errorLog != null && errorLog.size() != 0;
        int currRowNum = parsedRow.getRowNum();
        if (currRowNum == 0) {
            this.hasErrorRow = StringUtils.isEmpty((CharSequence)HIESUtil.getSplitValue((String)parsedRow.get(0)));
            this.isFirstSheet = this.templateNum.equals(HIESUtil.getSplitValue((String)parsedRow.get(this.hasErrorRow ? 1 : 0)));
            this.curErrorLineNum = this.isFirstSheet ? 5 : 4;
            this.handleMergeCells(sxssfSheet, this.getMergeCellList().get(this.getCurrentSheetName()), this.hasErrorRow, this.currentSheetNeedErrorColum);
            this.handleDataColStyle(workbook, sxssfSheet, stylesMap, this.hasErrorRow);
        }
        int sheetReadRow = this.isFirstSheet ? 5 : 4;
        DynamicObject tpl = this.importWorker.getImportStart().getImportContext().getTpl();
        if ("localupload".equalsIgnoreCase(tpl.getString("tplgenmode"))) {
            this.curErrorLineNum = sheetReadRow = this.importWorker.getImportStart().getImportContext().getReadRowOfSheetName().getOrDefault(this.getCurrentSheetName(), sheetReadRow + 2) - 2;
        }
        if (currRowNum == sheetReadRow) {
            SXSSFRow curRow = this.getRow(sxssfSheet, currRowNum);
            this.nameRowsMap.put(this.getCurrentSheetName(), curRow);
            if (this.currentSheetNeedErrorColum) {
                SXSSFCell cell = curRow.createCell(0);
                ImportContext importContext = this.importWorker.getImportStart().getImportContext();
                if (importContext.isSerialModel() && !importContext.issMPartInstore() && importContext.getSuccessedValidateBillCount().get() != importContext.getTotalBillCount()) {
                    cell.setCellValue(ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"ExcelImportFailedSheetHandler_4", (String)"hrmp-hies-import", (Object[])new Object[0]));
                } else {
                    cell.setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ExcelImportFailedSheetHandler_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
                }
                sxssfSheet.setColumnWidth(0, 12800);
            }
        } else if (currRowNum > sheetReadRow) {
            int curLine = this.writeErrCell(sxssfSheet, stylesMap, isAllData, currRowNum, errorLog, errIndex, errHeadIndex, parsedRow);
            if (curLine < 0) {
                return;
            }
            currRowNum = curLine;
        }
        this.handleCorrectRow(parsedRow, workbook, sxssfSheet, stylesMap, currRowNum, currRowNum > sheetReadRow && this.isIgnoreStyle());
    }

    @ExcludeFromJacocoGeneratedReport
    private int writeErrCell(SXSSFSheet sheet, Map<Integer, CellStyle> stylesMap, boolean isAllData, int currRowNum, ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog, Set<Integer> errIndex, Set<Integer> errHeadIndex, SheetHandler.ParsedRow parsedRow) {
        ImportRowErrorLog rowErrLog;
        ImportRowErrorLog importRowErrorLog = rowErrLog = errorLog == null ? null : errorLog.get(currRowNum + 1);
        if (rowErrLog != null) {
            SXSSFCell cell;
            SXSSFRow curRow;
            String mergeLogStr;
            if (rowErrLog.getMsg().length() > 4000) {
                mergeLogStr = rowErrLog.getMsg().substring(0, 3996);
                mergeLogStr = mergeLogStr.concat("...");
            } else {
                mergeLogStr = rowErrLog.getMsg();
            }
            if (isAllData) {
                curRow = this.getRow(sheet, currRowNum);
                cell = this.getCell(curRow);
            } else {
                curRow = this.getRow(sheet, ++this.curErrorLineNum);
                cell = this.getCell(curRow);
                currRowNum = this.curErrorLineNum;
            }
            curRow.setHidden(Boolean.valueOf(parsedRow.isHideRow()));
            cell.setCellValue(mergeLogStr);
            cell.setCellStyle(stylesMap.get(-1));
            return currRowNum;
        }
        if (isAllData) {
            if (errorLog != null && this.hasEntry(currRowNum, errIndex)) {
                if (errHeadIndex.contains(currRowNum + 1)) {
                    SXSSFRow row = this.getRow(sheet, currRowNum);
                    SXSSFCell cell = this.getCell(row);
                    cell.setCellValue(ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExcelImportFailedSheetHandler_5", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    cell.setCellStyle(stylesMap.get(-1));
                }
                return currRowNum;
            }
            SXSSFRow row = this.getRow(sheet, currRowNum);
            SXSSFCell cell = this.getCell(row);
            cell.setCellValue(ResManager.loadKDString((String)"\u6210\u529f", (String)"ExcelImportFailedSheetHandler_1", (String)"hrmp-hies-import", (Object[])new Object[0]));
            cell.setCellStyle(stylesMap.get(-2));
            return currRowNum;
        }
        if (errorLog != null && this.hasEntry(currRowNum, errIndex)) {
            if (errHeadIndex.contains(currRowNum + 1)) {
                SXSSFRow row = this.getRow(sheet, currRowNum);
                SXSSFCell cell = this.getCell(row);
                cell.setCellValue(ResManager.loadKDString((String)"\u5931\u8d25", (String)"ExcelImportFailedSheetHandler_5", (String)"hrmp-hies-import", (Object[])new Object[0]));
                cell.setCellStyle(stylesMap.get(-1));
            }
            return ++this.curErrorLineNum;
        }
        return -1;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean hasEntry(int currRowNum, Set<Integer> errIndex) {
        return errIndex.contains(currRowNum + 1);
    }

    @Override
    public void endDocument() throws SAXException {
        LOGGER.info("Reporter_endDocument_sheetName:{},stylesOfAllMap_size:{},stylesOfErrMap_size:{}", new Object[]{this.getCurrentSheetName(), this.stylesOfAllMap.size(), this.stylesOfErrMap.size()});
        super.endDocument();
        XSSFSheet sheet = this.sxssfWorkbookOfErr.getXSSFWorkbook().getSheet(this.getCurrentSheetName());
        if (sheet != null) {
            String ref = HIESUtil.tranDecimalToBase26((int)(this.hasErrorRow ? this.getColCount() : this.getColCount() + 1));
            if (!this.isOnlyErrorReport) {
                CTWorksheet ctSheet = this.sxssfWorkbook.getXSSFWorkbook().getSheet(this.getCurrentSheetName()).getCTWorksheet();
                ctSheet.getDimension().setRef("A1:".concat(ref).concat(String.valueOf(this.getRowCount())));
            }
            CTWorksheet ctSheet2 = this.sxssfWorkbookOfErr.getXSSFWorkbook().getSheet(this.getCurrentSheetName()).getCTWorksheet();
            ctSheet2.getDimension().setRef("A1:".concat(ref).concat(String.valueOf(this.getRowCount())));
        }
        String lastsheet = this.getAllSheetNames().get(this.getAllSheetNames().size() - 1);
        if (this.getCurrentSheetName() != null && this.getCurrentSheetName().equals(lastsheet)) {
            if (!this.isOnlyErrorReport) {
                this.ignoreSheet(this.sxssfWorkbook);
            }
            this.ignoreSheet(this.sxssfWorkbookOfErr);
            LOGGER.info("Reporter_before_write_file.");
            try {
                if (!this.isOnlyErrorReport) {
                    ThreadPools.executeOnce((String)"ExcelImportFailedSheetHandler.endDocument.generateFileUrl", () -> {
                        try {
                            this.generateFileUrl(this.sxssfWorkbook, true);
                        }
                        catch (IOException ioException) {
                            LOGGER.error("ExcelImportFailedSheetHandler_endDocument() ioException:{}", (Object)ioException.getMessage());
                        }
                    });
                }
                this.generateFileUrl(this.sxssfWorkbookOfErr, false);
                LOGGER.info("Reporter_after_write_file.");
            }
            catch (IOException ioException) {
                LOGGER.error("ExcelImportFailedSheetHandler_endDocument() ioException:{}", (Object)ioException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private void generateFileUrl(SXSSFWorkbook workbook, boolean isAllData) throws IOException {
        if (this.getActiveTab() != null) {
            try {
                workbook.setActiveSheet(workbook.getSheetIndex(this.getActiveTab()));
            }
            catch (Exception e) {
                LOGGER.error("setActiveSheet_activeTab=" + this.getActiveTab(), (Throwable)e);
            }
        }
        ImportStart importStart = this.importWorker.getImportStart();
        ImportContext importContext = importStart.getImportContext();
        File temp = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        try (FileOutputStream fos = new FileOutputStream(temp);
             FileInputStream fis = new FileInputStream(temp);){
            workbook.write((OutputStream)fos);
            String firstFileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_", (String)"ExcelImportFailedSheetHandler_2", (String)"hrmp-hies-import", (Object[])new Object[0]);
            if (importStart.getImportContext().getSuccessedBillCount().intValue() == importStart.getImportContext().getTotalBillCount()) {
                firstFileName = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f_", (String)"ExcelImportFailedSheetHandler_3", (String)"hrmp-hies-import", (Object[])new Object[0]);
            }
            LocalDate now = LocalDate.now();
            String fileName = firstFileName.concat(importContext.getFileName().split("\\.")[0]).concat("_").concat(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth())).concat(".xlsx");
            fileName = HIESConstant.SpecCharPattern.matcher(fileName).replaceAll("");
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)importContext.getAppId(), (String)(importContext.getMainFormId() + UUID.randomUUID().toString()), (String)fileName);
            String uploadUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, path, (InputStream)fis));
            if (isAllData) {
                importContext.setErrorFileForAllData(uploadUrl);
                this.writeUrlCache("errorFileForAllData", uploadUrl);
            } else {
                importContext.setErrorFileForErrorData(uploadUrl);
                this.writeUrlCache("errorFileForErrorData", uploadUrl);
            }
        }
        finally {
            workbook.dispose();
            try {
                ImportFileUtil.deleteLocalTempFile((String)temp.getPath());
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
    }

    private void writeUrlCache(String key, String url) {
        ImportStart importStart = this.importWorker.getImportStart();
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map customData = (Map)cache.get(MethodUtil.getTaskCachePath((String)String.valueOf(importStart.getImportContext().getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"urls"), Map.class);
        if (customData == null) {
            customData = Maps.newHashMapWithExpectedSize((int)2);
        }
        customData.put(key, url);
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(importStart.getImportContext().getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"urls"), (Object)customData);
    }

    @Override
    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        if (!this.isOnlyErrorReport) {
            this.handleValidations(cellValidations, this.sheetsMap);
        }
        this.handleValidations(cellValidations, this.sheetsOfErrMap);
    }

    @Override
    public void handleSheetComments(Map<String, CommentsTable> comments) {
        if (!this.isOnlyErrorReport) {
            this.handleSheetComments(this.sxssfWorkbook, this.nameRowsMap, this.isFirstSheet ? 5 : 4);
        }
        this.handleSheetComments(this.sxssfWorkbookOfErr, this.nameRowsMap, this.isFirstSheet ? 5 : 4);
        if (comments != null) {
            comments.clear();
        }
    }

    @Override
    protected int countIndex(int index) {
        if (this.hasErrorRow || !this.currentSheetNeedErrorColum) {
            return index;
        }
        return ++index;
    }
}

