/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.init;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.cache.EHcacheDiskCacheManager;
import kd.hr.hies.common.cache.NettyOutJVMHeapManager;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.templateConf.TemplateConfService;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.common.plugin.ImportContextArgsDto;
import kd.hr.impt.common.plugin.UserImportPluginUtil;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.init.ImportTaskDispatcher;
import kd.hr.impt.core.monitor.Monitor;
import kd.hr.impt.core.parse.Parser;
import kd.hr.impt.core.save.InstoreDispatcher;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;
import kd.hr.impt.core.validate.dto.BaseDataContainer;

public class BigExcelImportTask
implements Callable<Object> {
    private static final Log logger = LogFactory.getLog(BigExcelImportTask.class);
    private AtomicInteger childThreadMonitor;
    private ImportTaskDispatcher dispatcher;
    private Map<String, Object> params;

    public BigExcelImportTask(Map<String, Object> params, ImportTaskDispatcher dispatcher, AtomicInteger childThreadMonitor) {
        this.childThreadMonitor = childThreadMonitor;
        this.dispatcher = dispatcher;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        ImportContext importContext = new ImportContext();
        importContext.setRecoveryTask((Boolean)this.params.get("isRecoveryTask"));
        ImportStart importStart = new ImportStart(importContext);
        try {
            Long taskPkid = (Long)this.params.get("taskPkId");
            Monitor monitor = new Monitor(importStart);
            importStart.getWorkers().put(monitor.getName(), monitor);
            this.recordTraceLog(importStart, this.params, start);
            Object sourceRc = this.params.remove("requestContext");
            if (sourceRc instanceof RequestContext) {
                RequestContext.set((RequestContext)((RequestContext)sourceRc));
            } else {
                RequestContext.set((RequestContext)((RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)));
            }
            MethodUtil.syncRequestTraceId((Object)RequestContext.get());
            ConcurrentHashMap<String, Object> other = importStart.getMonitor().getImportTrace().getOther();
            other.put("traceId", RequestContext.get().getTraceId());
            logger.info("BigExcelImportTask_started!trace_id=" + RequestContext.get().getTraceId() + ",params=".concat(JSONObject.toJSONString(this.params)));
            importContext.setRc(RequestContext.get());
            TaskService.updateTaskAFOOTStatus((Long)taskPkid);
            importContext.setFilePath((String)this.params.get("fileUrl"));
            Parser parser = new Parser(importStart);
            importStart.getWorkers().put(parser.getName(), parser);
            this.asyncDownloadFile(importStart);
            this.initGlobalSysParam(importContext);
            importContext.setImportLog(new ImportLog());
            importContext.setTaskPkId(taskPkid);
            importContext.setTplPkid(Long.parseLong((String)this.params.get("tplpkid")));
            importContext.setTpl(this.getTpl(importStart));
            importContext.setTplFieldConfig(HIESUtil.getTplFieldConfig((DynamicObject)importContext.getTpl()));
            importContext.setEntityBdFieldMainPropName(MethodUtil.initEntityF7MainPropName((DynamicObject)importContext.getTpl()));
            importContext.setExtOption(this.initExtOption(this.params, importContext.getTpl()));
            importContext.setNeedRelationInStoreForMEMS(HIESUtil.needRelationInStoreForMEMS((DynamicObject)importContext.getTpl()));
            importContext.setSerialModel(this.initSerialModel(this.params.get("serialModel")));
            importContext.setsMPartInstore(Boolean.parseBoolean((String)this.params.get("sMPartInstore")));
            importContext.setAppId((String)this.params.get("appId"));
            importContext.setServiceAppId((String)this.params.get("ServiceAppId"));
            importContext.setMainFormId((String)this.params.get("formId"));
            importContext.setPageId((String)this.params.get("pageId"));
            Object fileSize = this.params.get("fileSize");
            importContext.setFileSize(Long.valueOf(String.valueOf(fileSize)));
            importContext.setFileName((String)this.params.get("fileName"));
            this.initEntityCofigInfo(importContext, importStart);
            importContext.setSheetEntityMap((Map)JSONObject.parseObject((String)((String)this.params.get("sheetEntityMap")), Map.class));
            importContext.setSheetRowCountMap((Map)JSONObject.parseObject((String)((String)this.params.get("sheetCountRow")), Map.class));
            importContext.setEffectSheetNames((List)JSONObject.parseObject((String)((String)this.params.get("effectSheetNames")), List.class));
            importContext.setTotalRowCount((Integer)this.params.get("totalRow"));
            importContext.setFileType(importContext.getFilePath().substring(importContext.getFilePath().lastIndexOf(".")));
            importContext.setEntityType(MetadataServiceHelper.getDataEntityType((String)importContext.getMainFormId()));
            other.put("serialModel", importContext.isSerialModel());
            other.put("sMPartInstore", importContext.issMPartInstore());
            this.initUserPlugin(importStart, (String)this.params.get("importPlugin"));
            importStart.start();
            IHRAppCache cache = HRAppCache.get((String)"hies");
            cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(importContext.getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"status"), (Object)"finished");
        }
        catch (InterruptedException interruptedException) {
            logger.error("BigExcelImportTask_recievered_InterruptedException", (Throwable)interruptedException);
            boolean sysTerminator = importContext.isSysTerminator();
            boolean userHasTerminator = importContext.isUserHasTerminator();
            importStart.getMonitor().getImportTrace().getOther().put("sysTerminator", sysTerminator);
            importStart.getMonitor().getImportTrace().getOther().put("userHasTerminator", userHasTerminator);
            if (importStart != null) {
                importStart.end(false);
                IHRAppCache cache = HRAppCache.get((String)"hies");
                cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(importContext.getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"status"), (Object)"stop");
                logger.info("BigExcelImportTask_user_normally_InterruptedException.");
            }
        }
        catch (Throwable e) {
            logger.error("BigExcelImportTask_recievered_Exception", e);
            if (importStart != null) {
                importStart.end(false);
            }
            importStart.writeErrorLog(e);
            importContext.setSysTerminator(true);
        }
        finally {
            try {
                TempStoreDispatcher.hasExtentColum = false;
                this.releaseCache(importContext);
                importContext.getExtOption().put("userEndTime", System.currentTimeMillis());
                this.collectAppCacheData(importStart, start);
                IEGlobalTaskUtil.feedbackProgress((String)String.valueOf(importContext.getTaskPkId()), (int)100, (String)ImportCacheKeyType.IMPORT);
                importStart.getMonitor().addExpenseStatistics(BigExcelImportTask.class, (Long)(System.currentTimeMillis() - start), true);
                TaskInfo info = this.saveTaskInfo(importStart, start);
                ImportContextArgsDto dto = new ImportContextArgsDto(importContext);
                dto.setImportContext(importContext);
                HRImpPluginEngine.fireImptPluginEvent(importStart, "afterImportComplete", (AbstractEventArgs)dto);
                logger.info("Systemerrlog->" + info.getSystemerrlog());
                this.childThreadMonitor.getAndDecrement();
                this.dispatcher.getChildThreadSemaphore().release();
                OperateLogService.commonWriteLog((String)importContext.getAppId(), (String)importContext.getMainFormId(), (String)"bigExcelImport", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165", "BigExcelImportTask_0", "hrmp-hies-import"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165\u5b8c\u6210", "BigExcelImportTask_1", "hrmp-hies-import"), (String[])new String[0]);
            }
            catch (Throwable e) {
                logger.error("BigExcelImportTask_finally_error.", e);
            }
        }
        return null;
    }

    private void initUserPlugin(ImportStart importStart, String importPlugins) {
        ImportContext importContext = importStart.getImportContext();
        String templatePlugins = importContext.getTpl().getString("plugin");
        List tplAllEntitys = MethodUtil.getTplAllEntitys((DynamicObject)importContext.getTpl());
        List<HRImportPlugin> hrImportPlugin = UserImportPluginUtil.getHRImportPlugin(importPlugins, templatePlugins, null, (String)importContext.getExtOption().get("extParam"), importContext.getCustomParams(), tplAllEntitys);
        importContext.setUserPluginInstances(hrImportPlugin);
    }

    private void collectAppCacheData(ImportStart importStart, long start) {
        InstoreDispatcher instoreDispatcher = importStart.getInstoreDispatcher();
        if (instoreDispatcher != null) {
            instoreDispatcher.waiteChildFinished(instoreDispatcher.getWorkerMaxThread());
        }
        ImportContext importContext = importStart.getImportContext();
        int successedBillCount = importContext.getSuccessedBillCount().get();
        int finishedBillCount = importContext.getFinishedBillCount().get();
        int totalBillCount = importContext.getTotalBillCount();
        int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
        int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
        long spense = System.currentTimeMillis() - start;
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("spendTotalTime", String.valueOf(spense));
        customData.put("successedBillCount", String.valueOf(successedBillCount));
        customData.put("finishedBillCount", String.valueOf(finishedBillCount));
        customData.put("totalBillCount", String.valueOf(totalBillCount));
        customData.put("finishedValidateBillCount", String.valueOf(finishedValidateBillCount));
        customData.put("successedValidateBillCount", String.valueOf(successedValidateBillCount));
        customData.put("progress", 100);
        boolean isSysTerminator = importContext.isSysTerminator();
        customData.put("sysTerminator", isSysTerminator);
        boolean userTerminator = importContext.isUserHasTerminator();
        customData.put("userHasTerminator", userTerminator);
        customData.put("userStartTime", String.valueOf(importContext.getExtOption().get("userStartTime")));
        customData.put("userEndTime", String.valueOf(importContext.getExtOption().get("userEndTime")));
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(importStart.getImportContext().getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"result"), (Object)customData);
    }

    private Map<String, Object> initExtOption(Map<String, Object> map, DynamicObject tpl) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("userStartTime", map.get("userStartTime"));
        option.put("extParam", map.get("extParam"));
        option.put("callopStandExpense", MCConfigConstant.getStandExpense());
        option.put("disableRepeatDataValidator", false);
        String importtype = tpl.getString("importtype");
        if ("delete".equals(importtype)) {
            option.put("submitOP", "delete");
        } else {
            option.put("submitOP", "save");
        }
        return option;
    }

    private boolean initSerialModel(Object serialModel) {
        return !"concurrent".equals(serialModel);
    }

    private void initEntityCofigInfo(ImportContext importContext, ImportStart importStart) {
        ArrayList multiEntityDbTranSeq = Lists.newArrayListWithCapacity((int)6);
        HashMap entityUniqueVal = Maps.newHashMapWithExpectedSize((int)6);
        String mainEntityId = importContext.getTpl().getString("entity.id");
        String mainentityuniqueval = importContext.getTpl().getString("mainentityuniqueval");
        entityUniqueVal.put(mainEntityId, mainentityuniqueval);
        multiEntityDbTranSeq.add(mainEntityId);
        DynamicObjectCollection entityrelation = importContext.getTpl().getDynamicObjectCollection("entityrelation");
        HashMap entityRelationField = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        HashSet<String> allRelatMainEntityFields = new HashSet<String>();
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            String entityuniqueval = child.getString("entityuniqueval");
            entityUniqueVal.put(childId, entityuniqueval);
            multiEntityDbTranSeq.add(childId);
            String relationleftprop = child.getString("relationleftprop");
            String relationrightprop = child.getString("relationrightprop");
            if (!StringUtils.isNotEmpty((CharSequence)relationleftprop) || !StringUtils.isNotEmpty((CharSequence)relationrightprop)) continue;
            relationleftprop = relationleftprop.substring(relationleftprop.indexOf(46) + 1);
            relationrightprop = relationrightprop.substring(relationrightprop.indexOf(46) + 1);
            entityRelationField.put(childId, relationleftprop + ',' + relationrightprop);
            allRelatMainEntityFields.add(relationrightprop);
        }
        importContext.setEntityIdToUniqueValMap(entityUniqueVal);
        importContext.setMultiEntityDbTranSeq(multiEntityDbTranSeq);
        entityRelationField.put(mainEntityId, String.join((CharSequence)",", allRelatMainEntityFields));
        importContext.setEntityRelationField(entityRelationField);
        importStart.getMonitor().getImportTrace().getMems().put("entityRelationField", entityRelationField);
    }

    private TaskInfo saveTaskInfo(ImportStart importStart, long start) {
        TaskInfo info = new TaskInfo();
        try {
            ImportContext importContext = importStart.getImportContext();
            info.setId(importContext.getTaskPkId());
            info.setTotalamount(Integer.valueOf(importContext.getTotalBillCount()));
            info.setSucamount(Integer.valueOf(importContext.getSuccessedBillCount().get()));
            info.setFailamount(Integer.valueOf(importContext.getTotalBillCount() - importContext.getSuccessedBillCount().get()));
            Long starttime = (Long)importContext.getExtOption().get("userStartTime");
            Long endtime = (Long)importContext.getExtOption().get("userEndTime");
            info.setEtime(new Date(endtime));
            info.setTotalcost(Integer.valueOf((int)(endtime - starttime)));
            info.setProgress(Integer.valueOf(100));
            boolean sysTerminator = importContext.isSysTerminator();
            boolean userHasTerminator = importContext.isUserHasTerminator();
            if (sysTerminator || userHasTerminator) {
                info.setStatus(TaskState.TERMINATED);
            } else {
                info.setStatus(TaskState.FINISHED);
                if (importContext.getTotalBillCount() == importContext.getSuccessedBillCount().get()) {
                    info.setResult(TaskResult.SUCCESS);
                } else {
                    info.setResult(TaskResult.FAIL);
                }
            }
            if (userHasTerminator) {
                info.setInttime(new Date());
            }
            long spense = System.currentTimeMillis() - start;
            importStart.getMonitor().addExpenseStatistics("total", (Long)spense, true);
            int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
            ConcurrentHashMap<String, Object> other = importStart.getMonitor().getImportTrace().getOther();
            other.put("sheetDataSize", importStart.getImportContext().getSheetDataSizeMap());
            other.put("jvm", SerializationUtils.toJsonString(ManagementFactory.getRuntimeMXBean().getInputArguments()));
            importStart.getMonitor().collectBillCount(importContext);
            importStart.getMonitor().collectBdCacheCount(importContext);
            importStart.getMonitor().computeAverageExpense();
            info.setPerformancelog(importStart.getMonitor().getPerformancelog());
            info.setSystemerrlog(SerializationUtils.toJsonString(importContext.getImportLog().getErrorLogs()));
            HashMap validataMap = Maps.newHashMapWithExpectedSize((int)3);
            validataMap.put("rows", importContext.getImportLog().getRowErrors());
            validataMap.put("errors", importContext.getImportLog().getErrorInfos());
            info.setDatavalidlog(JSONObject.toJSONString((Object)validataMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNonStringKeyAsString}));
            StringBuilder str = new StringBuilder();
            importContext.getUserPluginInstances().forEach(pl -> {
                str.append(pl.getClass().getName());
                str.append(",");
            });
            info.setPluginrunlog(str.toString());
            HashMap extparamMap = Maps.newHashMapWithExpectedSize((int)16);
            extparamMap.put("successedValidateBillCount", successedValidateBillCount);
            info.setExtparam(JSONObject.toJSONString((Object)extparamMap));
            TaskInfoHelper.doUpdate((TaskInfo)info);
        }
        catch (Throwable e) {
            logger.error("saveTaskInfo_exception.", e);
        }
        return info;
    }

    private DynamicObject getTpl(ImportStart importStart) {
        long start = System.currentTimeMillis();
        DynamicObject tpl = TemplateConfService.load(importStart.getImportContext().getTplPkid());
        importStart.getMonitor().addExpenseStatistics("loadTpl", (Long)(System.currentTimeMillis() - start), true);
        return tpl;
    }

    private void initGlobalSysParam(ImportContext context) {
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        context.setSysParam(sysparam);
    }

    private void asyncDownloadFile(final ImportStart importStart) throws InterruptedException {
        final ImportContext importContext = importStart.getImportContext();
        final Parser parser = (Parser)importStart.getWorkers().get(Parser.class.getSimpleName());
        parser.getFileDownloadSemaphore().acquire();
        importStart.getPool().submit((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                long start = System.currentTimeMillis();
                logger.info("asyncDownloadFileTask_started.");
                try {
                    MethodUtil.syncRequestTraceId((Object)RequestContext.get());
                    String localPatch = ImportFileUtil.downloadFile((String)importContext.getFilePath());
                    importContext.setFileLocalPath(localPatch);
                }
                catch (Throwable e) {
                    logger.error(e);
                    importStart.writeErrorLog(e);
                }
                finally {
                    parser.getFileDownloadSemaphore().release();
                    importStart.getMonitor().addExpenseStatistics("asyncDownloadFileTask", (Long)(System.currentTimeMillis() - start), true);
                }
                return null;
            }
        });
    }

    private void recordTraceLog(ImportStart importStart, Map map, long startTime) {
        ConcurrentHashMap<String, Object> other = importStart.getMonitor().getImportTrace().getOther();
        other.put("taskExecuteTime", HRDateTimeUtils.format((Date)new Date(startTime)));
        other.put("sourceIp", map.get("sourceIp"));
        other.put("excuteIp", NetAddressUtils.getLocalIpAddress());
        other.put("isRecoveryTask", this.params.get("isRecoveryTask"));
        other.put("routeAppId", map.get("routeAppId"));
        other.put("taskPkId", map.get("taskPkId"));
        other.put("memoryConfig", MethodUtil.getMemoryConfig());
    }

    private void releaseCache(ImportContext importContext) {
        BaseDataContainer baseDataContainer = importContext.getBaseDataContainer();
        if (baseDataContainer != null) {
            EHcacheDiskCacheManager diskCacheManager;
            NettyOutJVMHeapManager outJVMHeapManager = baseDataContainer.getOutJVMHeapManager();
            if (outJVMHeapManager != null) {
                outJVMHeapManager.release();
            }
            if ((diskCacheManager = baseDataContainer.getDiskCacheManager()) != null) {
                diskCacheManager.close();
            }
        }
    }
}

