/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.init;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.plugin.CustomInstoreParam;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.ImportContextArgsDto;
import kd.hr.impt.core.ImportQueue;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.end.Reporter;
import kd.hr.impt.core.monitor.Monitor;
import kd.hr.impt.core.monitor.Progresser;
import kd.hr.impt.core.monitor.Terminator;
import kd.hr.impt.core.monitor.TimeRemainingAnalyser;
import kd.hr.impt.core.parse.Parser;
import kd.hr.impt.core.save.CustomInstoreDispatcher;
import kd.hr.impt.core.save.InstoreDataFlowSuggester;
import kd.hr.impt.core.save.InstoreDispatcher;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;
import kd.hr.impt.core.validate.DataValidateManager;
import kd.hr.impt.core.validate.ValidateDataFlowSuggester;
import org.apache.commons.lang3.StringUtils;

public class ImportStart {
    private static Log log = LogFactory.getLog(ImportStart.class);
    public Object syncLock = new Object();
    private ImportContext importContext;
    private ThreadPool pool = ThreadPools.newCachedThreadPool((String)(ImportStart.class.getSimpleName() + RequestContext.get().getTraceId()), (int)6, (int)15);
    private Map<String, ImportWorker> workers;
    private ImportQueue<ImportBillData> paserQueue;
    private ImportQueue<ImportBillData> tempStoreQueue;
    private ImportQueue<ImportBillData> waitInStoreQueue;
    private volatile boolean isStoped = false;
    private volatile boolean isMainThreadInterrupt = false;

    public ImportStart(ImportContext importContext) {
        this.importContext = importContext;
        this.workers = Maps.newHashMapWithExpectedSize((int)10);
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public Map<String, ImportWorker> getWorkers() {
        return this.workers;
    }

    public boolean isMainThreadInterrupt() {
        return this.isMainThreadInterrupt;
    }

    public void setMainThreadInterrupt(boolean mainThreadInterrupt) {
        this.isMainThreadInterrupt = mainThreadInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        log.info(ImportStart.class.getSimpleName() + "_start.");
        this.fireSetImportContextEvent();
        int configQueueSize = ImportStart.getConfigQueueSize(this);
        this.paserQueue = new ImportQueue("paserQueue", new LinkedBlockingQueue(configQueueSize), this);
        this.tempStoreQueue = new ImportQueue("tempStoreQueue", new LinkedBlockingQueue(configQueueSize), this);
        this.waitInStoreQueue = new ImportQueue("waitInStoreQueue", new LinkedBlockingQueue(configQueueSize), this);
        Parser parser = (Parser)this.getWorkers().get(Parser.class.getSimpleName());
        parser.setOutQueue(this.paserQueue);
        this.initImportStatus();
        Progresser progresser = new Progresser(this);
        int validateWorkerMaxThread = ValidateDataFlowSuggester.getWorkerMaxThread(this);
        ImportQueue<ImportBillData> validaOutQueue = this.importContext.isSerialModel() || this.importContext.isNeedRelationInStoreForMEMS() ? this.getTempStoreQueue() : this.getWaitInStoreQueue();
        DataValidateManager dataValidateManager = new DataValidateManager(this, validaOutQueue, validateWorkerMaxThread);
        InstoreDispatcher instoreDispatcher = this.startInstoreDispatcher();
        TimeRemainingAnalyser timeRemainingAnalyser = new TimeRemainingAnalyser(this);
        this.workers.put(progresser.getName(), progresser);
        this.workers.put(dataValidateManager.getName(), dataValidateManager);
        this.workers.put(instoreDispatcher.getName(), instoreDispatcher);
        this.workers.put(timeRemainingAnalyser.getName(), timeRemainingAnalyser);
        this.pool.submit((Callable)this.getMonitor());
        this.pool.submit((Callable)progresser);
        this.pool.submit((Callable)this.workers.get(Parser.class.getSimpleName()));
        this.pool.submit((Callable)dataValidateManager);
        this.pool.submit((Callable)instoreDispatcher);
        this.pool.submit((Callable)timeRemainingAnalyser);
        if (this.importContext.isSerialModel() || this.importContext.isNeedRelationInStoreForMEMS()) {
            TempStoreDispatcher storeDispatcher = new TempStoreDispatcher(this);
            this.pool.submit((Callable)storeDispatcher);
            this.workers.put(storeDispatcher.getName(), storeDispatcher);
        }
        log.info(ImportStart.class.getSimpleName() + "_started.");
        Object object = this.syncLock;
        synchronized (object) {
            this.syncLock.wait();
        }
        if (this.importContext.isSerialModel() && this.importContext.getSuccessedValidateBillCount().get() < this.importContext.getTotalBillCount()) {
            this.end(true);
        } else if (this.importContext.getSuccessedBillCount().get() < this.importContext.getTotalBillCount()) {
            this.end(true);
        } else {
            this.end(false);
        }
    }

    public void end(boolean needReport) {
        if (needReport) {
            Reporter reporter = new Reporter(this);
            this.workers.put(reporter.getName(), reporter);
            this.pool.submit((Callable)reporter);
        } else {
            try {
                ImportFileUtil.deleteLocalTempFile((String)this.importContext.getFileLocalPath());
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.isStoped = true;
        this.pool.close();
        log.info("ImportStart_normally_finished!");
    }

    private void initImportStatus() throws Exception {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)String.valueOf(this.importContext.getTaskPkId()), (String)ImportCacheKeyType.IMPORT, (String)"status"), (Object)"run");
        Terminator terminator = new Terminator(this);
        this.pool.submit((Callable)terminator);
        this.workers.put(terminator.getName(), terminator);
    }

    public void writeRowErrorLog(ImportRowErrorLog errorLog) {
        this.getImportContext().getImportLog().writeRowLog(errorLog);
    }

    public synchronized void writeErrorLog(Throwable throwable) {
        try {
            boolean userHasTerminator = this.importContext.isUserHasTerminator();
            if (userHasTerminator) {
                return;
            }
            List<String> errorLogs = this.getImportContext().getImportLog().getErrorLogs();
            if (errorLogs.size() > 5) {
                return;
            }
            String errorLog = HIESUtil.formatException((Throwable)throwable);
            this.getImportContext().getImportLog().getErrorLogs().add(errorLog);
        }
        catch (Throwable e) {
            log.error("ImportStart_writeErrorLog.", e);
        }
    }

    public Monitor getMonitor() {
        return (Monitor)this.workers.get(Monitor.class.getSimpleName());
    }

    public ImportQueue<ImportBillData> getPaserQueue() {
        return this.paserQueue;
    }

    public void setPaserQueue(ImportQueue<ImportBillData> paserQueue) {
        this.paserQueue = paserQueue;
    }

    public ImportQueue<ImportBillData> getTempStoreQueue() {
        return this.tempStoreQueue;
    }

    public void setTempStoreQueue(ImportQueue<ImportBillData> tempStoreQueue) {
        this.tempStoreQueue = tempStoreQueue;
    }

    public ImportQueue<ImportBillData> getWaitInStoreQueue() {
        return this.waitInStoreQueue;
    }

    public void setWaitInStoreQueue(ImportQueue<ImportBillData> waitInStoreQueue) {
        this.waitInStoreQueue = waitInStoreQueue;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    public void setStoped(boolean stoped) {
        this.isStoped = stoped;
    }

    private void fireSetImportContextEvent() {
        ImportContextArgsDto dto = new ImportContextArgsDto(this.importContext);
        dto.setImportContext(this.importContext);
        HRImpPluginEngine.fireImptPluginEvent(this, "afterInitContext", (AbstractEventArgs)dto);
        ConcurrentHashMap<String, Object> other = this.getMonitor().getImportTrace().getOther();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("entityIdToUniqueValMap", this.importContext.getEntityIdToUniqueValMap());
        map.put("multiEntityDbTranSeq", this.importContext.getMultiEntityDbTranSeq());
        map.put("excludeMultiEntityDbTran", this.importContext.getExcludeMultiEntityDbTran());
        map.put("callopStandExpense", this.importContext.getExtOption().get("callopStandExpense"));
        map.put("disableRepeatDataValidator", this.importContext.getExtOption().get("disableRepeatDataValidator"));
        map.put("enableBatchMultiCallOp", this.importContext.isEnableBatchMultiCallOp());
        map.put("enableSequenceInstore", this.importContext.isEnableSequenceInstore());
        map.put("enableRowStatistics", this.importContext.isEnableRowStatistics());
        map.put("customInstoreParam", this.importContext.getCustomInstoreParam());
        map.put("cusValidateBatchSize", this.importContext.getCusValidateBatchSize());
        map.put("cusValidateMaxThread", this.importContext.getCusValidateMaxThread());
        map.put("cusQueueSize", this.importContext.getCusQueueSize());
        other.put("afterInitContextEventParams", map);
    }

    private InstoreDispatcher startInstoreDispatcher() throws InterruptedException {
        int opWorkerMaxThread = InstoreDataFlowSuggester.getWorkerMaxThread(this);
        CustomInstoreParam customInstoreParam = this.importContext.getCustomInstoreParam();
        InstoreDispatcher instoreDispatcher = null;
        instoreDispatcher = customInstoreParam == null ? new InstoreDispatcher(this, opWorkerMaxThread) : new CustomInstoreDispatcher(this, customInstoreParam.isSync() ? 1 : opWorkerMaxThread);
        instoreDispatcher.getEntityBlankDynamicObjectSemaphore().acquire();
        return instoreDispatcher;
    }

    public InstoreDispatcher getInstoreDispatcher() {
        String instoreDispatcherName = this.importContext.getCustomInstoreParam() != null ? CustomInstoreDispatcher.class.getSimpleName() : InstoreDispatcher.class.getSimpleName();
        InstoreDispatcher instoreDispatcher = (InstoreDispatcher)this.getWorkers().get(instoreDispatcherName);
        return instoreDispatcher;
    }

    private static int getConfigQueueSize(ImportStart importStart) {
        int size = MCConfigConstant.getQueueSize();
        String cusQueueSize = importStart.getImportContext().getCusQueueSize();
        if (StringUtils.isNotEmpty((CharSequence)cusQueueSize)) {
            switch (cusQueueSize) {
                case "1000": {
                    size = 1000;
                    break;
                }
                case "2000": {
                    size = 2000;
                    break;
                }
            }
        }
        return size;
    }
}

