/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.monitor;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.Parser;
import kd.hr.impt.core.validate.DataValidateManager;

public class TimeRemainingAnalyser
extends ImportWorker {
    private static Log log = LogFactory.getLog(TimeRemainingAnalyser.class);
    public static final String HAS_GETALL_ASSESS_TOTALBILLCOUNT = "hasGetAllAssessTotalBillCount";
    public static final String ASSESS_TOTALBILLCOUNT = "assessTotalBillCount";
    private Date hasFinishedstartTime;
    private int timeRemaining;
    private int validateTimeRemaining;
    private int totalBillCount;

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public int getValidateTimeRemaining() {
        return this.validateTimeRemaining;
    }

    public TimeRemainingAnalyser(ImportStart importStart) {
        super(TimeRemainingAnalyser.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(TimeRemainingAnalyser.class.getSimpleName() + "_started.");
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put(HAS_GETALL_ASSESS_TOTALBILLCOUNT, false);
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                ImportContext importContext = this.importStart.getImportContext();
                this.totalBillCount = importContext.getTotalBillCount();
                Parser parser = (Parser)this.importStart.getWorkers().get(Parser.class.getSimpleName());
                if (parser != null && !parser.isEnd()) {
                    TimeRemainingAnalyser.getAssessTotalBillCount(importContext, params);
                    int assessTotalBillCount = (Integer)params.get(ASSESS_TOTALBILLCOUNT);
                    if (assessTotalBillCount > importContext.getTotalBillCount()) {
                        this.totalBillCount = assessTotalBillCount;
                        this.importStart.getMonitor().getImportTrace().getOther().put("TAUsedAssessCount", true);
                    }
                }
                if (importContext.isSerialModel()) {
                    this.computeValidateTimeRemaining();
                }
                this.computeTimeRemaining();
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }

    private void computeValidateTimeRemaining() {
        ImportContext importContext = this.importStart.getImportContext();
        DataValidateManager validateManager = (DataValidateManager)this.importStart.getWorkers().get(DataValidateManager.class.getSimpleName());
        Date startTime = validateManager.getValidateStartTime();
        AtomicInteger finishedValidateBillCount = importContext.getFinishedValidateBillCount();
        if (startTime == null || finishedValidateBillCount.get() == 0) {
            return;
        }
        double avgSpense = (double)(System.currentTimeMillis() - startTime.getTime()) / (double)finishedValidateBillCount.get();
        long timeRemaining = (long)((double)(this.totalBillCount - finishedValidateBillCount.get()) * avgSpense);
        this.validateTimeRemaining = (int)(timeRemaining / 1000L);
    }

    private void computeTimeRemaining() {
        ImportContext importContext = this.importStart.getImportContext();
        AtomicInteger finishedBillCount = importContext.getFinishedBillCount();
        if (this.hasFinishedstartTime == null && finishedBillCount.get() > 0) {
            this.hasFinishedstartTime = new Date();
        }
        if (this.hasFinishedstartTime == null || finishedBillCount.get() == 0) {
            return;
        }
        double avgSpense = (double)(System.currentTimeMillis() - this.hasFinishedstartTime.getTime()) / (double)finishedBillCount.get();
        long remainTime = (long)((double)(this.totalBillCount - finishedBillCount.get()) * avgSpense);
        this.timeRemaining = (int)(remainTime / 1000L);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> getAssessTotalBillCount(ImportContext importContext, Map<String, Object> params) {
        Boolean hasGetAllAssessTotalBillCount = (Boolean)params.get(HAS_GETALL_ASSESS_TOTALBILLCOUNT);
        if (hasGetAllAssessTotalBillCount.booleanValue()) {
            return params;
        }
        AtomicInteger assessTotalBillCount = new AtomicInteger(0);
        ConcurrentHashMap<String, Map<String, Integer>> sheetDataSizeMap = importContext.getSheetDataSizeMap();
        sheetDataSizeMap.values().forEach(item -> {
            Integer count = (Integer)item.get("totalCount");
            assessTotalBillCount.getAndAdd(count);
        });
        if (sheetDataSizeMap.size() == importContext.getSheetRowCountMap().size()) {
            params.put(HAS_GETALL_ASSESS_TOTALBILLCOUNT, true);
        }
        params.put(ASSESS_TOTALBILLCOUNT, assessTotalBillCount.get());
        return params;
    }
}

