/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.parse;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.parse.BillDataSizeAssessTask;
import kd.hr.impt.core.parse.Parser;

public class ExcelReadListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Log LOGGER = LogFactory.getLog(ExcelReadListener.class);
    private final Map<String, Set<String>> allBaseDataFieldKeys = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> allMulBaseDataFieldKeys = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> allRefBillFieldKeys = new HashMap<String, Set<String>>();
    private final Map<String, Set<Integer>> entryToColNum = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> entityToColNum = new HashMap<String, Set<Integer>>();
    Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName;
    private Parser parser;
    private String tplType;
    private Map<String, Map<String, DynamicObject>> tplFieldConfig;
    private boolean isMESS;
    private String setNullIdentify;
    private String curMainEntityNum;
    private String currentSheetName;
    private int curCellTotalIndex;
    private Set<String> curEntityAllBaseDataKeys = new HashSet<String>();
    private Set<String> curEntityAllMulBaseDataKeys = new HashSet<String>();
    private Set<String> curEntityAllRefBillKeys = new HashSet<String>();
    private Map<Integer, String> fieldNumRow;
    private int billIndex = 1;
    private int startIndex = 0;
    private int endIndex = 0;
    private int curExcelIndex = 0;
    private JSONObject data;
    private Set<Integer> emptyRowIndex;
    private Map<Integer, String> lastHeaderRow;

    public ExcelReadListener(Parser parser) {
        this.parser = parser;
        DynamicObject tplDy = parser.getImportStart().getImportContext().getTpl();
        this.isMESS = tplDy.get("entitytype").equals("MESS");
        this.tplType = tplDy.getString("importtype");
        this.tplFieldConfig = parser.getImportStart().getImportContext().getTplFieldConfig();
        this.entityBdFieldMainPropName = parser.getImportStart().getImportContext().getEntityBdFieldMainPropName();
        DynamicObject sysParamsDy = parser.getImportStart().getImportContext().getSysParam();
        if (sysParamsDy != null) {
            this.setNullIdentify = sysParamsDy.getString("setnullparam");
        }
        if ("localupload".equalsIgnoreCase(tplDy.getString("tplgenmode"))) {
            DynamicObjectCollection collection = tplDy.getDynamicObjectCollection("entryentity");
            parser.getImportStart().getImportContext().setReadRowOfSheetName(collection.stream().collect(Collectors.toMap(dy -> dy.getString("sheetname"), dy2 -> dy2.getInt("sheetreadrow"), (x1, x2) -> x1)));
        }
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext analysisContext) {
        this.currentSheetName = analysisContext.readSheetHolder().getSheetName();
        headMap.values().removeIf(Objects::isNull);
        boolean isFirstSheet = this.parser.getImportStart().getImportContext().getEffectSheetNames().get(0).equalsIgnoreCase(this.currentSheetName);
        if (!isFirstSheet) {
            this.parser.getImportStart().getImportContext().setHasErrorRow(StringUtils.isEmpty((CharSequence)HIESUtil.getSplitValue((String)headMap.get(0))));
            this.handleEntityRow(headMap);
        }
    }

    public void invoke(Map<Integer, String> rowData, AnalysisContext analysisContext) {
        Integer rowIndex = analysisContext.readRowHolder().getRowIndex();
        this.currentSheetName = analysisContext.readSheetHolder().getSheetName();
        rowData.values().removeIf(Objects::isNull);
        this.curExcelIndex = rowIndex + 1;
        if (this.parser.getImportStart().isStoped()) {
            return;
        }
        boolean isFirstSheet = this.parser.getImportStart().getImportContext().getEffectSheetNames().get(0).equalsIgnoreCase(this.currentSheetName);
        int currRowNum = isFirstSheet ? rowIndex - 1 : rowIndex;
        int fieldNameRowNum = 4;
        if (this.parser.getImportStart().getImportContext().getReadRowOfSheetName() != null) {
            int readRowOfSheetName = this.parser.getImportStart().getImportContext().getReadRowOfSheetName().getOrDefault(this.currentSheetName, 6);
            fieldNameRowNum = isFirstSheet ? readRowOfSheetName - 3 : readRowOfSheetName - 2;
        }
        try {
            int offSet;
            if (currRowNum == 0) {
                this.parser.getImportStart().getImportContext().setHasErrorRow(StringUtils.isEmpty((CharSequence)HIESUtil.getSplitValue((String)rowData.get(0))));
                this.handleEntityRow(rowData);
            } else if (currRowNum == 3) {
                this.fieldNumRow = rowData;
                int n = offSet = this.parser.getImportStart().getImportContext().isHasErrorRow() ? 1 : 2;
                if (this.isMESS) {
                    HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
                    this.groupByEntity(rowData, rowDataGroup);
                    rowDataGroup.forEach((entityNum, mapTemp) -> {
                        HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                        mapTemp.forEach((key, value) -> map.put(value, HIESUtil.tranDecimalToBase26((int)(key + offSet))));
                        this.parser.getImportStart().getImportContext().setCellIndexOfEntities((String)entityNum, map);
                        this.curCellTotalIndex = map.size();
                    });
                } else {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                    rowData.forEach((key, value) -> map.put(value, HIESUtil.tranDecimalToBase26((int)(key + offSet))));
                    this.parser.getImportStart().getImportContext().setCellIndexOfEntities(this.curMainEntityNum, map);
                    this.curCellTotalIndex = map.size();
                }
            } else if (currRowNum == fieldNameRowNum) {
                int n = offSet = this.parser.getImportStart().getImportContext().isHasErrorRow() ? 1 : 2;
                if (this.isMESS) {
                    HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
                    this.groupByEntity(rowData, rowDataGroup);
                    rowDataGroup.forEach((entityNum, mapTemp) -> {
                        HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                        mapTemp.forEach((key, value) -> map.put(HIESUtil.tranDecimalToBase26((int)(key + offSet)), value));
                        this.parser.getImportStart().getImportContext().setCellNameIndexOfEntities((String)entityNum, map);
                    });
                } else {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                    rowData.forEach((key, value) -> map.put(HIESUtil.tranDecimalToBase26((int)(key + offSet)), value));
                    this.parser.getImportStart().getImportContext().setCellNameIndexOfEntities(this.curMainEntityNum, map);
                }
            } else if (currRowNum > fieldNameRowNum) {
                this.handDataRow(rowData);
            }
        }
        catch (Throwable exception) {
            LOGGER.error("ExcelImportSheetHandler.handleRow() error:", exception);
            throw exception;
        }
        this.parser.getImportStart().getImportContext().addParserCount();
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleEntityRow(Map<Integer, String> entityRowData) {
        ImportContext importContext = this.parser.getImportStart().getImportContext();
        String entityName = importContext.isHasErrorRow() ? entityRowData.get(1) : entityRowData.get(0);
        this.curMainEntityNum = HIESUtil.getSplitValue((String)entityName);
        this.getAllBaseDataFieldKeys(this.curMainEntityNum);
        if (this.isMESS) {
            DynamicObjectCollection entityRelationCollection = importContext.getTpl().getDynamicObjectCollection("entityrelation");
            ArrayList entityRelation = Lists.newArrayListWithExpectedSize((int)entityRelationCollection.size());
            for (DynamicObject dynamicObject : entityRelationCollection) {
                String relationEntityNum = dynamicObject.getString("rentity.number");
                this.getAllBaseDataFieldKeys(relationEntityNum);
                entityRelation.add(relationEntityNum);
            }
            HashMap<Integer, String> relationRowData = new HashMap<Integer, String>(entityRowData.size());
            entityRowData.forEach((key, value) -> {
                String splitValue = HIESUtil.getSplitValue((String)value);
                if (entityRelation.contains(splitValue) || splitValue.equals(this.curMainEntityNum)) {
                    relationRowData.put((Integer)key, splitValue);
                }
            });
            Map<Integer, Set<Integer>> entityInt2Range = this.getIntegerSetMap(relationRowData);
            relationRowData.forEach((key, value) -> this.entityToColNum.put(HIESUtil.getSplitValue((String)value), (Set<Integer>)entityInt2Range.get(key)));
            LOGGER.info("ExcelImportSheetHandler_handleEntityRow(),entityToColNum:{}", this.entityToColNum);
        }
        Map<Integer, Set<Integer>> int2Range = this.getIntegerSetMap(entityRowData);
        entityRowData.forEach((key, value) -> {
            String splitValue = HIESUtil.getSplitValue((String)value);
            Set integers = (Set)int2Range.get(key);
            if (this.entryToColNum.get(splitValue) != null) {
                integers.addAll((Collection)this.entryToColNum.get(splitValue));
            }
            this.entryToColNum.put(splitValue, integers);
        });
        LOGGER.info("ExcelImportSheetHandler_handleEntityRow(),entryToColNum:{}", this.entryToColNum);
    }

    @ExcludeFromJacocoGeneratedReport
    private void handDataRow(Map<Integer, String> rowData) {
        int currRowNum = this.curExcelIndex - 1;
        if (rowData.size() == 0) {
            if (this.emptyRowIndex == null) {
                this.emptyRowIndex = Sets.newHashSet();
            }
            this.emptyRowIndex.add(currRowNum);
            if (this.data != null) {
                ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.currentSheetName, this.billIndex, this.startIndex, this.endIndex, this.parser.getImportStart().getImportContext().getTpl());
                importBillData.setOpType(this.tplType);
                this.pushBillData(importBillData);
                ++this.billIndex;
            }
            return;
        }
        if (this.parser.getImportStart().getImportContext().isHasErrorRow()) {
            rowData.remove(0);
        }
        Set<Integer> fieldRange = rowData.keySet();
        Set<Integer> colIndexOfEntity = this.entryToColNum.get(this.curMainEntityNum);
        if (currRowNum == 5) {
            LOGGER.info("ExcelImportSheetHandler.handDataRow(),curMainEntityNum:{},entryToColNum:{}", (Object)this.curMainEntityNum, this.entryToColNum);
        }
        if (colIndexOfEntity == null) {
            return;
        }
        HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
        if (this.isMESS) {
            this.groupByEntity(rowData, rowDataGroup);
        }
        boolean isNotSameOne = fieldRange.stream().anyMatch(colIndexOfEntity::contains);
        if (this.lastHeaderRow != null && isNotSameOne && currRowNum > 5) {
            AtomicBoolean flag = new AtomicBoolean(true);
            if (this.lastHeaderRow.equals(rowData)) {
                flag.set(false);
            } else {
                colIndexOfEntity.forEach(num -> {
                    String value1 = this.lastHeaderRow.get(num);
                    String value2 = (String)rowData.get(num);
                    if (value1 != null && !value1.equals(value2) || value2 != null && !value2.equals(value1)) {
                        flag.set(false);
                    }
                });
            }
            if (flag.get()) {
                isNotSameOne = false;
            }
        }
        if (isNotSameOne) {
            this.lastHeaderRow = rowData;
            this.buildNewBillData(rowData, rowDataGroup);
        } else {
            ++this.endIndex;
            if (this.isMESS) {
                rowDataGroup.forEach(this::addNewEntryBatchByIsMESS);
            } else {
                this.addNewEntryBatch(this.curMainEntityNum, rowData, this.data.getJSONObject(this.curMainEntityNum));
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void groupByEntity(Map<Integer, String> rowData, Map<String, Map<Integer, String>> rowDataGroup) {
        rowData.forEach((key1, value) -> {
            Optional<Map.Entry> optional = this.entityToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(key1)).findFirst();
            if (optional.isPresent()) {
                Map orDefault = rowDataGroup.getOrDefault(optional.get().getKey(), new HashMap());
                orDefault.put(key1, value);
                rowDataGroup.put((String)optional.get().getKey(), orDefault);
            }
        });
    }

    private void buildNewBillData(Map<Integer, String> rowData, Map<String, Map<Integer, String>> rowDataGroup) {
        if (this.data != null) {
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.currentSheetName, this.billIndex, this.startIndex, this.endIndex, this.parser.getImportStart().getImportContext().getTpl());
            importBillData.setOpType(this.tplType);
            this.pushBillData(importBillData);
            ++this.billIndex;
        }
        if (this.isMESS) {
            this.data = new JSONObject();
            rowDataGroup.forEach((key, value) -> {
                if (key.equals(this.curMainEntityNum)) {
                    this.data.putAll((Map)this.rowConvertJson((String)key, (Map<Integer, String>)value));
                } else {
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add((Object)this.rowConvertJson((String)key, (Map<Integer, String>)value).getJSONObject(key));
                    this.data.put(key, (Object)jsonArray);
                }
            });
        } else {
            this.data = this.rowConvertJson(this.curMainEntityNum, rowData);
        }
        this.endIndex = this.startIndex = this.curExcelIndex;
    }

    private JSONObject rowConvertJson(String curEntityId, Map<Integer, String> rowData) {
        JSONObject dataMap = new JSONObject(rowData.size());
        JSONObject entityLevelMap = new JSONObject(rowData.size());
        this.curEntityAllBaseDataKeys = this.allBaseDataFieldKeys.get(curEntityId);
        this.curEntityAllMulBaseDataKeys = this.allMulBaseDataFieldKeys.get(curEntityId);
        this.curEntityAllRefBillKeys = this.allRefBillFieldKeys.get(curEntityId);
        for (Map.Entry<Integer, String> row : rowData.entrySet()) {
            Integer index = row.getKey();
            if (this.parser.getImportStart().getImportContext().isHasErrorRow() && index.longValue() == 0L) continue;
            Optional<Map.Entry> optional = this.entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(index)).findFirst();
            String entityKey = optional.isPresent() ? (String)optional.get().getKey() : "";
            boolean isMainEntity = entityKey.equalsIgnoreCase(curEntityId);
            String fieldKey = this.fieldNumRow.get(index);
            if (StringUtils.isBlank((CharSequence)fieldKey)) continue;
            Object fieldLevelMap = entityLevelMap.computeIfAbsent((Object)entityKey, key -> {
                if (isMainEntity) {
                    return null;
                }
                return new JSONArray();
            });
            if (null != fieldLevelMap) {
                if (fieldLevelMap instanceof JSONArray) {
                    Object tempMap = ((JSONArray)fieldLevelMap).size() > 0 ? ((JSONArray)fieldLevelMap).get(0) : new JSONObject();
                    this.buildDataMap(curEntityId, row, fieldKey, tempMap);
                    ((JSONArray)fieldLevelMap).clear();
                    ((JSONArray)fieldLevelMap).add(tempMap);
                    continue;
                }
                this.buildDataMap(curEntityId, row, fieldKey, fieldLevelMap);
                continue;
            }
            this.buildDataMap(curEntityId, row, fieldKey, entityLevelMap);
        }
        dataMap.put(curEntityId, (Object)entityLevelMap);
        return dataMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private void buildDataMap(String curEntityId, Map.Entry<Integer, String> row, String fieldKey, Object dataMapList) {
        if (StringUtils.isBlank((CharSequence)fieldKey) || "null".equals(fieldKey)) {
            LOGGER.info("ExcelReadListener.buildDataMap_fieldKey_null:{}", (Object)fieldKey);
            return;
        }
        String rowValue = row.getValue().equals(this.setNullIdentify) ? null : row.getValue();
        JSONObject dataMap = new JSONObject();
        if (dataMapList == null) {
            return;
        }
        if (dataMapList instanceof JSONObject) {
            dataMap = (JSONObject)dataMapList;
            dataMap.putIfAbsent((Object)"$excelIndex", (Object)this.curExcelIndex);
        }
        String baseDataFormatValue = "";
        DynamicObject fieldDy = this.tplFieldConfig.get(curEntityId).get(MethodUtil.getLevelOneKey((String)fieldKey));
        if (!ObjectUtils.isEmpty((Object)fieldDy)) {
            baseDataFormatValue = fieldDy.getString("imptattr");
        }
        Map<String, Map<String, Object>> entityFieldProName = this.entityBdFieldMainPropName.get(curEntityId);
        if (fieldKey.contains(".")) {
            this.putMulLevelDataMap(fieldKey, rowValue, dataMap);
        } else if (this.curEntityAllBaseDataKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && "number_name".equalsIgnoreCase(baseDataFormatValue) && rowValue != null) {
            this.putBaseDataMap(rowValue, fieldKey, dataMap, entityFieldProName);
        } else if (this.curEntityAllMulBaseDataKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && "number_name".equalsIgnoreCase(baseDataFormatValue) && rowValue != null) {
            String[] splits = rowValue.split(",");
            Map<String, Object> fieldProName = entityFieldProName.get(MethodUtil.getLevelOneKey((String)fieldKey));
            String realName = (String)fieldProName.get("name");
            String realNumber = (String)fieldProName.get("number");
            JSONArray tempArray = new JSONArray();
            for (String split : splits) {
                String[] temp = split.split("##");
                JSONObject tempJson = new JSONObject();
                tempJson.put(realNumber, (Object)temp[0]);
                tempJson.put(realName, (Object)(temp.length > 1 ? temp[1] : ""));
                if (rowValue.contains("##")) {
                    tempJson.put("$bdSplit", (Object)"##");
                }
                tempArray.add((Object)tempJson);
            }
            dataMap.put(fieldKey, (Object)tempArray);
        } else if (this.curEntityAllRefBillKeys.contains(fieldKey) && rowValue != null) {
            JSONObject tempJson = new JSONObject();
            tempJson.put("billno", (Object)rowValue);
            dataMap.put(fieldKey, (Object)tempJson);
        } else {
            dataMap.put(fieldKey, (Object)rowValue);
        }
    }

    private void putMulLevelDataMap(String fieldKey, String rowValue, JSONObject dataMap) {
        String[] split = fieldKey.split("\\.");
        String splitFirst = split[0];
        String splitSecond = split[1];
        if (this.curEntityAllMulBaseDataKeys.contains(splitFirst)) {
            if (rowValue == null) {
                dataMap.put(splitFirst, null);
            } else {
                JSONArray map = new JSONArray();
                Arrays.stream(rowValue.split(",")).forEach(array -> {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, array);
                    map.add((Object)temp);
                });
                JSONArray jobjs = (JSONArray)dataMap.get((Object)splitFirst);
                if (jobjs == null) {
                    dataMap.put(splitFirst, (Object)map);
                } else {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, (Object)rowValue);
                    jobjs.add((Object)temp);
                }
            }
        } else {
            if (this.curEntityAllBaseDataKeys.contains(MethodUtil.getLevelOneKey((String)fieldKey)) && rowValue == null) {
                dataMap.put(splitFirst, null);
                return;
            }
            JSONObject map = dataMap.containsKey((Object)splitFirst) ? dataMap.getJSONObject(splitFirst) : new JSONObject();
            map.put(splitSecond, (Object)rowValue);
            dataMap.put(split[0], (Object)map);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void putBaseDataMap(String rowValue, String fieldKey, JSONObject dataMap, Map<String, Map<String, Object>> entityFieldProName) {
        if (rowValue == null) {
            dataMap.put(fieldKey, null);
        } else {
            Map<String, Object> fieldProName = entityFieldProName.get(MethodUtil.getLevelOneKey((String)fieldKey));
            String realName = (String)fieldProName.get("name");
            String realNumber = (String)fieldProName.get("number");
            String[] split = rowValue.split("##");
            JSONObject tempJson = new JSONObject();
            tempJson.put(realNumber, (Object)split[0]);
            tempJson.put(realName, (Object)(split.length > 1 ? split[1] : ""));
            if (rowValue.contains("##")) {
                tempJson.put("$bdSplit", (Object)"##");
            }
            dataMap.put(fieldKey, (Object)tempJson);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void addNewEntryBatchByIsMESS(String curEntityNum, Map<Integer, String> rowData) {
        Set<Integer> fieldRange = rowData.keySet();
        Set<Integer> integers = this.entryToColNum.get(curEntityNum);
        Object dataObject = this.data.get((Object)curEntityNum);
        if (fieldRange.stream().noneMatch(integers::contains)) {
            if (dataObject instanceof JSONArray) {
                int size = ((JSONArray)dataObject).size() - 1;
                JSONObject jsonObject = ((JSONArray)dataObject).getJSONObject(size);
                this.addNewEntryBatch(curEntityNum, rowData, jsonObject);
                ((JSONArray)dataObject).remove(size);
                ((JSONArray)dataObject).add((Object)jsonObject);
                this.data.put(curEntityNum, dataObject);
            } else {
                this.addNewEntryBatch(curEntityNum, rowData, (JSONObject)dataObject);
            }
        } else if (dataObject instanceof JSONArray) {
            ((JSONArray)dataObject).add((Object)this.rowConvertJson(curEntityNum, rowData).getJSONObject(curEntityNum));
            this.data.put(curEntityNum, dataObject);
        }
    }

    private void addNewEntryBatch(String curEntityId, Map<Integer, String> rowData, JSONObject entityLevelMap) {
        this.curEntityAllBaseDataKeys = this.allBaseDataFieldKeys.get(curEntityId);
        this.curEntityAllMulBaseDataKeys = this.allMulBaseDataFieldKeys.get(curEntityId);
        JSONObject entryMap = new JSONObject();
        this.entryToColNum.keySet().stream().filter(field -> !field.equals(curEntityId)).forEach(entityKey -> entryMap.put(entityKey, (Object)new JSONObject()));
        for (Map.Entry<Integer, String> ob : rowData.entrySet()) {
            Integer index = ob.getKey();
            String fieldKey = this.fieldNumRow.get(index);
            Optional<Map.Entry> findFirst = this.entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(index)).findFirst();
            if (!findFirst.isPresent()) {
                LOGGER.info("ExcelImportSheetHandler.addNewEntryBatch(),entryToColNum:{},index:{},fieldKey:{}", new Object[]{this.entryToColNum, index, fieldKey});
                continue;
            }
            String entityKey2 = (String)findFirst.get().getKey();
            JSONObject fieldLevelMap = entryMap.getJSONObject(entityKey2);
            this.buildDataMap(curEntityId, ob, fieldKey, fieldLevelMap);
            entryMap.put(entityKey2, (Object)fieldLevelMap);
        }
        for (Map.Entry<Integer, String> entity : entryMap.entrySet()) {
            Object fieldLevelMap = entityLevelMap.get((Object)entity.getKey());
            if (fieldLevelMap == null && !((String)((Object)entity.getKey())).equalsIgnoreCase(curEntityId)) {
                fieldLevelMap = entityLevelMap.computeIfAbsent((Object)entity.getKey(), val -> new JSONArray());
            }
            if (!(fieldLevelMap instanceof JSONArray) || ObjectUtils.isEmpty((Object)entity.getValue())) continue;
            ((JSONArray)fieldLevelMap).add((Object)entity.getValue());
        }
        this.data.put(curEntityId, (Object)entityLevelMap);
    }

    private void pushBillData(ImportBillData billData) {
        ImportContext importContext = this.parser.getImportStart().getImportContext();
        AfterParseBillDataEventArgs args = new AfterParseBillDataEventArgs(importContext, billData);
        HRImpPluginEngine.fireImptPluginEvent(this.parser.getImportStart(), "afterParseBillData", (AbstractEventArgs)args);
        int retryCount = 100;
        this.parser.putToOutQueue(billData, retryCount);
        int count = ImportUtil.statisticsBillCount(billData, importContext.isEnableRowStatistics());
        importContext.addTotalBillCount(count);
        this.collectBillDataToAssess(billData);
        this.data = null;
    }

    @ExcludeFromJacocoGeneratedReport
    private void collectBillDataToAssess(ImportBillData billData) {
        List importBillData;
        Parser parser = this.parser;
        ImportContext importContext = parser.getImportStart().getImportContext();
        if (BillDataSizeAssessTask.canTriggerBillDataSizeAssess(importContext) && (importBillData = parser.getSheetDataSamplingMap().computeIfAbsent(billData.getSheetName(), ob -> new ArrayList(10))).size() < 10) {
            importBillData.add(billData);
            if (importBillData.size() == 10) {
                parser.getImportStart().getPool().submit((Callable)new BillDataSizeAssessTask(this.parser, importBillData));
            }
        }
    }

    private void getAllBaseDataFieldKeys(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            LOGGER.warn("ExcelImportSheetHandler_getAllBaseDataFieldKeys(),entityId is null");
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        HashSet allKeys = new HashSet();
        HashSet allMulKeys = new HashSet();
        HashSet allRefBillKeys = new HashSet();
        HIESUtil.getAllBDFieldKeys((DataEntityPropertyCollection)entityType.getProperties(), allKeys, allMulKeys, allRefBillKeys);
        this.allBaseDataFieldKeys.put(entityId, allKeys);
        this.allMulBaseDataFieldKeys.put(entityId, allMulKeys);
        this.allRefBillFieldKeys.put(entityId, allRefBillKeys);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        if (this.data != null) {
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.currentSheetName, this.billIndex, this.startIndex, this.endIndex, this.parser.getImportStart().getImportContext().getTpl());
            importBillData.setOpType(this.tplType);
            this.pushBillData(importBillData);
            ++this.billIndex;
        }
        if (this.emptyRowIndex == null) {
            this.emptyRowIndex = Sets.newHashSet();
        }
        this.parser.getImportStart().getImportContext().getImportLog().addEmptyRowIndex(this.currentSheetName, this.emptyRowIndex);
        this.emptyRowIndex = Sets.newHashSet();
        this.curMainEntityNum = null;
        this.startIndex = 0;
        this.entryToColNum.clear();
        this.entityToColNum.clear();
    }

    protected Map<Integer, Set<Integer>> getIntegerSetMap(Map<Integer, String> rowData) {
        HashMap<Integer, Set<Integer>> int2Range = new HashMap<Integer, Set<Integer>>(rowData.size());
        Object[] integers = rowData.keySet().toArray(new Integer[0]);
        Arrays.sort(integers);
        for (int index = 0; index < integers.length; ++index) {
            int end = index + 1 < integers.length ? (Integer)integers[index + 1] : 500;
            HashSet<Integer> range = new HashSet<Integer>(rowData.size());
            for (int count = ((Integer)integers[index]).intValue(); count < end; ++count) {
                range.add(count);
            }
            int2Range.put((Integer)integers[index], range);
        }
        return int2Range;
    }
}

