/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.parse;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.SheetHandler;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelReader {
    private static final Log log = LogFactory.getLog(ExcelReader.class);
    protected ImportStart importStart;

    public ExcelReader(ImportStart importStart) {
        this.importStart = importStart;
    }

    public void read(File file, SheetHandler sheetHandler) throws Exception {
        this.readByWayType(file, sheetHandler, "common");
    }

    public void readByWayType(File file, SheetHandler sheetHandler, String readerWayType) throws Exception {
        String sheetName;
        InputStream sheet;
        log.info("ExcelReader_read_started.");
        log.info("ExcelReader_read_filePath=" + file.getPath());
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        XSSFReader xssfReader = new XSSFReader(pkg);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        LinkedList<String> allSheetNames = new LinkedList<String>();
        while (sheets.hasNext()) {
            sheets.next();
            String sheetName2 = sheets.getSheetName();
            allSheetNames.add(sheetName2);
        }
        sheetHandler.setAllSheetNames(allSheetNames);
        if (this.importStart != null) {
            sheetHandler.setEffectSheetNames(this.importStart.getImportContext().getEffectSheetNames());
        }
        sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        if (!"mergeCell".equals(readerWayType)) {
            sheetHandler.setSharedStringsTable((SharedStringsTable)xssfReader.getSharedStringsTable());
        }
        sheetHandler.setStylesTable(xssfReader.getStylesTable());
        XMLReader reader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setContentHandler(sheetHandler);
        ReaderWay readerWay = this.getReaderWay(readerWayType, sheetHandler, reader, sheets);
        try {
            if (readerWay instanceof MergeCellReaderWay) {
                MergeCellReaderWay mergeCellReaderWay = (MergeCellReaderWay)readerWay;
                mergeCellReaderWay.handleWb(xssfReader.getWorkbookData());
            }
        }
        catch (KDBizException e) {
            if (e.getErrorCode().getCode().equals("908")) {
                log.info(e.getMessage());
            }
            pkg.close();
            throw e;
        }
        while (sheets.hasNext() && !readerWay.interrupt(sheet = sheets.next(), sheetName = sheets.getSheetName())) {
            try {
                List<String> effectSheetNames = this.importStart == null ? null : this.importStart.getImportContext().getEffectSheetNames();
                readerWay.handle(sheet, effectSheetNames, sheetName);
            }
            catch (KDBizException e) {
                if (e.getErrorCode().getCode().equals("908")) {
                    log.info(e.getMessage());
                    continue;
                }
                pkg.close();
                throw e;
            }
        }
        pkg.close();
    }

    private ReaderWay getReaderWay(String readerWayType, SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
        if (StringUtils.isBlank((CharSequence)readerWayType)) {
            return new CommonReaderWay(sheetHandler, parser, sheets);
        }
        switch (readerWayType) {
            case "fail": {
                return new FailReaderWay(sheetHandler, parser, sheets);
            }
            case "sensitive": {
                return new SensitiveReaderWay(sheetHandler, parser, sheets);
            }
            case "mergeCell": {
                return new MergeCellReaderWay(sheetHandler, parser, sheets);
            }
        }
        return new CommonReaderWay(sheetHandler, parser, sheets);
    }

    @ExcludeFromJacocoGeneratedReport
    static class SensitiveReaderWay
    extends CommonReaderWay {
        private int count = 0;

        public SensitiveReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (this.count++ == 0 || StringUtils.isNotBlank((CharSequence)sheetName) && StringUtils.equals((CharSequence)sheetName, (CharSequence)"sensitive_fields_sheet")) {
                super.handle(sheet, effectSheetNames, sheetName);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    static class MergeCellReaderWay
    extends CommonReaderWay {
        public MergeCellReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (sheetName.endsWith("DDM")) {
                return;
            }
            InputSource sheetSource = new InputSource(sheet);
            this.sheetHandler.setCurrentSheetName(this.sheets.getSheetName());
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        public void handleWb(InputStream wb) throws Exception {
            InputSource wbSource = new InputSource(wb);
            this.parser.parse(wbSource);
            wb.close();
        }
    }

    static class FailReaderWay
    extends CommonReaderWay {
        public FailReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (this.sheetHandler.isIgnoreStyle() && !effectSheetNames.contains(sheetName) && sheetName.equals(this.sheetHandler.getAllSheetNames().get(0)) && !sheetName.endsWith("DDM")) {
                return;
            }
            InputSource sheetSource = new InputSource(sheet);
            String curSheetName = this.sheets.getSheetName();
            if (StringUtils.isNotBlank((CharSequence)curSheetName)) {
                this.sheetHandler.setCurrentSheetName(curSheetName);
                Comments comments = this.sheets.getSheetComments();
                if (comments != null) {
                    this.sheetHandler.addSheetComments(curSheetName, (CommentsTable)comments);
                }
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }
    }

    static class CommonReaderWay
    implements ReaderWay {
        protected SheetHandler sheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.sheetHandler = sheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (sheetName.endsWith("DDM") || effectSheetNames != null && !effectSheetNames.contains(sheetName)) {
                return;
            }
            InputSource sheetSource = new InputSource(sheet);
            this.sheetHandler.setCurrentSheetName(this.sheets.getSheetName());
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                return this.sheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, List<String> var2, String var3) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

