/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterDbTanRollbackEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.CallMultiOperationTask;
import kd.hr.impt.core.save.CombineDataConvertDynamicObject;
import kd.hr.impt.core.save.InstoreDispatcher;

@ExcludeFromJacocoGeneratedReport
public class CallBatchMultiOperationTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(CallBatchMultiOperationTask.class);
    private ImportStart importStart;
    private List<ImportBillData> tempBilldatas;
    private String mainSheetName;
    private Map<Object, Map<String, Object>> idMapRowIndex;
    private AtomicInteger childThreadMonitor;
    private AtomicInteger dataCanStopFlag;
    private InstoreDispatcher dispatcher;

    public CallBatchMultiOperationTask(List<ImportBillData> tempBilldatas, ImportStart importStart, InstoreDispatcher dispatcher, AtomicInteger childThreadMonitor, AtomicInteger dataCanStopFlag) {
        this.childThreadMonitor = childThreadMonitor;
        this.dataCanStopFlag = dataCanStopFlag;
        this.dataCanStopFlag.getAndIncrement();
        this.tempBilldatas = tempBilldatas;
        this.mainSheetName = tempBilldatas.get(0).getSheetName();
        this.importStart = importStart;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(CallBatchMultiOperationTask.class.getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ImportContext importContext = this.importStart.getImportContext();
        int totalCount = 0;
        try {
            this.dispatcher.getImportStart().getMonitor().addOtherListData(CallBatchMultiOperationTask.class.getSimpleName() + "_received", this.tempBilldatas.size());
            CombineDataConvertDynamicObject convert = new CombineDataConvertDynamicObject(this.importStart, this.dispatcher);
            log.info("before_convert.toDynamicObject_count=" + this.tempBilldatas.size());
            List<Map<String, Object>> dynamicObjects = convert.toDynamicObject(this.tempBilldatas, this.dispatcher.getEntityBlankDynamicObject());
            log.info("after_convert.toDynamicObject_count=" + dynamicObjects.size());
            AfterConvertDynamicObjectsEventArgs args0 = new AfterConvertDynamicObjectsEventArgs(importContext);
            args0.setImportBillDatas(this.tempBilldatas);
            HashMap groupDys = Maps.newHashMapWithExpectedSize((int)1);
            groupDys.put("default", dynamicObjects);
            args0.setMutilDynamicObjects(groupDys);
            HRImpPluginEngine.fireImptPluginEvent(this.importStart, "AfterConvertDynamicObjects", (AbstractEventArgs)args0);
            Map<Object, Integer> idBillCountMap = CallMultiOperationTask.initIdBillCountMap(this.tempBilldatas, importContext);
            totalCount = idBillCountMap.values().stream().mapToInt(count -> count).sum();
            this.idMapRowIndex = this.initIdMapRowIndex(this.tempBilldatas);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                log.info("convert.toDynamicObject_failed.count=" + this.tempBilldatas.size());
                importContext.addFinishedBillCount(totalCount);
                this.dataCanStopFlag.getAndDecrement();
                Object var10_12 = null;
                return var10_12;
            }
            if (this.importStart.isStoped()) {
                Object var10_13 = null;
                return var10_13;
            }
            this.callOp(groupDys, dynamicObjects, totalCount);
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(totalCount);
            log.error(CallBatchMultiOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(this.tempBilldatas, this.importStart, e);
            this.dataCanStopFlag.getAndDecrement();
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(CallBatchMultiOperationTask.class, (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private Map<Object, Map<String, Object>> initIdMapRowIndex(List<ImportBillData> tempBilldatas) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        for (ImportBillData data : tempBilldatas) {
            Collection values = data.getData().values();
            for (Map.Entry next1 : data.getData().entrySet()) {
                for (Object val : values) {
                    if (val instanceof JSONObject) {
                        JSONObject obj = (JSONObject)val;
                        DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(next1.getKey());
                        Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), obj, blankDynamicObject.getDynamicObjectType().getProperties());
                        map.put(data.getPkId(), childMap);
                        continue;
                    }
                    JSONArray valarr = (JSONArray)val;
                    for (JSONObject next : valarr) {
                        DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(next1.getKey());
                        Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), next, blankDynamicObject.getDynamicObjectType().getProperties());
                        map.put(next.get((Object)"id"), childMap);
                    }
                }
            }
        }
        return map;
    }

    private Map<Object, Integer> initIdBillCountMap() {
        HashMap idBillCountMap = Maps.newHashMapWithExpectedSize((int)this.tempBilldatas.size());
        for (ImportBillData data : this.tempBilldatas) {
            int count = 0;
            Collection values = data.getData().values();
            for (Object val : values) {
                if (val instanceof JSONObject) {
                    ++count;
                    continue;
                }
                JSONArray valarr = (JSONArray)val;
                count += valarr.size();
            }
            idBillCountMap.put(data.getPkId(), count);
        }
        return idBillCountMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private void relateEntityRecordErrorLog(List<Map<String, Object>> dynamicObjects, String errorMsg, ImportContext importContext) {
        for (Map<String, Object> entitys : dynamicObjects) {
            for (Map.Entry<String, Object> next : entitys.entrySet()) {
                if (!(next.getValue() instanceof List)) continue;
                String sheetName = this.dispatcher.getEntitySheetMap().get(next.getKey());
                if (StringUtils.isEmpty((CharSequence)sheetName)) {
                    sheetName = this.mainSheetName;
                }
                List collection = (List)next.getValue();
                for (DynamicObject dy : collection) {
                    Map<String, Object> entryMap = this.idMapRowIndex.get(dy.getPkValue());
                    if (entryMap == null) continue;
                    String entityRowIndex = (String)entryMap.get("entity");
                    String[] split = StringUtils.split((String)entityRowIndex, (String)",");
                    ImportRowErrorLog errorLog = new ImportRowErrorLog(sheetName, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), ResManager.loadKDString((String)"\u540c\u4e00\u6279\u6b21\u5b9e\u4f53\u5b58\u5728\u5165\u5e93\u5931\u8d25\uff0c\u4e8b\u52a1\u88ab\u8feb\u53d6\u6d88\u3002\u539f\u56e0:".concat(errorMsg == null ? "" : errorMsg), (String)"CallBatchMultiOperationTask_0", (String)"hrmp-hies-import", (Object[])new Object[0]), importContext.getImportLog());
                    this.importStart.writeRowErrorLog(errorLog);
                }
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private LinkedHashMap<String, Object> createNewOrderBySeq(Map<String, Object> entitys) {
        LinkedHashMap newEntitys = Maps.newLinkedHashMapWithExpectedSize((int)entitys.size());
        List<String> multiEntityDbTranSeq = this.importStart.getImportContext().getMultiEntityDbTranSeq();
        if (CollectionUtils.isEmpty(multiEntityDbTranSeq)) {
            entitys.forEach((key, val) -> newEntitys.put(key, val));
        } else {
            multiEntityDbTranSeq.forEach(key -> {
                Object val = entitys.get(key);
                if (val != null) {
                    newEntitys.put(key, val);
                }
            });
            entitys.forEach((key2, val) -> {
                if (!newEntitys.containsKey(key2)) {
                    newEntitys.put(key2, val);
                }
            });
        }
        return newEntitys;
    }

    private void callOp(Map<String, List<Map<String, Object>>> groupDys, List<Map<String, Object>> dynamicObjects, int totalCount) {
        ImportContext importContext = this.importStart.getImportContext();
        String submitOP = (String)importContext.getExtOption().get("submitOP");
        OperateOption operateOption = importContext.getOpParam();
        LinkedHashMap<String, List<DynamicObject>> hasCallOpEntitys = new LinkedHashMap<String, List<DynamicObject>>();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                for (Map.Entry<String, List<Map<String, Object>>> next0 : groupDys.entrySet()) {
                    List<Map<String, Object>> dyslist = next0.getValue();
                    BeforeCallOperationEventArgs args = new BeforeCallOperationEventArgs(importContext);
                    args.setImportBillDatas(this.tempBilldatas);
                    args.setDynamicObjects(dyslist.toArray());
                    Map<String, IFormView> formIdEntityFormViewMap = importContext.getFormIdEntityFormViewMap();
                    HashMap submitOPMap = Maps.newHashMapWithExpectedSize((int)formIdEntityFormViewMap.size());
                    HashMap operateOptionMap = Maps.newHashMapWithExpectedSize((int)formIdEntityFormViewMap.size());
                    formIdEntityFormViewMap.forEach((x, y) -> {
                        submitOPMap.put(x, (String)this.importStart.getImportContext().getExtOption().get("submitOP"));
                        operateOptionMap.put(x, importContext.getOpParam().copy());
                    });
                    args.setSubmitOPs(submitOPMap);
                    args.setOperateOptions(operateOptionMap);
                    HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeCallOperation", (AbstractEventArgs)args);
                    HashMap batchEntitys = Maps.newHashMapWithExpectedSize((int)formIdEntityFormViewMap.size());
                    for (Map<String, Object> entitys : dyslist) {
                        entitys.forEach((key, val) -> {
                            if (val instanceof List) {
                                Object objval = batchEntitys.computeIfAbsent(String.valueOf(key), vl -> new LinkedList());
                                List list = (List)objval;
                                list.addAll((List)val);
                            }
                        });
                    }
                    LinkedHashMap<String, Object> newBatchEntitys = this.createNewOrderBySeq(batchEntitys);
                    long start0 = System.currentTimeMillis();
                    for (Map.Entry<String, Object> next : newBatchEntitys.entrySet()) {
                        OperateOption childOperateOption;
                        List collection = (List)next.getValue();
                        String childSubmitOP = args.getSubmitOPs().get(next.getKey());
                        if (StringUtils.isNotEmpty((CharSequence)childSubmitOP)) {
                            submitOP = childSubmitOP;
                        }
                        if ((childOperateOption = args.getOperateOptions().get(next.getKey())) != null) {
                            operateOption = childOperateOption;
                        }
                        OperationServiceImpl im = new OperationServiceImpl();
                        log.info("entity_localInvokeOperation_collection.size()=" + collection.size() + ",entityId=" + next.getKey());
                        DynamicObject[] dys = collection.toArray(new DynamicObject[0]);
                        if (ImportServiceHelper.isBuBaseData(next.getKey())) {
                            ImportServiceHelper.setUseOrgFieldValue(dys);
                        }
                        if (this.importStart.isStoped()) break;
                        OperationResult result = null;
                        long start1 = System.currentTimeMillis();
                        if (importContext.getExcludeMultiEntityDbTran() != null && importContext.getExcludeMultiEntityDbTran().contains(next.getKey())) {
                            try (TXHandle txHandle2 = TX.notSupported();){
                                result = im.localInvokeOperation(submitOP, dys, operateOption);
                            }
                        } else {
                            result = im.localInvokeOperation(submitOP, dys, operateOption);
                        }
                        long spense = System.currentTimeMillis() - start1;
                        this.dispatcher.getSuggester().addExpenseTimes(spense);
                        hasCallOpEntitys.put(next.getKey(), collection);
                        AfterCallOperationEventArgs args2 = new AfterCallOperationEventArgs(importContext);
                        args2.setDynamicObjects(dys);
                        args2.setResult(result);
                        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterCallOperation", (AbstractEventArgs)args2);
                        result = args2.getResult();
                        if (result.isSuccess()) continue;
                        String sheetName = this.dispatcher.getEntitySheetMap().get(next.getKey());
                        if (StringUtils.isEmpty((CharSequence)sheetName)) {
                            sheetName = this.mainSheetName;
                        }
                        ImportUtil.writeOperationResultLog(result, this.idMapRowIndex, dys, this.importStart, sheetName);
                        throw new KDBizException(new ErrorCode("907", ResManager.loadKDString((String)"\u4e8b\u52a1\u56de\u6eda\u3002", (String)"CallMultiOperationTask_1", (String)"hrmp-hies-import", (Object[])new Object[0])), new Object[0]);
                    }
                    txHandle.commit();
                    long spense0 = System.currentTimeMillis() - start0;
                    this.importStart.getMonitor().addExpenseStatistics("callBatchMultiOp_tran", (Long)spense0, false);
                    importContext.addSuccessedBillCount(totalCount);
                    this.importStart.getImportContext().addFinishedBillCount(totalCount);
                }
            }
            catch (Throwable e) {
                String[] split;
                txHandle.markRollback();
                this.importStart.getImportContext().addFinishedBillCount(totalCount);
                log.info(CallBatchMultiOperationTask.class.getSimpleName() + "_handler_a_exception:" + e.getMessage());
                log.error(e);
                String errorMsg = e.getMessage();
                if (StringUtils.isNotEmpty((CharSequence)e.getMessage()) && (split = StringUtils.split((String)e.getMessage(), (String)"SQL:")).length > 0) {
                    errorMsg = split[0];
                }
                this.relateEntityRecordErrorLog(dynamicObjects, errorMsg, importContext);
                AfterDbTanRollbackEventArgs args1 = new AfterDbTanRollbackEventArgs();
                args1.setHasCallOpEntitys(hasCallOpEntitys);
                HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterDbTanRollback", (AbstractEventArgs)args1);
            }
        }
    }
}

