/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.CallSingleOperationTask;
import kd.hr.impt.core.save.InstoreDispatcher;

public class CallDeleteOperationTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(CallDeleteOperationTask.class);
    private ImportStart importStart;
    private List<ImportBillData> tempBilldatas;
    private String sheetName;
    private Map<Object, Map<String, Object>> idMapRowIndex;
    private Map<Object, ImportBillData> idAndbillDataMap;
    private AtomicInteger childThreadMonitor;
    private AtomicInteger dataCanStopFlag;
    private String formId;
    private InstoreDispatcher dispatcher;

    public CallDeleteOperationTask(List<ImportBillData> tempBilldatas, ImportStart importStart, String formId, InstoreDispatcher dispatcher, AtomicInteger childThreadMonitor, AtomicInteger dataCanStopFlag) {
        this.childThreadMonitor = childThreadMonitor;
        this.dataCanStopFlag = dataCanStopFlag;
        this.dataCanStopFlag.getAndIncrement();
        this.tempBilldatas = tempBilldatas;
        this.importStart = importStart;
        this.sheetName = tempBilldatas.get(0).getSheetName();
        this.formId = formId;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(CallDeleteOperationTask.class.getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.dispatcher.getImportStart().getMonitor().addOtherListData(CallDeleteOperationTask.class.getSimpleName() + "_received", this.tempBilldatas.size());
            DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(this.formId);
            log.info("before_getDynamicObjects_count=" + this.tempBilldatas.size());
            DynamicObject[] dynamicObjects = this.getDynamicObjects();
            log.info("after_getDynamicObjects_count=" + dynamicObjects.length);
            this.idAndbillDataMap = CallSingleOperationTask.initIdAndbillDataMap(this.tempBilldatas);
            this.idMapRowIndex = this.initIdMapRowIndex(this.tempBilldatas, blankDynamicObject.getDynamicObjectType().getProperties());
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                log.warn("getDynamicObjects_failed.count=" + this.tempBilldatas.size());
                importContext.addFinishedBillCount(ImportUtil.statisticsBillCount(this.tempBilldatas, importContext.isEnableRowStatistics()));
                this.dataCanStopFlag.getAndDecrement();
                Object var6_8 = null;
                return var6_8;
            }
            if (ImportServiceHelper.isBuBaseData(this.formId)) {
                ImportServiceHelper.setUseOrgFieldValue(dynamicObjects);
            }
            OperateOption operateOption = importContext.getOpParam();
            if (BaseDataServiceHelper.checkBaseDataCtrl((String)this.formId).booleanValue()) {
                Map<String, List<DynamicObject>> map = this.groupByCreateOrg(dynamicObjects);
                Iterator<Map.Entry<String, List<DynamicObject>>> iterator = map.entrySet().iterator();
                int index = 1;
                while (iterator.hasNext()) {
                    Map.Entry<String, List<DynamicObject>> next = iterator.next();
                    DynamicObject[] subDys = next.getValue().toArray(new DynamicObject[0]);
                    operateOption.setVariableValue("createOrg", next.getKey());
                    if (index >= map.size()) {
                        this.dataCanStopFlag.getAndDecrement();
                    }
                    ++index;
                    this.callOp(subDys, operateOption);
                }
            } else {
                this.dataCanStopFlag.getAndDecrement();
                this.callOp(dynamicObjects, operateOption);
            }
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(this.tempBilldatas, importContext.isEnableRowStatistics()));
            log.error(CallDeleteOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(this.tempBilldatas, this.importStart, e);
            this.dataCanStopFlag.getAndDecrement();
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(CallDeleteOperationTask.class.getSimpleName(), (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private void callOp(DynamicObject[] dys, OperateOption operateOption) {
        ImportContext importContext = this.importStart.getImportContext();
        String submitOP = (String)this.importStart.getImportContext().getExtOption().get("submitOP");
        long start1 = System.currentTimeMillis();
        String extParam = (String)importContext.getExtOption().get("extParam");
        BeforeCallOperationEventArgs args = new BeforeCallOperationEventArgs(importContext);
        args.setImportBillDatas(this.tempBilldatas);
        args.setDynamicObjects(dys);
        HashMap submitOPMap = Maps.newHashMapWithExpectedSize((int)1);
        submitOPMap.put(this.formId, submitOP);
        args.setSubmitOPs(submitOPMap);
        HashMap operateOptionMap = Maps.newHashMapWithExpectedSize((int)1);
        operateOptionMap.put(this.formId, importContext.getOpParam().copy());
        args.setOperateOptions(operateOptionMap);
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeCallOperation", (AbstractEventArgs)args);
        operateOption = args.getOperateOptions().get(this.formId);
        submitOP = args.getSubmitOPs().get(this.formId);
        OperationServiceImpl im = new OperationServiceImpl();
        log.info("localInvokeOperation_dys.size=" + dys.length);
        operateOption.setVariableValue("extParam", extParam);
        if (this.importStart.isStoped()) {
            return;
        }
        OperationResult result = im.localInvokeOperation(submitOP, dys, operateOption);
        AfterCallOperationEventArgs args2 = new AfterCallOperationEventArgs(importContext);
        args2.setDynamicObjects(dys);
        args2.setResult(result);
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterCallOperation", (AbstractEventArgs)args2);
        result = args2.getResult();
        long spense = System.currentTimeMillis() - start1;
        this.dispatcher.getSuggester().addExpenseTimes(spense);
        this.importStart.getMonitor().addExpenseStatistics("callDeleteOp", (Long)spense, false);
        importContext.addSuccessedBillCount(CallSingleOperationTask.getSuccessedBillCount(result.getSuccessPkIds(), importContext, this.idAndbillDataMap));
        this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(this.tempBilldatas, importContext.isEnableRowStatistics()));
        if (!result.isSuccess()) {
            ImportUtil.writeOperationResultLog(result, this.idMapRowIndex, dys, this.importStart, this.sheetName);
        }
    }

    private Map<Object, Map<String, Object>> initIdMapRowIndex(List<ImportBillData> tempBilldatas, DataEntityPropertyCollection properties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        for (int i = 0; i < tempBilldatas.size(); ++i) {
            ImportBillData data = tempBilldatas.get(i);
            JSONObject obj = (JSONObject)data.getData().get((Object)data.getMainEntityId());
            Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), obj, properties);
            map.put(data.getPkId(), childMap);
        }
        return map;
    }

    private DynamicObject[] getDynamicObjects() {
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(this.tempBilldatas.size());
        Map<Object, Object> map = null;
        if (this.importStart.getImportContext().isSerialModel()) {
            DynamicObject[] dynamicObjects;
            map = Maps.newHashMapWithExpectedSize((int)this.tempBilldatas.size());
            List<Object> ids = this.tempBilldatas.stream().map(de -> de.getPkId()).collect(Collectors.toList());
            for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, this.tempBilldatas.get(0).getMainEntityId())) {
                map.put((Long)oldBill.getPkValue(), oldBill);
            }
        } else {
            map = this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap();
        }
        for (ImportBillData data : this.tempBilldatas) {
            DynamicObject oldBill = (DynamicObject)map.get(data.getPkId());
            if (oldBill != null) {
                billObjs.add(oldBill);
                map.remove(data.getPkId());
                continue;
            }
            ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), "can not find dynamicObject from cache", this.importStart.getImportContext().getImportLog());
            this.importStart.writeRowErrorLog(errResult);
        }
        return billObjs.toArray(new DynamicObject[billObjs.size()]);
    }

    private Map<String, List<DynamicObject>> groupByCreateOrg(DynamicObject[] dynamicObjects) {
        Map<String, List<DynamicObject>> map = Arrays.asList(dynamicObjects).stream().collect(Collectors.groupingBy(item -> item.getString("createorg.id"), Collectors.toList()));
        return map;
    }
}

