/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.DataConvertDynamicObject;
import kd.hr.impt.core.save.InstoreDispatcher;

public class CallSingleOperationTask
implements Callable<Object> {
    private Log log = LogFactory.getLog((String)this.getClass().getSimpleName());
    private ImportStart importStart;
    private List<ImportBillData> tempBilldatas;
    private String sheetName;
    private Map<Object, Map<String, Object>> idMapRowIndex;
    private Map<Object, ImportBillData> idAndbillDataMap;
    private AtomicInteger childThreadMonitor;
    private AtomicInteger dataCanStopFlag;
    private String formId;
    private InstoreDispatcher dispatcher;

    public CallSingleOperationTask(List<ImportBillData> tempBilldatas, ImportStart importStart, String formId, InstoreDispatcher dispatcher, AtomicInteger childThreadMonitor, AtomicInteger dataCanStopFlag) {
        this.childThreadMonitor = childThreadMonitor;
        this.dataCanStopFlag = dataCanStopFlag;
        this.dataCanStopFlag.getAndIncrement();
        this.tempBilldatas = tempBilldatas;
        this.sheetName = tempBilldatas.get(0).getSheetName();
        this.importStart = importStart;
        this.formId = formId;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        this.log.info(this.getClass().getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.dispatcher.getImportStart().getMonitor().addOtherListData(this.getClass().getSimpleName() + "_received", this.tempBilldatas.size());
            DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(this.formId);
            DataConvertDynamicObject convert = new DataConvertDynamicObject(this.importStart, this.dispatcher);
            this.log.info("before_convert.toDynamicObject_count=" + this.tempBilldatas.size());
            DynamicObject[] dynamicObjects = convert.toDynamicObject(this.tempBilldatas, null, blankDynamicObject);
            this.log.info("after_convert.toDynamicObject_count=" + dynamicObjects.length);
            this.idAndbillDataMap = CallSingleOperationTask.initIdAndbillDataMap(this.tempBilldatas);
            this.idMapRowIndex = this.initIdMapRowIndex(this.tempBilldatas, blankDynamicObject.getDynamicObjectType().getProperties());
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                this.log.warn("convert.toDynamicObject_failed.count=" + this.tempBilldatas.size());
                importContext.addFinishedBillCount(ImportUtil.statisticsBillCount(this.tempBilldatas, importContext.isEnableRowStatistics()));
                this.dataCanStopFlag.getAndDecrement();
                Object var7_9 = null;
                return var7_9;
            }
            if (ImportServiceHelper.isBuBaseData(this.formId)) {
                ImportServiceHelper.setUseOrgFieldValue(dynamicObjects);
            }
            AfterConvertDynamicObjectsEventArgs args = new AfterConvertDynamicObjectsEventArgs(importContext);
            args.setImportBillDatas(this.tempBilldatas);
            HashMap groupDys = Maps.newHashMapWithExpectedSize((int)1);
            groupDys.put("default", dynamicObjects);
            args.setDynamicObjects(groupDys);
            HRImpPluginEngine.fireImptPluginEvent(this.importStart, "AfterConvertDynamicObjects", (AbstractEventArgs)args);
            this.callOp(args.getDynamicObjects());
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(this.tempBilldatas, importContext.isEnableRowStatistics()));
            this.log.error(this.getClass().getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(this.tempBilldatas, this.importStart, e);
            this.dataCanStopFlag.getAndDecrement();
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(this.getClass().getSimpleName(), (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private void callOp(Map<String, DynamicObject[]> groupDys) {
        ImportContext importContext = this.importStart.getImportContext();
        String extParam = (String)importContext.getExtOption().get("extParam");
        String submitOP = (String)this.importStart.getImportContext().getExtOption().get("submitOP");
        OperateOption operateOption = importContext.getOpParam();
        int index = 1;
        for (Map.Entry<String, DynamicObject[]> next : groupDys.entrySet()) {
            Object[] dynamicObjects = next.getValue();
            long start1 = System.currentTimeMillis();
            List<ImportBillData> relateBilldatas = null;
            try {
                if (index >= groupDys.size()) {
                    this.dataCanStopFlag.getAndDecrement();
                }
                relateBilldatas = this.getRelateBilldatas((DynamicObject[])dynamicObjects);
                HashMap subIdMapRowIndex = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    subIdMapRowIndex.put(dynamicObject.getPkValue(), this.idMapRowIndex.get(dynamicObject.getPkValue()));
                }
                this.log.info("dynamicObjects_localInvokeOperation_subIdMapRowIndex.size=" + subIdMapRowIndex.size());
                BeforeCallOperationEventArgs args = new BeforeCallOperationEventArgs(importContext);
                args.setGroupName(next.getKey());
                args.setImportBillDatas(relateBilldatas);
                args.setDynamicObjects(dynamicObjects);
                HashMap submitOPMap = Maps.newHashMapWithExpectedSize((int)1);
                submitOPMap.put(this.formId, submitOP);
                args.setSubmitOPs(submitOPMap);
                HashMap operateOptionMap = Maps.newHashMapWithExpectedSize((int)1);
                operateOptionMap.put(this.formId, importContext.getOpParam().copy());
                args.setOperateOptions(operateOptionMap);
                HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeCallOperation", (AbstractEventArgs)args);
                operateOption = args.getOperateOptions().get(this.formId);
                submitOP = args.getSubmitOPs().get(this.formId);
                OperationServiceImpl operationServiceImpl = new OperationServiceImpl();
                this.log.info("localInvokeOperation_dynamicObjects.size=" + dynamicObjects.length);
                operateOption.setVariableValue("extParam", extParam);
                if (this.importStart.isStoped()) {
                    return;
                }
                OperationResult result = operationServiceImpl.localInvokeOperation(submitOP, (DynamicObject[])dynamicObjects, operateOption);
                this.log.info("localInvokeOperation_OperationResult.getBillNos.size={} getSuccessPkIds.size={}", (Object)result.getBillNos().size(), (Object)result.getSuccessPkIds().size());
                AfterCallOperationEventArgs args2 = new AfterCallOperationEventArgs(importContext);
                args2.setDynamicObjects((DynamicObject[])dynamicObjects);
                args2.setResult(result);
                HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterCallOperation", (AbstractEventArgs)args2);
                result = args2.getResult();
                long spense = System.currentTimeMillis() - start1;
                this.dispatcher.getSuggester().addExpenseTimes(spense);
                this.importStart.getMonitor().addExpenseStatistics("callOp", (Long)spense, false);
                this.log.info("OperationResult_result.getSuccessPkIds()=" + result.getSuccessPkIds().size());
                importContext.addSuccessedBillCount(CallSingleOperationTask.getSuccessedBillCount(result.getSuccessPkIds(), importContext, this.idAndbillDataMap));
                if (!result.isSuccess()) {
                    ImportUtil.writeOperationResultLog(result, subIdMapRowIndex, (DynamicObject[])dynamicObjects, this.importStart, this.sheetName);
                }
                this.importStart.getImportContext().addFinishedBillCount(importContext.isEnableRowStatistics() ? ImportUtil.statisticsBillCount(relateBilldatas, importContext.isEnableRowStatistics()) : dynamicObjects.length);
            }
            catch (Throwable e) {
                this.importStart.getImportContext().addFinishedBillCount(importContext.isEnableRowStatistics() ? ImportUtil.statisticsBillCount(relateBilldatas, importContext.isEnableRowStatistics()) : dynamicObjects.length);
                this.log.error(this.getClass().getSimpleName() + "_exception.", e);
                this.importStart.writeErrorLog(e);
                ImportUtil.writeExceptionRowLog(relateBilldatas, this.importStart, e);
            }
        }
    }

    private List<ImportBillData> getRelateBilldatas(DynamicObject[] dynamicObjects) {
        ArrayList<ImportBillData> subBilldatas = new ArrayList<ImportBillData>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            ImportBillData billData = this.idAndbillDataMap.get(dy.getPkValue());
            subBilldatas.add(billData);
        }
        return subBilldatas;
    }

    private Map<Object, Map<String, Object>> initIdMapRowIndex(List<ImportBillData> tempBilldatas, DataEntityPropertyCollection properties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        for (int i = 0; i < tempBilldatas.size(); ++i) {
            ImportBillData data = tempBilldatas.get(i);
            JSONObject obj = (JSONObject)data.getData().get((Object)data.getMainEntityId());
            Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), obj, properties);
            map.put(data.getPkId(), childMap);
        }
        return map;
    }

    public static Map<Object, ImportBillData> initIdAndbillDataMap(List<ImportBillData> tempBilldatas) {
        HashMap idAndbillDataMap = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        tempBilldatas.forEach(item -> idAndbillDataMap.put(item.getPkId(), item));
        return idAndbillDataMap;
    }

    public static int getSuccessedBillCount(List<Object> successPkids, ImportContext importContext, Map<Object, ImportBillData> idAndbillDataMap) {
        if (importContext.isEnableRowStatistics()) {
            AtomicInteger count = new AtomicInteger();
            successPkids.forEach(pkid -> {
                ImportBillData billData = (ImportBillData)idAndbillDataMap.get(pkid);
                if (billData != null) {
                    count.addAndGet(billData.getEndIndex() - billData.getStartIndex() + 1);
                }
            });
            return count.get();
        }
        return successPkids.size();
    }
}

