/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ChildImportBillData;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.DataConvertDynamicObject;
import kd.hr.impt.core.save.InstoreDispatcher;

public class CombineDataConvertDynamicObject
extends DataConvertDynamicObject {
    private static final Log LOGGER = LogFactory.getLog(CombineDataConvertDynamicObject.class);

    public CombineDataConvertDynamicObject(ImportStart importStart, InstoreDispatcher dispatcher) {
        super(importStart, dispatcher);
    }

    public List<Map<String, Object>> toDynamicObject(List<ImportBillData> tempBilldatas, Map<String, DynamicObject> blankDynamicObjects) {
        ArrayList<Map<String, Object>> billObjs = new ArrayList<Map<String, Object>>(tempBilldatas.size());
        if ("new".equals(this.importtype)) {
            long[] ids = DB.genGlobalLongIds((int)tempBilldatas.size());
            for (int i = 0; i < tempBilldatas.size(); ++i) {
                Map<String, Object> dto;
                ImportBillData data = tempBilldatas.get(i);
                if (null == data.getPkId()) {
                    data.setPkId(ids[i]);
                }
                if ((dto = this.createNewDynamicObject(data, blankDynamicObjects)) == null) continue;
                billObjs.add(dto);
            }
        } else if ("update".equals(this.importtype)) {
            LinkedList<ImportBillData> noAdaptMainBilldatas = new LinkedList<ImportBillData>();
            HashMap errorBillDatas = Maps.newHashMapWithExpectedSize((int)16);
            List<Map<String, Object>> updateDatas = this.createUpdateDynamicObject(tempBilldatas, noAdaptMainBilldatas, errorBillDatas);
            for (Map<String, Object> updateData : updateDatas) {
                if (errorBillDatas.containsKey(updateData.get("id"))) continue;
                billObjs.add(updateData);
            }
            noAdaptMainBilldatas.forEach(item -> {
                OperationResult result = new OperationResult();
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CombineDataConvertDynamicObject_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
                ImportRowErrorLog errResult = new ImportRowErrorLog(item.getSheetName(), item.getStartIndex(), item.getEndIndex(), result.getMessage(), this.importStart.getImportContext().getImportLog());
                this.importStart.writeRowErrorLog(errResult);
            });
        } else if ("updateandnew".equals(this.importtype)) {
            List<Map<String, Object>> newOrUpdateDynamicObjects = this.createNewOrUpdateDynamicObject(tempBilldatas, blankDynamicObjects);
            billObjs.addAll(newOrUpdateDynamicObjects);
        }
        return billObjs;
    }

    private List<Map<String, Object>> createUpdateDynamicObject(List<ImportBillData> billdatas, List<ImportBillData> noAdaptMainBilldatas, Map<Long, Object> errorBillDatas) {
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)6);
        for (ImportBillData billData : billdatas) {
            for (Map.Entry next : billData.getData().entrySet()) {
                ArrayList<ChildImportBillData> listdata = (ArrayList<ChildImportBillData>)groupMap.get(next.getKey());
                if (CollectionUtils.isEmpty((Collection)listdata)) {
                    listdata = new ArrayList<ChildImportBillData>(billdatas.size());
                    groupMap.put(next.getKey(), listdata);
                }
                List<ChildImportBillData> childBillDatas = this.splitImportBillData(billData, (String)next.getKey());
                listdata.addAll(childBillDatas);
            }
        }
        LOGGER.info("groupMap.size=" + groupMap.size());
        HashMap groupSetMap = Maps.newHashMapWithExpectedSize((int)6);
        for (Map.Entry next : groupMap.entrySet()) {
            HashMap dataMap = null;
            if (this.importStart.getImportContext().isSerialModel()) {
                DynamicObject[] dynamicObjects;
                List<Object> ids = ((List)next.getValue()).stream().map(de -> de.getPkId()).collect(Collectors.toList());
                for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, ((ChildImportBillData)((List)next.getValue()).get(0)).getMainEntityId())) {
                    if (dataMap == null) {
                        dataMap = Maps.newHashMapWithExpectedSize((int)((List)next.getValue()).size());
                    }
                    dataMap.put((Object)oldBill.getPkValue(), (DynamicObject)oldBill);
                }
            } else {
                dataMap = this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap();
            }
            for (ChildImportBillData data : (List)next.getValue()) {
                if (dataMap == null) continue;
                DynamicObject oldBill = dataMap.get(data.getPkId());
                List<String> errors = this.setValues(oldBill, data);
                if (CollectionUtils.isEmpty(errors)) {
                    LinkedList<DynamicObject> list = (LinkedList<DynamicObject>)groupSetMap.get(data.getMainEntityPkid());
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        list = new LinkedList<DynamicObject>();
                        groupSetMap.put(data.getMainEntityPkid(), list);
                    }
                    list.add(oldBill);
                    continue;
                }
                for (String error : errors) {
                    ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                    this.importStart.writeRowErrorLog(errResult);
                }
            }
        }
        LOGGER.info("groupSetMap.size=" + groupSetMap.size());
        HashMap composeMap = Maps.newHashMapWithExpectedSize((int)billdatas.size());
        for (Map.Entry next : groupSetMap.entrySet()) {
            Map dto = (Map)composeMap.get(next.getKey());
            if (dto == null) {
                dto = Maps.newHashMapWithExpectedSize((int)6);
                dto.put("id", next.getKey());
                composeMap.put(next.getKey(), dto);
            }
            List entitys = (List)next.getValue();
            Map entityGroupTemp = entitys.stream().collect(Collectors.groupingBy(entity -> entity.getDynamicObjectType().getName(), Collectors.toList()));
            for (Map.Entry next1 : entityGroupTemp.entrySet()) {
                dto.put(next1.getKey(), next1.getValue());
            }
        }
        LOGGER.info("composeMap.size=" + composeMap.size());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(composeMap.size());
        list.addAll(composeMap.values());
        return list;
    }

    public Map<String, Object> createNewDynamicObject(ImportBillData data, Map<String, DynamicObject> blankDynamicObjects) {
        boolean createSuccess = true;
        HashMap dto = Maps.newHashMapWithExpectedSize((int)6);
        dto.put("id", data.getPkId());
        for (Map.Entry next : data.getData().entrySet()) {
            List<ChildImportBillData> childBillDatas = this.splitImportBillData(data, (String)next.getKey());
            DynamicObjectCollection childdys = null;
            for (ChildImportBillData childBillData : childBillDatas) {
                DynamicObject childdy = super.createNewDynamicObject(childBillData, blankDynamicObjects.get(next.getKey()));
                if (childdy == null) {
                    this.importStart.getImportContext().getImportLog().writeRowLog(childBillData.getSheetName(), childBillData.getStartIndex(), childBillData.getEndIndex(), "entity:" + childBillData.getMainEntityId() + " create failed.");
                    createSuccess = false;
                }
                if (childdys == null && childdy != null) {
                    childdys = new DynamicObjectCollection(childdy.getDynamicObjectType(), null);
                }
                if (childdy == null) continue;
                childdys.add((Object)childdy);
            }
            dto.put(next.getKey(), childdys);
        }
        if (!createSuccess) {
            return null;
        }
        return dto;
    }

    private List<Map<String, Object>> createNewOrUpdateDynamicObject(List<ImportBillData> billdatas, Map<String, DynamicObject> blankDynamicObjects) {
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)6);
        for (ImportBillData billData : billdatas) {
            if (null == billData.getPkId()) {
                billData.setPkId(ID.genLongId());
            }
            for (Map.Entry next : billData.getData().entrySet()) {
                Object listdata = (Map)groupMap.get(next.getKey());
                if (listdata == null) {
                    listdata = Maps.newHashMapWithExpectedSize((int)billdatas.size());
                    listdata.put("new", new LinkedList());
                    listdata.put("update", new LinkedList());
                    groupMap.put(next.getKey(), listdata);
                }
                List<ChildImportBillData> childBillDatas = this.splitImportBillData(billData, (String)next.getKey());
                for (ChildImportBillData item : childBillDatas) {
                    if ("new".equalsIgnoreCase(item.getOpType())) {
                        ((List)listdata.get("new")).add(item);
                        continue;
                    }
                    if (!"update".equalsIgnoreCase(item.getOpType())) continue;
                    ((List)listdata.get("update")).add(item);
                }
            }
        }
        LOGGER.info("groupMap.size=" + groupMap.size());
        HashMap groupSetMap = Maps.newHashMapWithExpectedSize((int)6);
        for (Map.Entry next : groupMap.entrySet()) {
            List newBillDatas = (List)((Map)next.getValue()).get("new");
            for (ChildImportBillData newBillData : newBillDatas) {
                DynamicObject newDynamicObject = super.createNewDynamicObject(newBillData, blankDynamicObjects.get(next.getKey()));
                LinkedList<DynamicObject> list = (LinkedList<DynamicObject>)groupSetMap.get(newBillData.getMainEntityPkid());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    list = new LinkedList<DynamicObject>();
                    groupSetMap.put(newBillData.getMainEntityPkid(), list);
                }
                if (newDynamicObject == null) continue;
                list.add(newDynamicObject);
            }
            List updateBillDatas = (List)((Map)next.getValue()).get("update");
            HashMap dataMap = null;
            if (this.importStart.getImportContext().isSerialModel()) {
                DynamicObject[] dynamicObjects;
                List<Object> ids = updateBillDatas.stream().map(de -> de.getPkId()).collect(Collectors.toList());
                for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, (String)next.getKey())) {
                    if (dataMap == null) {
                        dataMap = Maps.newHashMapWithExpectedSize((int)((Map)next.getValue()).size());
                    }
                    dataMap.put((Object)oldBill.getPkValue(), (DynamicObject)oldBill);
                }
            } else {
                dataMap = this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap();
            }
            for (ChildImportBillData data : updateBillDatas) {
                if (dataMap == null) continue;
                DynamicObject oldBill = dataMap.get(data.getPkId());
                List<String> errors = this.setValues(oldBill, data);
                if (CollectionUtils.isEmpty(errors)) {
                    LinkedList<DynamicObject> list = (LinkedList<DynamicObject>)groupSetMap.get(data.getMainEntityPkid());
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        list = new LinkedList<DynamicObject>();
                        groupSetMap.put(data.getMainEntityPkid(), list);
                    }
                    list.add(oldBill);
                    continue;
                }
                for (String error : errors) {
                    ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                    this.importStart.writeRowErrorLog(errResult);
                }
            }
        }
        LOGGER.info("groupSetMap.size=" + groupSetMap.size());
        HashMap composeMap = Maps.newHashMapWithExpectedSize((int)billdatas.size());
        for (Map.Entry next : groupSetMap.entrySet()) {
            Map dto = (Map)composeMap.get(next.getKey());
            if (dto == null) {
                dto = Maps.newHashMapWithExpectedSize((int)6);
                dto.put("id", next.getKey());
                composeMap.put(next.getKey(), dto);
            }
            List entitys = (List)next.getValue();
            Map entityGroupTemp = entitys.stream().collect(Collectors.groupingBy(entity -> entity.getDynamicObjectType().getName(), Collectors.toList()));
            for (Map.Entry next1 : entityGroupTemp.entrySet()) {
                dto.put(next1.getKey(), next1.getValue());
            }
        }
        LOGGER.info("composeMap.size=" + composeMap.size());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(composeMap.size());
        list.addAll(composeMap.values());
        return list;
    }

    private List<ChildImportBillData> splitImportBillData(ImportBillData data, String entityId) {
        LinkedList<ChildImportBillData> list = new LinkedList<ChildImportBillData>();
        Object sourceobj = data.getData().get((Object)entityId);
        if (sourceobj instanceof JSONObject) {
            ChildImportBillData newbill = this.createNewImportBillData(data, entityId);
            JSONObject newobj = new JSONObject();
            newobj.put(entityId, sourceobj);
            newbill.setData(newobj);
            if (null == data.getPkId()) {
                data.setPkId(DB.genGlobalLongId());
            }
            newbill.setPkId(data.getPkId());
            newbill.setMainEntityPkid(data.getPkId());
            list.add(newbill);
        } else if (sourceobj instanceof JSONArray) {
            JSONArray sour = (JSONArray)sourceobj;
            for (JSONObject next : sour) {
                ChildImportBillData newbill = this.createNewImportBillData(data, entityId);
                JSONObject newobj = new JSONObject();
                newobj.put(entityId, (Object)next);
                newbill.setOpType((String)next.get((Object)"$opType"));
                Object idVal = next.get((Object)"id");
                if (idVal != null) {
                    newbill.setPkId(idVal);
                }
                newbill.setData(newobj);
                if (null == newbill.getPkId()) {
                    newbill.setPkId(ID.genLongId());
                    next.put("id", newbill.getPkId());
                }
                newbill.setMainEntityPkid(data.getPkId());
                list.add(newbill);
            }
        }
        return list;
    }

    private ChildImportBillData createNewImportBillData(ImportBillData data, String entityId) {
        ChildImportBillData newbill = new ChildImportBillData();
        newbill.setMainEntityPkid(data.getPkId());
        newbill.setOpType(data.getOpType());
        newbill.setBillIndex(data.getBillIndex());
        newbill.setEndIndex(data.getEndIndex());
        newbill.setMainEntityId(entityId);
        newbill.setSheetName(data.getSheetName());
        newbill.setStartIndex(data.getStartIndex());
        return newbill;
    }
}

