/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.CustomInstoreParam;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.CustomCallSingleOperationTask;
import kd.hr.impt.core.save.InstoreDispatcher;

@ExcludeFromJacocoGeneratedReport
public class CustomInstoreDispatcher
extends InstoreDispatcher {
    private static Log log = LogFactory.getLog(CustomInstoreDispatcher.class);
    private CustomInstoreParam customInstoreParam;
    private Semaphore syncSemaphore;
    private Semaphore groupSemaphore;

    public CustomInstoreDispatcher(ImportStart importStart, int workerMaxThread) {
        super(CustomInstoreDispatcher.class.getSimpleName(), importStart, workerMaxThread);
        this.customInstoreParam = importStart.getImportContext().getCustomInstoreParam();
        if (this.customInstoreParam.isSync()) {
            this.syncSemaphore = new Semaphore(1);
        }
        if (this.customInstoreParam.isGroup()) {
            this.groupSemaphore = new Semaphore(1);
        }
    }

    public Semaphore getSyncSemaphore() {
        return this.syncSemaphore;
    }

    public Semaphore getGroupSemaphore() {
        return this.groupSemaphore;
    }

    @Override
    public Object call() {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        try {
            this.initEntitySheetMap();
            this.setOperateOption();
            this.waiteInitEntityBlankDynamicObject();
            this.initComboItems();
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                this.suggester.runDataFlowSuggest();
                if (this.suggester.getSuggestThreads() <= this.childThreadMonitor.get()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e);
                    }
                    continue;
                }
                List<ImportBillData> tempBilldatas = this.getBatchData(this.inQueue.getQueue().size());
                log.info(this.name + "_receivedTempBilldatas.count=" + tempBilldatas.size());
                if (tempBilldatas.size() == 0) continue;
                if (this.customInstoreParam.isGroup()) {
                    this.groupSemaphore.release();
                }
                if (this.callopStartTime == null) {
                    this.callopStartTime = new Date();
                }
                CustomCallSingleOperationTask task = new CustomCallSingleOperationTask(tempBilldatas, this.importStart, tempBilldatas.get(0).getMainEntityId(), this, this.childThreadMonitor, this.dataCanStopFlag);
                super.submitWithTimeOut(task);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        this.end();
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }
}

