/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.tempstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;

public class EntityRelationInStoreService {
    private static final Log LOGGER = LogFactory.getLog(EntityRelationInStoreService.class);
    private static final String MEMS_RELATED_COUNT = "mems_related_count";

    public static void relateTempDataByNestLoop(Map<String, DataSet> dataSetMap, DynamicObject tpl, TempStoreDispatcher worker) {
        long start = System.currentTimeMillis();
        LOGGER.info("relateTempDataByNestLoop_started.");
        worker.getImportStart().getMonitor().getImportTrace().getMems().put("relateTempDataByNestLoop", true);
        String mainEntityId = tpl.getString("entity.id");
        HashMap bitSetMap = Maps.newHashMapWithExpectedSize((int)dataSetMap.size());
        Map<String, String> sheetEntityMap = worker.getImportStart().getImportContext().getSheetEntityMap();
        Map entitySheetMap = MethodUtil.reversalMap(sheetEntityMap);
        DataSet dataSet = dataSetMap.get(entitySheetMap.get(mainEntityId));
        if (dataSet != null) {
            HashMap batchMap = Maps.newHashMapWithExpectedSize((int)1000);
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                if (worker.getImportStart().isStoped()) {
                    return;
                }
                Row mainRow = (Row)iterator.next();
                Integer mainSeq = mainRow.getInteger("seq");
                Set<Integer> seqs = worker.getValidatefailedBillDatasForMEMS().get(entitySheetMap.get(mainEntityId));
                if (seqs != null && seqs.contains(mainSeq)) continue;
                Map rowMap = batchMap.computeIfAbsent(mainSeq, val -> Maps.newHashMapWithExpectedSize((int)6));
                rowMap.put(mainEntityId, Collections.singletonList(mainRow));
                if (batchMap.size() < 1000) continue;
                long start2 = System.currentTimeMillis();
                EntityRelationInStoreService.qureyRelateEntityData(batchMap, dataSetMap, bitSetMap, worker, mainEntityId);
                EntityRelationInStoreService.packageDataPushToQueue(batchMap, worker, mainEntityId);
                batchMap.clear();
                worker.getImportStart().getMonitor().addExpenseStatistics("mianEntity_batch", (Long)(System.currentTimeMillis() - start2), false);
            }
            if (batchMap.size() > 0) {
                long start2 = System.currentTimeMillis();
                EntityRelationInStoreService.qureyRelateEntityData(batchMap, dataSetMap, bitSetMap, worker, mainEntityId);
                EntityRelationInStoreService.packageDataPushToQueue(batchMap, worker, mainEntityId);
                worker.getImportStart().getMonitor().addExpenseStatistics("mianEntity_batch", (Long)(System.currentTimeMillis() - start2), false);
            }
        }
        EntityRelationInStoreService.noRelateChildDataPushToQueue(dataSetMap, bitSetMap, worker, mainEntityId);
        worker.getImportStart().getMonitor().addExpenseStatistics("relateTempDataByNestLoop", (Long)(System.currentTimeMillis() - start), true);
        dataSetMap.values().forEach(ds -> ds.close());
        LOGGER.info("relateTempDataByNestLoop_end.");
    }

    private static void qureyRelateEntityData(Map<Integer, Map<String, List<Row>>> batchMap, Map<String, DataSet> dataSetMap, Map<String, BitSet> bitSetMap, ImportWorker worker, String mainEntityId) {
        Map<String, String> sheetEntityMap = worker.getImportStart().getImportContext().getSheetEntityMap();
        Map entitySheetMap = MethodUtil.reversalMap(sheetEntityMap);
        Map<String, String> needRelationInStoreChildEntitys = worker.getImportStart().getImportContext().getEntityRelationField();
        for (Map.Entry<String, DataSet> next1 : dataSetMap.entrySet()) {
            String entityId = sheetEntityMap.get(next1.getKey());
            if (entityId.equalsIgnoreCase(mainEntityId)) continue;
            BitSet bitSet = bitSetMap.computeIfAbsent(entityId, val -> new BitSet());
            String relateField = needRelationInStoreChildEntitys.get(entityId);
            String[] split = relateField.split(",");
            DataSet childDataSet = next1.getValue().copy();
            for (Row childRow : childDataSet) {
                Object childVal = childRow.get(split[0]);
                Integer seq = childRow.getInteger("seq");
                if (bitSet.get(seq)) continue;
                for (Map.Entry<Integer, Map<String, List<Row>>> next : batchMap.entrySet()) {
                    Row mainRow = next.getValue().get(mainEntityId).get(0);
                    Object mianVal = mainRow.get(split[1]);
                    if (!((String)childVal).equalsIgnoreCase((String)mianVal)) continue;
                    List childRows = next.getValue().computeIfAbsent(entityId, val -> new LinkedList());
                    childRows.add(childRow);
                    bitSet.set((int)seq, true);
                }
            }
        }
    }

    private static void packageDataPushToQueue(Map<Integer, Map<String, List<Row>>> batchMap, ImportWorker worker, String mainEntityId) {
        for (Map.Entry<Integer, Map<String, List<Row>>> next : batchMap.entrySet()) {
            List<Row> removeMainRow = next.getValue().remove(mainEntityId);
            Row mainRow = removeMainRow.get(0);
            String mainJson = (String)mainRow.get("data");
            ImportBillData mainBillData = (ImportBillData)JSONObject.parseObject((String)mainJson, ImportBillData.class);
            JSONObject mainData = mainBillData.getData();
            for (Map.Entry<String, List<Row>> next1 : next.getValue().entrySet()) {
                next1.getValue().forEach(childRow -> {
                    String childJson = (String)childRow.get("data");
                    ImportBillData childBillData = (ImportBillData)JSONObject.parseObject((String)childJson, ImportBillData.class);
                    JSONObject jsonObject = childBillData.getData().getJSONObject((String)next1.getKey());
                    if (null != childBillData.getPkId()) {
                        jsonObject.put("id", childBillData.getPkId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)childBillData.getOpType())) {
                        jsonObject.put("$opType", (Object)childBillData.getOpType());
                    }
                    jsonObject.put("$startIndex", (Object)childBillData.getStartIndex());
                    jsonObject.put("$endIndex", (Object)childBillData.getEndIndex());
                    JSONArray childArry = (JSONArray)mainData.computeIfAbsent(next1.getKey(), val -> new JSONArray());
                    childArry.add((Object)jsonObject);
                });
            }
            int count = 100;
            worker.putToOutQueue(mainBillData, count);
        }
    }

    private static void noRelateChildDataPushToQueue(Map<String, DataSet> dataSetMap, Map<String, BitSet> bitSetMap, TempStoreDispatcher worker, String mainEntityId) {
        Map<String, String> sheetEntityMap = worker.getImportStart().getImportContext().getSheetEntityMap();
        Map entitySheetMap = MethodUtil.reversalMap(sheetEntityMap);
        for (Map.Entry<String, DataSet> next : dataSetMap.entrySet()) {
            if (next.getKey().equalsIgnoreCase((String)entitySheetMap.get(mainEntityId))) continue;
            BitSet bitSet = bitSetMap.computeIfAbsent(sheetEntityMap.get(next.getKey()), val -> new BitSet());
            Iterator iterator2 = next.getValue().iterator();
            while (iterator2.hasNext()) {
                Set<Integer> seqs;
                if (worker.getImportStart().isStoped()) {
                    return;
                }
                Row next1 = (Row)iterator2.next();
                Integer seq = next1.getInteger("seq");
                if (bitSet.get(seq) || (seqs = worker.getValidatefailedBillDatasForMEMS().get(next.getKey())) != null && seqs.contains(seq)) continue;
                String json = (String)next1.get("data");
                ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
                int count = 100;
                worker.putToOutQueue(billData, count);
            }
        }
    }

    public static void relateTempDataByJoin(Map<String, DataSet> dataSetMap, DynamicObject tpl, TempStoreDispatcher worker) {
        LOGGER.info("relateTempDataByJoin_started.");
        worker.getImportStart().getMonitor().getImportTrace().getMems().put("relateTempDataByJoin", true);
        long start = System.currentTimeMillis();
        String mainEntityId = tpl.getString("entity.id");
        Map<String, String> needRelationInStoreChildEntitys = worker.getImportStart().getImportContext().getEntityRelationField();
        Map<String, String> sheetEntityMap = worker.getImportStart().getImportContext().getSheetEntityMap();
        Map entitySheetMap = MethodUtil.reversalMap(sheetEntityMap);
        DataSet mainDataSet = dataSetMap.get(entitySheetMap.get(mainEntityId));
        HashMap bitSetMap = Maps.newHashMapWithExpectedSize((int)dataSetMap.size());
        DataSet tempDataSet = mainDataSet;
        int index = 1;
        long start1 = System.currentTimeMillis();
        for (Map.Entry<String, String> next1 : needRelationInStoreChildEntitys.entrySet()) {
            if (next1.getKey().equalsIgnoreCase(mainEntityId)) continue;
            DataSet childDataSet = dataSetMap.get(entitySheetMap.get(next1.getKey()));
            if (tempDataSet == null || childDataSet == null) continue;
            String[] split = next1.getValue().split(",");
            String[] tempfieldNames = tempDataSet.getRowMeta().getFieldNames();
            ArrayList<String> tempFieldNamesList = new ArrayList<String>(tempfieldNames.length);
            for (String field : tempfieldNames) {
                if (field.startsWith("@")) continue;
                tempFieldNamesList.add(field);
            }
            String[] childFieldNames = childDataSet.getRowMeta().getFieldNames();
            ArrayList<String> childFieldNamesList = new ArrayList<String>(childFieldNames.length);
            for (String field : childFieldNames) {
                if (field.startsWith("@")) continue;
                childFieldNamesList.add(field + ' ' + field + '_' + index);
            }
            tempDataSet = tempDataSet.fullJoin(childDataSet).on(split[1], split[0]).select(tempFieldNamesList.toArray(new String[0]), childFieldNamesList.toArray(new String[0])).finish();
            ++index;
        }
        worker.getImportStart().getMonitor().addExpenseStatistics("relateTempDataByJoin_join", (Long)(System.currentTimeMillis() - start1), true);
        Integer lastMainSeq = null;
        ImportBillData lastMainBillData = null;
        ImportBillData currentMainBillData = null;
        long start2 = System.currentTimeMillis();
        if (tempDataSet != null) {
            Iterator iterator = tempDataSet.iterator();
            while (iterator.hasNext()) {
                if (worker.getImportStart().isStoped()) {
                    return;
                }
                Row row = (Row)iterator.next();
                Integer mainSeq = row.getInteger("seq");
                if (mainSeq == null) {
                    lastMainBillData = currentMainBillData;
                    int index2 = 1;
                    for (Map.Entry<String, DataSet> next2 : dataSetMap.entrySet()) {
                        String entityId = sheetEntityMap.get(next2.getKey());
                        if (entityId.equalsIgnoreCase(mainEntityId)) continue;
                        String childJson = (String)row.get("data_" + index2);
                        if (StringUtils.isNotEmpty((CharSequence)childJson)) {
                            Integer seq = row.getInteger("seq_" + index2);
                            Set<Integer> seqs = worker.getValidatefailedBillDatasForMEMS().get(next2.getKey());
                            if (seqs != null && seqs.contains(seq)) continue;
                            ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)childJson, ImportBillData.class);
                            int count = 100;
                            worker.putToOutQueue(billData, count);
                        }
                        ++index2;
                    }
                    continue;
                }
                Set<Integer> seqs = worker.getValidatefailedBillDatasForMEMS().get(entitySheetMap.get(mainEntityId));
                if (seqs != null && seqs.contains(mainSeq)) continue;
                if (!mainSeq.equals(lastMainSeq)) {
                    String mainJson = (String)row.get("data");
                    lastMainBillData = currentMainBillData;
                    currentMainBillData = (ImportBillData)JSONObject.parseObject((String)mainJson, ImportBillData.class);
                }
                JSONObject data = currentMainBillData != null ? currentMainBillData.getData() : null;
                int index2 = 1;
                for (Map.Entry<String, String> next2 : needRelationInStoreChildEntitys.entrySet()) {
                    if (next2.getKey().equalsIgnoreCase(mainEntityId) || !dataSetMap.containsKey(entitySheetMap.get(next2.getKey()))) continue;
                    String childJson = (String)row.get("data_" + index2);
                    if (StringUtils.isNotEmpty((CharSequence)childJson)) {
                        Integer seq;
                        BitSet bitSet = bitSetMap.computeIfAbsent(next2.getKey(), val -> new BitSet());
                        if (bitSet.get(seq = row.getInteger("seq_" + index2))) continue;
                        bitSet.set((int)seq, true);
                        ImportBillData childBillData = (ImportBillData)JSONObject.parseObject((String)childJson, ImportBillData.class);
                        JSONObject jsonObject = childBillData.getData().getJSONObject(next2.getKey());
                        if (null != childBillData.getPkId()) {
                            jsonObject.put("id", childBillData.getPkId());
                        }
                        if (StringUtils.isNotBlank((CharSequence)childBillData.getOpType())) {
                            jsonObject.put("$opType", (Object)childBillData.getOpType());
                        }
                        jsonObject.put("$startIndex", (Object)childBillData.getStartIndex());
                        jsonObject.put("$endIndex", (Object)childBillData.getEndIndex());
                        if (data != null) {
                            Object childArry = data.get((Object)next2.getKey());
                            if (childArry == null) {
                                childArry = new JSONArray();
                                data.put(next2.getKey(), childArry);
                            }
                            ((JSONArray)childArry).add((Object)jsonObject);
                        }
                    }
                    ++index2;
                }
                if (lastMainSeq != null && !lastMainSeq.equals(mainSeq)) {
                    int count = 100;
                    worker.putToOutQueue(lastMainBillData, count);
                    if (lastMainBillData != null && lastMainBillData.getData().size() > 1) {
                        worker.getImportStart().getMonitor().addOtherTotalCount(MEMS_RELATED_COUNT, 1);
                    }
                    lastMainBillData = null;
                }
                lastMainSeq = mainSeq;
            }
            if (currentMainBillData != null) {
                int count = 100;
                worker.putToOutQueue(currentMainBillData, count);
                if (currentMainBillData.getData().size() > 1) {
                    worker.getImportStart().getMonitor().addOtherTotalCount(MEMS_RELATED_COUNT, 1);
                }
            }
            worker.getImportStart().getMonitor().addExpenseStatistics("relateTempDataByJoin_relate", (Long)(System.currentTimeMillis() - start2), true);
        }
        LOGGER.info("relateTempDataByJoin_started2.");
        for (Map.Entry<String, DataSet> next : dataSetMap.entrySet()) {
            String entityId = worker.getImportStart().getImportContext().getSheetEntityMap().get(next.getKey());
            if (needRelationInStoreChildEntitys.containsKey(entityId)) continue;
            Iterator iterator3 = next.getValue().iterator();
            while (iterator3.hasNext()) {
                if (worker.getImportStart().isStoped()) {
                    return;
                }
                Row next1 = (Row)iterator3.next();
                String json = (String)next1.get("data");
                ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
                int count = 100;
                worker.putToOutQueue(billData, count);
            }
        }
        dataSetMap.values().forEach(dataSet -> dataSet.close());
        worker.getImportStart().getMonitor().addExpenseStatistics("relateTempDataByJoin_all", (Long)(System.currentTimeMillis() - start), true);
        LOGGER.info("relateTempData_end.");
    }

    public static Map<String, Set<Integer>> validateRelationEntityData(Map<String, DataSet> dataSetMap, DynamicObject tpl, TempStoreDispatcher worker) {
        LOGGER.info("validateRelationEntityData_started.");
        long start = System.currentTimeMillis();
        Map<String, String> sheetEntityMap = worker.getImportStart().getImportContext().getSheetEntityMap();
        Map entitySheetMap = MethodUtil.reversalMap(sheetEntityMap);
        HashMap failedBillDatas = Maps.newHashMapWithExpectedSize((int)6);
        String mainEntityId = tpl.getString("entity.id");
        String mainSheetName = (String)entitySheetMap.get(mainEntityId);
        for (Map.Entry<String, DataSet> next : EntityRelationInStoreService.reOrderBy(dataSetMap, mainSheetName).entrySet()) {
            Iterator iterator2 = next.getValue().copy().iterator();
            while (iterator2.hasNext()) {
                if (worker.getImportStart().isStoped()) {
                    return failedBillDatas;
                }
                Row next1 = (Row)iterator2.next();
                String json = (String)next1.get("data");
                ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
                boolean needCancel = EntityRelationInStoreService.isNeedCancel(billData, worker, mainSheetName, sheetEntityMap);
                if (!needCancel) continue;
                Set seqs = failedBillDatas.computeIfAbsent(next.getKey(), val -> new HashSet(16));
                Integer seq = next1.getInteger("seq");
                seqs.add(seq);
            }
        }
        worker.getImportStart().getMonitor().addExpenseStatistics("validateRelationEntityData", (Long)(System.currentTimeMillis() - start), true);
        LOGGER.info("validateRelationEntityData_end.");
        return failedBillDatas;
    }

    private static boolean isNeedCancel(ImportBillData billData, ImportWorker worker, String mainSheetName, Map<String, String> sheetEntityMap) {
        ImportContext importContext = worker.getImportStart().getImportContext();
        Map<String, String> entityRelationField = importContext.getEntityRelationField();
        ConcurrentHashMap<String, Map<Object, Object>> failedBillDataFieldVaues = importContext.getBaseDataContainer().getValidateFailedBillDataFieldVaues();
        if (mainSheetName.equalsIgnoreCase(billData.getSheetName())) {
            for (Map.Entry<String, Map<Object, Object>> next : failedBillDataFieldVaues.entrySet()) {
                String[] split;
                Object fieldVal;
                if (mainSheetName.equalsIgnoreCase(next.getKey()) || next.getValue() == null) continue;
                JSONObject mainObj = billData.getData().getJSONObject(billData.getMainEntityId());
                String childEntityField = entityRelationField.get(sheetEntityMap.get(next.getKey()));
                if (StringUtils.isEmpty((CharSequence)childEntityField) || (fieldVal = ImportUtil.getBillDataValue((split = StringUtils.split((String)childEntityField, (String)","))[1], mainObj)) == null) continue;
                if (next.getValue().containsKey(fieldVal)) {
                    Map mainSheetFailedBillData = failedBillDataFieldVaues.computeIfAbsent(mainSheetName, val -> Maps.newHashMapWithExpectedSize((int)16));
                    mainSheetFailedBillData.put(fieldVal, new Object());
                    EntityRelationInStoreService.writeEntityErrorLog(billData, worker);
                    return true;
                }
                return false;
            }
            return false;
        }
        Map<Object, Object> mainFailedValues = failedBillDataFieldVaues.get(mainSheetName);
        if (mainFailedValues == null) {
            return false;
        }
        JSONObject childObj = billData.getData().getJSONObject(billData.getMainEntityId());
        String childEntityField = entityRelationField.get(billData.getMainEntityId());
        String[] split = StringUtils.split((String)childEntityField, (String)",");
        Object fieldVal = ImportUtil.getBillDataValue(split[0], childObj);
        if (fieldVal == null) {
            return false;
        }
        if (mainFailedValues.containsKey(fieldVal)) {
            EntityRelationInStoreService.writeEntityErrorLog(billData, worker);
            return true;
        }
        return false;
    }

    private static void writeEntityErrorLog(ImportBillData billData, ImportWorker worker) {
        ImportContext importContext = worker.getImportStart().getImportContext();
        ImportRowErrorLog errorLog = new ImportRowErrorLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), ResManager.loadKDString((String)"\u56e0\u4e3a\u5173\u8054\u5b9e\u4f53\u6570\u636e\u6821\u9a8c\u5931\u8d25\uff0c\u5f53\u524d\u5b9e\u4f53\u6570\u636e\u4e5f\u88ab\u8feb\u53d6\u6d88\u5165\u5e93\u3002", (String)"EntityRelationInStoreService_0", (String)"hrmp-hies-import", (Object[])new Object[0]), importContext.getImportLog());
        worker.getImportStart().writeRowErrorLog(errorLog);
        importContext.getSuccessedValidateBillCount().getAndDecrement();
    }

    private static LinkedHashMap<String, DataSet> reOrderBy(Map<String, DataSet> dataSetMap, String mainSheetName) {
        LinkedHashMap<String, DataSet> newMap = new LinkedHashMap<String, DataSet>();
        if (dataSetMap.containsKey(mainSheetName)) {
            newMap.put(mainSheetName, dataSetMap.get(mainSheetName));
        }
        dataSetMap.forEach((key, val) -> newMap.put((String)key, (DataSet)val));
        return newMap;
    }
}

