/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.tempstore;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.plugin.AfterDataTempStoreArgs;
import kd.hr.impt.common.plugin.BeforeTempStoreInstoreArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.core.ImportQueue;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.CustomInstoreDispatcher;
import kd.hr.impt.core.tempstore.EntityRelationInStoreService;
import kd.hr.impt.core.tempstore.PutTempDataToOutQueueTask;
import kd.hr.impt.core.tempstore.algo.AlgoManager;

public class TempStoreDispatcher
extends ImportWorker {
    private static Log log = LogFactory.getLog(TempStoreDispatcher.class);
    public static volatile boolean hasExtentColum = false;
    private Map<String, String> entityEntryFields;
    private AlgoManager algoManager;
    protected Map<String, ImportQueue<ImportBillData>> groupImportBillData = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Set<Integer>> validatefailedBillDatasForMEMS = Maps.newHashMapWithExpectedSize((int)6);

    public TempStoreDispatcher(ImportStart importStart) {
        super(TempStoreDispatcher.class.getSimpleName(), importStart, importStart.getTempStoreQueue(), importStart.getWaitInStoreQueue(), MCConfigConstant.getWorkerMaxThread());
        this.algoManager = new AlgoManager(importStart);
    }

    public AlgoManager getAlgoManager() {
        return this.algoManager;
    }

    public Map<String, String> getEntityEntryFields() {
        return this.entityEntryFields;
    }

    public Map<String, Set<Integer>> getValidatefailedBillDatasForMEMS() {
        return this.validatefailedBillDatasForMEMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        Object dataQueue;
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.initEntityEntryFields();
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                List<ImportBillData> tempBilldatas = super.getBatchData(MCConfigConstant.getQueueSize());
                log.info(this.name + "_receivedTempBilldatas.count=" + tempBilldatas.size());
                List<String> effectSheetNames = this.importStart.getImportContext().getEffectSheetNames();
                if (CollectionUtils.isNotEmpty(effectSheetNames) && effectSheetNames.size() > 1) {
                    this.groupImportBillData(tempBilldatas);
                    for (Map.Entry<String, ImportQueue<ImportBillData>> next : this.groupImportBillData.entrySet()) {
                        dataQueue = next.getValue();
                        this.submitTask((ImportQueue<ImportBillData>)dataQueue);
                    }
                    continue;
                }
                if (tempBilldatas.size() <= 0) continue;
                this.algoManager.createDataSetBuilder(tempBilldatas);
                this.getAlgoManager().save(tempBilldatas);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        try {
            this.printGroupImportBillData();
            long start2 = System.currentTimeMillis();
            this.algoManager.buildDataSet();
            this.importStart.getMonitor().addExpenseStatistics("buildDataSet", (Long)(System.currentTimeMillis() - start2), true);
            log.info("algoManager.buildDataSet_finished.");
            this.algoManager.setMainEntityHasData(this.isMainEntityHasData());
            this.afterDataTempStore();
            if (this.importStart.isStoped()) {
                return null;
            }
            ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = importContext.getImportLog().getRowErrors();
            if (!rowErrors.isEmpty()) {
                if (importContext.isNeedRelationInStoreForMEMS() && this.algoManager.isMainEntityHasData()) {
                    this.validatefailedBillDatasForMEMS = EntityRelationInStoreService.validateRelationEntityData(this.algoManager.getDataSetMap(), importContext.getTpl(), this);
                }
                if (importContext.isSerialModel() && !importContext.issMPartInstore()) {
                    Object syncLock;
                    this.algoManager.getDataSetMap().values().forEach(dataSet -> dataSet.close());
                    super.end();
                    dataQueue = syncLock = this.importStart.syncLock;
                    synchronized (dataQueue) {
                        syncLock.notifyAll();
                    }
                    return null;
                }
            }
            if (this.importStart.isStoped()) {
                return null;
            }
            if (importContext.isNeedRelationInStoreForMEMS() && this.algoManager.isMainEntityHasData()) {
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                long freeMemorySize = (heapMemoryUsage.getMax() - heapMemoryUsage.getUsed()) / 1024L / 1024L;
                this.importStart.getMonitor().getImportTrace().getMems().put("relateTempData_start_HMF", freeMemorySize);
                if (freeMemorySize >= 1048L && importContext.getTotalBillCount() <= 200000) {
                    EntityRelationInStoreService.relateTempDataByJoin(this.algoManager.getDataSetMap(), importContext.getTpl(), this);
                } else {
                    EntityRelationInStoreService.relateTempDataByNestLoop(this.algoManager.getDataSetMap(), importContext.getTpl(), this);
                }
                this.importStart.getMonitor().getImportTrace().getMems().put("relateTempData_end_HMF", freeMemorySize);
            } else if (importContext.getCustomInstoreParam() != null) {
                this.beforeTempStoreInstore();
            } else {
                for (Map.Entry<String, DataSet> next : this.algoManager.getDataSetMap().entrySet()) {
                    super.submitWithTimeOut(new PutTempDataToOutQueueTask(next.getKey(), this.importStart, this, this.childThreadMonitor));
                }
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            this.interruptMainThread();
        }
        super.end();
        hasExtentColum = false;
        this.algoManager.getDataSetMap().values().forEach(dataSet -> dataSet.close());
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    private void submitTask(ImportQueue<ImportBillData> dataQueue) {
        int size = dataQueue.getQueue().size();
        ArrayList<ImportBillData> dataCall = new ArrayList<ImportBillData>(size);
        dataQueue.getQueue().drainTo(dataCall, size);
        if (dataCall.size() == 0) {
            return;
        }
        log.info("submitTask__dataCall.count=" + dataCall.size());
        this.algoManager.createDataSetBuilder(dataCall);
        this.getAlgoManager().save(dataCall);
    }

    private void groupImportBillData(List<ImportBillData> importBillDataList) {
        for (ImportBillData data : importBillDataList) {
            boolean result;
            ImportQueue<ImportBillData> tempdataQueue = this.groupImportBillData.get(data.getSheetName());
            if (tempdataQueue == null) {
                tempdataQueue = new ImportQueue(this.name + "_groupQueue-".concat(data.getSheetName()), new LinkedBlockingQueue(MCConfigConstant.getQueueSize()), this.importStart);
                this.groupImportBillData.put(data.getSheetName(), tempdataQueue);
            }
            if (result = tempdataQueue.putOnce(data)) continue;
            this.submitTask(tempdataQueue);
            tempdataQueue.putOnce(data);
        }
    }

    private void initEntityEntryFields() {
        Map<String, IFormView> formIdEntityFormViewMap = this.importStart.getImportContext().getFormIdEntityFormViewMap();
        this.entityEntryFields = Maps.newHashMapWithExpectedSize((int)formIdEntityFormViewMap.size());
        for (Map.Entry<String, IFormView> next : formIdEntityFormViewMap.entrySet()) {
            StringBuilder builder = new StringBuilder();
            MainEntityType dataEntityType = next.getValue().getModel().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            properties.forEach(pro -> {
                if (pro instanceof EntryProp) {
                    builder.append(pro.getName()).append(",");
                }
            });
            this.entityEntryFields.put(next.getKey(), builder.toString());
        }
    }

    private void afterDataTempStore() {
        ImportContext importContext = this.importStart.getImportContext();
        Map<String, DataSet> dataSetMap = this.algoManager.getDataSetMap();
        Iterator<Map.Entry<String, DataSet>> iterator = dataSetMap.entrySet().iterator();
        HashMap datas = Maps.newHashMapWithExpectedSize((int)dataSetMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, DataSet> next = iterator.next();
            datas.put(next.getKey(), next.getValue().copy());
        }
        AfterDataTempStoreArgs args = new AfterDataTempStoreArgs(importContext);
        String json = JSONObject.toJSONString(importContext.getSheetEntityMap());
        Map clone = (Map)JSONObject.parseObject((String)json, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        args.setSheetEntityMap(clone);
        args.setDatas(datas);
        args.setImportLog(importContext.getImportLog());
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterDataTempStore", (AbstractEventArgs)args);
    }

    private void beforeTempStoreInstore() {
        ImportContext importContext = this.importStart.getImportContext();
        Map<String, DataSet> dataSetMap = this.algoManager.getDataSetMap();
        Iterator<Map.Entry<String, DataSet>> iterator = dataSetMap.entrySet().iterator();
        HashMap datas = Maps.newHashMapWithExpectedSize((int)dataSetMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, DataSet> next = iterator.next();
            datas.put(next.getKey(), next.getValue().copy());
        }
        BeforeTempStoreInstoreArgs args = new BeforeTempStoreInstoreArgs(importContext);
        String json = JSONObject.toJSONString(importContext.getSheetEntityMap());
        Map clone = (Map)JSONObject.parseObject((String)json, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        args.setSheetEntityMap(clone);
        args.setDatas(datas);
        args.setDispatcher(this);
        CustomInstoreDispatcher customInstoreDispatcher = (CustomInstoreDispatcher)this.importStart.getWorkers().get(CustomInstoreDispatcher.class.getSimpleName());
        if (importContext.getCustomInstoreParam().isSync()) {
            args.setSyncSemaphore(customInstoreDispatcher.getSyncSemaphore());
        }
        if (importContext.getCustomInstoreParam().isGroup()) {
            args.setGroupSemaphore(customInstoreDispatcher.getGroupSemaphore());
        }
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeTempStoreInstore", (AbstractEventArgs)args);
    }

    private void printGroupImportBillData() {
        if (this.groupImportBillData != null && this.groupImportBillData.size() > 0) {
            StringBuilder builder = new StringBuilder("groupImportBillData_queue_size,");
            this.groupImportBillData.values().forEach(queue -> builder.append(queue.getName()).append("=").append(queue.getQueue().size()).append(","));
            log.info(builder.toString());
        }
    }

    private boolean isMainEntityHasData() {
        DynamicObject tpl = this.importStart.getImportContext().getTpl();
        String mainEntityId = tpl.getString("entity.id");
        Map entitySheetMap = MethodUtil.reversalMap(this.importStart.getImportContext().getSheetEntityMap());
        return this.algoManager.getDataSetMap().containsKey(entitySheetMap.get(mainEntityId));
    }
}

