/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.tempstore.algo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.BillDataSizeAssessTask;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;
import org.apache.commons.lang3.ObjectUtils;

public class AlgoManager {
    private static final Log LOGGER = LogFactory.getLog(AlgoManager.class);
    private final int defaultColumsCount = 2;
    private volatile boolean canNotDealRelateField = false;
    public static final String COL_DATA = "data";
    public static final String COL_SEQ = "seq";
    private Map<String, DataSet> dataSetMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, DataSetBuilder> builderMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Integer> fillExtentColumsMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Integer> seqMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, String> extentColumsMap;
    private String hasExtentSheetName;
    private boolean mainEntityHasData = true;
    private ImportStart importStart;

    public Map<String, DataSet> getDataSetMap() {
        return this.dataSetMap;
    }

    public Map<String, DataSetBuilder> getBuilderMap() {
        return this.builderMap;
    }

    public void setDataSetMap(Map<String, DataSet> dataSetMap) {
        this.dataSetMap = dataSetMap;
    }

    public boolean isMainEntityHasData() {
        return this.mainEntityHasData;
    }

    public void setMainEntityHasData(boolean mainEntityHasData) {
        this.mainEntityHasData = mainEntityHasData;
    }

    public AlgoManager(ImportStart importStart) {
        this.importStart = importStart;
        DynamicObject tpl = this.importStart.getImportContext().getTpl();
        String mainEntityId = tpl.getString("entity.id");
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        this.extentColumsMap = Maps.newHashMapWithExpectedSize((int)entityrelation.size());
        for (DynamicObject child : entityrelation) {
            String mainEntityfields;
            String entityId = child.getString("rentity.id");
            String relationleftprop = child.getString("relationleftprop");
            String relationrightprop = child.getString("relationrightprop");
            if (!StringUtils.isNotEmpty((CharSequence)relationleftprop) || !StringUtils.isNotEmpty((CharSequence)relationrightprop)) continue;
            relationleftprop = relationleftprop.substring(relationleftprop.indexOf(46) + 1);
            relationrightprop = relationrightprop.substring(relationrightprop.indexOf(46) + 1);
            String fields = this.extentColumsMap.get(entityId);
            if (StringUtils.isBlank((CharSequence)fields)) {
                this.extentColumsMap.put(entityId, relationleftprop);
            }
            if ((mainEntityfields = StringUtils.isBlank((CharSequence)(mainEntityfields = this.extentColumsMap.get(mainEntityId))) ? "" : mainEntityfields).contains(',' + relationrightprop)) continue;
            this.extentColumsMap.put(mainEntityId, mainEntityfields + ',' + relationrightprop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(List<ImportBillData> datas) {
        DataSetBuilder dataSetBuilder;
        long start = System.currentTimeMillis();
        ImportContext importContext = this.importStart.getImportContext();
        ImportBillData billData = datas.get(0);
        String entityId = importContext.getSheetEntityMap().get(billData.getSheetName());
        Integer needFillColumCount = this.fillExtentColumsMap.get(billData.getSheetName());
        DataSetBuilder dataSetBuilder2 = dataSetBuilder = this.builderMap.get(billData.getSheetName());
        synchronized (dataSetBuilder2) {
            Integer seq = this.seqMap.get(billData.getSheetName());
            for (ImportBillData data : datas) {
                int i;
                String fields;
                if (this.importStart.isStoped()) break;
                String str = JSONObject.toJSONString((Object)data);
                if (needFillColumCount == null) {
                    needFillColumCount = 0;
                }
                int count = needFillColumCount + 2;
                String entitytype = importContext.getTpl().getString("entitytype");
                String[] split = new String[]{};
                if ("MEMS".equals(entitytype) && importContext.isNeedRelationInStoreForMEMS() && StringUtils.isNotBlank((CharSequence)(fields = this.extentColumsMap.get(entityId)))) {
                    split = StringUtils.split((String)fields, (String)",");
                    LOGGER.info("entityId=" + entityId + ",save_split.length=" + split.length);
                    count += split.length;
                }
                Object[] objects = new Object[count];
                Integer n = seq;
                Integer n2 = seq = Integer.valueOf(seq + 1);
                objects[0] = n;
                objects[1] = str;
                int offset = 2;
                LOGGER.info("save_count=" + count + ",split.length=" + split.length);
                for (i = 0; i < split.length; ++i) {
                    String val = "";
                    String[] splitAttr = StringUtils.split((String)split[i], (String)".");
                    if (splitAttr.length == 2) {
                        JSONObject colVal = data.getData().getJSONObject(entityId).getJSONObject(splitAttr[0]);
                        val = (String)colVal.get((Object)splitAttr[1]);
                    } else {
                        Object obj = data.getData().getJSONObject(entityId).get((Object)split[i]);
                        if (obj instanceof JSONObject) {
                            JSONObject jobj = (JSONObject)obj;
                            String fval = jobj.getString(RequestContext.get().getLang().toString());
                            if (StringUtils.isNotEmpty((CharSequence)fval)) {
                                val = fval;
                            } else {
                                if (!this.canNotDealRelateField) {
                                    this.canNotDealRelateField = true;
                                    LOGGER.error("canNotDealRelateField_occured.entityId=" + entityId + ",field=" + split[i] + ",obj=" + jobj.toJSONString());
                                    this.importStart.getMonitor().getImportTrace().getOther().put("canNotDealRelateField", true);
                                }
                                val = String.valueOf(obj);
                            }
                        } else {
                            val = String.valueOf(obj);
                        }
                    }
                    objects[offset] = val;
                    ++offset;
                }
                for (i = 0; i < needFillColumCount; ++i) {
                    objects[offset] = false;
                    ++offset;
                }
                dataSetBuilder.append(objects);
            }
            this.seqMap.put(billData.getSheetName(), seq);
        }
        this.importStart.getMonitor().addExpenseStatistics("put_dataSet_" + billData.getSheetName(), (Long)(System.currentTimeMillis() - start), false);
        this.importStart.getMonitor().addMEMSTotalCount("dataSet_" + billData.getSheetName() + "_count", datas.size());
    }

    public void putToOutQueue(String sheetName, ImportWorker worker) {
        DataSet dataSet = this.dataSetMap.get(sheetName);
        Iterator iterator = dataSet.iterator();
        while (iterator.hasNext() && !this.importStart.isStoped()) {
            Row next = (Row)iterator.next();
            String json = (String)next.get(COL_DATA);
            ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
            int retryCount = 100;
            if (this.isFailedValidateData(billData)) continue;
            worker.putToOutQueue(billData, retryCount);
        }
        if (sheetName.equals(this.hasExtentSheetName)) {
            TempStoreDispatcher.hasExtentColum = false;
            this.hasExtentSheetName = null;
        }
    }

    public void buildDataSet() {
        for (Map.Entry<String, DataSetBuilder> next : this.builderMap.entrySet()) {
            DataSet dataSet = next.getValue().build();
            this.dataSetMap.put(next.getKey(), dataSet);
        }
    }

    public void createDataSetBuilder(List<ImportBillData> tempBilldatas) {
        ImportContext importContext = this.importStart.getImportContext();
        String sheetName = tempBilldatas.get(0).getSheetName();
        DataSetBuilder dataSetBuilder = this.builderMap.get(sheetName);
        if (dataSetBuilder == null) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
            long freeMemorySize = (heapMemoryUsage.getMax() - heapMemoryUsage.getUsed()) / 1024L / 1024L;
            long availableSize = freeMemorySize - 3024L;
            Map<String, Integer> resul = null;
            if (BillDataSizeAssessTask.canTriggerBillDataSizeAssess(importContext)) {
                resul = this.getAssessSheetDataSize(sheetName, 0);
            }
            int totalSize = 0;
            if (resul != null) {
                totalSize = resul.get("totalSize");
            }
            if (resul != null && !TempStoreDispatcher.hasExtentColum && (long)totalSize > availableSize) {
                String entityId;
                String fields;
                this.importStart.getMonitor().getImportTrace().getMems().put("needAlgoExtentColum", true);
                this.hasExtentSheetName = sheetName;
                TempStoreDispatcher.hasExtentColum = true;
                int totalCount = resul.get("totalCount");
                int perSize = resul.get("perSize");
                long differSize = ((long)totalSize - availableSize) * 1024L * 1024L;
                int diffCount = (int)(differSize / (long)perSize);
                int relateColumCount = 0;
                String entitytype = importContext.getTpl().getString("entitytype");
                if ("MEMS".equals(entitytype) && importContext.isNeedRelationInStoreForMEMS() && StringUtils.isNotBlank((CharSequence)(fields = this.extentColumsMap.get(entityId = importContext.getSheetEntityMap().get(sheetName))))) {
                    String[] split = StringUtils.split((String)fields, (String)",");
                    relateColumCount = split.length;
                }
                int global_max_cells = AlgoConfiguration.MM_LIMIT_GLOBALMAXCELLS.getInt();
                int needFillCellCount = global_max_cells - totalCount * (2 + relateColumCount);
                int needFillColumCount = (int)Math.ceil((double)(needFillCellCount + diffCount) / (double)totalCount);
                Map<String, Object> map = this.createColums(sheetName, needFillColumCount);
                String[] fileds = (String[])map.get("fileds");
                DataType[] types = (DataType[])map.get("types");
                RowMeta meta = new RowMeta(fileds, types);
                DataSetBuilder builder = Algo.create((String)"import_".concat(UUID.randomUUID().toString())).createDataSetBuilder(meta);
                this.builderMap.put(sheetName, builder);
                this.fillExtentColumsMap.put(sheetName, needFillColumCount);
                this.importStart.getMonitor().getImportTrace().getOther().put("fillExtentColums", this.fillExtentColumsMap);
            } else {
                Map<String, Object> map = this.createColums(sheetName, 0);
                String[] fileds = (String[])map.get("fileds");
                DataType[] types = (DataType[])map.get("types");
                RowMeta meta = new RowMeta(fileds, types);
                DataSetBuilder builder = Algo.create((String)"import_".concat(UUID.randomUUID().toString())).createDataSetBuilder(meta);
                this.builderMap.put(sheetName, builder);
            }
        }
    }

    private Map<String, Object> createColums(String sheetName, int placeholdersColumCount) {
        int i;
        String entityId;
        String fields;
        this.seqMap.put(sheetName, 0);
        ImportContext importContext = this.importStart.getImportContext();
        int count = placeholdersColumCount + 2;
        String[] split = new String[]{};
        String entitytype = importContext.getTpl().getString("entitytype");
        if ("MEMS".equals(entitytype) && importContext.isNeedRelationInStoreForMEMS() && StringUtils.isNotBlank((CharSequence)(fields = this.extentColumsMap.get(entityId = importContext.getSheetEntityMap().get(sheetName))))) {
            split = StringUtils.split((String)fields, (String)",");
            LOGGER.info("entityId=" + entityId + ",createColums_split.length=" + split.length);
            count += split.length;
        }
        String[] fileds = new String[count];
        DataType[] types = new DataType[count];
        fileds[0] = COL_SEQ;
        types[0] = DataType.LongType;
        fileds[1] = COL_DATA;
        types[1] = DataType.StringType;
        int offset = 2;
        LOGGER.info("createColums_count=" + count + ",split.length=" + split.length);
        for (i = 0; i < split.length; ++i) {
            fileds[offset] = split[i];
            types[offset] = DataType.StringType;
            ++offset;
        }
        for (i = 0; i < placeholdersColumCount; ++i) {
            fileds[offset] = "@" + i;
            types[offset] = DataType.BooleanType;
            ++offset;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("fileds", fileds);
        map.put("types", types);
        map.put("relateColumCount", types);
        return map;
    }

    private Map<String, Integer> getAssessSheetDataSize(String sheetName, int repeat) {
        ImportContext importContext = this.importStart.getImportContext();
        Map<String, Integer> result = importContext.getSheetDataSizeMap().get(sheetName);
        if (result != null) {
            return result;
        }
        if (repeat > 5) {
            return null;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        return this.getAssessSheetDataSize(sheetName, ++repeat);
    }

    private boolean isFailedValidateData(ImportBillData billData) {
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = this.importStart.getImportContext().getImportLog().getRowErrors();
        ConcurrentHashMap<Integer, ImportRowErrorLog> errLogMap = rowErrors.get(billData.getSheetName());
        if (ObjectUtils.isNotEmpty(errLogMap)) {
            Enumeration<Integer> keys = errLogMap.keys();
            while (keys.hasMoreElements()) {
                Integer row = keys.nextElement();
                if (billData.getStartIndex() > row || billData.getEndIndex() < row) continue;
                this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(billData, this.importStart.getImportContext().isEnableRowStatistics()));
                return true;
            }
        }
        return false;
    }
}

