/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.FormRoot;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.util.ImportUtil;
import kd.hr.impt.core.ImportQueue;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.InstoreDispatcher;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.hr.impt.core.validate.ExistsValidator;
import kd.hr.impt.core.validate.FormatValidator;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.RepeatDataValidator;
import kd.hr.impt.core.validate.ValidateDataFlowSuggester;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.dto.DataValidateParams;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hr.impt.core.validate.util.ValidatorUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;

public class DataValidateManager
extends ImportWorker {
    private static final Log LOGGER = LogFactory.getLog(DataValidateManager.class);
    private Date validateStartTime;
    private ValidateDataFlowSuggester suggester;
    private int workerMaxThread;
    private DataValidateParams dataValidateParams;
    private RepeatDataValidator repeatDataValidator;
    private MultiValueMap<ValidatorEnum, AbstractValidateHandler> customValidateHandlers = null;

    public DataValidateManager(ImportStart importStart, ImportQueue<ImportBillData> outQueue, int workerMaxThread) {
        super(DataValidateManager.class.getSimpleName(), importStart, importStart.getPaserQueue(), outQueue, workerMaxThread);
        this.workerMaxThread = workerMaxThread;
        this.repeatDataValidator = new RepeatDataValidator(importStart);
        this.suggester = new ValidateDataFlowSuggester(importStart, this.workerMaxThread, outQueue);
    }

    public Date getValidateStartTime() {
        return this.validateStartTime;
    }

    public ValidateDataFlowSuggester getSuggester() {
        return this.suggester;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        ImportContext importContext = this.importStart.getImportContext();
        MethodUtil.syncRequestTraceId((Object)importContext.getRc());
        LOGGER.info("DataValidateManager_started3.");
        try {
            importContext.setFormIdEntityFormViewMap(this.initEntityAllFormView(importContext.getTpl()));
            InstoreDispatcher instoreDispatcher = this.importStart.getInstoreDispatcher();
            instoreDispatcher.getEntityBlankDynamicObjectSemaphore().release();
            LOGGER.info("DataValidateManager_beforeValidate");
            this.beforeValidate();
            while (!this.importStart.isStoped() && !this.isEnd) {
                try {
                    if (!this.canSubmitTask()) continue;
                    List<ImportBillData> batchData = super.getBatchData(this.getFinallyValidateBatchSize());
                    LOGGER.info("processInNormalModel_batchDataCount=" + batchData.size());
                    AtomicInteger countInit = new AtomicInteger();
                    batchData.forEach(item -> countInit.getAndAdd(ImportUtil.statisticsBillCount(item, importContext.isEnableRowStatistics())));
                    if (this.validateStartTime == null && countInit.get() > 0) {
                        this.validateStartTime = new Date();
                    }
                    this.repeatDataValidate(batchData, importContext, countInit);
                    this.submitTask(batchData, importContext, countInit);
                }
                catch (Throwable e) {
                    LOGGER.error(e);
                    this.importStart.writeErrorLog(e);
                    this.interruptMainThread();
                }
            }
            super.end(this.workerMaxThread);
        }
        catch (Throwable exception) {
            LOGGER.error("DataValidateManager-call() error:", exception);
            this.importStart.writeErrorLog(exception);
            super.interruptMainThread();
        }
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    private Map<String, IFormView> initEntityAllFormView(DynamicObject tpl) {
        long start = System.currentTimeMillis();
        String mainEntityId = tpl.getString("entity.id");
        IFormView mainEntityFormView = HIESUtil.createEntityFormView((String)mainEntityId);
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        HashMap formIdEntityFormViewMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        formIdEntityFormViewMap.put(mainEntityId, mainEntityFormView);
        for (DynamicObject child : entityrelation) {
            String formid = child.getString("rentity.id");
            IFormView entityFormView = HIESUtil.createEntityFormView((String)formid);
            formIdEntityFormViewMap.put(formid, entityFormView);
        }
        this.importStart.getMonitor().addExpenseStatistics("initEntityAllFormView", (Long)(System.currentTimeMillis() - start), true);
        return formIdEntityFormViewMap;
    }

    private void beforeValidate() {
        ImportContext importContext = this.importStart.getImportContext();
        DynamicObject tplDy = importContext.getTpl();
        String importType = tplDy.getString("importtype");
        boolean isDeleteTemplate = "delete".equals(importType);
        String mainEntity = tplDy.getString("entity.number");
        HashMap<String, Boolean> isBaseDataCtrlMap = new HashMap<String, Boolean>();
        DynamicObjectCollection fieldEntryCollection = tplDy.getDynamicObjectCollection("tpltreeentryentity");
        this.dataValidateParams = new DataValidateParams(isDeleteTemplate);
        this.dataValidateParams.setSerialModel(importContext.isSerialModel());
        this.dataValidateParams.setBaseDataContainer(new BaseDataContainer());
        this.dataValidateParams.setImportStart(this.importStart);
        this.dataValidateParams.setTpl(tplDy);
        this.dataValidateParams.setCellIndexOfEntities(importContext.getCellIndexOfEntities());
        this.dataValidateParams.setCellNameIndexOfEntities(importContext.getCellNameIndexOfEntities());
        this.dataValidateParams.setAllowDisableData(importContext.getSysParam().getBoolean("importdisable"));
        HashMap entityToNumberKey = Maps.newHashMapWithExpectedSize((int)16);
        LOGGER.info("DataValidateManager_isDeleteTemplate:{}", (Object)isDeleteTemplate);
        if (!isDeleteTemplate) {
            HashMap allFieldsOfEntities = Maps.newHashMapWithExpectedSize((int)16);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainEntity);
            this.getNumberProp(mainEntity, entityToNumberKey, mainType);
            allFieldsOfEntities.put(mainEntity, mainType.getAllFields());
            tplDy.getDynamicObjectCollection("entityrelation").forEach(dy -> {
                String entityId = dy.getString("rentity.number");
                MainEntityType realEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                this.getNumberProp(entityId, entityToNumberKey, realEntityType);
                allFieldsOfEntities.put(entityId, realEntityType.getAllFields());
            });
            Map<String, List<IDataEntityProperty>> entityToFields = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield") && field.getBoolean("ismustinput") && field.getBoolean("isimport")).collect(Collectors.groupingBy(dy -> dy.getString("childentity"), Collectors.mapping(field2 -> {
                if (field2.getBoolean("iscusfield")) {
                    TextProp textProp = new TextProp();
                    textProp.setName(field2.getString("fieldnumber"));
                    return textProp;
                }
                return (IDataEntityProperty)((Map)allFieldsOfEntities.getOrDefault(field2.getString("childentity"), new HashMap())).get(field2.getString("fieldnumber"));
            }, Collectors.toList())));
            entityToFields.forEach((key, value) -> {
                List allCodeRule = CodeRuleCache.getAllCodeRuleByEntity((String)key);
                if (allCodeRule != null && !allCodeRule.isEmpty()) {
                    String number = entityToNumberKey.getOrDefault(key, "number");
                    Optional<IDataEntityProperty> optional = value.stream().filter(Objects::nonNull).filter(prop -> number.equals(prop.getName())).findFirst();
                    optional.ifPresent(value::remove);
                }
            });
            this.dataValidateParams.setEntity2MustFillInFields(entityToFields);
            this.dataValidateParams.setCountryToAreaCode(ImportServiceHelper.getCountries());
            Map<String, IFormView> formIdEntityFormViewMap = importContext.getFormIdEntityFormViewMap();
            formIdEntityFormViewMap.forEach((key, value) -> {
                ArrayList<String> allTelephoneControls = new ArrayList<String>();
                ArrayList<String> allEmailControls = new ArrayList<String>();
                HashMap<String, String> allDateRangeControls = new HashMap<String, String>();
                HashMap<String, String> allTimeRangeControls = new HashMap<String, String>();
                HashMap<String, String> marks = new HashMap<String, String>();
                Map fieldApMap = ExcelStyleUtil.getFieldControlApMap((String)key);
                List contains = ((FormRoot)((IFormView)formIdEntityFormViewMap.get(key)).getRootControl()).getItems();
                ValidatorUtils.getControlsFromContains(contains, allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls, fieldApMap, marks);
                this.dataValidateParams.setNeedFormatTelFields((String)key, (List<String>)allTelephoneControls);
                this.dataValidateParams.setNeedFormatEmailFields((String)key, (List<String>)allEmailControls);
                this.dataValidateParams.setDateRangeFields((String)key, (Map<String, String>)allDateRangeControls);
                this.dataValidateParams.setTimeRangeFields((String)key, (Map<String, String>)allTimeRangeControls);
                this.dataValidateParams.setMarksMap((String)key, (Map<String, String>)marks);
            });
        }
        String permissionStatus = DataValidateServiceHelper.getPermissionStatus(importType);
        HashBasedTable entityToDataRuleScript = HashBasedTable.create();
        String mainFormId = this.importStart.getImportContext().getMainFormId();
        String bizAppId = DataValidateServiceHelper.getPermAppIdPkid(importContext.getAppId(), mainFormId, true);
        this.putDataRuleScript(importType, permissionStatus, (Table<String, String, BOSExpression>)entityToDataRuleScript, mainFormId, bizAppId);
        if (!isDeleteTemplate) {
            this.putFieldControlRules(mainFormId, bizAppId);
        }
        tplDy.getDynamicObjectCollection("entityrelation").forEach(arg_0 -> this.lambda$beforeValidate$8(importContext, mainFormId, importType, permissionStatus, (Table)entityToDataRuleScript, isDeleteTemplate, arg_0));
        this.dataValidateParams.setEntity2DataRuleScript((Table<String, String, BOSExpression>)entityToDataRuleScript);
        this.dataValidateParams.setTplFieldDefValue(this.getTplFieldDefValue(tplDy));
        isBaseDataCtrlMap.put(mainEntity, BaseDataServiceHelper.checkBaseDataCtrl((String)mainEntity));
        DynamicObjectCollection entityRelationCollection = tplDy.getDynamicObjectCollection("entityrelation");
        for (DynamicObject dynamicObject : entityRelationCollection) {
            String relationEntityNum = dynamicObject.getString("rentity.number");
            isBaseDataCtrlMap.put(relationEntityNum, BaseDataServiceHelper.checkBaseDataCtrl((String)relationEntityNum));
        }
        this.dataValidateParams.setUniqueKeyFieldsMap(this.getUniqueKeyFieldsMap());
        this.dataValidateParams.setIsBaseDataCtrlMap(isBaseDataCtrlMap);
        this.dataValidateParams.setEntityToNumberKey(entityToNumberKey);
        BeforeInitValidatorEventArgs beforeInitValidatorEventArgs = new BeforeInitValidatorEventArgs(this.importStart.getImportContext());
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeInitValidator", (AbstractEventArgs)beforeInitValidatorEventArgs);
        this.customValidateHandlers = beforeInitValidatorEventArgs.getAbstractValidateHandler();
        LOGGER.info("DataValidateManager.beforeValidate()_end");
    }

    private void getNumberProp(String mainEntity, Map<String, String> entityToNumberKey, MainEntityType mainType) {
        if (mainType instanceof BasedataEntityType) {
            entityToNumberKey.put(mainEntity, ((BasedataEntityType)mainType).getNumberProperty());
        } else if (mainType instanceof BillEntityType) {
            entityToNumberKey.put(mainEntity, ((BillEntityType)mainType).getBillNo());
        } else {
            entityToNumberKey.put(mainEntity, "number");
        }
    }

    private void putDataRuleScript(String importType, String permissionStatus, Table<String, String, BOSExpression> entityToDataRuleScript, String entityFormId, String appId) {
        LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_before,permissionStatus:{},entityFormId:{},appId:{}", new Object[]{permissionStatus, entityFormId, appId});
        BOSExpression bosExpression = DataValidateServiceHelper.getDataRuleScript(permissionStatus, entityFormId, appId);
        entityToDataRuleScript.put((Object)entityFormId, (Object)permissionStatus, (Object)bosExpression);
        LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_new,entityFormId:{},bosExpression:{}", (Object)entityFormId, (Object)bosExpression.toString());
        if (importType.equalsIgnoreCase("updateandnew")) {
            bosExpression = DataValidateServiceHelper.getDataRuleScript("4715a0df000000ac", entityFormId, appId);
            entityToDataRuleScript.put((Object)entityFormId, (Object)"4715a0df000000ac", (Object)bosExpression);
            LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_modify,entityFormId:{},bosExpression:{}", (Object)entityFormId, (Object)bosExpression.toString());
        }
    }

    private void putFieldControlRules(String entityFormId, String bizAppId) {
        Set<String> nonFieldPermSet = DataValidateServiceHelper.getFieldControlRules(bizAppId, entityFormId);
        LOGGER.info("DataValidateManager_getFieldControlRules(),appId:{},entityFormId:{},nonFieldPermSet:{}", new Object[]{bizAppId, entityFormId, nonFieldPermSet});
        if (nonFieldPermSet != null) {
            this.dataValidateParams.setNonFieldPermMap(entityFormId, nonFieldPermSet);
        }
    }

    private boolean canSubmitTask() {
        this.suggester.runDataFlowSuggest();
        if (this.suggester.getSuggestThreads() <= this.childThreadMonitor.get()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void repeatDataValidate(List<ImportBillData> batchData, ImportContext importContext, AtomicInteger countInit) {
        Object disableRepeatDataValidator = importContext.getExtOption().get("disableRepeatDataValidator");
        if (!Boolean.TRUE.equals(disableRepeatDataValidator)) {
            this.repeatDataValidator.validate(batchData, importContext.getImportLog());
            AtomicInteger afterRepeatDataValidatorcount = new AtomicInteger();
            batchData.forEach(item -> afterRepeatDataValidatorcount.getAndAdd(ImportUtil.statisticsBillCount(item, importContext.isEnableRowStatistics())));
            importContext.addFinishedBillCount(countInit.get() - afterRepeatDataValidatorcount.get());
        }
    }

    private void submitTask(List<ImportBillData> batchData, ImportContext importContext, AtomicInteger countInit) {
        String taskName = this.getClass().getSimpleName() + "_task";
        super.submitWithTimeOut(() -> {
            long start = System.currentTimeMillis();
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            AtomicInteger beforeDataValidatorCount = new AtomicInteger();
            try {
                this.childThreadMonitor.getAndIncrement();
                MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
                batchData.forEach(item -> beforeDataValidatorCount.getAndAdd(ImportUtil.statisticsBillCount(item, importContext.isEnableRowStatistics())));
                List<ImportBillData> billDataList = this.handleBatchData(batchData);
                this.validatePutToOutQueue(billDataList);
            }
            catch (Throwable e) {
                LOGGER.error("DataValidateManager-processInNormalModel(),error:", e);
                this.importStart.writeErrorLog(e);
                ImportUtil.writeExceptionRowLog(batchData, this.importStart, e);
                importContext.addFinishedBillCount(beforeDataValidatorCount.get());
            }
            finally {
                this.importStart.getImportContext().addFinishedValidateBillCount(countInit.get());
                long spense = System.currentTimeMillis() - start;
                this.importStart.getMonitor().addExpenseStatistics(taskName, (Long)spense, false);
                this.childThreadMonitor.getAndDecrement();
                this.childThreadSemaphore.release();
            }
            return null;
        });
    }

    protected List<ImportBillData> handleBatchData(List<ImportBillData> billDataList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        BeforeValidateEventArgs beforeValidateEventArgs = new BeforeValidateEventArgs(this.importStart.getImportContext(), billDataList);
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "beforeValidate", (AbstractEventArgs)beforeValidateEventArgs);
        this.dataValidateParams.setF7ExtUniqueValMap(beforeValidateEventArgs.getF7ExtUniqueValMap());
        this.dataValidateParams.setF7ExtUniqueValFieldMap(beforeValidateEventArgs.getF7ExtUniqueValFieldMap());
        this.dataValidateParams.setEntityExtUniqueValMap(beforeValidateEventArgs.getEntityExtUniqueValMap());
        ArrayList toSort = Lists.newArrayList((Object[])ValidatorEnum.values());
        toSort.sort(Comparator.comparing(ValidatorEnum::getOrder));
        AtomicReference formatFailedRowIndex = new AtomicReference();
        formatFailedRowIndex.set(new HashSet());
        for (ValidatorEnum validator : toSort) {
            AbstractValidateHandler validateHandler = null;
            LinkedList<AbstractValidateHandler> list = new LinkedList<AbstractValidateHandler>();
            if (!StringUtils.isBlank((CharSequence)validator.getClassName())) {
                Class<?> validatorClass = Class.forName(validator.getClassName());
                validateHandler = (AbstractValidateHandler)validatorClass.newInstance();
            }
            if (this.customValidateHandlers != null && this.customValidateHandlers.get((Object)validator) != null) {
                List tempList = (List)this.customValidateHandlers.get((Object)validator);
                boolean has = tempList.stream().anyMatch(x -> x.getValidatorOrderEnum() == ValidatorOrderEnum.REPLACE || x.getValidatorOrderEnum() == ValidatorOrderEnum.IGNORE);
                if (validateHandler != null) {
                    ((InnerValidateHandler)validateHandler).setEnable(!has);
                    list.add(validateHandler);
                }
                tempList.sort(Comparator.comparing(AbstractValidateHandler::getValidatorOrderEnum));
                list.addAll(tempList);
            } else if (validateHandler != null) {
                list.add(validateHandler);
            }
            list.forEach(validatorTemp -> {
                if (this.importStart.isStoped()) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (validatorTemp instanceof InnerValidateHandler) {
                    InnerValidateHandler handler = (InnerValidateHandler)validatorTemp;
                    handler.setCustomParams(this.dataValidateParams);
                    if (validatorTemp instanceof ExistsValidator) {
                        ExistsValidator existsValidator = (ExistsValidator)validatorTemp;
                        existsValidator.setFormatFailedRowIndex((Set)formatFailedRowIndex.get());
                    }
                    validatorTemp.validate(billDataList, this.importStart.getImportContext().getImportLog());
                    if (validatorTemp instanceof FormatValidator) {
                        FormatValidator formatValidator = (FormatValidator)validatorTemp;
                        ((Set)formatFailedRowIndex.get()).addAll(formatValidator.getFailedRowIndex());
                    }
                } else if (validatorTemp.getValidatorOrderEnum() != ValidatorOrderEnum.IGNORE) {
                    validatorTemp.validate(billDataList, this.importStart.getImportContext().getImportLog());
                }
                long spense = System.currentTimeMillis() - start;
                String simpleName = validatorTemp.getClass().getSimpleName();
                LOGGER.info(simpleName + "_validator_end.cost=" + spense);
                this.importStart.getMonitor().addExpenseStatistics(simpleName, (Long)spense, false);
            });
        }
        return billDataList;
    }

    protected void validatePutToOutQueue(List<ImportBillData> dataList) {
        AfterValidateEventArgs args = new AfterValidateEventArgs(this.importStart.getImportContext(), dataList);
        HRImpPluginEngine.fireImptPluginEvent(this.importStart, "afterValidate", (AbstractEventArgs)args);
        this.getImportStart().getImportContext().setBaseDataContainer(this.dataValidateParams.getBaseDataContainer());
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = this.getImportStart().getImportContext().getImportLog().getRowErrors();
        List<ImportBillData> collect = dataList.stream().filter(billData -> {
            billData.clearBaseDataJson();
            ConcurrentHashMap errLogMap = (ConcurrentHashMap)rowErrors.get(billData.getSheetName());
            if (errLogMap == null) {
                return true;
            }
            Enumeration keys = errLogMap.keys();
            while (keys.hasMoreElements()) {
                Integer row = (Integer)keys.nextElement();
                if (billData.getStartIndex() > row || billData.getEndIndex() < row) continue;
                if (this.importStart.getImportContext().isNeedRelationInStoreForMEMS()) {
                    this.addEntityFailedValue((ImportBillData)billData);
                }
                this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(billData, this.importStart.getImportContext().isEnableRowStatistics()));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (collect.size() > 0) {
            super.putToOutQueue(collect);
            collect.forEach(item -> {
                int count = ImportUtil.statisticsBillCount(item, this.importStart.getImportContext().isEnableRowStatistics());
                this.importStart.getImportContext().addSuccessedValidateBillCount(count);
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void addEntityFailedValue(ImportBillData billData) {
        ConcurrentHashMap<String, Map<Object, Object>> fieldVaues = this.dataValidateParams.getBaseDataContainer().getValidateFailedBillDataFieldVaues();
        Map fieldValueMap = fieldVaues.computeIfAbsent(billData.getSheetName(), val -> new ConcurrentHashMap(16));
        String mainEntityId = this.importStart.getImportContext().getTpl().getString("entity.id");
        String field = this.importStart.getImportContext().getEntityRelationField().get(billData.getMainEntityId());
        if (StringUtils.isNotEmpty((CharSequence)field)) {
            String[] split = StringUtils.split((String)field, (String)",");
            JSONObject obj = billData.getData().getJSONObject(billData.getMainEntityId());
            if (mainEntityId.equalsIgnoreCase(billData.getMainEntityId())) {
                for (String fd : split) {
                    Object fieldValue = ImportUtil.getBillDataValue(fd, obj);
                    if (fieldValue == null) continue;
                    fieldValueMap.put(fieldValue, new Object());
                }
            } else {
                Object fieldValue = ImportUtil.getBillDataValue(split[0], obj);
                if (fieldValue != null) {
                    fieldValueMap.put(fieldValue, new Object());
                }
            }
        }
    }

    private Map<String, List<String>> getUniqueKeyFieldsMap() {
        ImportContext importContext = this.importStart.getImportContext();
        HashMap uniqueKeyFieldsMap = Maps.newHashMapWithExpectedSize((int)importContext.getEntityIdToUniqueValMap().size());
        for (Map.Entry<String, String> next : importContext.getEntityIdToUniqueValMap().entrySet()) {
            Object[] split = StringUtils.split((String)next.getValue(), (String)",");
            uniqueKeyFieldsMap.put(next.getKey(), MethodUtil.arrayToList((Object[])split));
        }
        return uniqueKeyFieldsMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private JSONObject getTplFieldDefValue(DynamicObject tpl) {
        JSONObject result = new JSONObject();
        DynamicObjectCollection templateEntry = tpl.getDynamicObjectCollection("tpltreeentryentity");
        Map<Long, String> idToEntity = templateEntry.stream().filter(dy -> !dy.getBoolean("isfield")).collect(Collectors.toMap(dy1 -> dy1.getLong("id"), dy2 -> dy2.getString("fieldnumber"), (x1, x2) -> x1));
        Map entityToFields = templateEntry.stream().filter(dy -> !dy.getBoolean("isimport") && !dy.getBoolean("iscusfield") && StringUtils.isNotBlank((CharSequence)dy.getString("defvalprop"))).collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        if (entityToFields.size() == 0) {
            return result;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)tpl.getString("entity.number"));
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry entry : entityToFields.entrySet()) {
            String entityKey = entry.getKey();
            JSONObject map = (JSONObject)result.getOrDefault((Object)entityKey, (Object)new JSONObject());
            entry.getValue().forEach(dy -> {
                String entityKeyTemp = (String)idToEntity.get(dy.getLong("pid"));
                if (StringUtils.isBlank((CharSequence)entityKeyTemp)) {
                    entityKeyTemp = entityKey;
                }
                JSONObject mapTemp = (JSONObject)map.getOrDefault((Object)entityKeyTemp, (Object)new JSONObject());
                String fieldNumber = dy.getString("fieldnumber");
                String defVal = dy.getString("defvalprop");
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                if (defVal.contains("$dynamicFlag_")) {
                    mapTemp.put(fieldNumber, (Object)defVal);
                } else if (property instanceof LongProp || property instanceof BigIntProp) {
                    mapTemp.put(fieldNumber, (Object)Long.valueOf(defVal));
                } else if (property instanceof IntegerProp) {
                    mapTemp.put(fieldNumber, (Object)Integer.valueOf(defVal));
                } else if (property instanceof DecimalProp) {
                    mapTemp.put(fieldNumber, (Object)new BigDecimal(defVal));
                } else if (property instanceof MuliLangTextProp) {
                    mapTemp.put(fieldNumber, (Object)JSONObject.parseObject((String)defVal));
                } else if (property instanceof DateTimeProp) {
                    mapTemp.put(fieldNumber, (Object)new Timestamp(Long.parseLong(defVal)));
                } else if (property instanceof TimeProp) {
                    mapTemp.put(fieldNumber, (Object)LocalTime.ofSecondOfDay(Long.parseLong(defVal)));
                } else if (property instanceof MulComboProp) {
                    String[] split;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String key : split = defVal.split(",")) {
                        ((ComboProp)property).getComboItems().forEach(valueMapItem -> {
                            if (valueMapItem.getValue().equals(key)) {
                                stringBuilder.append(valueMapItem.getName().getLocaleValue()).append(",");
                            }
                        });
                    }
                    mapTemp.put(fieldNumber, (Object)stringBuilder.toString());
                } else if (property instanceof ComboProp) {
                    ((ComboProp)property).getComboItems().forEach(valueMapItem -> {
                        if (valueMapItem.getValue().equals(defVal)) {
                            mapTemp.put(fieldNumber, (Object)valueMapItem.getName().getLocaleValue());
                        }
                    });
                } else if (property instanceof BasedataProp) {
                    JSONObject jsonObject = new JSONObject();
                    String basedataId = ((BasedataProp)property).getBaseEntityId();
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(basedataId);
                    DynamicObject singleDy = null;
                    Object id = defVal;
                    try {
                        id = Long.parseLong(defVal);
                        singleDy = helper.loadSingle(id);
                    }
                    catch (NumberFormatException e) {
                        singleDy = helper.loadSingle(id);
                    }
                    if (singleDy != null) {
                        String realNumber;
                        String realName;
                        if (property instanceof IQueryProp) {
                            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)basedataId);
                            realName = (String)hrPersonMainProp.get("name");
                            realNumber = (String)hrPersonMainProp.get("number");
                        } else {
                            Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.importStart.getImportContext().getEntityBdFieldMainPropName();
                            Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityKey).get(property.getName());
                            realNumber = (String)bdFieldMainPropName.get("number");
                            realName = (String)bdFieldMainPropName.get("name");
                        }
                        jsonObject.put("number", (Object)singleDy.getString(realNumber));
                        jsonObject.put("name", (Object)singleDy.getString(realName));
                        jsonObject.put("$basedataentity", (Object)basedataId);
                        jsonObject.put("$basedataBelongEntity", (Object)entityKey);
                        this.dataValidateParams.getBaseDataContainer().addBaseDataDy(entityKey, basedataId, property.getName(), singleDy.getString(realNumber), Collections.singletonList(singleDy));
                    }
                    jsonObject.put("id", id);
                    mapTemp.put(fieldNumber, (Object)jsonObject);
                } else if (property instanceof MulBasedataProp) {
                    JSONArray jsonArray = new JSONArray();
                    Object[] split = (Object[])ConvertUtils.convert((String[])defVal.split(","), Object.class);
                    String basedataId = ((MulBasedataProp)property).getBaseEntityId();
                    DynamicObject[] dynamicObjects = new HRBaseServiceHelper(basedataId).loadDynamicObjectArray(split);
                    if (dynamicObjects != null) {
                        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                            String realNumber;
                            String realName;
                            if (property instanceof IQueryProp) {
                                Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)basedataId);
                                realName = (String)hrPersonMainProp.get("name");
                                realNumber = (String)hrPersonMainProp.get("number");
                            } else {
                                Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.importStart.getImportContext().getEntityBdFieldMainPropName();
                                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityKey).get(property.getName());
                                realNumber = (String)bdFieldMainPropName.get("number");
                                realName = (String)bdFieldMainPropName.get("name");
                            }
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("number", (Object)dynamicObject.getString(realNumber));
                            jsonObject.put("name", (Object)dynamicObject.getString(realName));
                            jsonObject.put("$basedataentity", (Object)basedataId);
                            jsonObject.put("$basedataBelongEntity", (Object)entityKey);
                            jsonObject.put("id", dynamicObject.get("id"));
                            jsonArray.add((Object)jsonObject);
                            this.dataValidateParams.getBaseDataContainer().addBaseDataDy(entityKey, basedataId, property.getName(), dynamicObject.getString(realNumber), Collections.singletonList(dynamicObject));
                        });
                    }
                    mapTemp.put(fieldNumber, (Object)jsonArray);
                } else {
                    mapTemp.put(fieldNumber, (Object)defVal);
                }
                map.put(entityKeyTemp, (Object)mapTemp);
            });
            result.put(entityKey, (Object)map);
        }
        return result;
    }

    private int getFinallyValidateBatchSize() {
        int size = 1000;
        String cusValidateBatchSize = this.importStart.getImportContext().getCusValidateBatchSize();
        if (StringUtils.isNotEmpty((CharSequence)cusValidateBatchSize)) {
            switch (cusValidateBatchSize) {
                case "1/2": {
                    size = (int)((double)size * 0.5);
                    break;
                }
                case "2/3": {
                    size = (int)((double)size * 0.66);
                    break;
                }
            }
        }
        return size;
    }

    private /* synthetic */ void lambda$beforeValidate$8(ImportContext importContext, String mainFormId, String importType, String permissionStatus, Table entityToDataRuleScript, boolean isDeleteTemplate, DynamicObject dy) {
        String entityId = dy.getString("rentity.number");
        String relBizAppId = DataValidateServiceHelper.getPermAppIdPkid(importContext.getAppId(), mainFormId, true);
        this.putDataRuleScript(importType, permissionStatus, (Table<String, String, BOSExpression>)entityToDataRuleScript, entityId, relBizAppId);
        if (!isDeleteTemplate) {
            this.putFieldControlRules(entityId, relBizAppId);
        }
    }
}

