/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.enu.BaseInfoFormatEnum;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImptPluginContext;
import kd.hr.impt.common.plugin.AfterF7MatchedEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.dto.BaseDataWrapping;
import kd.hr.impt.core.validate.dto.DistinctionWrapping;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class ExistsValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(ExistsValidator.class);
    private final List<EnabledLang> enabledLang = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
    private FunctionSubPageService functionSubPageService = new FunctionSubPageService();
    private ImportBillData curBillData;
    private Object mainOrgValue;
    private Set<String> baseDataCtrl = new HashSet<String>();
    private Map<String, Map<String, Set<String>>> allRefBdSelectedAtrr = new HashMap<String, Map<String, Set<String>>>(16);
    private Set<Integer> formatFailedRowIndex = new HashSet<Integer>();

    public void setFormatFailedRowIndex(Set<Integer> formatFailedRowIndex) {
        this.formatFailedRowIndex = formatFailedRowIndex;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        HashMap baseDataWrappingMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap refBillNoMap = Maps.newHashMapWithExpectedSize((int)16);
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        ImportContext importContext = this.getDataValidateParams().getImportStart().getImportContext();
        String opType = billDataList.get(0).getOpType();
        this.handleDataOpType(billDataList, importLog, baseDataContainer, opType);
        JSONObject tplFieldDefValue = this.getDataValidateParams().getTplFieldDefValue();
        LOGGER.info("ExistsValidator.validate_tplFieldDefValue:{}", (Object)tplFieldDefValue);
        if (this.getDataValidateParams().isDeleteTemplate()) {
            return;
        }
        HashMap MulClassTypeToValueTemp = Maps.newHashMapWithExpectedSize((int)16);
        billDataList.forEach(billData -> {
            this.curBillData = billData;
            MulClassTypeToValueTemp.clear();
            billData.getData().forEach((key, value) -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)key);
                if (value instanceof JSONArray) {
                    for (Object data : (JSONArray)value) {
                        this.iterateBaseDataProp(baseDataWrappingMap, entityType, entityType.getProperties(), (ImportBillData)billData, (JSONObject)data, null, MulClassTypeToValueTemp, refBillNoMap);
                    }
                } else {
                    this.iterateBaseDataProp(baseDataWrappingMap, entityType, entityType.getProperties(), (ImportBillData)billData, (JSONObject)value, null, MulClassTypeToValueTemp, refBillNoMap);
                }
            });
        });
        Collection baseDataWrappingCollection = baseDataWrappingMap.values();
        baseDataWrappingCollection.stream().sorted((o1, o2) -> !(o1.getProp() instanceof OrgProp) && o2.getProp() instanceof OrgProp ? 1 : -1).forEachOrdered(baseDataWrapping -> {
            this.setControlledBDPermTable(baseDataContainer, (BaseDataWrapping)baseDataWrapping);
            this.queryBaseDataByWrap(billDataList, baseDataContainer, importContext, (BaseDataWrapping)baseDataWrapping);
        });
        refBillNoMap.entrySet().forEach(entry -> {
            DistinctionWrapping distinctionWrapping = (DistinctionWrapping)entry.getKey();
            QFilter[] qFilters = ImportServiceHelper.getRefBillDefaultQFilter(distinctionWrapping, (Set)entry.getValue());
            BeforeQueryRefBdEventArgs args = new BeforeQueryRefBdEventArgs((String)importContext.getExtOption().get("extParam"), importContext.getCustomParams());
            args.setEntityId(distinctionWrapping.getEntityId());
            args.setBaseDataName(distinctionWrapping.getBdType());
            args.setFieldId(distinctionWrapping.getFieldKey());
            args.setFilters(qFilters);
            args.setSelectFields(Sets.newHashSet((Object[])new String[]{"billno"}));
            args.setBillDataList(billDataList);
            ImptPluginContext context = new ImptPluginContext();
            context.setImporttype(importContext.getTpl().getString("importtype"));
            args.setContext(context);
            args.setImportInvoke(true);
            HRImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStart(), "beforeQueryRefBd", (AbstractEventArgs)args);
            DataSet dataSet = new HRBaseServiceHelper(distinctionWrapping.getBdType()).queryDataSet("ExistsValidator_query_refbill", "id,billno", args.getFilters());
            ConcurrentHashMap<Object, Object> map = baseDataContainer.getBasedataIdMap().getOrDefault(distinctionWrapping.getBdType(), new ConcurrentHashMap());
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.get(1), row.get(0));
            }
            baseDataContainer.getBasedataIdMap().put(distinctionWrapping.getBdType(), map);
        });
        billDataList.forEach(billData -> {
            this.curBillData = billData;
            billData.getData().forEach((entity, jsonValue) -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
                if (jsonValue instanceof JSONArray) {
                    for (Object data : (JSONArray)jsonValue) {
                        this.mainOrgValue = ((JSONObject)data).get((Object)entityType.getMainOrg());
                        this.iterateCheckBaseData(importLog, entityType.getProperties(), (String)entity, (JSONObject)data, baseDataContainer);
                        this.handleDefValue(tplFieldDefValue, (String)entity, (JSONObject)data, entityType.getAllFields());
                    }
                } else {
                    this.mainOrgValue = ((JSONObject)jsonValue).get((Object)entityType.getMainOrg());
                    this.iterateCheckBaseData(importLog, entityType.getProperties(), (String)entity, (JSONObject)jsonValue, baseDataContainer);
                    this.handleDefValue(tplFieldDefValue, (String)entity, (JSONObject)jsonValue, entityType.getAllFields());
                }
            });
        });
        this.checkBaseDataCtrlOrg(billDataList, baseDataContainer, importContext, importLog);
    }

    private void queryBaseDataByWrap(List<ImportBillData> billDataList, BaseDataContainer baseDataContainer, ImportContext importContext, BaseDataWrapping baseDataWrapping) {
        QFilter[] qFilters;
        String baseDataEntityNum = baseDataWrapping.getBaseDataEntityNum();
        String mainEntityNum = baseDataWrapping.getEntityType().getName();
        String fieldNum = baseDataWrapping.getProp().getName();
        String logKey = "queryBaseDataByWrap_" + mainEntityNum + "&" + baseDataEntityNum + "&" + baseDataWrapping.getProp().getName() + "_" + System.currentTimeMillis();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(mainEntityNum, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if ((qFilters = baseDataWrapping.getQFiltrs(baseDataContainer)) == null) {
            return;
        }
        BeforeQueryRefBdEventArgs args = new BeforeQueryRefBdEventArgs((String)importContext.getExtOption().get("extParam"), importContext.getCustomParams());
        args.setEntityId(mainEntityNum);
        args.setBaseDataName(baseDataEntityNum);
        args.setFieldId(fieldNum);
        args.setFilters(qFilters);
        args.setSelectFields(baseDataWrapping.getSelectFields());
        args.setBillDataList(billDataList);
        args.setSourceCondition(baseDataWrapping.getSourceCondition());
        ImptPluginContext context = new ImptPluginContext();
        context.setImporttype(importContext.getTpl().getString("importtype"));
        args.setContext(context);
        args.setImportInvoke(true);
        HRImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStart(), "beforeQueryRefBd", (AbstractEventArgs)args);
        qFilters = args.getFilters();
        QFilter bdRefPermQFilters = baseDataWrapping.getBDRefPermQFilters();
        Set selectFields = args.getSelectFields();
        LOGGER.info(logKey + "_BeforeQueryRefBdEvent_selectFields:{}", (Object)selectFields);
        MethodUtil.printQfilters((QFilter[])qFilters, (String)(logKey + "_BeforeQueryRefBdEvent_qFilters"));
        long start = System.currentTimeMillis();
        boolean isQueryProp = baseDataWrapping.getProp() instanceof IQueryProp;
        DataSet resultDataSet = HIESUtil.smartQueryF7((String)baseDataEntityNum, (Set)selectFields, (QFilter[])qFilters, (boolean)isQueryProp, (String)logKey);
        if (bdRefPermQFilters != null && baseDataContainer.getDataRulePermBasedata(mainEntityNum, baseDataEntityNum, fieldNum) == null) {
            MethodUtil.printQfilters((QFilter[])new QFilter[]{bdRefPermQFilters}, (String)(logKey + "_bdRefPermQFilters_"));
            long start1 = System.currentTimeMillis();
            DataSet dataSet = resultDataSet.copy().filter(bdRefPermQFilters.toString());
            HashSet hasPermId = Sets.newHashSetWithExpectedSize((int)16);
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                hasPermId.add(next.getLong("id"));
            }
            dataSet.close();
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_dataRule", System.currentTimeMillis() - start1, false);
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_dataRule_" + baseDataEntityNum, System.currentTimeMillis() - start1, false);
            baseDataContainer.addDataRulePermBasedata(mainEntityNum, baseDataEntityNum, fieldNum, hasPermId);
            LOGGER.info("ExistsValidator.queryBaseDataByWrap.addDataRulePermBasedata,fieldNum:{},hasPermId:{}", (Object)fieldNum, (Object)hasPermId);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        while (resultDataSet.hasNext()) {
            Row next = resultDataSet.next();
            ids.add(next.get("id"));
        }
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_id", System.currentTimeMillis() - start, false);
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_id_" + baseDataEntityNum, System.currentTimeMillis() - start, false);
        LOGGER.info(logKey + "_resultDataSet_idsSize:{}", (Object)ids.size());
        if (ids.size() > 0) {
            DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)baseDataEntityNum, baseDataWrapping.getSelectFields());
            long start2 = System.currentTimeMillis();
            DynamicObject[] dynamicObjects = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)type, (Boolean)true);
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_load", System.currentTimeMillis() - start2, false);
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_load_" + baseDataEntityNum, System.currentTimeMillis() - start2, false);
            LOGGER.info(logKey + "_BusinessDataReader_load_dynamicObjects_size:{}", (Object)(dynamicObjects == null ? 0 : dynamicObjects.length));
            AfterQueryRefBdEventArgs args2 = new AfterQueryRefBdEventArgs((String)importContext.getExtOption().get("extParam"), baseDataEntityNum, dynamicObjects);
            args2.setImportInvoke(true);
            HRImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStart(), "AfterQueryRefBd", (AbstractEventArgs)args2);
            dynamicObjects = args2.getDatas();
            LOGGER.info(logKey + "_AfterQueryRefBdEventArgs_dynamicObjects_size:{}", (Object)(dynamicObjects == null ? 0 : dynamicObjects.length));
            if (dynamicObjects != null) {
                String baseDataFormat = baseDataWrapping.getBaseDataFormat();
                Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(mainEntityNum).get(fieldNum);
                String customKey = isQueryProp ? baseDataWrapping.getHRControlQueryKey("") : "";
                Map finalF7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap;
                Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> this.getPutWhereKey((DynamicObject)dy, customKey, baseDataFormat, bdFieldMainPropName, this.getExtF7UniqueVal(mainEntityNum, fieldNum), (Map<String, String>)((Map)finalF7ExtUniqueValFieldMap.get(fieldNum))))).forEach((key, value) -> {
                    baseDataContainer.addBaseDataDy(mainEntityNum, baseDataEntityNum, fieldNum, key, (List<DynamicObject>)value);
                    LOGGER.info(logKey + "_mainEntityNum:{},key:{},valueSize:{}", new Object[]{mainEntityNum, key, value.size()});
                    this.getDataValidateParams().getImportStart().getMonitor().addTotalCachedCount("BasedataTable", value.size());
                });
            }
        }
        resultDataSet.close();
    }

    @ExcludeFromJacocoGeneratedReport
    private void setControlledBDPermTable(BaseDataContainer baseDataContainer, BaseDataWrapping baseDataWrapping) {
        if (baseDataWrapping.isBaseDataCtrl()) {
            Set<Object> useOrgValueSet = baseDataWrapping.getUseOrgValue();
            LOGGER.info("ExistsValidator_getControlledBDPerm(),BaseDataEntityNum:{},useOrgValueSet:{}", (Object)baseDataWrapping.getBaseDataEntityNum(), useOrgValueSet);
            if (useOrgValueSet == null || useOrgValueSet.size() == 0) {
                return;
            }
            long start = System.currentTimeMillis();
            useOrgValueSet.forEach(useOrgValue -> {
                if ((useOrgValue == null || StringUtils.isBlank((CharSequence)String.valueOf(useOrgValue))) && StringUtils.isNotBlank((CharSequence)baseDataWrapping.getUseOrgFieldKey())) {
                    QFilter dataRuleForBdProp = DataValidateServiceHelper.getDataRuleForBdProp(baseDataWrapping.getEntityType().getName(), baseDataWrapping.getEntityType().getAppId(), baseDataWrapping.getUseOrgFieldKey(), "47150e89000000ac");
                    if (dataRuleForBdProp == null) {
                        LOGGER.info("ExistsValidator_getControlledBDPerm()_has all perm");
                        return;
                    }
                    DataSet dataSet = new HRBaseServiceHelper("bos_org").queryDataSet("ExistsValidator.setControlledBDPermTable", "id", new QFilter[]{dataRuleForBdProp});
                    LinkedList<Long> orgID = new LinkedList<Long>();
                    while (dataSet.hasNext()) {
                        orgID.add(dataSet.next().getLong(0));
                    }
                    QFilter baseDataQFilter = DataValidateServiceHelper.getBaseDataQFilter(baseDataWrapping.getBaseDataEntityNum(), orgID, true);
                    DynamicObject[] results = new HRBaseServiceHelper(baseDataWrapping.getBaseDataEntityNum()).queryOriginalArray("id", new QFilter[]{baseDataQFilter});
                    List<Long> collect = Arrays.stream(results).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    long currUserId = RequestContext.get().getCurrUserId();
                    baseDataContainer.setControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), currUserId, collect);
                    LOGGER.info("ExistsValidator_setControlledBDPermTable(),BaseDataEntityNum:{},currUserId:{},results:{}", new Object[]{baseDataWrapping.getBaseDataEntityNum(), currUserId, collect});
                    return;
                }
                List<DynamicObject> useOrgDy = baseDataContainer.getBaseDataDy(baseDataWrapping.getEntityType().getName(), baseDataWrapping.getUseOrgEntityNum(), baseDataWrapping.getUseOrgFieldKey(), useOrgValue);
                if (ObjectUtils.isEmpty(useOrgDy)) {
                    LOGGER.info("ExistsValidator_setControlledBDPermTable()_getBaseDataDy(),mainEntityNum:{},baseDataEntityNum:{},fieldNum:{},key:{}", new Object[]{baseDataWrapping.getEntityType().getName(), baseDataWrapping.getUseOrgEntityNum(), baseDataWrapping.getProp().getName(), useOrgValue});
                }
                if (useOrgDy != null && useOrgDy.size() == 1 && baseDataContainer.getControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), useOrgDy.get(0).getLong("id")) == null) {
                    long userOrgId = useOrgDy.get(0).getLong("id");
                    QFilter baseDataQFilter = DataValidateServiceHelper.getBaseDataQFilter(baseDataWrapping.getBaseDataEntityNum(), userOrgId);
                    LOGGER.info("ExistsValidator_setControlledBDPermTable(),BaseDataEntityNum:{},baseDataQFilter:{}", (Object)baseDataWrapping.getBaseDataEntityNum(), (Object)baseDataQFilter);
                    DynamicObject[] results = new HRBaseServiceHelper(baseDataWrapping.getBaseDataEntityNum()).queryOriginalArray("id", new QFilter[]{baseDataQFilter});
                    List<Long> collect = Arrays.stream(results).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    baseDataContainer.setControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), userOrgId, collect);
                    LOGGER.info("ExistsValidator_setControlledBDPermTable(),BaseDataEntityNum:{},userOrgId:{},results:{}", new Object[]{baseDataWrapping.getBaseDataEntityNum(), userOrgId, collect});
                }
            });
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_load", System.currentTimeMillis() - start, false);
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("queryBd_load_" + baseDataWrapping.getBaseDataEntityNum(), System.currentTimeMillis() - start, false);
        }
    }

    private void handleDataOpType(List<ImportBillData> billDataList, ImportLog importLog, BaseDataContainer baseDataContainer, String opType) {
        long start = System.currentTimeMillis();
        if (!"new".equals(opType)) {
            HashSet noAdaptBilldatas = Sets.newHashSetWithExpectedSize((int)16);
            HashSet dbRepeatBilldatas = Sets.newHashSetWithExpectedSize((int)16);
            String entitytype = this.getDataValidateParams().getTpl().getString("entitytype");
            Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
            Map<Object, DynamicObject> existsDysMap = "MESS".equals(entitytype) ? ImportServiceHelper.analysisComposeDataNewOrUpdate(billDataList, tplFieldConfig, noAdaptBilldatas, dbRepeatBilldatas, this.getDataValidateParams(), this.formatFailedRowIndex) : ImportServiceHelper.analysisSimpleDataNewOrUpdate(billDataList, tplFieldConfig, noAdaptBilldatas, dbRepeatBilldatas, this.getDataValidateParams(), this.formatFailedRowIndex);
            baseDataContainer.addExistsEntityDyMap(existsDysMap);
            boolean deleteTemplate = this.getDataValidateParams().isDeleteTemplate();
            if ("update".equals(opType) || "delete".equals(opType)) {
                int type = deleteTemplate ? 18 : 8;
                noAdaptBilldatas.forEach(item -> DataValidateServiceHelper.writeRowErrorLog(type, importLog, item.getSheetName(), item.getStartIndex(), item.getEndIndex(), item.getStartIndex(), new Object[0]));
            }
            int type2 = deleteTemplate ? 19 : 9;
            dbRepeatBilldatas.forEach(item -> DataValidateServiceHelper.writeRowErrorLog(type2, importLog, item.getSheetName(), item.getStartIndex(), item.getEndIndex(), item.getStartIndex(), new Object[0]));
        } else {
            DataValidateServiceHelper.dealBillstatusJudge(billDataList, this.getDataValidateParams().getImportStart().getImportContext(), null);
            ImportServiceHelper.setRuleNumber(billDataList, this.getDataValidateParams().getEntityToNumberKey());
            HashMap entryToEntryId = Maps.newHashMapWithExpectedSize((int)16);
            HashMap entryIdToLine = Maps.newHashMapWithExpectedSize((int)16);
            Map<String, List<ImportBillData>> sheetGroupDataList = billDataList.stream().collect(Collectors.groupingBy(ImportBillData::getMainEntityId));
            sheetGroupDataList.forEach((entityId, sheetDataList) -> {
                entryToEntryId.clear();
                entryIdToLine.clear();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                List entryList = mainEntityType.getAllEntities().entrySet().stream().filter(entry -> entry.getValue() instanceof EntryType).map(Map.Entry::getKey).collect(Collectors.toList());
                sheetDataList.forEach(importBillData -> ImportServiceHelper.checkEntryIdExistsOfNew(mainEntityType, entityId, entryList, importBillData, entryToEntryId, entryIdToLine, importLog));
                ImportServiceHelper.tipEntryIdExists(this.getDataValidateParams().getImportStart(), sheetDataList, mainEntityType, entryToEntryId, entryIdToLine);
            });
        }
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("handleDataOpType", System.currentTimeMillis() - start, false);
    }

    private void iterateBaseDataProp(Map<String, BaseDataWrapping> baseDataWrappingMap, MainEntityType entityType, DataEntityPropertyCollection properties, ImportBillData billData, JSONObject dataJson, String entryPropName, Map<String, String> MulClassTypeToValueTemp, Map<DistinctionWrapping, Set<String>> refBillNoMap) {
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (dataJson.get((Object)propName) == null) continue;
            if (property instanceof BasedataProp) {
                this.addBaseDataWrap(baseDataWrappingMap, billData, dataJson, dataJson.getJSONObject(propName), entityType, property, entryPropName, MulClassTypeToValueTemp);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                dataJson.getJSONArray(propName).forEach(dataTemp -> this.addBaseDataWrap(baseDataWrappingMap, billData, dataJson, (JSONObject)dataTemp, entityType, property, entryPropName, MulClassTypeToValueTemp));
                continue;
            }
            if (property instanceof EntryProp) {
                dataJson.getJSONArray(propName).forEach(entryData -> this.iterateBaseDataProp(baseDataWrappingMap, entityType, ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties(), billData, (JSONObject)entryData, propName, MulClassTypeToValueTemp, refBillNoMap));
                continue;
            }
            if (property instanceof ItemClassTypeProp) {
                if (!StringUtils.isBlank((CharSequence)entryPropName)) continue;
                List comboItems = ((ItemClassTypeProp)property).getComboItems();
                Optional<ValueMapItem> optional = comboItems.stream().filter(comboItem -> comboItem.getName().getLocaleValue().equals(String.valueOf(dataJson.get((Object)propName)))).findFirst();
                optional.ifPresent(valueMapItem -> MulClassTypeToValueTemp.put(propName, valueMapItem.getValue()));
                continue;
            }
            if (!(property instanceof RefBillProp)) continue;
            this.iterateRefBillProp(entityType.getName(), (RefBillProp)property, dataJson, refBillNoMap, this.getDataValidateParams().getBaseDataContainer());
        }
    }

    private void iterateRefBillProp(String entityTypeName, RefBillProp property, JSONObject dataJson, Map<DistinctionWrapping, Set<String>> refBillNoMap, BaseDataContainer baseDataContainer) {
        String billEntityId = property.getBillEntityId();
        String propName = property.getName();
        JSONObject valueJson = dataJson.getJSONObject(propName);
        String billNo = valueJson.getString("billno");
        DistinctionWrapping key = new DistinctionWrapping(entityTypeName, billEntityId, propName);
        key.setProperty(property);
        Set<String> set = refBillNoMap.get(key);
        if (set == null) {
            refBillNoMap.put(key, Sets.newHashSet((Object[])new String[]{billNo}));
        } else if (set.add(billNo)) {
            refBillNoMap.put(key, set);
        } else if (baseDataContainer.getRefBillIdMap().get(entityTypeName) != null && !baseDataContainer.getRefBillIdMap().get(entityTypeName).containsKey(billNo)) {
            set.add(billNo);
            refBillNoMap.put(key, set);
        }
    }

    private void iterateCheckBaseData(ImportLog importLog, DataEntityPropertyCollection properties, String entityNumber, JSONObject data, BaseDataContainer baseDataContainer) {
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof OrgProp)) continue;
            this.checkBaseData(importLog, entityNumber, data, baseDataContainer, property);
        }
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof OrgProp) continue;
            this.checkBaseData(importLog, entityNumber, data, baseDataContainer, prop);
        }
    }

    private void checkBaseData(ImportLog importLog, String entityNumber, JSONObject data, BaseDataContainer baseDataContainer, IDataEntityProperty property) {
        Object propValue = data.get((Object)property.getName());
        if (property instanceof BasedataProp && propValue != null) {
            JSONObject baseDataJson = data.getJSONObject(property.getName());
            this.checkBaseDataExists(importLog, baseDataContainer, (IBasedataField)((BasedataProp)property), entityNumber, data, baseDataJson);
        } else if (property instanceof MulBasedataProp && propValue != null) {
            data.getJSONArray(property.getName()).forEach(dataTemp -> this.checkBaseDataExists(importLog, baseDataContainer, (IBasedataField)((MulBasedataProp)property), entityNumber, data, (JSONObject)dataTemp));
        } else if (property instanceof AdminDivisionProp && propValue != null) {
            this.handleAdminDivision(importLog, entityNumber, data, property, propValue);
        } else if (property instanceof RefBillProp && propValue != null) {
            this.checkRefBillExists(importLog, entityNumber, data, baseDataContainer, property);
        } else if (property instanceof TreeEntryProp) {
            String propName = property.getName();
            JSONArray dataJSONArray = data.getJSONArray(propName);
            if (dataJSONArray == null) {
                return;
            }
            HashSet entryIds = Sets.newHashSet();
            HashMap entryPids = Maps.newHashMap();
            dataJSONArray.forEach(entryData -> {
                Long pid;
                this.iterateCheckBaseData(importLog, ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties(), entityNumber, (JSONObject)entryData, baseDataContainer);
                Long id = ((JSONObject)entryData).getLong(propName + "_id");
                if (id != null && id != 0L) {
                    entryIds.add(id);
                }
                if ((pid = ((JSONObject)entryData).getLong(propName + "_pid")) != null && pid != 0L) {
                    entryPids.put(((JSONObject)entryData).getInteger("$excelIndex"), pid);
                }
            });
            entryPids.forEach((key, value) -> {
                if (!entryIds.contains(value)) {
                    String cellIndex = this.getCellIndex(propName + "_pid", entityNumber);
                    DataValidateServiceHelper.writeRowErrorLog(29, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), key, cellIndex);
                }
            });
        } else if (property instanceof EntryProp && propValue != null) {
            data.getJSONArray(property.getName()).forEach(entryData -> this.iterateCheckBaseData(importLog, ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties(), entityNumber, (JSONObject)entryData, baseDataContainer));
        }
    }

    private void checkRefBillExists(ImportLog importLog, String entityNumber, JSONObject data, BaseDataContainer baseDataContainer, IDataEntityProperty property) {
        JSONObject baseDataJson = data.getJSONObject(property.getName());
        String billno = baseDataJson.getString("billno");
        ConcurrentHashMap<Object, Object> map = baseDataContainer.getBasedataIdMap().get(((RefBillProp)property).getBillEntityId());
        if (map != null && map.get(billno) != null) {
            baseDataJson.put("$refbillentity", (Object)((RefBillProp)property).getBillEntityId());
            baseDataJson.put("id", map.get(billno));
        } else {
            int rowIndex = data.getIntValue("$excelIndex");
            String cellIndex = this.getCellIndex(property.getName(), entityNumber);
            DataValidateServiceHelper.writeRowErrorLog(5, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNumber), billno);
        }
    }

    private void handleAdminDivision(ImportLog importLog, String entityNumber, JSONObject data, IDataEntityProperty property, Object propValue) {
        Map<String, Long> adminDivisionMap = this.getDataValidateParams().getBaseDataContainer().getAdminDivisionMap();
        if (adminDivisionMap.size() == 0) {
            List<QFilter> qFilters = ImportServiceHelper.getDefaultQFilter(entityNumber, property, "bd_admindivision", this.getDataValidateParams().isAllowDisableData());
            DynamicObjectCollection collection = new HRBaseServiceHelper("bd_admindivision").queryOriginalCollection("id,fullname,country.name", qFilters.toArray(new QFilter[0]));
            adminDivisionMap = collection.stream().collect(Collectors.toMap(dy -> dy.getString(2) + "/" + dy.getString(1).replace("_", "/"), dy2 -> dy2.getLong(0), (x1, x2) -> x1));
        }
        if (adminDivisionMap.get(propValue) != null) {
            data.put(property.getName(), (Object)(propValue + "##" + adminDivisionMap.get(propValue)));
        } else {
            if (Pattern.compile("^[1-9]\\d*$").matcher(String.valueOf(propValue)).matches() && adminDivisionMap.containsValue(Long.valueOf(String.valueOf(propValue)))) {
                return;
            }
            String cellIndex = this.getCellIndex(property.getName(), entityNumber);
            DataValidateServiceHelper.writeRowErrorLog(5, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), propValue);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkBaseDataExists(ImportLog importLog, BaseDataContainer baseDataContainer, IBasedataField property, String entityNumber, JSONObject baseDataParentJson, JSONObject baseDataJson) {
        Map<String, Map<String, DynamicObject>> tplFieldConfig;
        DynamicObject fieldDy;
        String baseDataFormat;
        ImportContext importContext = this.getDataValidateParams().getImportStart().getImportContext();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityNumber, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if (StringUtils.isBlank((CharSequence)(baseDataFormat = (fieldDy = (tplFieldConfig = importContext.getTplFieldConfig()).get(entityNumber).get(property.getName())).getString("imptattr")))) {
            baseDataFormat = "number";
        }
        Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
        Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNumber).get(property.getName());
        String baseDataEntityId = baseDataJson.getString("$basedataentity");
        int rowIndex = baseDataParentJson.getIntValue("$excelIndex");
        String fieldKey = DataValidateServiceHelper.getFieldKey(property.getName(), baseDataFormat, bdFieldMainPropName);
        Object id = baseDataJson.get((Object)"id");
        if (ObjectUtils.isNotEmpty((Object)id)) {
            DynamicObject baseDataDys = baseDataContainer.getBasedataIdMap(entityNumber, baseDataEntityId, property.getName(), id);
            this.setBaseDataF7Json(property, entityNumber, baseDataParentJson, baseDataJson, baseDataEntityId, baseDataDys, rowIndex, fieldKey);
            return;
        }
        Object putWhereKey = this.getPutWhereKey(baseDataJson, baseDataFormat, bdFieldMainPropName, baseDataParentJson, this.getExtF7UniqueVal(entityNumber, MethodUtil.getLevelOneKey((String)fieldKey)), (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(MethodUtil.getLevelOneKey((String)fieldKey))));
        if (putWhereKey == null) {
            LOGGER.info("ExistsValidator.checkBaseDataExists.putWhereKey_valueJson:{},bdFieldMainPropName:{}", (Object)baseDataJson, bdFieldMainPropName);
            return;
        }
        List<DynamicObject> baseDataDys = baseDataContainer.getBaseDataDy(entityNumber, baseDataEntityId, property.getName(), putWhereKey);
        if (ObjectUtils.isEmpty(baseDataDys) || baseDataDys.size() > 1) {
            AfterF7MatchedEventArgs args = new AfterF7MatchedEventArgs(importContext);
            args.setFieldId(property.getName());
            args.setCurrentF7Key(putWhereKey);
            args.setBaseDataDys(baseDataDys);
            long start = System.currentTimeMillis();
            args.setF7QueryDataMap(baseDataContainer.getBaseDataDyMap(entityNumber, baseDataEntityId, property.getName()));
            this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("getBaseDataDyMap_" + entityNumber, System.currentTimeMillis() - start, false);
            HRImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStart(), "AfterF7Matched", (AbstractEventArgs)args);
            baseDataDys = args.getBaseDataDys();
        }
        if (ObjectUtils.isEmpty(baseDataDys)) {
            LOGGER.info("ExistsValidator.checkBaseDataExists_baseDataDys_is_null,entityNumber:{},baseDataEntityId:{},fieldId:{},putWhereKey:{}", new Object[]{entityNumber, baseDataEntityId, property.getName(), putWhereKey});
            if (this.isEnable() && !this.getDataValidateParams().isDeleteTemplate()) {
                String cellIndex;
                if (property instanceof ItemClassProp && StringUtils.isBlank((CharSequence)baseDataEntityId)) {
                    cellIndex = this.getCellIndex(((ItemClassProp)property).getTypePropName(), entityNumber);
                    DataValidateServiceHelper.writeRowErrorLog(30, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNumber));
                } else {
                    cellIndex = this.getCellIndex(fieldKey, entityNumber);
                    DataValidateServiceHelper.writeRowErrorLog(5, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNumber), putWhereKey);
                }
            }
        } else if (baseDataDys.size() > 1) {
            if (this.isEnable() && !this.getDataValidateParams().isDeleteTemplate()) {
                Object useOrg;
                Long userOrgId;
                List<Long> controlledBDPermTable;
                List<Long> permMainBU;
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                if (property.getName().equals(entityType.getMainOrg()) && (permMainBU = this.getPermMainBU(baseDataContainer, entityType, entityNumber)).get(0) != -2L) {
                    ArrayList collect = new ArrayList(baseDataDys.size());
                    ArrayList<Object> errCollect = new ArrayList<Object>(baseDataDys.size());
                    baseDataDys.forEach(dy -> {
                        if (permMainBU.contains(dy.getLong("id"))) {
                            collect.add(dy);
                        } else {
                            errCollect.add(dy.get("id"));
                        }
                    });
                    if (collect.size() == 1) {
                        Object bdId = ((DynamicObject)collect.get(0)).get("id");
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_PermMainBU(),entityNumber:{},baseDataEntityId:{},collect:{}", new Object[]{entityNumber, baseDataEntityId, bdId});
                        this.setBaseDataF7Json(property, entityNumber, baseDataParentJson, baseDataJson, baseDataEntityId, (DynamicObject)collect.get(0), rowIndex, fieldKey);
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_PermMainBU(),errCollect:{},baseDataParentJson:{}", errCollect, (Object)baseDataParentJson);
                        List<DynamicObject> collectOfDy = this.removeErrDy(baseDataContainer, entityNumber, baseDataEntityId, property.getName(), errCollect, bdId);
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_BasedataIdTable:{}", collectOfDy);
                        return;
                    }
                }
                if (this.baseDataCtrl.contains(baseDataEntityId) && (controlledBDPermTable = baseDataContainer.getControlledBDPermTable(baseDataEntityId, userOrgId = (useOrg = baseDataParentJson.get((Object)property.getOrgProp())) == null ? (this.mainOrgValue == null ? null : ((JSONObject)this.mainOrgValue).getLong("id")) : ((JSONObject)useOrg).getLong("id"))) != null && controlledBDPermTable.size() > 0) {
                    ArrayList<Object> errCollect = new ArrayList<Object>(baseDataDys.size());
                    ArrayList collect = new ArrayList(baseDataDys.size());
                    baseDataDys.forEach(dy -> {
                        if (controlledBDPermTable.contains(dy.getLong("id"))) {
                            collect.add(dy);
                        } else {
                            errCollect.add(dy.getLong("id"));
                        }
                    });
                    if (collect.size() == 1) {
                        Long bdId = ((DynamicObject)collect.get(0)).getLong("id");
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_ControlledBDPerm(),entityNumber:{},baseDataEntityId:{},collect:{}", new Object[]{entityNumber, baseDataEntityId, bdId});
                        this.setBaseDataF7Json(property, entityNumber, baseDataParentJson, baseDataJson, baseDataEntityId, (DynamicObject)collect.get(0), rowIndex, fieldKey);
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_ControlledBDPerm(),errCollect:{},baseDataParentJson:{}", errCollect, (Object)baseDataParentJson);
                        List<DynamicObject> collectOfDy = this.removeErrDy(baseDataContainer, entityNumber, baseDataEntityId, property.getName(), errCollect, bdId);
                        LOGGER.info("ExistsValidator.checkBaseDataExists()_BasedataIdTable:{}", collectOfDy);
                        return;
                    }
                }
                String cellIndex = this.getCellIndex(fieldKey, entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(6, importLog, this.curBillData.getSheetName(), this.curBillData.getStartIndex(), this.curBillData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNumber), putWhereKey);
            }
        } else {
            this.setBaseDataF7Json(property, entityNumber, baseDataParentJson, baseDataJson, baseDataEntityId, baseDataDys.get(0), rowIndex, fieldKey);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private List<DynamicObject> removeErrDy(BaseDataContainer baseDataContainer, String entityNumber, String baseDataEntityId, String fieldId, List<Object> errCollect, Object bdId) {
        List<DynamicObject> collectOfDy = baseDataContainer.getBaseDataDy(entityNumber, baseDataEntityId, fieldId, bdId);
        List errCollectOfDy = collectOfDy.stream().filter(dy -> errCollect.contains(dy.getLong("id"))).collect(Collectors.toList());
        collectOfDy.removeAll(errCollectOfDy);
        errCollect.forEach(id -> {
            ConcurrentHashMap<Object, Object> map = baseDataContainer.getBasedataIdMap().get(baseDataEntityId);
            if (map != null) {
                map.remove(id);
            }
        });
        return collectOfDy;
    }

    @ExcludeFromJacocoGeneratedReport
    private void setBaseDataF7Json(IBasedataField property, String entityNumber, JSONObject baseDataParentJson, JSONObject baseDataJson, String baseDataEntityId, DynamicObject baseDataDy, int rowIndex, String fieldKey) {
        Object curBaseDataJson;
        BOSExpression bosExpression;
        Object id = baseDataJson.get((Object)"id");
        if (ObjectUtils.isNotEmpty((Object)id)) {
            baseDataJson.put("$isDefaultValue", (Object)"1");
            baseDataJson.put("$fieldNameOfDefaultValue", (Object)property.getDisplayName().getLocaleValue());
        }
        baseDataJson.put("$basedataentity", (Object)baseDataEntityId);
        baseDataJson.put("$basedataBelongEntity", (Object)entityNumber);
        baseDataJson.put("id", baseDataDy.get("id"));
        if (ImportServiceHelper.hasHis(baseDataEntityId)) {
            baseDataJson.put("boid", baseDataDy.get("boid"));
        }
        baseDataJson.put("$excelIndex", (Object)rowIndex);
        baseDataJson.put("$basedataFieldKey", (Object)fieldKey);
        if (this.baseDataCtrl.contains(baseDataEntityId)) {
            Object useOrg = baseDataParentJson.get((Object)property.getOrgProp());
            if (useOrg == null) {
                if (this.mainOrgValue == null || StringUtils.isNotBlank((CharSequence)property.getOrgProp())) {
                    baseDataJson.put("$useOrgId", (Object)0L);
                } else {
                    baseDataJson.put("$useOrgId", (Object)(((JSONObject)this.mainOrgValue).getLong("id") == null ? Long.valueOf(0L) : ((JSONObject)this.mainOrgValue).getLong("id")));
                }
            } else {
                baseDataJson.put("$useOrgId", (Object)((JSONObject)useOrg).getLong("id"));
            }
            baseDataJson.put("$isBaseDataCtrl", (Object)"1");
        }
        if ((bosExpression = this.getDataValidateParams().getEntity2DataRuleScript(entityNumber, DataValidateServiceHelper.getPermissionStatus(this.curBillData.getOpType()))) != null) {
            Set vars = bosExpression.getVars();
            vars.stream().filter(key -> key.contains(property.getName() + ".") && !baseDataJson.containsKey(key)).forEach(key2 -> {
                String[] split = key2.split("\\.", 2);
                if (property.getName().equals(split[0])) {
                    String tempKey = split[1];
                    baseDataJson.put(tempKey, baseDataDy.get(tempKey));
                }
            });
        }
        if ((curBaseDataJson = this.curBillData.getBaseDataJson(property.getName())) != null) {
            if (curBaseDataJson instanceof JSONObject) {
                JSONArray tempArray = new JSONArray();
                tempArray.add(curBaseDataJson);
                tempArray.add((Object)baseDataJson);
                this.curBillData.setBaseDataJson(property.getName(), tempArray);
            } else if (curBaseDataJson instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)curBaseDataJson;
                if (jsonArray.stream().noneMatch(jsonOb -> ((JSONObject)jsonOb).getLong("id").longValue() == baseDataJson.getLong("id").longValue())) {
                    ((JSONArray)curBaseDataJson).add((Object)baseDataJson);
                }
                this.curBillData.setBaseDataJson(property.getName(), curBaseDataJson);
            }
        } else {
            this.curBillData.setBaseDataJson(property.getName(), baseDataJson);
        }
    }

    private void addBaseDataWrap(Map<String, BaseDataWrapping> baseDataWrappingMap, ImportBillData billData, JSONObject rowJson, JSONObject valueJsonTemp, MainEntityType entityType, IDataEntityProperty property, String entryPropName, Map<String, String> MulClassTypeToValueTemp) {
        ImportContext importContext = this.getDataValidateParams().getImportStart().getImportContext();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityType.getName(), val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        JSONObject valueJson = valueJsonTemp.clone();
        Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
        DynamicObject fieldDy = tplFieldConfig.get(entityType.getName()).get(property.getName());
        String baseDataFormat = fieldDy == null || StringUtils.isBlank((CharSequence)fieldDy.getString("imptattr")) ? "number" : fieldDy.getString("imptattr");
        Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
        Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityType.getName()).get(property.getName());
        if (BaseInfoFormatEnum.NUMBER.getCode().equalsIgnoreCase(baseDataFormat) && !bdFieldMainPropName.get(BaseInfoFormatEnum.NUMBER.getCode()).equals(bdFieldMainPropName.get(BaseInfoFormatEnum.NAME.getCode()))) {
            valueJson.remove(bdFieldMainPropName.get(BaseInfoFormatEnum.NAME.getCode()));
        }
        if (valueJson.isEmpty()) {
            LOGGER.info("ExistsValidator.addBaseDataWrap_svalueJson:{},bdFieldMainPropName:{}", (Object)valueJsonTemp, bdFieldMainPropName);
            return;
        }
        String baseEntityId = this.handleMulClassBD(rowJson, entityType, property, entryPropName, MulClassTypeToValueTemp);
        valueJsonTemp.put("$basedataentity", (Object)baseEntityId);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return;
        }
        String bdkey = entityType.getName() + '&' + baseEntityId + '&' + property.getName();
        BaseDataWrapping baseDataWrapping = baseDataWrappingMap.get(bdkey);
        String[] extF7UniqueVal = this.getExtF7UniqueVal(entityType.getName(), property.getName());
        JSONObject valueJsonClone = this.addExtF7UniqueVal(valueJson, rowJson, extF7UniqueVal, (Map)f7ExtUniqueValFieldMap.get(property.getName()));
        if (baseDataWrapping != null) {
            baseDataWrapping.getWhereMap().put(this.getPutWhereKey(valueJson, baseDataFormat, bdFieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(property.getName()))), (Map<String, Object>)valueJsonClone);
            this.addSourceCondition(billData, valueJsonClone, baseDataWrapping);
            String useOrgFieldKey = ((IBasedataField)property).getOrgProp();
            JSONObject useOrgJson = rowJson.getJSONObject(useOrgFieldKey);
            if (useOrgJson == null && StringUtils.isBlank((CharSequence)useOrgFieldKey)) {
                useOrgFieldKey = entityType.getMainOrg();
                useOrgJson = rowJson.getJSONObject(useOrgFieldKey);
            }
            baseDataWrapping.setUseOrgValue(this.getPutWhereKey(useOrgJson, baseDataFormat, bdFieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(property.getName()))));
            baseDataWrapping.setEntryPropName(entryPropName);
        } else {
            Object putWhereKey = this.getPutWhereKey(valueJson, baseDataFormat, bdFieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(property.getName())));
            if (putWhereKey == null) {
                LOGGER.info("ExistsValidator.putWhereKey_valueJson:{},bdFieldMainPropName:{}", (Object)valueJson, bdFieldMainPropName);
                return;
            }
            Set<String> defaultF7SelectFields = this.getF7SelectFields(entityType, property);
            this.addF7ExtUniqueField(defaultF7SelectFields, entityType.getName(), property.getName());
            Boolean aBoolean = BaseDataServiceHelper.checkBaseDataCtrl((String)baseEntityId);
            baseDataWrapping = new BaseDataWrapping((IBasedataField)property, defaultF7SelectFields, baseDataFormat);
            baseDataWrapping.setAppId(importContext.getAppId());
            baseDataWrapping.setMainFormId(importContext.getMainFormId());
            baseDataWrapping.setEntityType(entityType);
            baseDataWrapping.setBaseDataEntityNum(baseEntityId);
            baseDataWrapping.putWhere(putWhereKey, valueJsonClone);
            this.addSourceCondition(billData, valueJsonClone, baseDataWrapping);
            if (!((IBasedataField)property).isShowUsed()) {
                baseDataWrapping.setAllowDisableData(true);
            }
            baseDataWrapping.setBaseDataCtrl(aBoolean);
            baseDataWrapping.setExtF7UniqueVal(extF7UniqueVal);
            if (aBoolean.booleanValue()) {
                this.baseDataCtrl.add(baseEntityId);
                LOGGER.info("ExistsValidator_add_baseDataCtrl:{}", (Object)baseEntityId);
            }
            String useOrgFieldKey = ((IBasedataField)property).getOrgProp();
            JSONObject useOrgJson = rowJson.getJSONObject(useOrgFieldKey);
            LOGGER.info("ExistsValidator_new_BaseDataWrapping,bdkey:{},Org:{}", (Object)bdkey, (Object)useOrgFieldKey);
            if (useOrgJson == null && StringUtils.isBlank((CharSequence)useOrgFieldKey)) {
                useOrgFieldKey = entityType.getMainOrg();
                useOrgJson = rowJson.getJSONObject(useOrgFieldKey);
                LOGGER.info("ExistsValidator_new_BaseDataWrapping,bdkey:{},MainOrg:{}", (Object)bdkey, (Object)useOrgFieldKey);
            }
            if (!StringUtils.isBlank((CharSequence)useOrgFieldKey)) {
                DynamicObject fieldDyOrg = tplFieldConfig.get(entityType.getName()).get(useOrgFieldKey);
                if (fieldDyOrg != null) {
                    String baseDataFormatOrg = fieldDyOrg.getString("imptattr");
                    baseDataWrapping.setUseOrgValue(this.getPutWhereKey(useOrgJson, baseDataFormatOrg, bdFieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(property.getName()))));
                }
                baseDataWrapping.setUseOrgFieldKey(useOrgFieldKey);
                baseDataWrapping.setUseOrgEntityNum(((OrgProp)entityType.getProperties().get((Object)useOrgFieldKey)).getBaseEntityId());
            } else {
                baseDataWrapping.setUseOrgEntityNum("");
            }
            baseDataWrapping.setEntryPropName(entryPropName);
            BOSExpression bosExpression = this.getDataValidateParams().getEntity2DataRuleScript(entityType.getName(), DataValidateServiceHelper.getPermissionStatus(this.curBillData.getOpType()));
            if (bosExpression != null) {
                Set<String> selectFields = baseDataWrapping.getSelectFields();
                Set vars = bosExpression.getVars();
                vars.stream().filter(key -> key.indexOf(property.getName() + ".") == 0).forEach(key2 -> selectFields.add(key2.split("\\.", 2)[1]));
                baseDataWrapping.setSelectFields(selectFields);
            }
            baseDataWrappingMap.put(bdkey, baseDataWrapping);
        }
    }

    private String handleMulClassBD(JSONObject rowJson, MainEntityType entityType, Object property, String entryPropName, Map<String, String> MulClassTypeToValueTemp) {
        String baseEntityId = ((IBasedataField)property).getBaseEntityId();
        if (property instanceof ItemClassProp) {
            String typePropName = ((ItemClassProp)property).getTypePropName();
            String typeValue = rowJson.getString(typePropName);
            if (StringUtils.isBlank((CharSequence)typeValue)) {
                return MulClassTypeToValueTemp.getOrDefault(typePropName, "");
            }
            List comboItems = ((ItemClassTypeProp)entityType.getAllFields().get(typePropName)).getComboItems();
            Optional<ValueMapItem> optional = comboItems.stream().filter(comboItem -> comboItem.getName().getLocaleValue().equals(typeValue)).findFirst();
            if (optional.isPresent()) {
                baseEntityId = optional.get().getValue();
                if (StringUtils.isBlank((CharSequence)entryPropName)) {
                    MulClassTypeToValueTemp.put(typePropName, baseEntityId);
                }
            }
        }
        return baseEntityId;
    }

    private Set<String> getF7SelectFields(MainEntityType entityType, IDataEntityProperty property) {
        HashSet defaultF7SelectFields;
        String baseEntityId = ((IBasedataField)property).getBaseEntityId();
        if (property instanceof IQueryProp) {
            defaultF7SelectFields = Sets.newHashSet((Object[])new String[]{"id"});
            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseEntityId);
            defaultF7SelectFields.add((String)hrPersonMainProp.get("number"));
            defaultF7SelectFields.add((String)hrPersonMainProp.get("name"));
        } else {
            defaultF7SelectFields = Sets.newHashSet((Object[])"id,status,enable".split(","));
            Map<String, Object> fieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName().get(entityType.getName()).get(property.getName());
            String realName = (String)fieldMainPropName.get("name");
            String realNumber = (String)fieldMainPropName.get("number");
            if (StringUtils.isNotEmpty((CharSequence)realName)) {
                defaultF7SelectFields.add(realName);
            }
            if (StringUtils.isNotEmpty((CharSequence)realNumber)) {
                defaultF7SelectFields.add(realNumber);
            }
        }
        this.addF7SelectFields(defaultF7SelectFields, this.allRefBdSelectedAtrr, entityType.getName(), property.getName());
        if (ImportServiceHelper.hasHis(baseEntityId)) {
            defaultF7SelectFields.add("boid");
        }
        return defaultF7SelectFields;
    }

    private void addF7SelectFields(Set<String> defaultF7SelectFields, Map<String, Map<String, Set<String>>> allRefBdSelectedAtrr, String entityName, String propName) {
        Set sets;
        Map keysRefBdSelectedAtrr = allRefBdSelectedAtrr.get(entityName);
        if (keysRefBdSelectedAtrr == null) {
            keysRefBdSelectedAtrr = MethodUtil.getAllRefBdSelectedAtrr((String)entityName);
            Set strings = (Set)keysRefBdSelectedAtrr.get(propName);
            if (Objects.nonNull(strings)) {
                defaultF7SelectFields.addAll(strings);
            }
            this.allRefBdSelectedAtrr.put(entityName, keysRefBdSelectedAtrr);
        }
        if ((sets = (Set)keysRefBdSelectedAtrr.get(propName)) != null) {
            defaultF7SelectFields.addAll(sets);
        }
    }

    private void addF7ExtUniqueField(Set<String> defaultF7SelectFields, String entityNum, String fieldNum) {
        String[] extF7UniqueVal = this.getExtF7UniqueVal(entityNum, fieldNum);
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal)) {
            Collections.addAll(defaultF7SelectFields, extF7UniqueVal);
        }
    }

    private void addSourceCondition(ImportBillData billData, JSONObject valueJson, BaseDataWrapping baseDataWrapping) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("data", billData);
        HashMap map1 = Maps.newHashMapWithExpectedSize((int)3);
        for (Map.Entry entryTemp : valueJson.entrySet()) {
            String key = (String)entryTemp.getKey();
            if ("$bdSplit".equals(key)) continue;
            if (baseDataWrapping.isHRPersonProp()) {
                Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseDataWrapping.getBaseDataEntityNum());
                key = (String)hrPersonMainProp.get(key);
            }
            map1.put(key, entryTemp.getValue());
        }
        map.put("val", map1);
        baseDataWrapping.getSourceCondition().add(map);
    }

    private void handleDefValue(JSONObject tplFieldDefValue, String key, JSONObject dataJson, Map<String, IDataEntityProperty> allFieldMap) {
        JSONObject fieldDefMapOrg = tplFieldDefValue.getJSONObject(key);
        if (fieldDefMapOrg != null && dataJson != null) {
            JSONObject fieldDefMap = fieldDefMapOrg.clone();
            JSONObject fieldDef = fieldDefMap.getJSONObject(key);
            HashMap defaultValMap = Maps.newHashMap();
            StringBuilder errorMsg = new StringBuilder();
            if (fieldDef != null) {
                fieldDef.forEach((fieldNumber, defValue) -> {
                    if (defValue.toString().contains("$dynamicFlag_")) {
                        this.handleDynamicDefValue(dataJson, null, allFieldMap, defaultValMap, errorMsg, (String)fieldNumber, defValue, "");
                    } else {
                        dataJson.put(fieldNumber, defValue);
                    }
                });
                fieldDefMap.remove((Object)key);
            }
            fieldDefMap.forEach((entryNumber, entryDefValue) -> {
                JSONArray entityJson = (JSONArray)dataJson.getOrDefault(entryNumber, (Object)new JSONArray());
                entityJson.forEach(json -> ((JSONObject)entryDefValue).forEach((fieldNumber, defValue) -> {
                    if (defValue.toString().contains("$dynamicFlag_")) {
                        this.handleDynamicDefValue(dataJson, (JSONObject)json, allFieldMap, defaultValMap, errorMsg, (String)fieldNumber, defValue, entryNumber + ".");
                    } else {
                        ((JSONObject)json).put(fieldNumber, defValue);
                    }
                }));
            });
        }
    }

    private void handleDynamicDefValue(JSONObject dataJson, JSONObject entryDataJson, Map<String, IDataEntityProperty> allFieldMap, Map<String, Object> defaultValMap, StringBuilder errorMsg, String fieldNumber, Object function, String fieldPatchPrefix) {
        defaultValMap.clear();
        errorMsg.reverse();
        String valueTemp = function.toString().replace("$dynamicFlag_", "");
        long start = System.currentTimeMillis();
        IDataEntityProperty prop = allFieldMap.get(fieldNumber);
        if (prop instanceof MuliLangTextProp) {
            JSONObject valueJson = new JSONObject();
            for (EnabledLang lang : this.enabledLang) {
                String langNumber = lang.getNumber();
                boolean flag = false;
                for (Map.Entry entryTemp : dataJson.entrySet()) {
                    String key = (String)entryTemp.getKey();
                    Object value = entryTemp.getValue();
                    if (!valueTemp.contains("$" + key + "$")) continue;
                    if (value instanceof JSONObject && ((JSONObject)value).get((Object)langNumber) != null) {
                        defaultValMap.put(key, ((JSONObject)value).get((Object)langNumber));
                        continue;
                    }
                    if (value instanceof String) {
                        defaultValMap.put(key, value);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                Object executeResult = this.functionSubPageService.preExecuteExpr(valueTemp, defaultValMap, errorMsg, ReportFunctionExecuteService.class.getName());
                if (executeResult == null && errorMsg.length() > 0) {
                    LOGGER.info("ExistsValidator.handleDefValue_fieldNumber:{},error:{}", (Object)fieldNumber, (Object)errorMsg);
                    continue;
                }
                valueJson.put(langNumber, (Object)String.valueOf(executeResult));
            }
            if (entryDataJson == null) {
                dataJson.put(fieldNumber, (Object)valueJson);
            } else {
                entryDataJson.put(fieldNumber, (Object)valueJson);
            }
        } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
            if (entryDataJson == null) {
                for (Map.Entry entryTemp : dataJson.entrySet()) {
                    String key;
                    String fieldPatchTmp = key = (String)entryTemp.getKey();
                    if (!valueTemp.contains("$" + fieldPatchTmp + "$") && !valueTemp.contains("$" + fieldPatchTmp + ".")) continue;
                    String[] split = valueTemp.split("\\$")[1].split("\\.");
                    String targetField = Arrays.stream(split).skip(1L).collect(Collectors.joining("."));
                    JSONObject value = (JSONObject)entryTemp.getValue();
                    value.put("$relBDFieldNumber", (Object)key);
                    if (ObjectUtils.isNotEmpty((Object)value.get((Object)targetField))) {
                        dataJson.put(fieldNumber, (Object)value);
                    } else {
                        String bdEntityNmuber = value.getString("$basedataentity");
                        DynamicObject dyn = new HRBaseServiceHelper(bdEntityNmuber).queryOne(value.get((Object)"id"));
                        String[] split1 = targetField.split("\\.");
                        targetField = split1.length > 2 ? split1[1] : split1[0];
                        dataJson.put(fieldNumber, dyn.get(targetField));
                    }
                    break;
                }
            } else {
                String[] split1;
                DynamicObject dyn;
                JSONObject value;
                String targetField;
                String[] split;
                String fieldPatchTmp;
                String key;
                for (Map.Entry entryTemp : entryDataJson.entrySet()) {
                    key = (String)entryTemp.getKey();
                    fieldPatchTmp = fieldPatchPrefix + key;
                    if (!valueTemp.contains("$" + fieldPatchTmp + "$") && !valueTemp.contains("$" + fieldPatchTmp + ".")) continue;
                    split = valueTemp.split("\\$")[1].split("\\.");
                    targetField = Arrays.stream(split).skip(2L).collect(Collectors.joining("."));
                    value = (JSONObject)entryTemp.getValue();
                    value.put("$relBDFieldNumber", (Object)key);
                    if (ObjectUtils.isNotEmpty((Object)value.get((Object)targetField))) {
                        entryDataJson.put(fieldNumber, (Object)value);
                        break;
                    }
                    dyn = new HRBaseServiceHelper(value.getString("$basedataentity")).queryOne(value.get((Object)"id"));
                    split1 = targetField.split("\\.");
                    targetField = split1.length > 2 ? split1[1] : split1[0];
                    dataJson.put(fieldNumber, dyn.get(targetField));
                    break;
                }
                for (Map.Entry entryTemp : dataJson.entrySet()) {
                    fieldPatchTmp = key = (String)entryTemp.getKey();
                    if (!valueTemp.contains("$" + fieldPatchTmp + "$") && !valueTemp.contains("$" + fieldPatchTmp + ".")) continue;
                    split = valueTemp.split("\\$")[1].split("\\.");
                    targetField = String.join((CharSequence)".", Arrays.stream(split).skip(1L).collect(Collectors.toList()));
                    value = (JSONObject)entryTemp.getValue();
                    value.put("$relBDFieldNumber", (Object)key);
                    if (ObjectUtils.isNotEmpty((Object)value.get((Object)targetField))) {
                        entryDataJson.put(fieldNumber, (Object)value);
                    } else {
                        dyn = new HRBaseServiceHelper(value.getString("$basedataentity")).queryOne(value.get((Object)"id"));
                        split1 = targetField.split("\\.");
                        targetField = split1.length > 2 ? split1[1] : split1[0];
                        dataJson.put(fieldNumber, dyn.get(targetField));
                    }
                    break;
                }
            }
        } else {
            Object executeResult;
            for (Map.Entry entryTemp : dataJson.entrySet()) {
                this.dealDynamicDefValue(allFieldMap, defaultValMap, valueTemp, entryTemp, 1, "");
            }
            if (entryDataJson != null) {
                for (Map.Entry entryTemp : entryDataJson.entrySet()) {
                    this.dealDynamicDefValue(allFieldMap, defaultValMap, valueTemp, entryTemp, 2, fieldPatchPrefix);
                }
            }
            if ((executeResult = this.functionSubPageService.preExecuteExpr(valueTemp, defaultValMap, errorMsg, ReportFunctionExecuteService.class.getName())) == null && errorMsg.length() > 0) {
                LOGGER.info("ExistsValidator.handleDefValue_fieldNumber:{},error:{}", (Object)fieldNumber, (Object)errorMsg);
            } else if (entryDataJson == null) {
                dataJson.put(fieldNumber, executeResult);
            } else {
                entryDataJson.put(fieldNumber, executeResult);
            }
        }
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("handleDynamicDefValue", System.currentTimeMillis() - start, false);
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("handleDynamicDefValue_" + fieldNumber, System.currentTimeMillis() - start, false);
    }

    private void dealDynamicDefValue(Map<String, IDataEntityProperty> allFieldMap, Map<String, Object> defaultValMap, String valueTemp, Map.Entry<String, Object> entryTemp, int skipNum, String fieldPatchPrefix) {
        String key = entryTemp.getKey();
        Object value = entryTemp.getValue();
        String fieldPatchTmp = fieldPatchPrefix + key;
        if (valueTemp.contains("$" + fieldPatchTmp + "$") || valueTemp.contains("$" + fieldPatchTmp + ".")) {
            IDataEntityProperty property = allFieldMap.get(key);
            if (ObjectUtils.isNotEmpty((Object)property) && property instanceof BasedataProp) {
                String[] fieldPaths;
                ArrayList<String> targetFields = new ArrayList<String>(8);
                for (String fieldPath : fieldPaths = valueTemp.split("\\$")) {
                    if (!fieldPath.startsWith(fieldPatchTmp)) continue;
                    String[] split = fieldPath.split("\\.");
                    String targetField = String.join((CharSequence)".", Arrays.stream(split).skip(skipNum).collect(Collectors.toList()));
                    if (((JSONObject)value).containsKey((Object)targetField)) {
                        defaultValMap.put(fieldPath, ((JSONObject)value).get((Object)targetField));
                        continue;
                    }
                    targetFields.add(targetField);
                }
                if (CollectionUtils.isNotEmpty(targetFields)) {
                    DynamicObject dyn = new HRBaseServiceHelper(((JSONObject)value).getString("$basedataentity")).queryOne(((JSONObject)value).get((Object)"id"));
                    for (String targetField : targetFields) {
                        defaultValMap.put(fieldPatchTmp + "." + targetField, dyn.get(targetField));
                    }
                }
            } else {
                defaultValMap.put(fieldPatchTmp, value);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkBaseDataCtrlOrg(List<ImportBillData> billDataList, BaseDataContainer baseDataContainer, ImportContext importContext, ImportLog importLog) {
        String importtype;
        long start = System.currentTimeMillis();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billDataList.get(0).getMainEntityId());
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityType.getName(), val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if ("new".equalsIgnoreCase(importtype = importContext.getTpl().getString("importtype")) || "delete".equalsIgnoreCase(importtype)) {
            return;
        }
        Map<Object, Object> map = Maps.newHashMapWithExpectedSize((int)this.baseDataCtrl.size());
        if (importContext.isSerialModel()) {
            Map entityGroupMap = billDataList.stream().filter(x -> "update".equalsIgnoreCase(x.getOpType())).collect(Collectors.groupingBy(ImportBillData::getMainEntityId, Collectors.toList()));
            for (Map.Entry next : entityGroupMap.entrySet()) {
                if (!BaseDataServiceHelper.checkBaseDataCtrl((String)next.getKey()).booleanValue()) continue;
                List vals = next.getValue();
                List ids = vals.stream().map(ImportBillData::getPkId).collect(Collectors.toList());
                HRBaseServiceHelper helper = new HRBaseServiceHelper(((ImportBillData)vals.get(0)).getMainEntityId());
                DynamicObject[] dynamicObjects = helper.queryOriginalArray("id," + entityType.getMainOrg() + ".id", new QFilter[]{new QFilter("id", "in", ids)});
                map.putAll(Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.get("id"), dy2 -> dy2, (x1, x2) -> x1)));
            }
        } else {
            map = baseDataContainer.getExistsEntityDyMap();
        }
        Map<Object, Object> finalMap = map;
        Map finalF7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap;
        billDataList.stream().filter(x -> "update".equalsIgnoreCase(x.getOpType())).forEach(billData -> {
            if (BaseDataServiceHelper.checkBaseDataCtrl((String)billData.getMainEntityId()).booleanValue()) {
                DynamicObject dy = (DynamicObject)finalMap.get(billData.getPkId());
                JSONObject jObject = billData.getData().getJSONObject(billData.getMainEntityId());
                JSONObject orgObject = jObject.getJSONObject(entityType.getMainOrg());
                if (orgObject == null || dy == null) {
                    return;
                }
                long oldMainOrgId = dy.getLong(entityType.getMainOrg() + ".id");
                Long newMainOrgId = orgObject.getLong("id");
                if (newMainOrgId != null && newMainOrgId != oldMainOrgId) {
                    DynamicObject fieldDy = importContext.getTplFieldConfig().get(billData.getMainEntityId()).get(entityType.getMainOrg());
                    Map<String, Object> bdFieldMainPropName = importContext.getEntityBdFieldMainPropName().get(billData.getMainEntityId()).get(entityType.getMainOrg());
                    String baseDataFormat = fieldDy.getString("imptattr");
                    String fieldKey = DataValidateServiceHelper.getFieldKey(entityType.getMainOrg(), baseDataFormat, bdFieldMainPropName);
                    String cellIndex = this.getCellIndex(fieldKey, billData.getMainEntityId());
                    Object putWhereKey = this.getPutWhereKey(orgObject, baseDataFormat, bdFieldMainPropName, billData.getData().getJSONObject(billData.getMainEntityId()), this.getExtF7UniqueVal(billData.getMainEntityId(), MethodUtil.getLevelOneKey((String)fieldKey)), (Map<String, String>)((Map)finalF7ExtUniqueValFieldMap.get(MethodUtil.getLevelOneKey((String)fieldKey))));
                    DataValidateServiceHelper.writeRowErrorLog(26, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), cellIndex, this.getCellName(cellIndex, billData.getMainEntityId()), putWhereKey);
                }
            }
        });
        this.getDataValidateParams().getImportStart().getMonitor().addExistsValidatorStat("checkBaseDataCtrlOrg", System.currentTimeMillis() - start, false);
    }

    private String[] getExtF7UniqueVal(String entityNum, String fieldNum) {
        Map<String, String> entityMap;
        Map<String, Map<String, String>> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (ObjectUtils.isNotEmpty(f7UniqueValMap) && ObjectUtils.isNotEmpty(entityMap = f7UniqueValMap.get(entityNum))) {
            return StringUtils.split((String)entityMap.get(fieldNum), (String)",");
        }
        return null;
    }

    private JSONObject addExtF7UniqueVal(JSONObject valueJson, JSONObject billJson, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        JSONObject clone = valueJson.clone();
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal) && ObjectUtils.isNotEmpty((Object)billJson)) {
            for (String ext : extF7UniqueVal) {
                if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap) && f7ExtUniqueValFieldMap.containsKey(ext)) {
                    String ext2 = f7ExtUniqueValFieldMap.get(ext);
                    clone.put(ext, billJson.get((Object)ext2));
                    continue;
                }
                clone.put(ext, billJson.get((Object)ext));
            }
        }
        return clone;
    }
}

