/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;

@ExcludeFromJacocoGeneratedReport
public final class FieldControlValidator
extends InnerValidateHandler {
    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable() || this.getDataValidateParams().isDeleteTemplate()) {
            return;
        }
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((entity, jsonValue) -> {
                Set<String> nonFieldPerm = this.getDataValidateParams().getNonFieldPermMap((String)entity);
                if (nonFieldPerm == null || nonFieldPerm.size() == 0) {
                    return;
                }
                if (jsonValue instanceof JSONArray) {
                    for (Object data : (JSONArray)jsonValue) {
                        this.getErrCollect((JSONObject)data, (Collection<String>)nonFieldPerm, billData, importLog, (String)entity);
                    }
                } else {
                    this.getErrCollect((JSONObject)jsonValue, (Collection<String>)nonFieldPerm, billData, importLog, (String)entity);
                }
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void getErrCollect(JSONObject rowJSON, Collection<String> nonFieldPerm, ImportBillData billData, ImportLog importLog, String entity) {
        nonFieldPerm.forEach(field -> {
            if (rowJSON.containsKey(field)) {
                String cellIndex = this.getCellIndex((String)field, entity);
                DataValidateServiceHelper.writeRowErrorLog(4, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowJSON.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entity));
            } else {
                rowJSON.values().stream().filter(value -> value instanceof JSONArray).forEach(ob -> ((JSONArray)ob).forEach(jsonOb -> {
                    if (((JSONObject)jsonOb).containsKey(field)) {
                        String cellIndex = this.getCellIndex((String)field, entity);
                        DataValidateServiceHelper.writeRowErrorLog(4, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), ((JSONObject)jsonOb).getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entity));
                    }
                }));
            }
        });
    }
}

