/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hr.impt.core.validate.util.ValidatorUtils;
import org.apache.commons.lang3.ObjectUtils;

public final class FormatValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(FormatValidator.class);
    private Set<Integer> failedRowIndex = new HashSet<Integer>();
    private ValidatorUtils validatorUtils = new ValidatorUtils();

    public Set<Integer> getFailedRowIndex() {
        return this.failedRowIndex;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable() || this.getDataValidateParams().isDeleteTemplate()) {
            return;
        }
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((mainEntityId, value) -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)mainEntityId);
                Map<String, String> marksMap = this.getDataValidateParams().getMarksMap((String)mainEntityId);
                if (value instanceof JSONArray) {
                    for (Object data : (JSONArray)value) {
                        this.iterateProp((String)mainEntityId, entityType.getProperties(), (JSONObject)data, billData, importLog, marksMap);
                    }
                } else {
                    this.iterateProp((String)mainEntityId, entityType.getProperties(), (JSONObject)value, billData, importLog, marksMap);
                }
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void iterateProp(String entityNumber, DataEntityPropertyCollection properties, JSONObject data, ImportBillData billData, ImportLog importLog, Map<String, String> marksMap) {
        ArrayList errorCollect = Lists.newArrayListWithCapacity((int)16);
        for (IDataEntityProperty property : properties) {
            String cellIndex;
            if (property instanceof EntryProp) {
                JSONArray entryDataCollection = data.getJSONArray(property.getName());
                if (entryDataCollection == null) continue;
                DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                entryDataCollection.forEach(entryData -> this.iterateProp(entityNumber, entryProperties, (JSONObject)entryData, billData, importLog, marksMap));
                continue;
            }
            Object value = data.get((Object)property.getName());
            if (Objects.isNull(value)) continue;
            if (this.getDataValidateParams().getNeedFormatTelFields(entityNumber).contains(property.getName())) {
                ValidatorUtils.checkTelFormat((String)value, errorCollect, this.getDataValidateParams().getCountryToAreaCode());
                if (errorCollect.size() <= 0) continue;
                cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(1, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, errorCollect.get(0));
                errorCollect.clear();
                continue;
            }
            if (this.getDataValidateParams().getNeedFormatEmailFields(entityNumber).contains(property.getName())) {
                ValidatorUtils.checkEmailFormat((String)value, errorCollect);
                if (errorCollect.size() <= 0) continue;
                cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(2, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), value);
                errorCollect.clear();
                continue;
            }
            this.validatorUtils.formatValidate(data, errorCollect, property, marksMap);
            if (errorCollect.size() > 0) {
                cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(3, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), value);
                List<String> uniqueKey = this.getDataValidateParams().getUniqueKeyFieldsMap().get(entityNumber);
                if (ObjectUtils.isNotEmpty(uniqueKey) && uniqueKey.contains(property.getName())) {
                    this.failedRowIndex.add(billData.getStartIndex());
                }
                errorCollect.clear();
            } else {
                this.checkFieldValueRange(entityNumber, data, billData, importLog, property, data.get((Object)property.getName()));
            }
            this.checkTextFieldLength(entityNumber, data, billData, importLog, property, value);
            this.checkMulComboField(entityNumber, importLog, billData, property, value);
        }
    }

    private void checkMulComboField(String entityNumber, ImportLog importLog, ImportBillData billData, IDataEntityProperty property, Object keyValue) {
        HashMap comboItems = new HashMap(16);
        if (property instanceof ComboProp) {
            HashMap<String, String> itmes = new HashMap<String, String>(16);
            comboItems.put(property.getName(), itmes);
            ComboProp temp = (ComboProp)property;
            for (ValueMapItem item : temp.getComboItems()) {
                itmes.put(item.getName().getLocaleValue(), item.getValue());
            }
            boolean isValidCombo = true;
            if (!comboItems.isEmpty() && comboItems.containsKey(property.getName())) {
                Map fieldVal = (Map)comboItems.get(property.getName());
                String comboVal = keyValue.toString();
                if (comboVal.contains("\uff0c")) {
                    isValidCombo = this.checkComboValue(fieldVal, comboVal, "\uff0c");
                } else if (comboVal.contains(",")) {
                    isValidCombo = this.checkComboValue(fieldVal, comboVal, ",");
                } else {
                    Object returnVal = fieldVal.get(keyValue);
                    if (ObjectUtils.isEmpty(returnVal)) {
                        isValidCombo = false;
                    }
                }
            }
            if (!isValidCombo) {
                String cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(22, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), cellIndex, this.getCellName(cellIndex, entityNumber), this.optimizeTipsValue(keyValue.toString()));
            }
        }
    }

    private boolean checkComboValue(Map<String, Object> fieldVal, String comboVal, String dot) {
        String[] split;
        for (String str : split = comboVal.split(dot)) {
            String val = (String)fieldVal.get(str);
            if (!Objects.isNull(val)) continue;
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkFieldValueRange(String entityNumber, JSONObject data, ImportBillData billData, ImportLog importLog, IDataEntityProperty property, Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        if (property instanceof DecimalProp) {
            if (!((DecimalProp)property).checkScope(value)) {
                String cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(25, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), this.optimizeTipsValue(value.toString()), ((DecimalProp)property).getDataScope());
                return;
            }
            if (value != null) {
                Pattern pattern;
                Matcher matcher;
                String valueTemp = String.valueOf(value);
                int integerPlaces = ((DecimalProp)property).getPrecision() - ((DecimalProp)property).getScale();
                int decimalPlaces = ((DecimalProp)property).getScale();
                if (integerPlaces == 0 && decimalPlaces == 0) {
                    return;
                }
                if (valueTemp.contains("E")) {
                    valueTemp = new BigDecimal(valueTemp).toPlainString();
                }
                if (!(matcher = (pattern = decimalPlaces > 0 ? Pattern.compile("^[-+]?([0-9]{1," + integerPlaces + "})[.]([0-9]{1," + decimalPlaces + "})$|^[-+]?[0-9]{1," + integerPlaces + "}$") : Pattern.compile("^[-+]?[0-9]{1," + integerPlaces + "}$")).matcher(valueTemp)).matches()) {
                    String cellIndex = this.getCellIndex(property.getName(), entityNumber);
                    DataValidateServiceHelper.writeRowErrorLog(28, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), this.optimizeTipsValue(value.toString()), integerPlaces, decimalPlaces);
                }
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkTextFieldLength(String entityNumber, JSONObject data, ImportBillData billData, ImportLog importLog, IDataEntityProperty property, Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        if (property.getName().endsWith("_tag") && ((TextProp)property).getMaxLenth() == 0 && ((TextProp)property).getMinLenth() == 0) {
            return;
        }
        if (property instanceof MuliLangTextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            int minLenth = ((TextProp)property).getMinLenth();
            data.getJSONObject(property.getName()).forEach((fieldKey, fieldValue) -> {
                if (Objects.isNull(fieldValue)) {
                    return;
                }
                if (fieldValue.toString().length() > maxLenth || fieldValue.toString().length() < minLenth) {
                    String cellIndex = this.getCellIndex(property.getName().concat(".").concat((String)fieldKey), entityNumber);
                    DataValidateServiceHelper.writeRowErrorLog(21, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), this.optimizeTipsValue(fieldValue.toString()), "[".concat(String.valueOf(minLenth)).concat(",").concat(String.valueOf(maxLenth)).concat("]"));
                }
            });
        } else if (property instanceof TextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            int minLenth = ((TextProp)property).getMinLenth();
            if (value.toString().length() > maxLenth || value.toString().length() < minLenth) {
                String cellIndex = this.getCellIndex(property.getName(), entityNumber);
                DataValidateServiceHelper.writeRowErrorLog(21, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), data.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNumber), this.optimizeTipsValue(value.toString()), "[".concat(String.valueOf(minLenth)).concat(",").concat(String.valueOf(maxLenth)).concat("]"));
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String optimizeTipsValue(String fieldValue) {
        if (fieldValue.length() > 30) {
            fieldValue = fieldValue.substring(0, 30).concat("...");
        }
        return fieldValue;
    }
}

