/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.ImportQueue;
import kd.hr.impt.core.init.ImportStart;
import org.apache.commons.lang3.StringUtils;

public class ValidateDataFlowSuggester {
    private static Log log = LogFactory.getLog(ValidateDataFlowSuggester.class);
    private ImportStart importStart;
    private ImportQueue<ImportBillData> outQueue;
    private int suggestThreads;
    private int workerMaxThread;

    public ValidateDataFlowSuggester(ImportStart importStart, int workerMaxThread, ImportQueue<ImportBillData> outQueue) {
        this.importStart = importStart;
        this.outQueue = outQueue;
        this.suggestThreads = MCConfigConstant.getWorkerMaxThread();
        this.workerMaxThread = workerMaxThread;
    }

    public int getSuggestThreads() {
        if (this.suggestThreads < 1) {
            this.suggestThreads = 1;
        }
        return this.suggestThreads;
    }

    public void runDataFlowSuggest() {
        if (this.outQueue.getQueue().size() >= MCConfigConstant.getQueueSize()) {
            if (this.suggestThreads >= 2) {
                this.suggestThreads = (int)((double)this.suggestThreads * 0.5);
            }
        } else {
            this.suggestThreads = ++this.suggestThreads;
            if (this.suggestThreads > this.workerMaxThread) {
                this.suggestThreads = this.workerMaxThread;
            }
        }
    }

    public static int getWorkerMaxThread(ImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int workerMaxThread = ValidateDataFlowSuggester.getConfigWorkerMaxThread(importStart);
        String entitytype = importContext.getTpl().getString("entitytype");
        Map<String, Integer> sheetRowCountMap = importContext.getSheetRowCountMap();
        int totaolRows = sheetRowCountMap.values().stream().mapToInt(c -> c).sum();
        if ("MESS".equals(entitytype)) {
            totaolRows *= importContext.getEntityIdToUniqueValMap().size();
        }
        if (importContext.isEnableSequenceInstore()) {
            workerMaxThread = 1;
        }
        importStart.getMonitor().getImportTrace().getOther().put(ValidateDataFlowSuggester.class.getSimpleName() + "_workerMaxThread", workerMaxThread);
        return workerMaxThread;
    }

    private static int getConfigWorkerMaxThread(ImportStart importStart) {
        int count = MCConfigConstant.getWorkerMaxThread();
        String cusValidateMaxThread = importStart.getImportContext().getCusValidateMaxThread();
        if (StringUtils.isNotEmpty((CharSequence)cusValidateMaxThread)) {
            switch (cusValidateMaxThread) {
                case "2": {
                    count = 2;
                    break;
                }
                case "3": {
                    count = 3;
                    break;
                }
            }
        }
        return count;
    }
}

