/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IBasedataField;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.orm.query.QFilter;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseDataWrapping {
    private final IBasedataField prop;
    private MainEntityType entityType;
    private String baseDataEntityNum;
    private boolean isBaseDataCtrl = false;
    private boolean isHRPersonProp = false;
    private boolean allowDisableData = false;
    private Set<Object> useOrgValue;
    private String useOrgFieldKey;
    private String useOrgEntityNum;
    private Map<Object, Map<String, Object>> whereMap = new HashMap<Object, Map<String, Object>>();
    private List<Map<String, Object>> sourceCondition = new LinkedList<Map<String, Object>>();
    private Set<String> selectFields;
    private QFilter basicQFilter;
    private String entryPropName;
    private String baseDataFormat = "number";
    private String[] extF7UniqueVal;
    private String appId;
    private String mainFormId;

    public BaseDataWrapping(IBasedataField prop, Set<String> selectFields, String baseDataFormat) {
        this.prop = prop;
        if (prop instanceof IQueryProp) {
            this.isHRPersonProp = true;
        }
        this.selectFields = selectFields;
        if (StringUtils.isNotEmpty((CharSequence)baseDataFormat)) {
            this.baseDataFormat = baseDataFormat;
        }
    }

    public void putWhere(Object key, JSONObject jsonObject) {
        this.whereMap.put(key, (Map<String, Object>)JSON.parseObject((String)jsonObject.toJSONString(), Map.class));
    }

    public IBasedataField getProp() {
        return this.prop;
    }

    public Map<Object, Map<String, Object>> getWhereMap() {
        return this.whereMap;
    }

    public Set<String> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(Set<String> selectFields) {
        this.selectFields = selectFields;
    }

    public String getBaseDataEntityNum() {
        return this.baseDataEntityNum;
    }

    public void setBaseDataEntityNum(String baseDataEntityNum) {
        this.baseDataEntityNum = baseDataEntityNum;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isBaseDataCtrl() {
        return this.isBaseDataCtrl;
    }

    public void setBaseDataCtrl(boolean baseDataCtrl) {
        this.isBaseDataCtrl = baseDataCtrl;
    }

    public Set<Object> getUseOrgValue() {
        return this.useOrgValue;
    }

    public void setUseOrgValue(Object useOrgValue) {
        if (this.useOrgValue == null) {
            this.useOrgValue = new HashSet<Object>();
        }
        if (useOrgValue != null && StringUtils.isNotBlank((CharSequence)String.valueOf(useOrgValue))) {
            this.useOrgValue.add(useOrgValue);
        }
    }

    public String getUseOrgEntityNum() {
        return this.useOrgEntityNum;
    }

    public void setUseOrgEntityNum(String useOrgEntityNum) {
        this.useOrgEntityNum = useOrgEntityNum;
    }

    public boolean isAllowDisableData() {
        return this.allowDisableData;
    }

    public void setAllowDisableData(boolean allowDisableData) {
        this.allowDisableData = allowDisableData;
    }

    public String[] getExtF7UniqueVal() {
        return this.extF7UniqueVal;
    }

    public void setExtF7UniqueVal(String[] extF7UniqueVal) {
        this.extF7UniqueVal = extF7UniqueVal;
    }

    public QFilter[] getQFiltrs(BaseDataContainer baseDataContainer) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = this.getBasicQFilter(baseDataContainer);
        if (qFilter == null) {
            return null;
        }
        qFilters.add(qFilter);
        List<QFilter> defaultQFilter = ImportServiceHelper.getDefaultQFilter(this.entityType.getName(), (IDataEntityProperty)this.prop, this.prop.getBaseEntityId(), this.allowDisableData);
        if (defaultQFilter.size() > 0) {
            qFilters.addAll(defaultQFilter);
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private QFilter buildBasicQFilter(BaseDataContainer baseDataContainer) {
        QFilter qFilter = null;
        LinkedList list = Lists.newLinkedList();
        String singleKey = "";
        for (Map.Entry<Object, Map<String, Object>> entry : this.whereMap.entrySet()) {
            QFilter qFilterTemp = null;
            if (!ObjectUtils.isEmpty(baseDataContainer.getBaseDataDy(this.entityType.getName(), this.getBaseDataEntityNum(), this.getProp().getName(), entry.getKey()))) continue;
            for (Map.Entry<String, Object> entryTemp : entry.getValue().entrySet()) {
                String key = entryTemp.getKey();
                if (key.startsWith("$")) continue;
                key = this.getHRControlQueryKey(key);
                Object val = entryTemp.getValue();
                if (entry.getKey() instanceof Long) {
                    val = Long.parseLong((String)entryTemp.getValue());
                }
                if (ObjectUtils.isEmpty((Object)this.extF7UniqueVal) && (this.baseDataFormat.equals("number") || this.baseDataFormat.equals("name") || this.baseDataFormat.equals("id"))) {
                    singleKey = key;
                    list.add(val);
                    continue;
                }
                if (qFilterTemp == null) {
                    qFilterTemp = new QFilter(key, "=", val);
                    continue;
                }
                qFilterTemp.and(new QFilter(key, "=", val));
            }
            qFilter = qFilter == null ? qFilterTemp : qFilter.or(qFilterTemp);
        }
        if (ObjectUtils.isNotEmpty((Object)list)) {
            qFilter = new QFilter(singleKey, "in", (Object)list);
        }
        return qFilter;
    }

    public String getHRControlQueryKey(String key) {
        String baseEntityId;
        if (this.prop instanceof IQueryProp && ("hrpi_depempf7query".equals(baseEntityId = this.prop.getBaseEntityId()) || "hrpi_employeef7query".equals(baseEntityId)) && !key.equalsIgnoreCase("id")) {
            key = "person." + key;
        }
        return key;
    }

    public QFilter getBDRefPermQFilters() {
        String bizAppId;
        String filed = this.prop.getName();
        String currentEntityId = this.entityType.getName();
        QFilter result = DataValidateServiceHelper.getDataRuleForBdProp(currentEntityId, bizAppId = DataValidateServiceHelper.getPermAppIdPkid(this.appId, currentEntityId, currentEntityId.equals(this.mainFormId)), filed, "47150e89000000ac");
        if (result != null) {
            this.selectFields.add(result.getProperty());
            result.getNests(true).forEach(ob -> this.selectFields.add(ob.getFilter().getProperty()));
        }
        return result;
    }

    public QFilter getBasicQFilter(BaseDataContainer baseDataContainer) {
        if (this.basicQFilter == null) {
            this.basicQFilter = this.buildBasicQFilter(baseDataContainer);
        }
        return this.basicQFilter;
    }

    public void setBasicQFilter(QFilter basicQFilter) {
        this.basicQFilter = basicQFilter;
    }

    public String getEntryPropName() {
        return this.entryPropName;
    }

    public void setEntryPropName(String entryPropName) {
        this.entryPropName = entryPropName;
    }

    public List<Map<String, Object>> getSourceCondition() {
        return this.sourceCondition;
    }

    public boolean isHRPersonProp() {
        return this.isHRPersonProp;
    }

    public String getUseOrgFieldKey() {
        return this.useOrgFieldKey;
    }

    public void setUseOrgFieldKey(String useOrgFieldKey) {
        this.useOrgFieldKey = useOrgFieldKey;
    }

    public String getBaseDataFormat() {
        return this.baseDataFormat;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMainFormId() {
        return this.mainFormId;
    }

    public void setMainFormId(String mainFormId) {
        this.mainFormId = mainFormId;
    }
}

