/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import org.apache.commons.lang3.StringUtils;

public class DataValidateServiceHelper {
    private static Log log = LogFactory.getLog(DataValidateServiceHelper.class);

    public static String getPermissionStatus(String importType) {
        switch (importType) {
            case "update": {
                return "4715a0df000000ac";
            }
            case "delete": {
                return "4715e1f1000000ac";
            }
        }
        return "47156aff000000ac";
    }

    public static BOSExpression getDataRuleScript(String permissionStatus, String entityFormId, String appId) {
        return new BOSExpression((String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"PermissionService", (String)"getDataRuleScript", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId, permissionStatus, Maps.newHashMap()}));
    }

    public static QFilter getDataRuleForBdProp(String entityFormId, String appId, String propKey, String permItemId) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId, propKey, permItemId, null});
    }

    public static QFilter getBaseDataQFilter(String baseDataEntityNumber, Long useOrgId) {
        return (QFilter)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IBaseDataService", (String)"getBaseDataFilter", (Object[])new Object[]{baseDataEntityNumber, useOrgId});
    }

    public static QFilter getBaseDataQFilter(String baseDataEntityNumber, List<Long> orgID, boolean isRemoveDup) {
        return (QFilter)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IBaseDataService", (String)"getBaseDataFilter", (Object[])new Object[]{baseDataEntityNumber, orgID, isRemoveDup});
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<String> getFieldControlRules(String appId, String entityFormId) {
        FieldControlRules fieldControlRules = (FieldControlRules)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"PermissionService", (String)"getFieldControlRules", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId});
        if (fieldControlRules != null && fieldControlRules.getFieldControlRuleDtos().size() > 0) {
            List fieldControlRuleDtos = fieldControlRules.getFieldControlRuleDtos();
            HashSet nonFieldPermSet = Sets.newHashSetWithExpectedSize((int)fieldControlRuleDtos.size());
            fieldControlRuleDtos.forEach(fieldControlRuleDto -> {
                FieldControlRule fieldControlRule = fieldControlRuleDto.getFieldControlRule();
                nonFieldPermSet.addAll(fieldControlRule.getCanNotReadFields());
                nonFieldPermSet.addAll(fieldControlRule.getCanNotWriteFields());
            });
            return nonFieldPermSet;
        }
        return null;
    }

    public static void writeRowErrorLog(int type, ImportLog importLog, String sheetName, int startIndex, int endIndex, int errorIndex, Object ... params) {
        if (errorIndex == 0) {
            errorIndex = startIndex;
        }
        String errorInfo = "";
        switch (type) {
            case 0: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u5fc5\u5f55\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6570\u636e\uff0c\u8bf7\u7ef4\u62a4\u6570\u636e\u540e\u4e0a\u4f20\u3002", (String)"DataValidateServiceHelper_0", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 1: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\uff0c%2$s\u3002", (String)"DataValidateServiceHelper_1", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 2: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u90ae\u7bb1\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"DataValidateServiceHelper_2", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 3: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"DataValidateServiceHelper_3", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 4: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7684\u5bfc\u5165\u6743\u9650\u3002\u5982\u9700\u7ee7\u7eed\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_4", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 5: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u672a\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_5", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 6: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_6", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 7: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7684\u201c%3$s\u201d\u6570\u636e\u7ef4\u62a4\u6743\u9650\u3002\u5982\u9700\u7ee7\u7eed\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_7", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 8: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_8", (String)"hrmp-hies-import", (Object[])new Object[0]);
                break;
            }
            case 9: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
                break;
            }
            case 10: {
                errorInfo = ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u5220\u9664\u8be5\u884c\u6570\u636e\u3002\u5982\u9700\u7ee7\u7eed\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_10", (String)"hrmp-hies-import", (Object[])new Object[0]);
                break;
            }
            case 11: {
                errorInfo = ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u5bfc\u5165\u8be5\u884c\u6570\u636e\u3002\u5982\u9700\u7ee7\u7eed\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_11", (String)"hrmp-hies-import", (Object[])new Object[0]);
                break;
            }
            case 12: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u5f00\u59cb\u65e5\u671f\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_12", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 13: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u7ed3\u675f\u65e5\u671f\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_13", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 14: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7b2c%2$s\u5217\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_14", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 15: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u5f00\u59cb\u65f6\u95f4\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_15", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 16: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u7ed3\u675f\u65f6\u95f4\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_16", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 17: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b2c%2$s\u5217\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_17", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 18: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_18", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 19: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_19", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 20: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5206\u5f55\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_20", (String)"hrmp-hies-import", (Object[])new Object[0]);
                break;
            }
            case 21: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u8fc7\u9650\u5b9a\u8303\u56f4%4$s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_21", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 22: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_22", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 23: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u503c\u3002", (String)"DataValidateServiceHelper_23", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 24: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7684\u201c%3$s\u201d\u7ef4\u62a4\u6743\u9650\u3002\u5982\u9700\u7ee7\u7eed\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_24", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 25: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u8d85\u51fa\u6570\u503c\u8303\u56f4%4$s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_25", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 26: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_26", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 27: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u914d\u7f6e\u201c%1$s\u201d\u5b57\u6bb5\u7684\u9ed8\u8ba4\u503c\u4e3a\u201c%2$s\u201d\uff0c\u8be5\u503c\u4e0d\u5728\u4f60\u7684\u5bfc\u5165\u6743\u9650\u8303\u56f4\u5185\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"DataValidateServiceHelper_27", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 28: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u7ef4\u62a4\u7684\u201c%3$s\u201d\u8d85\u51fa\u4e86\u7cfb\u7edf\u89c4\u5b9a\u7684\u7cbe\u5ea6\u8303\u56f4\uff1a\u6574\u6570%4$s\u4f4d\uff0c\u5c0f\u6570%5$s\u4f4d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_28", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 29: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u4e0a\u7ea7\u5185\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_29", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 30: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7f3a\u5c11\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u6570\u636e\u518d\u4e0a\u4f20\u3002", (String)"DataValidateServiceHelper_30", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 31: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5206\u5f55\u5185\u7801\u201c%1$s\u201d\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_31", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 32: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5206\u5f55\u5185\u7801\u201c%1$s\u201d\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_32", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 33: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bfc\u5165\u6682\u5b58\u3001\u5df2\u5ba1\u6838/\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"DataValidateServiceHelper_33", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 34: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u66f4\u65b0\u7cfb\u7edf\u4e2d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u6001\u7684\u5355\u636e\u3002", (String)"DataValidateServiceHelper_34", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
            case 35: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4ec5\u652f\u6301\u66f4\u65b0\u4e3a\uff1a\u6682\u5b58\u3001\u5df2\u5ba1\u6838/\u5ba1\u6279\u901a\u8fc7\u3002", (String)"DataValidateServiceHelper_35", (String)"hrmp-hies-import", (Object[])new Object[0]), params);
                break;
            }
        }
        importLog.writeRowLog(sheetName, startIndex, endIndex, errorIndex, errorInfo);
    }

    public static QFilter getDataRule(String entityNumber, String permItemId, Map<String, Object> customParam) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), DataValidateServiceHelper.getBizAppIdPkid(entityNumber), entityNumber, permItemId, customParam});
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter getPermMainBUQFilter(String entityNumber) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (StringUtils.isBlank((CharSequence)entityType.getMainOrg())) {
            return null;
        }
        String appId = DataValidateServiceHelper.getBizAppIdPkid(entityNumber);
        String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)entityNumber);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityNumber, (String)"47150e89000000ac");
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return new QFilter(entityType.getMainOrg(), "in", (Object)result.getHasPermOrgs());
    }

    public static String getPermAppIdPkid(String viewAppId, String entityNumber, boolean isMainEntity) {
        if (isMainEntity && StringUtils.isNotEmpty((CharSequence)viewAppId)) {
            return AppMetadataCache.getAppInfo((String)viewAppId).getId();
        }
        return DataValidateServiceHelper.getBizAppIdPkid(entityNumber);
    }

    private static String getBizAppIdPkid(String entityNumber) {
        DynamicObject appObj;
        String masterId;
        QFilter[] filterArray;
        DynamicObject formDynamic;
        String bizAppIdStr = "";
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        PermissionDimension permissionDimension = entityMetadata.getRootEntity().getPermissionDimension();
        if (Objects.nonNull(permissionDimension) && HRStringUtils.isNotEmpty((String)permissionDimension.getPublishApps())) {
            String appString = permissionDimension.getPublishApps().replace("[", "").replace("]", "").replace("\"", "");
            bizAppIdStr = appString.split(",")[0];
        }
        if (HRStringUtils.isEmpty((String)bizAppIdStr) && Objects.nonNull(formDynamic = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])(filterArray = new QFilter[]{new QFilter("number", "=", (Object)entityNumber)})))) {
            String formId = formDynamic.getString("id");
            bizAppIdStr = formDynamic.getString("bizappid");
            if (HRStringUtils.isEmpty((String)bizAppIdStr)) {
                bizAppIdStr = DataValidateServiceHelper.getAppIdByFormId(formId);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(masterId = (appObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"type,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizAppIdStr)})).getString("masterid")))) {
            bizAppIdStr = masterId;
        }
        return bizAppIdStr;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getDataDimensionField(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        PermissionDimension permissionDimension = entityMetadata.getRootEntity().getPermissionDimension();
        if (Objects.nonNull(permissionDimension)) {
            return permissionDimension.getDataDimensionField();
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])filters);
        return unitRelForm.getString("bizapp");
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter getF7BdQFilter(String entityId, String appId, IDataEntityProperty field, HasPermOrgResult hasPermOrg, Map<String, Object> bdMainProp) {
        QFilter dataInitQFilter;
        String baseEntityId;
        boolean hasHis;
        QFilter filter = new QFilter("1", "=", (Object)1);
        String enableProp = bdMainProp.getOrDefault("enable", null);
        String statusProp = (String)bdMainProp.get("status");
        if (StringUtils.isNotEmpty((CharSequence)enableProp)) {
            filter = new QFilter(enableProp, "=", (Object)"1");
            IBasedataField basedataField = (IBasedataField)field;
            if (!basedataField.isShowUsed()) {
                filter.or(new QFilter(enableProp, "=", (Object)"0"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)statusProp)) {
            filter.and(new QFilter(statusProp, "=", (Object)"C"));
        }
        if (hasHis = ImportServiceHelper.hasHis(baseEntityId = ((IBasedataField)field).getComplexType().getName())) {
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        if ((dataInitQFilter = MethodUtil.getDataInitQFilter((String)baseEntityId)) != null) {
            filter.and(dataInitQFilter);
        }
        List<Long> entityHasPermOrgIds = hasPermOrg.getHasPermOrgs();
        if (hasPermOrg.hasAllOrgPerm()) {
            entityHasPermOrgIds = ImportServiceHelper.getEntityHasPermOrgId(entityId);
        }
        String dataDimensionField = DataValidateServiceHelper.getDataDimensionField(entityId);
        if (field instanceof MainOrgProp || field.getName().equals(dataDimensionField)) {
            log.info("getF7BdQFilter_MainOrgProp_baseEntityId:{},field:{},dataDimensionField:{}", new Object[]{baseEntityId, field.getName(), dataDimensionField});
            QFilter mainOrgQfilter = ImportServiceHelper.getMainOrgQfilter(entityHasPermOrgIds);
            filter.and(mainOrgQfilter);
        } else {
            log.info("getF7BdQFilter_getDataRuleForBdPropp_baseEntityId:{}", (Object)baseEntityId);
            QFilter bdPermQfilter = ImportServiceHelper.getDataRuleForBdProp(entityId, appId, "47150e89000000ac", field);
            if (bdPermQfilter != null) {
                filter.and(bdPermQfilter);
            }
        }
        if (BaseDataServiceHelper.checkBaseDataCtrl((String)baseEntityId).booleanValue()) {
            log.info("getF7BdQFilter_checkBaseDataCtrl_baseEntityId:{}", (Object)baseEntityId);
            QFilter orgFilter = DataValidateServiceHelper.getF7UseOrgCtrl(entityId, appId, baseEntityId, field);
            if (orgFilter != null) {
                filter.and(orgFilter);
            }
        }
        MethodUtil.printQfilters((QFilter[])new QFilter[]{filter}, (String)("getF7BdQFilter_" + baseEntityId + "_filter"));
        return filter;
    }

    private static QFilter getF7UseOrgCtrl(String entityId, String appId, String baseEntityId, IDataEntityProperty field) {
        String useOrgFieldKey = ((IBasedataField)field).getOrgProp();
        if (StringUtils.isBlank((CharSequence)useOrgFieldKey)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            useOrgFieldKey = entityType.getMainOrg();
        }
        if (StringUtils.isEmpty((CharSequence)useOrgFieldKey) || field.getName().equals(useOrgFieldKey)) {
            return null;
        }
        QFilter dataRuleForBdProp = DataValidateServiceHelper.getDataRuleForBdProp(entityId, appId, useOrgFieldKey, "47150e89000000ac");
        if (dataRuleForBdProp != null) {
            DataSet dataSet = new HRBaseServiceHelper("bos_org").queryDataSet("DataValidateServiceHelper.getF7UseOrgCtrl", "id", new QFilter[]{dataRuleForBdProp});
            LinkedList<Long> orgID = new LinkedList<Long>();
            while (dataSet.hasNext()) {
                orgID.add(dataSet.next().getLong(0));
            }
            dataSet.close();
            QFilter qFilter = DataValidateServiceHelper.getBaseDataQFilter(baseEntityId, orgID, true);
            MethodUtil.printQfilters((QFilter[])new QFilter[]{qFilter}, (String)("getF7UseOrgCtrl_" + baseEntityId + "_filter"));
            return qFilter;
        }
        return null;
    }

    public static void containsKey(Set<String> vars, Map<String, Object> varValues, Map.Entry<String, Object> entry) {
        vars.forEach(tempKey -> {
            if (tempKey.equalsIgnoreCase((String)entry.getKey())) {
                varValues.put((String)tempKey, entry.getValue());
            } else if (tempKey.contains(".") && tempKey.split("\\.", 2)[0].equalsIgnoreCase((String)entry.getKey())) {
                varValues.put((String)tempKey, ((JSONObject)entry.getValue()).get((Object)tempKey.split("\\.", 2)[1]));
            }
        });
    }

    public static String getFieldKey(String fieldKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName) {
        if (!"number_name".equalsIgnoreCase(baseDataFormat)) {
            Object val = bdFieldMainPropName.get(baseDataFormat);
            String keytmp = val instanceof PKFieldProp ? "id" : (String)val;
            fieldKey = fieldKey.concat(".").concat(keytmp);
        }
        return fieldKey;
    }

    public static void dealBillstatusJudge(List<ImportBillData> billDataList, ImportContext importContext, DynamicObject currentBill) {
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)6);
        importContext.getEntityIdToUniqueValMap().forEach((key, value) -> {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)key);
            if (dataEntityType instanceof BillEntityType && !(dataEntityType instanceof BasedataEntityType)) {
                billMap.put(key, true);
            }
        });
        String billStatus = null;
        if (currentBill != null && currentBill.containsProperty("billstatus")) {
            billStatus = currentBill.getString("billstatus");
        }
        String finalBillStatus = billStatus;
        billDataList.forEach(billData -> {
            for (Map.Entry next : billData.getData().entrySet()) {
                if (!billMap.containsKey(next.getKey())) continue;
                Map comboValueKey = MethodUtil.getComboValueKey((String)((String)next.getKey()), (String)"billstatus");
                if (next.getValue() instanceof JSONObject) {
                    JSONObject object = (JSONObject)next.getValue();
                    Integer startIndex = billData.getStartIndex();
                    Integer endIndex = billData.getEndIndex();
                    if ("new".equals(billData.getOpType())) {
                        DataValidateServiceHelper.newBillstatusJudge((String)next.getKey(), object, startIndex, endIndex, comboValueKey, importContext);
                        continue;
                    }
                    if (!"update".equals(billData.getOpType()) || finalBillStatus == null) continue;
                    DataValidateServiceHelper.updateBillstatusJudge((String)next.getKey(), object, finalBillStatus, startIndex, endIndex, comboValueKey, importContext);
                    continue;
                }
                if (!(next.getValue() instanceof JSONArray)) continue;
                JSONArray sour = (JSONArray)next.getValue();
                for (Object so : sour) {
                    JSONObject object = (JSONObject)so;
                    Integer startIndex = (Integer)object.get((Object)"$startIndex");
                    Integer endIndex = (Integer)object.get((Object)"$endIndex");
                    if ("new".equals(object.get((Object)"$opType"))) {
                        DataValidateServiceHelper.newBillstatusJudge((String)next.getKey(), object, startIndex, endIndex, comboValueKey, importContext);
                        continue;
                    }
                    if (!"update".equals(billData.getOpType()) || finalBillStatus == null) continue;
                    DataValidateServiceHelper.updateBillstatusJudge((String)next.getKey(), object, finalBillStatus, startIndex, endIndex, comboValueKey, importContext);
                }
            }
        });
    }

    private static void newBillstatusJudge(String entityName, JSONObject object, Integer startIndex, Integer endIndex, Map<String, String> comboValueKey, ImportContext importContext) {
        String val;
        String billstatus = object.getString("billstatus");
        ImportLog importLog = importContext.getImportLog();
        Map entitySheetNameMap = MethodUtil.reversalMap(importContext.getSheetEntityMap());
        if (StringUtils.isNotEmpty((CharSequence)billstatus) && !"A".equals(val = comboValueKey.get(billstatus)) && !"C".equals(val)) {
            DataValidateServiceHelper.writeRowErrorLog(33, importLog, (String)entitySheetNameMap.get(entityName), startIndex, endIndex, startIndex, new Object[0]);
        }
    }

    private static void updateBillstatusJudge(String entityName, JSONObject object, String billStatus, Integer startIndex, Integer endIndex, Map<String, String> comboValueKey, ImportContext importContext) {
        ImportLog importLog = importContext.getImportLog();
        Map entitySheetNameMap = MethodUtil.reversalMap(importContext.getSheetEntityMap());
        if ("A".equals(billStatus)) {
            String val;
            String billstatus = object.getString("billstatus");
            if (StringUtils.isNotEmpty((CharSequence)billstatus) && !"A".equals(val = comboValueKey.get(billstatus)) && !"C".equals(val)) {
                DataValidateServiceHelper.writeRowErrorLog(35, importLog, (String)entitySheetNameMap.get(entityName), startIndex, endIndex, startIndex, new Object[0]);
            }
        } else {
            DataValidateServiceHelper.writeRowErrorLog(34, importLog, (String)entitySheetNameMap.get(entityName), startIndex, endIndex, startIndex, new Object[0]);
        }
    }
}

