/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.templateConf.TemplateConfService;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.common.plugin.UserImportPluginUtil;
import kd.hr.impt.core.parse.ExcelReader;
import kd.hr.impt.core.parse.SheetHandler;
import kd.hr.impt.core.validate.TemplateValidator;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TemplateUtils {
    private static final Log LOGGER = LogFactory.getLog(TemplateUtils.class);

    public static Map<String, Object> checkTemplate(String localPath, String pageMainEntityNum, final String importPlugin, final String extParam) throws Exception {
        File file = new File(localPath);
        final int[] totalRow = new int[]{0};
        final HashMap sheetRowCountMap = Maps.newHashMapWithExpectedSize((int)3);
        final HashMap sheetEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        LinkedMultiValueMap templateValidater = new LinkedMultiValueMap();
        final ArrayList effectSheetNamesSetTemp = new ArrayList(6);
        final String[] templateNumber = new String[]{""};
        final String[] firstSheetName = new String[]{""};
        final DynamicObject[] tplDys = new DynamicObject[]{null};
        final List[] templatePlugins = new List[]{new LinkedList()};
        try {
            SheetHandler sheetHandler = new SheetHandler((MultiValueMap)templateValidater){
                private Pattern UpperCacePattern = Pattern.compile("[A-Z]");
                private Pattern IntPattern = Pattern.compile("[0-9]");
                private int colCount = 0;
                private int onlyParserCount = 16;
                final /* synthetic */ MultiValueMap val$templateValidater;
                {
                    this.val$templateValidater = multiValueMap;
                }

                @Override
                protected boolean isSkipEmptyRow() {
                    return false;
                }

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    int curRowNum = this.getRowHolder().getRowNum();
                    if (curRowNum >= this.onlyParserCount) {
                        if (StringUtils.isEmpty((CharSequence)firstSheetName[0])) {
                            firstSheetName[0] = this.getCurrentSheetName();
                        }
                        throw new KDBizException(new ErrorCode("908", "sheet_parse_terminal."), new Object[0]);
                    }
                    super.startElement(uri, localName, name, attributes);
                    if ("dimension".equals(name)) {
                        String refdata = attributes.getValue("ref");
                        String rowCountStr = refdata.substring(refdata.indexOf(":") + 1).toUpperCase();
                        int sheetCountRow = Integer.parseInt(this.UpperCacePattern.matcher(rowCountStr).replaceAll(""));
                        sheetRowCountMap.put(this.getCurrentSheetName(), sheetCountRow - 5);
                        totalRow[0] = totalRow[0] + sheetCountRow;
                        this.colCount = HIESUtil.excelNum2Digit((String)this.IntPattern.matcher(rowCountStr).replaceAll(""));
                    }
                }

                @Override
                public void handleRow(SheetHandler.ParsedRow row) {
                    String currentSheetName = this.getCurrentSheetName();
                    int currRowNum = row.getRowNum();
                    if (!currentSheetName.equalsIgnoreCase(firstSheetName[0]) && tplDys[0] != null) {
                        ++currRowNum;
                    }
                    if (currRowNum == 0) {
                        templateNumber[0] = HIESUtil.getSplitValue(row.getData());
                        if (tplDys[0] == null) {
                            DynamicObject[] byNumber = TemplateConfService.getTplByNumber(templateNumber[0]);
                            if (byNumber != null && byNumber.length > 1) {
                                throw new KDBizException(new ErrorCode("999", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u4e2d\u6a21\u677f\u7f16\u7801\u201c%1$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\u65e0\u6cd5\u5bfc\u5165,\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e\u3002", (String)"TemplateUtils_0", (String)"hrmp-hies-import", (Object[])new Object[0]), templateNumber[0])), new Object[0]);
                            }
                            if (byNumber != null && byNumber.length == 1) {
                                tplDys[0] = byNumber[0];
                                firstSheetName[0] = currentSheetName;
                                templatePlugins[0] = TemplateUtils.loadUserPlugin(tplDys[0], importPlugin, extParam);
                            } else {
                                firstSheetName[0] = "";
                            }
                        }
                    } else if (currRowNum < this.onlyParserCount && currRowNum > 0) {
                        if (tplDys[0] == null) {
                            return;
                        }
                        if (currRowNum == 1) {
                            boolean emptyColum = StringUtils.isEmpty((CharSequence)HIESUtil.getSplitValue((String)row.get(0)));
                            String numberRow = emptyColum ? row.get(1) : row.get(0);
                            String entityName = HIESUtil.getSplitValue((String)numberRow);
                            try {
                                MetadataServiceHelper.getDataEntityType((String)entityName);
                                effectSheetNamesSetTemp.add(currentSheetName);
                            }
                            catch (Throwable e) {
                                LOGGER.warn(e.getMessage());
                            }
                            String entityNames = (String)sheetEntityMap.get(currentSheetName);
                            if (StringUtils.isBlank((CharSequence)entityNames)) {
                                sheetEntityMap.put(currentSheetName, entityName);
                            } else {
                                sheetEntityMap.put(currentSheetName, entityNames + ',' + entityName);
                            }
                        }
                        if (!effectSheetNamesSetTemp.contains(currentSheetName)) {
                            return;
                        }
                        this.val$templateValidater.add((Object)currentSheetName, row.getData());
                        if (currRowNum == 5) {
                            HashMap<Integer, String> map = new HashMap<Integer, String>();
                            map.put(0, String.valueOf(this.colCount));
                            this.val$templateValidater.add((Object)currentSheetName, map);
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String name) throws SAXException {
                    if (this.getRowHolder().getRowNum() < this.onlyParserCount) {
                        super.endElement(uri, localName, name);
                    }
                }
            };
            new ExcelReader(null).read(file, sheetHandler);
        }
        catch (Throwable throwable) {
            LOGGER.error("TemplateUtils_checkTemplate", throwable);
            if (throwable instanceof OLE2NotOfficeXmlFileException) {
                throw new KDBizException(new ErrorCode("909", ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0a\u4f20\u53ef\u80fd\u88ab\u52a0\u5bc6\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateUtils_2", (String)"hrmp-hies-import", (Object[])new Object[0])), new Object[0]);
            }
            throw throwable;
        }
        finally {
            try {
                ImportFileUtil.deleteLocalTempFile((String)localPath);
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (tplDys[0] != null) {
            boolean needRelationInStore = HIESUtil.needRelationInStoreForMEMS((DynamicObject)tplDys[0]);
            String importtype = tplDys[0].getString("importtype");
            map.put("needRelationInStore", String.valueOf(needRelationInStore));
            map.put("sheetEntityMap", JSONObject.toJSONString((Object)sheetEntityMap));
            map.put("sheetRowCountMap", JSONObject.toJSONString((Object)sheetRowCountMap));
            map.put("effectSheetNames", JSONObject.toJSONString(effectSheetNamesSetTemp));
            map.put("totalrow", totalRow[0] - 5);
            map.put("tplpkid", tplDys[0].getString("id"));
            map.put("optype", importtype);
            map.put("optypeText", TemplateUtils.getImporTtypeText(tplDys[0], importtype));
        }
        TemplateValidator validator = new TemplateValidator(firstSheetName[0], templateNumber[0], templatePlugins[0], extParam, tplDys[0], pageMainEntityNum);
        String msg = validator.validate((MultiValueMap<String, Map<Integer, String>>)templateValidater, tplDys[0]);
        map.put("msg", msg);
        return map;
    }

    private static List<HRImportPlugin> loadUserPlugin(DynamicObject tpl, String importPlugin, String extparam) {
        if (tpl == null) {
            return null;
        }
        String templatePlugins = tpl.getString("plugin");
        List tplAllEntitys = MethodUtil.getTplAllEntitys((DynamicObject)tpl);
        List<HRImportPlugin> hrImportPlugin = UserImportPluginUtil.getHRImportPlugin(importPlugin, templatePlugins, null, extparam, null, tplAllEntitys);
        return hrImportPlugin;
    }

    private static String getImporTtypeText(DynamicObject tpl, String val) {
        DynamicProperty prop = tpl.getDynamicObjectType().getProperty("importtype");
        ComboProp temp = (ComboProp)prop;
        String name = "";
        for (ValueMapItem item : temp.getComboItems()) {
            if (!item.getValue().equals(val)) continue;
            name = item.getName().getLocaleValue();
            break;
        }
        return name;
    }
}

