/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.NetAddressUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportTaskClick;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.BeforeShowTemplateSelectListEventArgs;
import kd.hr.impt.mservice.api.IImportService;
import kd.hr.impt.mservice.api.ITemplateService;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class HRImportStartPlugin
extends HRDataBaseEdit
implements UploadListener,
ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(HRImportStartPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String PROGRESSBARAPVALI = "progressbarapvali";
    private static final String FILE_SERVER_URL = "serverUrl";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CONCURRENT = "concurrent";
    private static final String CHECK_TEMPLATE_CALLBACK = "checkTemplate_callBack";
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String BACK_RUN = "backRun";
    private static final String INIT = "init";
    private static final String UPLOAD = "upload";
    private static final String SELECT_MODLE = "selectModle";
    private static final String VALIDATE = "validate";
    private static final String VALIDATE_FAILED = "validateFailed";
    private static final String INSTORE = "instore";
    private static final String FINISHED = "finished";
    private static final String TERMINATOR = "terminator";
    private static final String NO_FAIL_BILL = "noFailBill";
    private static final String NO_SUCCESS_BILL = "noSuccessBill";
    private static final String NO_SUCCESS_AND_FAIL_BILL = "noSuccessAndFailBill";
    private static final String ENABLE_SELECT_MODEL_VIEW = "enableSelectModelView";
    private static final String ENABLE_SELECT_MODEL_ITEM = "enableSelectModelItem";
    private boolean canClosePage = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndowntpl", "lblviewhis", "btnupstep", "btndownstep", "btnstart", "btnstop", "btnbackground", "btndownerror", "btndownall", "btnreupload", "lblfilename1", "lblfilename3", "lblfilename4", "lblfilename5", "lblfilename6", "lblfilename7"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
        ProgressBar barvali = (ProgressBar)this.getView().getControl(PROGRESSBARAPVALI);
        barvali.addProgressListener((ProgresssListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay(INIT);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("formId", this.getEntityNumber());
        params.put("importPlugin", showParameter.getCustomParam("importPlugin"));
        params.put("extParam", this.getModel().getValue("extparam"));
        params.put("pageId", showParameter.getCustomParam("pageId"));
        long start = System.currentTimeMillis();
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)ITemplateService.class.getSimpleName(), (String)"afterLoadStartPageEvent", (Object[])new Object[]{params});
        LOGGER.info("invokeService_afterLoadStartPageEvent expense:{}", (Object)(System.currentTimeMillis() - start));
        if (result.isSuccess()) {
            AfterLoadStartPageEventArgs args = (AfterLoadStartPageEventArgs)((Object)result.getData());
            this.getModel().setValue("extparam", (Object)args.getExtParams());
            this.getPageCache().put("formId", args.getFormId());
            this.getPageCache().put(ENABLE_SELECT_MODEL_VIEW, String.valueOf(args.isEnableSelectModelView()));
            this.getPageCache().put(ENABLE_SELECT_MODEL_ITEM, String.valueOf(args.isEnableSelectModelItem()));
            this.getModel().setValue("model", (Object)(args.getSerialModel() ? "serial" : CONCURRENT));
            this.getPageCache().put("sMPartInstore", String.valueOf(args.isEnableSMPartInstore()));
        } else {
            this.getView().showErrorNotification(result.getMsg());
        }
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar source = (ProgressBar)evt.getSource();
        try {
            if (PROGRESSBARAPVALI.equalsIgnoreCase(source.getKey())) {
                this.dealOnProgressForVali(evt);
            } else if (PROGRESSBARAP.equalsIgnoreCase(source.getKey())) {
                this.dealOnProgress(evt);
            }
            if (evt.getProgress() == 0) {
                evt.setProgress(1);
            }
        }
        catch (Throwable e) {
            LOGGER.error("dealOnProgress_exception.", e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        if (!this.validatePerm()) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String filesize;
            String filename;
            String localPath;
            block16: {
                localPath = "";
                filename = "";
                filesize = "";
                try {
                    if (urls[0] instanceof Map) {
                        Map map = (Map)urls[0];
                        String url = (String)map.get("url");
                        try {
                            localPath = ImportFileUtil.downloadTempFile((String)url);
                        }
                        catch (Exception e) {
                            LOGGER.error((Throwable)e);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u7a33\u5b9a\u5bfc\u81f4\u4e34\u65f6\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HRImportStartPlugin_11", (String)"hrmp-hies-import", (Object[])new Object[0]));
                            return;
                        }
                        filename = (String)map.get("name");
                        filesize = String.valueOf(map.get("size"));
                        break block16;
                    }
                    this.statusControlDisplay(INIT);
                    String url = String.valueOf(urls[0]);
                    if (url.lastIndexOf("/") != -1) {
                        filename = url.substring(url.lastIndexOf("/") + 1);
                    }
                    localPath = ImportFileUtil.downloadFile((String)url);
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    service.delete(url);
                    File file = new File(localPath);
                    filesize = String.valueOf(file.length());
                }
                catch (IOException ioException) {
                    LOGGER.error((Throwable)ioException);
                    this.getView().showErrorNotification(ioException.getMessage());
                    return;
                }
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)filename);
            model.setValue("filesize", (Object)filesize);
            model.setValue("filelocalpath", (Object)localPath);
            this.displayFilename(filename);
            try {
                String serverUrl;
                Map ret = ImportFileUtil.uploadFile((String)filename, (String)localPath);
                model.setValue(FILE_SERVER_URL, ret.get(FILE_SERVER_URL));
                model.setValue("fileuploadid", ret.get("uploadId"));
                model.setValue("clientUrl", ret.get("clientUrl"));
                this.getView().getPageCache().put("uploadId", (String)ret.get("uploadId"));
                String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                HashMap params = Maps.newHashMapWithExpectedSize((int)16);
                params.put(FILE_SERVER_URL, ret.get(FILE_SERVER_URL));
                params.put("filename", filename);
                params.put("formId", this.getEntityNumber());
                params.put("importPlugin", showParameter.getCustomParam("importPlugin"));
                params.put("extParam", this.getModel().getValue("extparam"));
                Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)ITemplateService.class.getSimpleName(), (String)"afterUploadFileEvent", (Object[])new Object[]{params});
                Map newFileInfo = null;
                if (result.isSuccess() && ObjectUtils.isNotEmpty((Object)result.getData()) && StringUtils.isNotEmpty((CharSequence)(serverUrl = (String)(newFileInfo = (Map)result.getData()).get(FILE_SERVER_URL)))) {
                    model.setValue(FILE_SERVER_URL, (Object)serverUrl);
                    model.setValue("fileuploadid", newFileInfo.get("uploadId"));
                    model.setValue("clientUrl", newFileInfo.get("clientUrl"));
                    this.getView().getPageCache().put("uploadId", (String)newFileInfo.get("uploadId"));
                }
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            finally {
                this.deleteLocalFile();
            }
            try {
                this.checkTemplate();
            }
            catch (Throwable exception) {
                LOGGER.error(exception);
                this.deleteLocalFile();
                HIESUtil.showMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u6821\u9a8c\u5f02\u5e38\u3002", (String)"HRImportStartPlugin_1", (String)"hrmp-hies-import", (Object[])new Object[0]), (String)exception.getMessage(), (ConfirmCallBackListener)new ConfirmCallBackListener(CHECK_TEMPLATE_CALLBACK, (IFormPlugin)this));
                this.statusControlDisplay(INIT);
                return;
            }
            this.statusControlDisplay(UPLOAD);
        }
    }

    public void click(EventObject evt) {
        if (!this.validatePerm()) {
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "btnreupload": {
                this.statusControlDisplay(INIT);
                break;
            }
            case "btnupstep": {
                this.statusControlDisplay(UPLOAD);
                break;
            }
            case "btndownstep": {
                ArrayList paraList = new ArrayList();
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.put("v", this.getModel().getValue("model"));
                p.put("key", "model");
                paraList.add(p);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.addAction("u", paraList);
                this.statusControlDisplay(SELECT_MODLE);
                break;
            }
            case "btndowntpl": {
                ListShowParameter lsp = new ListShowParameter();
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                lsp.setFormId("hies_diaetplselect");
                lsp.setBillFormId("hies_diaetplseleenti");
                lsp.setShowTitle(false);
                lsp.setHasRight(true);
                lsp.setLookUp(true);
                lsp.setMultiSelect(false);
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                lsp.setCustomParam("formId", (Object)this.getEntityNumber());
                lsp.setCustomParam("ListName", showParameter.getCustomParam("ListName"));
                lsp.setCustomParam("importPlugin", showParameter.getCustomParam("importPlugin"));
                lsp.setCustomParam("extParam", this.getModel().getValue("extparam"));
                lsp.setCustomParam("mainentityuniqueval", showParameter.getCustomParam("mainentityuniqueval"));
                lsp.setCustomParam("ServiceAppId", (Object)showParameter.getServiceAppId());
                HashMap params = Maps.newHashMapWithExpectedSize((int)6);
                params.put("formId", lsp.getFormId());
                params.put("billformid", lsp.getBillFormId());
                params.put("entityId", this.getEntityNumber());
                params.put("extParam", this.getModel().getValue("extparam"));
                params.put("importPlugin", showParameter.getCustomParam("importPlugin"));
                String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
                Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)ITemplateService.class.getSimpleName(), (String)"beforeShowTemplateSelectListEvent", (Object[])new Object[]{params});
                if (result.isSuccess()) {
                    BeforeShowTemplateSelectListEventArgs args = (BeforeShowTemplateSelectListEventArgs)((Object)result.getData());
                    lsp.setFormId(args.getFormId());
                    lsp.setBillFormId(args.getBillFormId());
                    if (args.getqFilterListStr() != null) {
                        LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
                        args.getqFilterListStr().forEach(item -> qFilterList.add(QFilter.fromSerializedString((String)item)));
                        args.setqFilterList(qFilterList);
                        ListFilterParameter listFilterParameter = new ListFilterParameter();
                        listFilterParameter.setQFilters(args.getqFilterList());
                        lsp.setListFilterParameter(listFilterParameter);
                    }
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                this.getView().showErrorNotification(result.getMsg());
                break;
            }
            case "btnstart": {
                String path = (String)this.getModel().getValue(FILE_SERVER_URL);
                if (StringUtils.isEmpty((CharSequence)path)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"HRImportStartPlugin_2", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    return;
                }
                boolean ret = this.startImportTask();
                if (ret) {
                    this.startProcesser(INSTORE);
                    String model = (String)this.getModel().getValue("model");
                    if (!CONCURRENT.equalsIgnoreCase(model) && "false".equalsIgnoreCase(this.getPageCache().get("sMPartInstore"))) {
                        this.statusControlDisplay(VALIDATE);
                        this.startProcesser(VALIDATE);
                        break;
                    }
                    this.statusControlDisplay(INSTORE);
                    break;
                }
                this.statusControlDisplay(INIT);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_12", (String)"hrmp-hies-import", (Object[])new Object[0]));
                break;
            }
            case "btnstop": {
                IHRAppCache cache;
                Map data;
                boolean terminatorFlag = TaskService.terminatorTask((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT);
                if (terminatorFlag) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u901a\u77e5\u7cfb\u7edf\u7ec8\u6b62\u5bfc\u5165\u3002", (String)"HRImportStartPlugin_5", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    break;
                }
                ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
                if (bar.getPercent() < 90 && (data = (Map)(cache = HRAppCache.get((String)"hies")).get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), Map.class)) != null) {
                    Map virtualProcess = MethodUtil.getVirtualProcess((int)bar.getPercent(), (int)((Integer)data.get("timeRemaining")), (float)Float.parseFloat((String)data.get("finishedBillCount")), (int)Integer.parseInt((String)data.get("totalBillCount")));
                    data.put("progress", virtualProcess.get("progress"));
                    data.put("timeRemaining", virtualProcess.get("timeRemaining"));
                    Integer finishedBillCount = (Integer)virtualProcess.get("finishedBillCount");
                    if (ObjectUtils.isNotEmpty((Object)finishedBillCount)) {
                        data.put("finishedBillCount", String.valueOf(virtualProcess.get("finishedBillCount")));
                    }
                    this.displayInfo(data);
                    bar.setPercent(((Integer)data.get("progress")).intValue());
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5373\u5c06\u5b8c\u6210\uff0c\u65e0\u6cd5\u7ec8\u6b62\u3002", (String)"HRImportStartPlugin_4", (String)"hrmp-hies-import", (Object[])new Object[0]));
                break;
            }
            case "btnbackground": {
                IHRAppCache cache2 = HRAppCache.get((String)"hies");
                cache2.put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
                this.setStart(true);
                this.closeForm();
                break;
            }
            case "lblfilename1": 
            case "lblfilename3": 
            case "lblfilename4": 
            case "lblfilename5": 
            case "lblfilename6": 
            case "lblfilename7": {
                String url = this.getDownloadUrl(this.getPageCache().get("uploadId"));
                this.getView().download(url);
                break;
            }
            case "btndownall": {
                this.downErrorFile("btndownall");
                break;
            }
            case "btndownerror": {
                this.downErrorFile("btndownerror");
                break;
            }
            case "lblviewhis": {
                TaskInfoHelper.showHistory((IFormView)this.getView(), (String)OprType.IMPORT.getValue());
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        String status = this.getPageCache().get(CURRENT_STATUS);
        this.canClosePage = !VALIDATE.equalsIgnoreCase(status) && !INSTORE.equalsIgnoreCase(status);
        if (!this.canClosePage && StringUtils.isNotBlank((CharSequence)this.getTaskPKId())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5bfc\u5165\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"HRImportStartPlugin_6", (String)"hrmp-hies-import", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btnback", (IFormPlugin)this));
            event.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (StringUtils.equals((CharSequence)"btnback", (CharSequence)messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u8f6c\u5165\u540e\u53f0\u3002", (String)"HRImportStartPlugin_3", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                }
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.toBackground();
            }
        } else if (messageboxclosedevent.getCallBackId().equalsIgnoreCase(CHECK_TEMPLATE_CALLBACK)) {
            this.removeAttachmentPanel(this.getView());
        }
    }

    private void removeAttachmentPanel(IFormView view) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("fileupload");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    private void statusControlDisplay(String type) {
        LOGGER.info("statusControlDisplay=" + type);
        String enableSelectModelItem = this.getPageCache().get(ENABLE_SELECT_MODEL_ITEM);
        String enableSelectModelView = this.getPageCache().get(ENABLE_SELECT_MODEL_VIEW);
        switch (type) {
            case "init": {
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("1%");
                Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
                lblinstorevalue.setText("");
                Label lblvalidateprocess1 = (Label)this.getControl("lblvalidateprocess1");
                lblvalidateprocess1.setText("");
                Label lblvalidateprocess2 = (Label)this.getControl("lblvalidateprocess2");
                lblvalidateprocess2.setText("1%");
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload", "lblremainingtip", "lblremainingtip1", "flexmini", "flexmini2", "flexmini3", "flexmini4", "flefail1", "flefail2", "flefailed", "flefail3", "flesuccess1", "flesuccess2", "flesuccess3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate", "fleremaintime", "lblinstorevalue", "fleremaintime1"});
                this.getModel().setValue(FILE_SERVER_URL, (Object)"");
                this.removeAttachmentPanel(this.getView());
                this.getPageCache().put(CURRENT_STATUS, INIT);
                break;
            }
            case "upload": {
                if ("false".equalsIgnoreCase(enableSelectModelView)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"btnstart"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btndownstep"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"btndownstep"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btnstart"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "fleselectmodel", "flevalidata2", "fleinstore", "flestop", "flefinished", "btnupstep", "btnstop", "btnbackground", "btndownerror", "btndownall", "flevalidatefail"});
                this.getPageCache().put(CURRENT_STATUS, UPLOAD);
                break;
            }
            case "selectModle": {
                if ("false".equalsIgnoreCase(enableSelectModelItem)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleselectmodel", "btnupstep", "btnstart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "flevalidata2", "fleinstore", "flestop", "flefinished", "btndownstep", "btnstop", "btnbackground", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, SELECT_MODLE);
                break;
            }
            case "validate": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flevalidata2", "btnstop", "btnbackground"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "fleinstore", "flestop", "flefinished", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, VALIDATE);
                break;
            }
            case "instore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleinstore", "btnstop", "btnbackground", "lblinstorevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flestop", "flefinished", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, INSTORE);
                break;
            }
            case "finished": {
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinished", "btndownerror", "btndownall", "btnreupload", "flefinished2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flestop", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "flefailed"});
                this.getPageCache().put(CURRENT_STATUS, FINISHED);
                break;
            }
            case "terminator": {
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flestop", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flefinished", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "btndownerror", "btndownall"});
                this.getPageCache().put(CURRENT_STATUS, TERMINATOR);
                break;
            }
            case "validateFailed": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "btndownerror", "btndownall", "btnreupload", "flevalidatefail"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flestop", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flefinished2", "btnstop", "btnbackground", "flefailed", "flefinished"});
                this.getPageCache().put(CURRENT_STATUS, VALIDATE_FAILED);
                break;
            }
            case "noSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail1", "flefail2", "flefailed"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess1", "flesuccess2", "btndownall", "flefinished2"});
                break;
            }
            case "noFailBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flesuccess1", "flesuccess2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "btndownerror", "btndownall"});
                break;
            }
            case "noSuccessAndFailBill": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "flesuccess1", "flesuccess2"});
                break;
            }
            case "validateNoSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess3", "btndownall"});
                break;
            }
            case "hasTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip"});
                break;
            }
            case "hasValidateTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip1"});
                break;
            }
        }
    }

    private void toBackground() {
        this.getPageCache().put(CURRENT_STATUS, BACK_RUN);
        this.closeForm();
        String taskPKId = this.getTaskPKId();
        if (!StringUtils.isBlank((CharSequence)taskPKId)) {
            String key = MethodUtil.getTaskCachePath((String)taskPKId, (String)"import", (String)"ball");
            IHRAppCache appCache = HRAppCache.get((String)"hies");
            TaskInfo taskInfo = (TaskInfo)appCache.get(key, TaskInfo.class);
            IHRAppCache cache = HRAppCache.get((String)"hies");
            Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"result"), Map.class);
            if (taskInfo == null && result == null) {
                Object filename = this.getModel().getValue("filename");
                IEGlobalTaskUtil.createNewGlobalTask((String)"import", (IFormView)this.getView(), (String)taskPKId, (String)((String)filename), (String)ImportTaskClick.class.getName(), null);
            }
        }
    }

    private void closeForm() {
        this.getView().close();
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private void displayInfo(Map<String, Object> data) {
        Integer progress = (Integer)data.get("progress");
        Label lblprogress = (Label)this.getControl("lblprogress");
        lblprogress.setText(progress + "%");
        String finishedBillCount = (String)data.get("finishedBillCount");
        String totalBillCount = (String)data.get("totalBillCount");
        if (StringUtils.isNotBlank((CharSequence)finishedBillCount) && Integer.parseInt(finishedBillCount) > 0) {
            String sta = this.getPageCache().get(CURRENT_STATUS);
            if (!INSTORE.equalsIgnoreCase(sta)) {
                this.statusControlDisplay(INSTORE);
            }
            Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
            lblinstorevalue.setText("(" + finishedBillCount.concat("/").concat(totalBillCount) + ")");
        }
        Label lblremainingm = (Label)this.getControl("lblremainingm");
        Label lblremainings = (Label)this.getControl("lblremainings");
        Integer timeRemaining = (Integer)data.get("timeRemaining");
        if (timeRemaining != null && timeRemaining > 0) {
            this.statusControlDisplay("hasTimeRemaining");
            String minite = String.valueOf(timeRemaining / 60);
            String second = String.valueOf(timeRemaining % 60);
            lblremainingm.setText(minite);
            lblremainings.setText(second);
            if ("0".equalsIgnoreCase(minite)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini"});
            }
        }
        this.getView().getPageCache().put("totalBillCount", totalBillCount);
    }

    private String getTaskPKId() {
        return this.getPageCache().get("import_taskPKid");
    }

    private String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskPKId()) ? "_" + this.getTaskPKId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }

    private String getEntityNumber() {
        String formId = this.getPageCache().get("formId");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        return formId;
    }

    private void checkTemplate() throws Exception {
        Object extparam = this.getModel().getValue("extparam");
        String serverPath = (String)this.getModel().getValue(FILE_SERVER_URL);
        String routeAppId = MethodUtil.getRouteAppId((String)this.getView().getFormShowParameter().getServiceAppId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)ITemplateService.class.getSimpleName(), (String)"templateValidate", (Object[])new Object[]{serverPath, this.getEntityNumber(), showParameter.getCustomParam("importPlugin"), extparam});
        if (!result.isSuccess()) {
            throw new Exception(result.getMsg());
        }
        Map ret = (Map)result.getData();
        this.getPageCache().put("sheetEntityMap", (String)ret.get("sheetEntityMap"));
        this.getPageCache().put("sheetRowCountMap", (String)ret.get("sheetRowCountMap"));
        this.getPageCache().put("effectSheetNames", (String)ret.get("effectSheetNames"));
        this.getModel().setValue("totalrow", ret.get("totalrow"));
        this.getModel().setValue("tplpkid", ret.get("tplpkid"));
        this.getModel().setValue("optype", ret.get("optype"));
        Label lblimporttype = (Label)this.getControl("lblimporttype");
        lblimporttype.setText((String)ret.get("optypeText"));
    }

    private boolean startImportTask() {
        this.getPageCache().put("taskTraceId", RequestContext.get().getTraceId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String serviceAppId = (String)this.getView().getFormShowParameter().getCustomParam("ServiceAppId");
        Map params = showParameter.getCustomParams();
        String queryEntityId = (String)params.get("queryEntityId");
        if (StringUtils.isNotEmpty((CharSequence)queryEntityId)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)queryEntityId);
            serviceAppId = dataEntityType.getAppId();
        }
        String routeAppId = MethodUtil.getRouteAppId((String)serviceAppId);
        params.put("appId", showParameter.getAppId());
        params.put("routeAppId", routeAppId);
        params.put("oprtype", OprType.IMPORT.getValue());
        params.put("OprCategory", this.getModel().getValue("optype"));
        params.put("tplpkid", this.getModel().getValue("tplpkid"));
        params.put("sheetEntityMap", this.getPageCache().get("sheetEntityMap"));
        params.put("sheetCountRow", this.getPageCache().get("sheetRowCountMap"));
        params.put("effectSheetNames", this.getPageCache().get("effectSheetNames"));
        params.put("totalRow", this.getModel().getValue("totalrow"));
        params.put("fileUrl", this.getModel().getValue(FILE_SERVER_URL));
        params.put("fileuploadid", this.getModel().getValue("fileuploadid"));
        params.put("fileName", this.getModel().getValue("filename"));
        params.put("fileSize", this.getModel().getValue("filesize"));
        params.put("serialModel", this.getModel().getValue("model"));
        params.put("sMPartInstore", this.getPageCache().get("sMPartInstore"));
        params.put("requestContext", SerializationUtils.toJsonString((Object)RequestContext.get()));
        params.put("sourceIp", NetAddressUtils.getLocalIpAddress());
        String extparam = (String)this.getModel().getValue("extparam");
        params.put("extParam", extparam);
        params.put("userStartTime", new Date().getTime());
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)IImportService.class.getSimpleName(), (String)"submitNewTask", (Object[])new Object[]{params});
        if (result.isSuccess()) {
            this.getPageCache().put("import_taskPKid", String.valueOf(result.getData()));
            return true;
        }
        this.getView().showMessage(result.getMsg());
        return false;
    }

    private void downErrorFile(String type) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"result"), Map.class);
        Map customData = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"urls"), Map.class);
        if (result.getOrDefault("sysTerminator", false).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\u5df2\u88ab\u8feb\u7ec8\u6b62\uff0c\u65e0\u6cd5\u751f\u6210\u7ed3\u679c\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_8", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return;
        }
        String fileId = null;
        if ("btndownall".equals(type)) {
            if (customData == null || StringUtils.isBlank((CharSequence)((CharSequence)customData.get("errorFileForAllData")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_7", (String)"hrmp-hies-import", (Object[])new Object[0]));
                return;
            }
            fileId = (String)customData.get("errorFileForAllData");
        } else {
            if (customData == null || StringUtils.isBlank((CharSequence)((CharSequence)customData.get("errorFileForErrorData")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_7", (String)"hrmp-hies-import", (Object[])new Object[0]));
                return;
            }
            fileId = (String)customData.get("errorFileForErrorData");
        }
        String url = this.getDownloadUrl(fileId);
        this.getView().download(url);
    }

    private void displayResultData(Map<String, Object> result) {
        String successedBillCount;
        Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
        Label lblresultstatics54 = (Label)this.getControl("lblresultstatics54");
        Label lblresultstatics541 = (Label)this.getControl("lblresultstatics541");
        String totalBillCount = (String)result.get("totalBillCount");
        lblinstorevalue.setText("(" + totalBillCount.concat("/").concat(totalBillCount) + ")");
        String userStartTime = (String)result.get("userStartTime");
        String userEndTime = (String)result.get("userEndTime");
        if (StringUtils.isNotBlank((CharSequence)userEndTime)) {
            String costTimeStr = TaskInfoHelper.costTimeIgnoreMs((Long)Long.parseLong(userEndTime), (Long)Long.parseLong(userStartTime));
            String remainingTime = String.format(ResManager.loadKDString((String)"\u5171\u8017\u65f6 %s", (String)"HRImportStartPlugin_9", (String)"hrmp-hies-import", (Object[])new Object[0]), costTimeStr);
            lblresultstatics54.setText(remainingTime);
            lblresultstatics541.setText(remainingTime);
        }
        successedBillCount = (successedBillCount = (String)result.get("successedBillCount")) == null ? "0" : successedBillCount;
        int lostCount = Integer.parseInt(totalBillCount) - Integer.parseInt(successedBillCount);
        Label lblsuccesscount1 = (Label)this.getControl("lblsuccesscount1");
        Label lblsuccesscount2 = (Label)this.getControl("lblsuccesscount2");
        Label lblfailcount1 = (Label)this.getControl("lblfailcount1");
        Label lblfailcount2 = (Label)this.getControl("lblfailcount2");
        Label lbtotalcount1 = (Label)this.getControl("lbtotalcount1");
        Label lbtotalcount2 = (Label)this.getControl("lbtotalcount2");
        if (StringUtils.isNotBlank((CharSequence)successedBillCount) && StringUtils.isNotBlank((CharSequence)totalBillCount)) {
            lblsuccesscount1.setText(successedBillCount);
            lblsuccesscount2.setText(successedBillCount);
            lblfailcount1.setText(String.valueOf(lostCount));
            lblfailcount2.setText(String.valueOf(lostCount));
            lbtotalcount1.setText(totalBillCount);
            lbtotalcount2.setText(totalBillCount);
        }
        if (successedBillCount.equals("0")) {
            LOGGER.info("noSuccessBill_from_concurrentModel");
            this.statusControlDisplay(NO_SUCCESS_BILL);
        }
        if (successedBillCount.equals(totalBillCount)) {
            LOGGER.info("nofailBill_from_concurrentModel");
            this.statusControlDisplay(NO_FAIL_BILL);
        }
        String finishedBillCount = (String)result.get("finishedBillCount");
        boolean userHasTerminator = (Boolean)result.getOrDefault("userHasTerminator", false);
        if (userHasTerminator) {
            LOGGER.info("userHasTerminator_from_concurrentModel");
            this.statusControlDisplay(TERMINATOR);
            Label lblterminatorcount = (Label)this.getControl("lblterminatorcount");
            int terminatorcount = Integer.parseInt(totalBillCount) - Integer.parseInt(finishedBillCount);
            lblterminatorcount.setText(String.valueOf(terminatorcount));
            int errorCount = Integer.parseInt(finishedBillCount) - Integer.parseInt(successedBillCount);
            lblfailcount1.setText(String.valueOf(errorCount));
            if (totalBillCount.equals(String.valueOf(terminatorcount))) {
                LOGGER.info("noSuccessAndFailBill_from_concurrentModel");
                this.statusControlDisplay(NO_SUCCESS_AND_FAIL_BILL);
            }
        }
        if (((Boolean)result.getOrDefault("sysTerminator", false)).booleanValue()) {
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff01traceId:%s \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_13", (String)"hrmp-hies-import", (Object[])new Object[0]), this.getPageCache().get("taskTraceId"));
            this.getView().showErrorNotification(tip);
        }
    }

    private void displayFilename(String filename) {
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        Label lblfilename3 = (Label)this.getControl("lblfilename3");
        Label lblfilename4 = (Label)this.getControl("lblfilename4");
        Label lblfilename5 = (Label)this.getControl("lblfilename5");
        Label lblfilename6 = (Label)this.getControl("lblfilename6");
        Label lblfilename7 = (Label)this.getControl("lblfilename7");
        lblfilename1.setText(filename);
        lblfilename3.setText(filename);
        lblfilename4.setText(filename);
        lblfilename5.setText(filename);
        lblfilename6.setText(filename);
        lblfilename7.setText(filename);
    }

    private void displayImporttype(DynamicObject tpl, String val) {
        DynamicProperty prop = tpl.getDynamicObjectType().getProperty("importtype");
        ComboProp temp = (ComboProp)prop;
        String name = "";
        for (ValueMapItem item : temp.getComboItems()) {
            if (!item.getValue().equals(val)) continue;
            name = item.getName().getLocaleValue();
            break;
        }
        Label lblimporttype = (Label)this.getControl("lblimporttype");
        lblimporttype.setText(name);
    }

    private void dealOnProgress(ProgressEvent evt) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"result"), Map.class);
        String status = this.getPageCache().get(CURRENT_STATUS);
        if (result != null && INSTORE.equalsIgnoreCase(status)) {
            evt.setProgress(99);
            this.statusControlDisplay(FINISHED);
            this.displayResultData(result);
        } else if (result != null && VALIDATE.equalsIgnoreCase(status)) {
            evt.setProgress(99);
            this.statusControlDisplay(INSTORE);
        } else if (result == null) {
            String stat;
            Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), Map.class);
            if (data == null) {
                return;
            }
            Map virtualProcess = null;
            Integer progress = (Integer)data.get("progress");
            if (progress >= 100) {
                progress = 99;
            } else if (progress < 90 && "canotstop".equals(stat = (String)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"status"), String.class))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop"});
                virtualProcess = MethodUtil.getVirtualProcess((int)progress, (int)((Integer)data.get("timeRemaining")), (float)Float.parseFloat((String)data.get("finishedBillCount")), (int)Integer.parseInt((String)data.get("totalBillCount")));
                data.put("progress", virtualProcess.get("progress"));
                data.put("timeRemaining", virtualProcess.get("timeRemaining"));
                Integer finishedBillCount = (Integer)virtualProcess.get("finishedBillCount");
                if (ObjectUtils.isNotEmpty((Object)finishedBillCount)) {
                    data.put("finishedBillCount", String.valueOf(virtualProcess.get("finishedBillCount")));
                }
            }
            evt.setProgress(progress.intValue());
            this.displayInfo(data);
        }
    }

    private void dealOnProgressForVali(ProgressEvent evt) {
        Label lblvalidateprocess1 = (Label)this.getControl("lblvalidateprocess1");
        Label lblvalidateprocess2 = (Label)this.getControl("lblvalidateprocess2");
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map data = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), Map.class);
        if (data == null) {
            return;
        }
        Integer finishedValidateBillCount = Integer.parseInt(data.getOrDefault("finishedValidateBillCount", "0"));
        Integer totalBillCount = Integer.parseInt(data.getOrDefault("totalBillCount", "0"));
        Map resultData = (Map)cache.get(MethodUtil.getTaskCachePath((String)this.getTaskPKId(), (String)ImportCacheKeyType.IMPORT, (String)"result"), Map.class);
        if (resultData != null) {
            finishedValidateBillCount = Integer.parseInt(resultData.getOrDefault("finishedValidateBillCount", "0"));
            Integer successedValidateBillCount = Integer.parseInt(resultData.getOrDefault("successedValidateBillCount", "0"));
            totalBillCount = Integer.parseInt(data.getOrDefault("totalBillCount", "0"));
            this.dealOnProgressForValiResult(evt, totalBillCount, finishedValidateBillCount, successedValidateBillCount, resultData);
        } else if (finishedValidateBillCount > 0) {
            int progress = (int)(finishedValidateBillCount.floatValue() / (float)totalBillCount.intValue() * 100.0f);
            if (progress >= 100) {
                progress = 99;
            } else if (progress == 0) {
                progress = 1;
            }
            evt.setProgress(progress);
            lblvalidateprocess1.setText("(" + finishedValidateBillCount + "/" + totalBillCount + ")");
            lblvalidateprocess2.setText(progress + "%");
            Label lblremainingm1 = (Label)this.getControl("lblremainingm1");
            Label lblremainings1 = (Label)this.getControl("lblremainings1");
            Integer validateTimeRemaining = (Integer)data.get("validateTimeRemaining");
            if (validateTimeRemaining != null && validateTimeRemaining > 0) {
                this.statusControlDisplay("hasValidateTimeRemaining");
                String minite = String.valueOf(validateTimeRemaining / 60);
                String second = String.valueOf(validateTimeRemaining % 60);
                lblremainingm1.setText(minite);
                lblremainings1.setText(second);
                if ("0".equalsIgnoreCase(minite)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini1"});
                }
            }
        }
    }

    private void dealOnProgressForValiResult(ProgressEvent evt, Integer totalBillCount, Integer finishedValidateBillCount, Integer successedValidateBillCount, Map<String, Object> resultData) {
        evt.setProgress(99);
        this.stopProcesser(VALIDATE);
        if (successedValidateBillCount.equals(totalBillCount)) {
            if (VALIDATE.equalsIgnoreCase(this.getPageCache().get(CURRENT_STATUS))) {
                this.statusControlDisplay(INSTORE);
            }
        } else {
            this.stopProcesser(INSTORE);
            if (resultData != null && ((Boolean)resultData.getOrDefault("userHasTerminator", false)).booleanValue()) {
                LOGGER.info("userHasTerminator_from_serialModel");
                this.statusControlDisplay(TERMINATOR);
                Label lbtotalcount1 = (Label)this.getControl("lbtotalcount1");
                lbtotalcount1.setText(String.valueOf(totalBillCount));
                Label lblterminatorcount = (Label)this.getControl("lblterminatorcount");
                int terminatorcount = totalBillCount - finishedValidateBillCount;
                lblterminatorcount.setText(String.valueOf(terminatorcount));
                int errorCount = finishedValidateBillCount - successedValidateBillCount;
                Label lblsuccesscount1 = (Label)this.getControl("lblsuccesscount1");
                lblsuccesscount1.setText(String.valueOf(successedValidateBillCount));
                Label lblfailcount1 = (Label)this.getControl("lblfailcount1");
                lblfailcount1.setText(String.valueOf(errorCount));
                if (totalBillCount.equals(terminatorcount)) {
                    this.statusControlDisplay(NO_SUCCESS_AND_FAIL_BILL);
                } else if (successedValidateBillCount.equals(0)) {
                    LOGGER.info("noSuccessAndFailBill_from_serialModel");
                    this.statusControlDisplay(NO_SUCCESS_BILL);
                } else if (errorCount == 0) {
                    LOGGER.info("nofailBill_from_serialModel");
                    this.statusControlDisplay(NO_FAIL_BILL);
                }
                return;
            }
            this.statusControlDisplay(VALIDATE_FAILED);
            Label lblfailcount3 = (Label)this.getControl("lblfailcount3");
            lblfailcount3.setText(String.valueOf(totalBillCount - successedValidateBillCount));
            Label lbtotalcount3 = (Label)this.getControl("lbtotalcount3");
            lbtotalcount3.setText(String.valueOf(totalBillCount));
            if (successedValidateBillCount > 0) {
                Label lblsuccesscount3 = (Label)this.getControl("lblsuccesscount3");
                lblsuccesscount3.setText(String.valueOf(successedValidateBillCount));
            } else {
                this.statusControlDisplay("validateNoSuccessBill");
            }
            if (resultData != null) {
                Label lblresultstatics5411 = (Label)this.getControl("lblresultstatics5411");
                String costTimeStr = TaskInfoHelper.costTimeIgnoreMs((Long)Long.parseLong((String)resultData.get("userEndTime")), (Long)Long.parseLong((String)resultData.get("userStartTime")));
                String remainingTime = String.format(ResManager.loadKDString((String)"\u5171\u8017\u65f6 %s", (String)"HRImportStartPlugin_9", (String)"hrmp-hies-import", (Object[])new Object[0]), costTimeStr);
                lblresultstatics5411.setText(remainingTime);
            }
        }
    }

    private void startProcesser(String type) {
        if (INSTORE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
            bar.setPercent(0);
            bar.start();
        } else if (VALIDATE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAPVALI);
            bar.setPercent(0);
            bar.start();
        }
    }

    private void stopProcesser(String type) {
        LOGGER.info("stopProcesser_type=" + type);
        if (INSTORE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
            bar.stop();
        } else if (VALIDATE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAPVALI);
            bar.stop();
        }
    }

    private void deleteLocalFile() {
        try {
            ImportFileUtil.deleteLocalTempFile((String)((String)this.getModel().getValue("filelocalpath")));
        }
        catch (FileSystemException e) {
            LOGGER.info("file can't delete.");
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    private boolean validatePerm() {
        FormShowParameter parentP = this.getView().getFormShowParameter();
        String formId = (String)parentP.getCustomParam("formId");
        boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)parentP.getAppId(), (String)formId, (String)"4730fc9f000003ae");
        if (!checkPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5bfc\u5165\u6743\u9650\uff0c\u5982\u9700\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_10", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getDownloadUrl(String surl) {
        return ExcelUtil.getDownloadUrl((String)surl, (String)this.getEntityNumber(), (String)"4730fc9f000003ae");
    }
}

