/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.formplugin.fieldstyle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.awt.GraphicsEnvironment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.FieldStyleServiceHelper;
import kd.hr.hies.common.dto.FieldStyle;
import kd.hr.impt.common.LocalCacheHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class FieldStyleReportFormPlugin
extends AbstractReportFormPlugin
implements ClickListener,
CellClickListener {
    private static final Log LOGGER = LogFactory.getLog(FieldStyleReportFormPlugin.class);
    private static final String GROUP_NAME_CLOSECALLBACK = "editGroupName_closeCallBack";
    private static final String BEFORE_GROUP_NAME_CLOSECALLBACK = "beforeGroupName_closeCallBack";
    private final Base64.Encoder encoder = Base64.getEncoder();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"bold", "italic", "foregroundcolor", "colorchoose", "backgroundcolor", "bgcolorchoose", "left", "center", "right", "merge", "cancelmerge", "cancelallmerge"});
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addCellClickListener((CellClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "colorchoose": {
                this.showColorChooseForm("foregroundcolor");
                break;
            }
            case "bgcolorchoose": {
                this.showColorChooseForm("backgroundcolor");
                break;
            }
            case "merge": 
            case "cancelmerge": {
                this.mergeClick(key);
                break;
            }
            case "cancelallmerge": {
                this.cancelAllMergeClick();
                break;
            }
            default: {
                this.fieldStyleClick(evt);
            }
        }
    }

    private void fieldStyleClick(EventObject evt) {
        JSONObject fieldStyleMap = this.getAllStyleCacheByEntityNum();
        FieldStyle fieldStyle = this.getFieldStyleCache(fieldStyleMap);
        switch (((Button)evt.getSource()).getKey()) {
            case "bold": {
                if ("bolder".equals(fieldStyle.getFontWeight())) {
                    fieldStyle.setFontWeight("normal");
                    break;
                }
                fieldStyle.setFontWeight("bolder");
                break;
            }
            case "italic": {
                if ("italic".equals(fieldStyle.getFontStyle())) {
                    fieldStyle.setFontStyle("normal");
                    break;
                }
                fieldStyle.setFontStyle("italic");
                break;
            }
            case "left": {
                fieldStyle.setTextAlign("left");
                break;
            }
            case "center": {
                fieldStyle.setTextAlign("center");
                break;
            }
            case "right": {
                fieldStyle.setTextAlign("right");
                break;
            }
            case "foregroundcolor": {
                if (this.getPageCache().get("curFontColor") == null) {
                    fieldStyle.setColor("#212121ff");
                    break;
                }
                fieldStyle.setColor(this.getPageCache().get("curFontColor"));
                break;
            }
            case "backgroundcolor": {
                if (this.getPageCache().get("curBDColor") == null) {
                    fieldStyle.setBackgroundColor("#212121ff");
                    break;
                }
                fieldStyle.setBackgroundColor(this.getPageCache().get("curBDColor"));
                break;
            }
        }
        this.putFieldStyleCache(fieldStyle, fieldStyleMap);
        this.setValueGlobalFieldStyle();
    }

    private void mergeClick(String clickKey) {
        this.sendDataToCusControl(clickKey);
    }

    private void cancelAllMergeClick() {
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("cancelAllMergeClick", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u53d6\u6d88\u5168\u90e8\u8868\u5934\u5408\u5e76\u5417\uff1f", (String)"FieldStyleReportFormPlugin_0", (String)"hrmp-hies-import", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (actionId.equals("cancelAllMergeClick") && event.getResult() == MessageBoxResult.Yes) {
            Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
            customParams.remove("fieldmerge");
            this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
            this.getView().refresh();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        try {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entityNumber = (String)customParams.get("entityNumber");
            String templateType = (String)customParams.get("tmpltype");
            this.hideButton(customParams);
            if ("IMPT".equalsIgnoreCase(templateType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"merge", "cancelmerge", "cancelallmerge"});
            }
            this.sendDataToCusControl("");
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontFamilyNames = ge.getAvailableFontFamilyNames();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(fontFamilyNames.length);
            for (String fontFamilyName : fontFamilyNames) {
                items.add(new ComboItem(new LocaleString(fontFamilyName), fontFamilyName));
            }
            ComboEdit fontfamily = (ComboEdit)this.getControl("fontfamily");
            fontfamily.setComboItems(items);
            this.getView().getModel().setValue("fontfamily", (Object)ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"FieldStyleReportFormPlugin_5", (String)"hrmp-hies-import", (Object[])new Object[0]));
            LocalCacheHelper.getLocalCache().put(this.getView().getFormShowParameter().getRootPageId() + entityNumber, (Object)this.getView().getPageId());
            this.handleFieldContent();
            JSONObject jsonObject = ((JSONObject)customParams).getJSONObject("fieldstyle");
            if (jsonObject != null && jsonObject.size() > 0) {
                String fieldStyleJson = jsonObject.getString(entityNumber);
                if (StringUtils.isNotBlank((CharSequence)fieldStyleJson) && !fieldStyleJson.equalsIgnoreCase("{}")) {
                    JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
                    JSONObject fieldStyleMap = JSONObject.parseObject((String)fieldStyleJson);
                    JSONObject fields = ((JSONObject)customParams).getJSONObject("fields");
                    Set fieldStyleMapKeys = fieldStyleMap.keySet();
                    Set fieldsKeys = fields.keySet();
                    fieldsKeys.stream().filter(key -> !fieldStyleMapKeys.contains(key)).forEach(field -> fieldStyleMap.put(field, (Object)globalFieldStyle));
                    this.putFieldStyleCache(null, fieldStyleMap);
                } else {
                    this.initGlobalFieldStyle(customParams);
                }
            } else {
                this.initGlobalFieldStyle(customParams);
            }
            JSONObject mergeJson = ((JSONObject)customParams).getJSONObject("fieldmerge");
            if (mergeJson != null) {
                JSONObject fieldJson = ((JSONObject)customParams).getJSONObject("fields");
                JSONObject mergeJsonTemp = new JSONObject();
                mergeJson.forEach((key, value) -> mergeJsonTemp.put(Arrays.stream(key.split(",")).filter(arg_0 -> ((JSONObject)fieldJson).containsKey(arg_0)).collect(Collectors.joining(",")), value));
                customParams.put("fieldmerge", mergeJsonTemp);
            }
            this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
        }
        catch (Exception exception) {
            LOGGER.error("FieldStyleReportFormPlugin.beforeBindData() Error:", (Throwable)exception);
        }
    }

    private void initGlobalFieldStyle(Map<String, Object> customParams) {
        JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
        if (globalFieldStyle != null) {
            Set fields = ((JSONObject)customParams).getJSONObject("fields").keySet();
            JSONObject styleMap = new JSONObject(fields.size());
            fields.forEach(field -> styleMap.put(field, (Object)globalFieldStyle.clone()));
            this.putFieldStyleCache(null, styleMap);
        }
    }

    private void hideButton(Map<String, Object> customParams) {
        if (!this.isHasMergeField(customParams)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancelmerge", "cancelallmerge"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cancelmerge", "cancelallmerge"});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("reportlistap", map);
        this.getView().setVisible(Boolean.TRUE, new String[]{"reportlistap"});
        this.getView().refresh();
    }

    private void putFieldStyleCache(FieldStyle fieldStyle, JSONObject fieldStyleMap) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        if (fieldStyle != null) {
            AbstractGrid.GridState gridState = ((ReportList)this.getControl("reportlistap")).getEntryState();
            String focusField = gridState.getFocusField();
            int focusRow = gridState.getFocusRow();
            if (StringUtils.isBlank((CharSequence)focusField)) {
                return;
            }
            String fieldContentKey = focusRow == 2 ? "content" : "header";
            JSONObject stringFieldStyleMap = fieldStyleMap.getJSONObject(focusField);
            if (stringFieldStyleMap == null) {
                stringFieldStyleMap = new JSONObject();
                stringFieldStyleMap.put(fieldContentKey, (Object)fieldStyle);
                fieldStyleMap.put(focusField, (Object)stringFieldStyleMap);
            } else {
                fieldStyleMap.getJSONObject(focusField).put(fieldContentKey, (Object)fieldStyle);
            }
        }
        this.getPageCache().put(entityNumber, fieldStyleMap.toJSONString());
        this.constructCustomStyles(fieldStyleMap);
        LocalCacheHelper.getLocalCache().put(this.getView().getFormShowParameter().getRootPageId() + entityNumber, (Object)this.getView().getPageId());
    }

    private void setValueGlobalFieldStyle() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "hies_diaesysparam".equals(parentView.getEntityId())) {
            JSONObject fieldStyle = new JSONObject();
            fieldStyle.put("globalfieldstyle", (Object)JSONObject.parseObject((String)this.getPageCache().get("globalfieldstyle")));
            this.getView().getParentView().getModel().setValue("globalfieldstyle", (Object)fieldStyle.toJSONString());
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void constructCustomStyles(JSONObject fieldStyle) {
        try {
            Map numberToContent = (Map)JSONObject.parseObject((String)this.getPageCache().get("numberToContent"), Map.class);
            Map numberToName = (Map)JSONObject.parseObject((String)this.getPageCache().get("numberToName"), Map.class);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object customParam = customParams.get("isSysParamsPage");
            StringBuilder defaultStyle = new StringBuilder("{\"type\":0,\"content\":\"");
            if (this.isHasMergeField(customParams)) {
                defaultStyle.append("$ .ag-header{height: 40px !important; min-height: 40px !important;}");
            } else {
                defaultStyle.append("$ .ag-header{height: 20px !important; min-height: 20px !important;}");
            }
            if (Objects.nonNull(customParam) && ((Boolean)customParam).booleanValue()) {
                defaultStyle.append("$ .ag-pivot-off{display: none;}");
            }
            Map fieldStyleMap = null;
            try {
                fieldStyleMap = (Map)JSONObject.parseObject((String)fieldStyle.toJSONString(), (TypeReference)new TypeReference<Map<String, Map<String, FieldStyle>>>(){}, (Feature[])new Feature[0]);
            }
            catch (Throwable e) {
                LOGGER.warn(e.getMessage());
                fieldStyleMap = (Map)JSONObject.parseObject((String)fieldStyle.toString(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), (TypeReference)new TypeReference<Map<String, Map<String, FieldStyle>>>(){}, (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect});
            }
            for (Map.Entry entry : fieldStyleMap.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                int dataRowIndex = 0;
                for (Map.Entry styleEntry : value.entrySet()) {
                    FieldStyle style = (FieldStyle)styleEntry.getValue();
                    if (numberToContent.get(key) == null && numberToName.get(key) == null) continue;
                    if (style.getBackgroundColor() != null) {
                        style.setBackgroundColor(style.getBackgroundColor() + " !important");
                    } else {
                        style.setBackgroundColor("rgba(255@255@255@0.1) !important");
                    }
                    String customStyles = "#reportlistap td[data-role=table-cell][data-code=" + key + "][data-rowindex='" + dataRowIndex + "']" + SerializationUtils.toJsonString((Object)style);
                    if (StringUtils.isNotBlank((CharSequence)style.getTextAlign())) {
                        customStyles = customStyles + "#reportlistap td[data-role=table-cell][data-code=" + key + "][data-rowindex='" + dataRowIndex + "'] > div{text-align: " + style.getTextAlign() + "}";
                    }
                    defaultStyle.append(customStyles.replaceAll("\"", "").replaceAll(",", ";").replaceAll("@", ","));
                    ++dataRowIndex;
                }
            }
            defaultStyle = new StringBuilder(defaultStyle.substring(0, defaultStyle.length() - 1)).append("}\"}");
            HashMap<String, String> ctl = new HashMap<String, String>();
            ctl.put("cstyles", this.encoder.encodeToString(defaultStyle.toString().getBytes(StandardCharsets.UTF_8)));
            this.getView().updateControlMetadata("fieldstyleflex", ctl);
        }
        catch (Exception exception) {
            LOGGER.error("FieldStyleReportFormPlugin_constructCustomStyles() error:", (Throwable)exception);
        }
    }

    private boolean isHasMergeField(Map<String, Object> customParams) {
        Object mergeFieldToGroupName;
        Object mergeJson;
        Map customParamsCache = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
        boolean flag = customParamsCache == null ? (mergeJson = customParams.get("fieldmerge")) != null : Objects.nonNull(mergeFieldToGroupName = customParamsCache.get("fieldmerge")) && ((LinkedHashMap)JSONObject.parseObject((String)customParamsCache.get("fieldmerge").toString(), LinkedHashMap.class)).size() > 0;
        return flag;
    }

    private void showColorChooseForm(String closeCallBackKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hies_colorpalette");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackKey));
        this.getView().showForm(formShowParameter);
    }

    private String getCacheKey() {
        AbstractGrid.GridState gridState = ((ReportList)this.getControl("reportlistap")).getEntryState();
        String focusField = gridState.getFocusField();
        int focusRow = gridState.getFocusRow();
        if (StringUtils.isBlank((CharSequence)focusField)) {
            return "";
        }
        Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
        JSONObject fields = (JSONObject)customParams.get("fields");
        JSONObject focusFieldJson = fields.getJSONObject(focusField);
        if (focusFieldJson == null) {
            return "";
        }
        String fieldName = focusRow == 2 ? focusFieldJson.getString("fieldcontent") : focusFieldJson.getString("fieldname");
        return StringUtils.isBlank((CharSequence)focusField) ? "" : focusField + "#" + fieldName;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        JSONObject fieldStyleMap = this.getAllStyleCacheByEntityNum();
        FieldStyle fieldStyle = this.getFieldStyleCache(fieldStyleMap);
        String key = propertyChangedArgs.getProperty().getName();
        if ("fontfamily".equals(key) && this.getModel().getValue("fontfamily") != null) {
            fieldStyle.setFontFamily(this.getModel().getValue("fontfamily").toString());
        } else if ("fontsize".equals(key) && this.getModel().getValue("fontsize") != null) {
            fieldStyle.setFontSize(this.getModel().getValue("fontsize").toString());
        }
        this.putFieldStyleCache(fieldStyle, fieldStyleMap);
        this.setValueGlobalFieldStyle();
    }

    private FieldStyle getFieldStyleCache(JSONObject fieldStyleMap) {
        String fieldContentKey;
        AbstractGrid.GridState gridState = ((ReportList)this.getControl("reportlistap")).getEntryState();
        String focusField = gridState.getFocusField();
        int focusRow = gridState.getFocusRow();
        if (StringUtils.isBlank((CharSequence)focusField)) {
            return new FieldStyle();
        }
        String string = fieldContentKey = focusRow == 2 ? "content" : "header";
        if (fieldStyleMap.get((Object)focusField) == null) {
            return new FieldStyle();
        }
        if (fieldStyleMap.getJSONObject(focusField).get((Object)fieldContentKey) == null) {
            return new FieldStyle();
        }
        return (FieldStyle)JSONObject.parseObject((String)fieldStyleMap.getJSONObject(focusField).getString(fieldContentKey), (TypeReference)new TypeReference<FieldStyle>(){}, (Feature[])new Feature[0]);
    }

    private JSONObject getAllStyleCacheByEntityNum() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        JSONObject fieldStyleMap = this.getPageCache().get(customParam) == null ? new JSONObject() : JSONObject.parseObject((String)this.getPageCache().get(customParam));
        return fieldStyleMap;
    }

    private void handleFieldContent() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject fields = (JSONObject)customParams.get("fields");
        HashMap numberToContent = new HashMap(fields.size());
        HashMap numberToName = new HashMap(fields.size());
        fields.forEach((key1, jsonValue) -> {
            if (jsonValue instanceof JSONObject) {
                String key = ((JSONObject)jsonValue).getString("fieldname");
                if (key == null) {
                    key = " ";
                }
                ((JSONObject)jsonValue).putIfAbsent((Object)"fieldcontent", (Object)key.concat(ResManager.loadKDString((String)"\u5185\u5bb9", (String)"FieldStyleReportFormPlugin_1", (String)"hrmp-hies-import", (Object[])new Object[0])));
                numberToContent.put(key1, ((JSONObject)jsonValue).getString("fieldcontent"));
                numberToName.put(key1, key);
            }
        });
        this.getPageCache().put("numberToContent", JSONObject.toJSONString(numberToContent));
        this.getPageCache().put("numberToName", JSONObject.toJSONString(numberToName));
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        queryParam.setCustomParam((Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        if (event.getActionId().equals(GROUP_NAME_CLOSECALLBACK)) {
            Map returnData = (Map)event.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)returnData.get("data")))) {
                Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
                Map mergeFieldToGroupName = (Map)JSONObject.parseObject((String)customParams.get("fieldmerge").toString(), LinkedHashMap.class);
                mergeFieldToGroupName.put(mergeFieldToGroupName.keySet().toArray(new String[0])[Integer.parseInt((String)returnData.get("index"))], returnData.get("data"));
                customParams.put("fieldmerge", JSONObject.toJSONString((Object)mergeFieldToGroupName));
                this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
                this.getView().refresh();
                this.sendDataToCusControl("refresh");
            }
        } else if (event.getActionId().equals(BEFORE_GROUP_NAME_CLOSECALLBACK)) {
            Map returnData = (Map)event.getReturnData();
            String data = StringUtils.isNotBlank((CharSequence)((CharSequence)returnData.get("data"))) ? (String)returnData.get("data") : ResManager.loadKDString((String)"\u8868\u5934\u540d\u79f0", (String)"FieldStyleReportListDataPlugin_2", (String)"hrmp-hies-import", (Object[])new Object[0]);
            Map mergeFieldToGroupName = new LinkedHashMap();
            Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
            Object mergeFieldsObject = customParams.get("fieldmerge");
            if (Objects.nonNull(mergeFieldsObject)) {
                mergeFieldToGroupName = (Map)JSONObject.parseObject((String)customParams.get("fieldmerge").toString(), LinkedHashMap.class);
            }
            mergeFieldToGroupName.put(returnData.get("mergeFields"), data);
            if (mergeFieldToGroupName.size() > 1) {
                String entityNumber = (String)customParams.get("entityNumber");
                JSONObject fields = (JSONObject)customParams.get("fields");
                List<String> storedField = this.getStoredFields(entityNumber, fields);
                Set mergeFieldToGroupNameKeys = mergeFieldToGroupName.keySet();
                LinkedHashMap mergeFieldToGroupNameTemp = new LinkedHashMap();
                Map finalMergeFieldToGroupName = mergeFieldToGroupName;
                storedField.stream().map(field -> mergeFieldToGroupNameKeys.stream().filter(key -> key.startsWith((String)field)).findAny()).forEach(any -> {
                    if (any.isPresent()) {
                        String key = (String)any.get();
                        mergeFieldToGroupNameTemp.put(key, finalMergeFieldToGroupName.get(key));
                    }
                });
                mergeFieldToGroupName.clear();
                mergeFieldToGroupName.putAll(mergeFieldToGroupNameTemp);
            }
            customParams.put("fieldmerge", JSONObject.toJSONString(mergeFieldToGroupName));
            this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
            LOGGER.info("FieldStyleReportFormPlugin.closedCallBack(),beforeGroupName_closeCallBack:{}", (Object)customParams);
            this.putFieldStyleCache(null, this.getAllStyleCacheByEntityNum());
            this.hideButton(customParams);
            this.getView().refresh();
            this.sendDataToCusControl("initDblClickEvent");
        } else {
            this.colorChooseCallBack(event);
        }
    }

    private void colorChooseCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        String colorvalue = (String)returnData.get("colorvalue");
        int transparency = Integer.parseInt((String)returnData.get("transparency"));
        float temp = (float)(255 * transparency) * 1.0f / 100.0f;
        int round = Math.round(temp);
        String hexString = Integer.toHexString(round);
        String customStyles = "{\"type\":0,\"content\":\"$ { border-bottom: 3px solid " + colorvalue + hexString + ";}\"}";
        if (event.getActionId().equals("foregroundcolor")) {
            this.getPageCache().put("curFontColor", colorvalue + hexString);
        } else {
            this.getPageCache().put("curBDColor", colorvalue + hexString);
        }
        String cacheKey = this.getCacheKey();
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            return;
        }
        HashMap<String, String> ctl = new HashMap<String, String>();
        ctl.put("cstyles", this.encoder.encodeToString(customStyles.getBytes(StandardCharsets.UTF_8)));
        this.getView().updateControlMetadata(event.getActionId(), ctl);
        JSONObject fieldStyleMap = this.getAllStyleCacheByEntityNum();
        FieldStyle fieldStyle = this.getFieldStyleCache(fieldStyleMap);
        if (event.getActionId().equals("foregroundcolor")) {
            fieldStyle.setColor(colorvalue + hexString);
        } else {
            fieldStyle.setBackgroundColor(colorvalue + hexString);
        }
        this.putFieldStyleCache(fieldStyle, fieldStyleMap);
        this.setValueGlobalFieldStyle();
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        try {
            String data = customEventArgs.getEventArgs();
            String eventName = customEventArgs.getEventName();
            LOGGER.info("FieldStyleReportFormPlugin_customEvent(),eventName:{},data:{}", (Object)eventName, (Object)data);
            switch (eventName) {
                case "mergeClick": {
                    this.mergeFields(data);
                    break;
                }
                case "cancelMergeClick": {
                    this.cancelMergeFields(data);
                    break;
                }
                case "editGroupName": {
                    this.showGroupNamedPage(data, GROUP_NAME_CLOSECALLBACK, "");
                    break;
                }
                case "fieldMove": {
                    this.moveColumn(data);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("FieldStyleReportFormPlugin_customEvent() error:", (Throwable)exception);
            this.showFieldMoveError();
        }
    }

    private void showGroupNamedPage(String index, String actionId, String mergeFields) {
        String[] split = index.split("#");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_fieldmergenameedit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("index", (Object)split[0]);
        showParameter.setCustomParam("value", (Object)(split.length > 1 ? split[1] : ""));
        showParameter.setCustomParam("mergeFields", (Object)mergeFields);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(showParameter);
    }

    private void cancelMergeFields(String data) {
        Optional<String> first;
        Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
        Map mergeFieldToGroupName = (Map)JSONObject.parseObject((String)customParams.get("fieldmerge").toString(), LinkedHashMap.class);
        if (mergeFieldToGroupName != null && (first = mergeFieldToGroupName.keySet().stream().filter(field -> field.contains(data)).findFirst()).isPresent()) {
            mergeFieldToGroupName.remove(first.get());
            customParams.put("fieldmerge", JSONObject.toJSONString((Object)mergeFieldToGroupName));
            this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
            this.putFieldStyleCache(null, this.getAllStyleCacheByEntityNum());
            this.hideButton(customParams);
            this.getView().refresh();
        }
    }

    private void mergeFields(String mergeFields) {
        if (!mergeFields.contains(",")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5408\u5e76\u7684\u5b57\u6bb5\uff0c\u5e76\u4e14\u5408\u5e76\u5b57\u6bb5\u4e2a\u6570\u4e0d\u80fd\u5c11\u4e8e1\u3002", (String)"FieldStyleReportFormPlugin_2", (String)"hrmp-hies-import", (Object[])new Object[0]));
        } else {
            Map customParam = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
            Object mergeFieldsObject = customParam.get("fieldmerge");
            Map mergeFieldToGroupName = new LinkedHashMap();
            if (Objects.nonNull(mergeFieldsObject)) {
                mergeFieldToGroupName = (Map)JSONObject.parseObject((String)customParam.get("fieldmerge").toString(), LinkedHashMap.class);
            }
            Optional<String> first = mergeFieldToGroupName.keySet().stream().filter(field -> Arrays.stream(mergeFields.split(",")).anyMatch(key -> ",".concat((String)field).concat(",").indexOf(",".concat((String)key).concat(",")) > 0)).findFirst();
            LOGGER.info("FieldStyleReportFormPlugin_mergeFields() mergeFieldToGroupName:{},mergeFields:{},exists:{}", new Object[]{mergeFieldToGroupName, mergeFields, first.isPresent()});
            if (!first.isPresent() && !mergeFields.startsWith("header,")) {
                this.showGroupNamedPage("", BEFORE_GROUP_NAME_CLOSECALLBACK, mergeFields);
            }
        }
    }

    private void sendDataToCusControl(String actionKey) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tabKey", "tab_" + entityNumber);
        map.put("actionKey", actionKey);
        map.put("date", System.currentTimeMillis());
        CustomControl fieldstyle = (CustomControl)this.getControl("fieldstyle");
        fieldstyle.setData(map);
    }

    private void showFieldMoveError() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u79fb\u52a8\u51fa\u73b0\u9519\u8bef\uff0c\u5df2\u81ea\u52a8\u5237\u65b0\u9875\u9762\u3002", (String)"FieldStyleReportFormPlugin_3", (String)"hrmp-hies-import", (Object[])new Object[0]));
        this.getView().updateView();
    }

    private void moveColumn(String data) {
        String[] split = data.split(",");
        String beforeFieldKey = split[0];
        String filedKey = split[1];
        String afterFieldKey = split[2];
        Map customParams = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
        String entityNumber = (String)customParams.get("entityNumber");
        JSONObject fields = (JSONObject)customParams.get("fields");
        List<String> storedFieldOld = this.getStoredFields(entityNumber, fields);
        LOGGER.info("FieldStyleReportFormPlugin.moveColumn() storedFieldOld:{}", storedFieldOld);
        int pid = fields.getJSONObject(filedKey).getIntValue("pid");
        int beforeFiePid = 0;
        if (StringUtils.isNotBlank((CharSequence)beforeFieldKey)) {
            beforeFiePid = fields.getJSONObject(beforeFieldKey).getIntValue("pid");
        }
        int afterFiePid = 0;
        if (StringUtils.isNotBlank((CharSequence)afterFieldKey)) {
            afterFiePid = fields.getJSONObject(afterFieldKey).getIntValue("pid");
        }
        if (beforeFiePid != pid && afterFiePid != pid) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u5b57\u6bb5\u4e0d\u80fd\u79fb\u52a8\u5230\u5355\u636e\u5934\u5b57\u6bb5\u4e4b\u524d\uff0c\u591a\u4e2a\u5206\u5f55\u4e4b\u95f4\u7684\u5b57\u6bb5\u4e0d\u80fd\u76f8\u4e92\u79fb\u52a8\u3002", (String)"FieldStyleReportFormPlugin_4", (String)"hrmp-hies-import", (Object[])new Object[0]));
        } else {
            storedFieldOld.remove(filedKey);
            if (StringUtils.isBlank((CharSequence)afterFieldKey)) {
                storedFieldOld.add(filedKey);
            } else {
                storedFieldOld.add(storedFieldOld.indexOf(afterFieldKey), filedKey);
            }
            for (int ordinal = 0; ordinal < storedFieldOld.size(); ++ordinal) {
                fields.getJSONObject(storedFieldOld.get(ordinal)).put("seq", (Object)(ordinal + 1));
            }
            this.getPageCache().put("customParams", JSONObject.toJSONString((Object)customParams));
            String fieldOrder = JSON.toJSONString(storedFieldOld);
            this.getPageCache().put(entityNumber + "#order", fieldOrder);
            LOGGER.info("FieldStyleReportFormPlugin_moveColumn(),entityNumber:{},order:{}", (Object)entityNumber, (Object)fieldOrder);
            Map customParam = (Map)JSONObject.parseObject((String)this.getPageCache().get("customParams"), Map.class);
            Object mergeFieldsObject = customParam.get("fieldmerge");
            if (Objects.nonNull(mergeFieldsObject)) {
                this.getView().refresh();
            }
        }
    }

    private List<String> getStoredFields(String entityNumber, JSONObject fields) {
        List storedField = JSONObject.parseArray((String)this.getPageCache().get(entityNumber + "#order"), String.class);
        if (storedField == null) {
            storedField = fields.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((JSONObject)entry.getValue()).getIntValue("seq"))).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return storedField;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        if (!"header".equals(cellClickEvent.getFieldKey())) {
            FieldStyle fieldStyleCache = this.getFieldStyleCache(this.getAllStyleCacheByEntityNum());
            this.getModel().setValue("fontfamily", (Object)fieldStyleCache.getFontFamily());
            this.getModel().setValue("fontsize", (Object)fieldStyleCache.getFontSize());
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

