/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.hr.hies.common.util.HIESUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DefaultExportPluginService {
    private static String[] hismodelPlugins = new String[]{"kd.hr.hies.formplugin.HisModelComHRExptPlugin"};
    private static final String[] odcFilterPlugins = new String[]{"kd.hr.hies.formplugin.odc.filter.OdcFilterExportPlugin"};
    private static final String[] odcFilterEntityIds = new String[]{"haos_adminorghr", "hbpm_positionhr", "hbpm_stposition", "hbjm_jobgradehr", "hbjm_joblevelhr", "hbjm_jobhr"};

    public static List<String> getDefaultPlugins(List<String> entitys) {
        List collect;
        LinkedList<String> list = new LinkedList<String>();
        if (CollectionUtils.isEmpty(entitys)) {
            return list;
        }
        for (String entity : entitys) {
            if (!HIESUtil.needLoadHisModelPlugin((String)entity)) continue;
            collect = Arrays.stream(hismodelPlugins).collect(Collectors.toList());
            list.addAll(collect);
        }
        for (String entity : entitys) {
            if (!HIESUtil.needLoadOdcFilterPlugin((String)entity, Arrays.asList(odcFilterEntityIds))) continue;
            collect = Arrays.stream(odcFilterPlugins).collect(Collectors.toList());
            list.addAll(collect);
        }
        return list;
    }
}

