/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.param.CustomParam;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.plugin.BeforeQueryPrimaryKeysEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.lang3.StringUtils;

public class ExportListHelper {
    private final BillList billList;
    private final IFormView parentView;
    private final String mainFormId;
    private ExportStart exportStart;
    private ExportContext exportContext;

    public ExportListHelper(ExportStart exportStart) {
        this.exportStart = exportStart;
        this.exportContext = exportStart.getExportContext();
        this.billList = this.exportContext.getBillList();
        this.parentView = this.exportContext.getFormView();
        this.mainFormId = this.exportContext.getMainFormId();
    }

    public List<Object> getAllPkIds() {
        List<Object> allPkids = new LinkedList();
        QueryBuilder qb = this.getListQueryBuilder();
        if ("Filter".equalsIgnoreCase(this.exportContext.getExportType())) {
            BeforeQueryPrimaryKeysEventArgs args = new BeforeQueryPrimaryKeysEventArgs(this.exportContext);
            args.setOrderby(qb.getOrderBys());
            args.setqFilters(qb.getFilters());
            UserExportPluginEngine.fireUserPluginEvent(this.exportStart, "beforeQueryPrimaryKeys", (AbstractEventArgs)args);
            allPkids = StringUtils.isNotEmpty((CharSequence)this.exportContext.getQueryEntityId()) ? this.getAllPkidsByQueryEntityId(args.getqFilters(), args.getOrderby()) : QueryServiceHelper.queryPrimaryKeys((String)this.exportContext.getMainFormId(), (QFilter[])args.getqFilters(), (String)args.getOrderby(), (int)-1);
        } else if ("Select".equalsIgnoreCase(this.exportContext.getExportType()) && "Tpl".equalsIgnoreCase(this.exportContext.getExportModle())) {
            Object[] selectIdsArr = this.billList.getSelectedRows().getPrimaryKeyValues();
            long start = System.currentTimeMillis();
            allPkids = this.reSortByList(qb, selectIdsArr, this.billList.isSelectedAll());
            this.exportStart.getMonitor().addExpenseStatistics("reSortByList", (Long)(System.currentTimeMillis() - start), true);
        }
        return allPkids.stream().distinct().collect(Collectors.toList());
    }

    public QueryBuilder getListQueryBuilder() {
        FilterContainer filterContainer = (FilterContainer)this.parentView.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.refresh();
        }
        IListModel listModel = ((IListView)this.parentView).getListModel();
        listModel.setNeedKeyFields(true);
        listModel.setListFields(this.billList.getListFields());
        IListDataProvider provider = listModel.getProvider();
        FilterParameter filterParameter = this.billList.generalFilterParameter();
        QueryBuilder qb = QueryBuilderFactory.createQueryBuilder((IListDataProvider)provider, (int)0, (int)1, (boolean)provider.isCustomListDataProvider());
        qb.setFilters(filterParameter.getQFilters().toArray(new QFilter[0]));
        if (StringUtils.isNotBlank((CharSequence)filterParameter.getOrderBy())) {
            qb.setOrderBys(filterParameter.getOrderBy());
        }
        return qb;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<Object> getAllPkIdsForNotCurrentList() {
        BeforeQueryPrimaryKeysEventArgs args = new BeforeQueryPrimaryKeysEventArgs(this.exportContext);
        UserExportPluginEngine.fireUserPluginEvent(this.exportStart, "beforeQueryPrimaryKeys", (AbstractEventArgs)args);
        List allPkids = StringUtils.isNotEmpty((CharSequence)this.exportContext.getQueryEntityId()) ? this.getAllPkidsByQueryEntityId(args.getqFilters(), args.getOrderby()) : QueryServiceHelper.queryPrimaryKeys((String)this.exportContext.getMainFormId(), (QFilter[])args.getqFilters(), (String)args.getOrderby(), (int)-1);
        return allPkids.stream().distinct().collect(Collectors.toList());
    }

    private List<Object> getAllPkidsByQueryEntityId(QFilter[] filters, String orderBy) {
        LinkedList<Object> allPkids = new LinkedList<Object>();
        QueryEntityType entityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.exportContext.getQueryEntityId());
        DataSet queryDataSet = entityType.getQueryDataSet("id", filters, orderBy);
        while (queryDataSet.hasNext()) {
            Row next = queryDataSet.next();
            Object id = next.get("id");
            allPkids.add(id);
        }
        return allPkids;
    }

    private List<Object> reSortByList(QueryBuilder qb, Object[] selectIdsArr, boolean isSelectedAll) {
        if (selectIdsArr.length == 1) {
            return MethodUtil.arrayToList((Object[])selectIdsArr);
        }
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String maxExportDataSize = (String)customParameterFromCache.get("EXPORT_MAX_EXPORT_DATA_SIZE");
        if (!StringUtils.isNumeric((CharSequence)maxExportDataSize)) {
            maxExportDataSize = String.valueOf(10000000);
        }
        QFilter selectIdsQf = new QFilter("id", "in", (Object)selectIdsArr);
        LinkedList<QFilter> qFilters = MethodUtil.arrayToList((Object[])qb.getFilters());
        if (qFilters == null) {
            qFilters = new LinkedList<QFilter>();
        }
        qFilters.add(selectIdsQf);
        long start1 = System.currentTimeMillis();
        List allPkidsByOrder = StringUtils.isNotEmpty((CharSequence)this.exportContext.getQueryEntityId()) ? this.getAllPkidsByQueryEntityId(qFilters.toArray(new QFilter[0]), qb.getOrderBys()) : QueryServiceHelper.queryPrimaryKeys((String)this.exportContext.getMainFormId(), (QFilter[])qFilters.toArray(new QFilter[0]), (String)qb.getOrderBys(), (int)Integer.parseInt(maxExportDataSize));
        this.exportStart.getMonitor().addExpenseStatistics("reSortByList_query", (Long)(System.currentTimeMillis() - start1), true);
        if (isSelectedAll && selectIdsArr.length == allPkidsByOrder.size()) {
            return allPkidsByOrder;
        }
        AtomicInteger index = new AtomicInteger();
        HashMap map = Maps.newHashMapWithExpectedSize((int)allPkidsByOrder.size());
        allPkidsByOrder.forEach(id -> {
            map.put(id, index.get());
            index.getAndIncrement();
        });
        ArrayList<Object> selectedIds = new ArrayList<Object>(selectIdsArr.length);
        Collections.addAll(selectedIds, selectIdsArr);
        long start2 = System.currentTimeMillis();
        selectedIds.sort((o1, o2) -> {
            int io1 = (Integer)map.get(o1);
            int io2 = (Integer)map.get(o2);
            if (io1 != -1) {
                io1 = selectedIds.size() - io1;
            }
            if (io2 != -1) {
                io2 = selectedIds.size() - io2;
            }
            return io2 - io1;
        });
        this.exportStart.getMonitor().addExpenseStatistics("reSortByList_order", (Long)(System.currentTimeMillis() - start2), true);
        return selectedIds;
    }
}

