/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HRVirtualFieldService {
    private static final Log LOGGER = LogFactory.getLog(HRVirtualFieldService.class);

    public static HRComplexObjContext getHRComplexObjContext() {
        DynamicObject[] allFields;
        DynamicObject[] entityRelation;
        HRComplexObjContext context = new HRComplexObjContext();
        context.setIdType(DataTypeEnum.LONG);
        HRBaseServiceHelper helper0 = new HRBaseServiceHelper("hies_virobjjoinentity");
        HRBaseServiceHelper helper1 = new HRBaseServiceHelper("hies_virobjentityrel");
        HRBaseServiceHelper helper2 = new HRBaseServiceHelper("hies_virobjqueryfield");
        DynamicObject[] allEntity = helper0.loadDynamicObjectArray(null);
        HashMap tempMap = Maps.newHashMapWithExpectedSize((int)allEntity.length);
        for (DynamicObject entity : allEntity) {
            String entitynumber = entity.getString("entitynumber");
            String longnumber = entity.getString("longnumber");
            String type = entity.getString("type");
            if (type.equals("main")) {
                context.setEntityNumber(entitynumber);
                context.setEntityTable(HREntityHelper.getTableName((String)entitynumber));
            }
            tempMap.put(entitynumber, longnumber);
        }
        LinkedList<HRComplexObjJoinRelation> joinRelationList = new LinkedList<HRComplexObjJoinRelation>();
        for (DynamicObject dy : entityRelation = helper1.loadDynamicObjectArray(null)) {
            String entityid = dy.getString("entityid.entitynumber");
            String jointype = dy.getString("jointype");
            String joinentityid = dy.getString("joinentityid.entitynumber");
            HRComplexObjJoinRelation relation = new HRComplexObjJoinRelation();
            relation.setEntityNumber(entityid);
            relation.setEntityAlias(entityid);
            relation.setJoinType(jointype);
            relation.setRelEntityNumber(joinentityid);
            relation.setRelEntityAlias(joinentityid);
            relation.setRelEntityLongNumber((String)tempMap.get(joinentityid));
            LinkedList condition = new LinkedList();
            DynamicObjectCollection joinconditions = dy.getDynamicObjectCollection("joinconditions");
            joinconditions.forEach(item -> {
                String comparetype = item.getString("comparetype");
                String leftprop = item.getString("leftprop");
                String rightprop = item.getString("rightprop");
                String rightpropval = item.getString("rightpropval");
                String logictype = item.getString("logictype");
                String rightproptype = item.getString("rightproptype");
                HRComplexObjConditionRow row = new HRComplexObjConditionRow();
                row.setLeftItem(leftprop);
                row.setCompareOp(comparetype);
                row.setRightItem(StringUtils.isBlank((CharSequence)rightprop) ? rightpropval : rightprop);
                row.setLogicOp(logictype);
                row.setRightFieldItem("field".equals(rightproptype));
                condition.add(row);
            });
            relation.setCondition(condition);
            joinRelationList.add(relation);
            context.setJoinRelationList(joinRelationList);
        }
        LinkedList<HRComplexObjFieldInfo> complexObjFieldInfoList = new LinkedList<HRComplexObjFieldInfo>();
        HRComplexObjFieldInfo fieldInfo0 = new HRComplexObjFieldInfo();
        fieldInfo0.setFullPath("id");
        fieldInfo0.setAlias("id");
        fieldInfo0.setDataType(DataTypeEnum.of((String)"long"));
        fieldInfo0.setFieldType("1");
        complexObjFieldInfoList.add(fieldInfo0);
        for (DynamicObject field : allFields = helper2.loadDynamicObjectArray(null)) {
            String fieldnumber = field.getString("fieldnumber");
            String fieldalias = field.getString("fieldalias");
            String fieldpath = field.getString("fieldpath");
            String valuetype = field.getString("valuetype");
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo();
            fieldInfo.setFullPath(fieldpath);
            fieldInfo.setAlias(fieldalias);
            fieldInfo.setDataType(DataTypeEnum.of((String)valuetype));
            fieldInfo.setFieldType("1");
            complexObjFieldInfoList.add(fieldInfo);
        }
        context.setComplexObjFieldInfoList(complexObjFieldInfoList);
        return context;
    }

    public static Map<Object, Map<String, Object>> findRelateFieldDataByPerson(Set<Object> persionIds, String personType, HRComplexObjContext context, Map<Object, Object> personIdMap) {
        personIdMap.putAll(HRVirtualFieldService.transferPersonIds(persionIds, personType));
        context.setQfilterList(Collections.singletonList(new QFilter("id", "in", personIdMap.values())));
        ReportQueryService queryService = new ReportQueryService(context);
        List datas = queryService.queryMap();
        return HRVirtualFieldService.getHrPersonDataMap(datas);
    }

    private static Map<Object, Map<String, Object>> getHrPersonDataMap(List<Map<String, Object>> datas) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)datas.size());
        ArrayList repeatDatas = new ArrayList(datas.size());
        Map collect = datas.stream().collect(Collectors.groupingBy(item -> item.get("id"), Collectors.toList()));
        collect.forEach((key, value) -> {
            map.put(key, value.get(0));
            if (value.size() > 1) {
                repeatDatas.add(key);
            }
        });
        if (ObjectUtils.isNotEmpty(repeatDatas)) {
            LOGGER.warn("getHrPersonDataMap_repeatDatas:{}", repeatDatas);
        }
        return map;
    }

    private static Map<Object, Object> transferPersonIds(Set<Object> ids, String personType) {
        HashMap personIdMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        switch (personType) {
            case "hrpi_employee": {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_employee");
                DynamicObjectCollection collection = helper.queryOriginalCollection("person.id,id", new QFilter[]{new QFilter("id", "in", ids)});
                ids.clear();
                collection.forEach(item -> personIdMap.put(item.getLong("id"), item.getLong("person.id")));
                break;
            }
            case "hrpi_depemp": {
                HRBaseServiceHelper helper2 = new HRBaseServiceHelper("hrpi_depemp");
                DynamicObjectCollection collection2 = helper2.queryOriginalCollection("person.id,id", new QFilter[]{new QFilter("id", "in", ids)});
                ids.clear();
                collection2.forEach(item -> personIdMap.put(item.getLong("id"), item.getLong("person.id")));
                break;
            }
            case "hrpi_person": {
                ids.forEach(id -> personIdMap.put(id, id));
                break;
            }
        }
        return personIdMap;
    }
}

