/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business.template;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.VoucherNoListField;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.FormatFieldData;
import kd.bos.entity.list.FormatRowData;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.BigIntColumnDesc;
import kd.bos.entity.list.column.BooleanColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.list.column.IconColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.list.column.MulBaseDataColumnDesc;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.list.column.VoucherNoColumnDesc;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.list.ListColumnType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ListExportBillData;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.SensitiveFiledUtil;

public class ExportByListConvertWriteData {
    private static Log log = LogFactory.getLog(ExportByListConvertWriteData.class);
    private static int DecimalValueIndex = 1;
    private static int DateTimeValueIndex = 0;
    private static int ExtendColTypeIndex = 0;
    private static Pattern IgnoreStringPattern = Pattern.compile("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]");
    private WriteDataByListContext context;
    private ListExportBillData data;

    public ExportByListConvertWriteData(ListExportBillData data, WriteDataByListContext context) {
        this.context = context;
        this.data = data;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<List<Object>> formatRows() {
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        Set<String> zeroShow = this.context.getZeroShow();
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        List formatRowDatas = this.data.getRows().getFormatRowDatas();
        Map<String, ListField> fieldMapping = this.data.getFieldMapping();
        boolean stripTrailingZeros = this.context.isStripTrailingZeros();
        int i = 0;
        FormatObject format = this.context.getFormat();
        String mainOrg = exportContext.getMainEntityType().getMainOrg();
        long mainOrgId = 0L;
        for (DynamicObject row : this.data.getRows().getCollection()) {
            NumberFormatProvider numFormat = this.data.getRows().getNumberFormatProvider();
            if (StringUtils.isNotBlank((CharSequence)mainOrg) && this.containsMainOrg(mainOrg, row)) {
                mainOrgId = (Long)row.getDynamicObject(mainOrg).getPkValue();
            }
            FieldControlRule fieldControlRule = SensitiveFiledUtil.getFieldControlRule((long)mainOrgId, (FieldControlRules)this.context.getFieldControlRules());
            LinkedList<Object> rowData = new LinkedList<Object>();
            for (KeyValue kv : this.context.getFieldCaptions()) {
                ListField listField = fieldMapping.get(kv.key);
                if (listField == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.VoucherNo.getValue()) {
                    listField = fieldMapping.get("$vouchernolistcolumn$");
                }
                Object value = null;
                if (listField == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.DynamicTextList.getValue()) {
                    value = "";
                } else if (listField instanceof DynamicTextListField) {
                    String formatExp = ((DynamicTextListField)listField).getFormatExpression();
                    value = ExportByListConvertWriteData.formatDynamicTextListColumn(exportContext.getMainEntityType(), formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i, formatExp, stripTrailingZeros);
                } else if (listField != null) {
                    value = ExportByListConvertWriteData.formatNormalColumn(exportContext.getMainEntityType(), formatRowDatas, format, numFormat, zeroShow, kv, listField, row, i, stripTrailingZeros);
                } else {
                    if (!(kv.value instanceof KeyValue)) continue;
                    value = ExportByListConvertWriteData.formatComplexColumn(exportContext.getMainEntityType(), formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i, stripTrailingZeros);
                }
                if (value instanceof String) {
                    value = IgnoreStringPattern.matcher((CharSequence)value).replaceAll("");
                }
                boolean canExport = SensitiveFiledUtil.isCanExport((FieldControlRule)fieldControlRule, (String)kv.key.split("\\.")[0]);
                value = SensitiveFiledUtil.tryDeSensitiveValue((DynamicObject)row, (KeyValue)kv, (ListField)listField, (Object)value, (boolean)canExport, (SensitiveArgs)this.context.getSensitiveArgs(), (String)exportContext.getMainFormId());
                value = this.canFillParent(exportContext.getMainEntityType(), kv, listField, row, value, fieldMapping);
                this.fillRowData(rowData, value);
            }
            dataRows.add(rowData);
            ++i;
            this.addIdSets(exportContext.getMainEntityType(), row);
            if (!this.context.isFileFirstRow()) continue;
            this.context.setFileFirstRow(false);
        }
        log.info("ExportByListConvertWriteData.formatRows()_collection_objectId:{}", (Object)System.identityHashCode(this.data.getRows().getCollection()));
        log.info("ExportByListConvertWriteData.formatRows()_dataRows:{},formatRowDatas:{},collection:{}", new Object[]{dataRows.size(), formatRowDatas.size(), this.data.getRows().getCollection().size()});
        return dataRows;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addIdSets(MainEntityType listEntityType, DynamicObject row) {
        if (this.context.getExportStart().getExportContext().isFillParent()) {
            return;
        }
        Map allEntities = listEntityType.getAllEntities();
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            if (entityTypeEntry.getValue() instanceof SubEntryType) continue;
            if (entityTypeEntry.getValue() instanceof EntryType) {
                String pkName = ((EntityType)entityTypeEntry.getValue()).getName() + "." + ((EntityType)entityTypeEntry.getValue()).getPrimaryKey().getName();
                if (null == row.getDataEntityType().getProperties().get((Object)pkName)) continue;
                this.addIdSet(((EntityType)entityTypeEntry.getValue()).getName(), row.get(pkName));
                continue;
            }
            if (row.getPkValue() == null) continue;
            this.addIdSet(((EntityType)entityTypeEntry.getValue()).getName(), row.getPkValue());
        }
    }

    private void addIdSet(String entityName, Object id) {
        this.context.getIdSetMap().computeIfAbsent(entityName, s -> new HashSet()).add(id);
    }

    @ExcludeFromJacocoGeneratedReport
    private void fillRowData(List<Object> rowData, Object value) {
        if (SensitiveFiledUtil.isInstanceofList((Object)value)) {
            rowData.addAll((List)value);
            return;
        }
        rowData.add(value);
    }

    @ExcludeFromJacocoGeneratedReport
    private Object canFillParent(MainEntityType mainEntityType, KeyValue kv, ListField listField, DynamicObject row, Object value, Map<String, ListField> fieldMapping) {
        try {
            boolean existParentRow;
            if (this.context.getExportStart().getExportContext().isFillParent() || "seq".equals(kv.key) || "fseq".equals(kv.key) || listField instanceof VoucherNoListField) {
                return value;
            }
            if (kv.value instanceof KeyValue) {
                for (int i = 0; i < ((List)((KeyValue)kv.value).value).size(); ++i) {
                    boolean isList = value instanceof List;
                    Object tmpVal = isList ? (value.getClass().getName().equals("java.util.Collections$SingletonList") ? ((List)value).get(0) : ((List)value).get(i)) : value;
                    Object obj = this.canFillParent(mainEntityType, (KeyValue)((List)((KeyValue)kv.value).value).get(i), fieldMapping.get(((KeyValue)((List)((KeyValue)kv.value).value).get((int)i)).key), row, tmpVal, fieldMapping);
                    if (isList) {
                        if (value.getClass().getName().equals("java.util.Collections$SingletonList")) {
                            value = Collections.singletonList(obj);
                            continue;
                        }
                        ((List)value).set(i, obj);
                        continue;
                    }
                    value = obj;
                }
            }
            if (null != listField && !(listField instanceof DynamicTextListField) && (existParentRow = this.existParentRow(mainEntityType, listField, row))) {
                value = "";
            }
        }
        catch (Throwable e) {
            log.error(e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)HiesExportRes.ExportByListConvertWriteData_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), new Object[0]));
        }
        return value;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean existParentRow(MainEntityType mainEntityType, ListField listField, DynamicObject row) {
        if (this.context.isFileFirstRow()) {
            return false;
        }
        Map<String, Set<Object>> idSetMap = this.context.getIdSetMap();
        if (!(!listField.isSeq() && !(listField.getSrcFieldProp().getParent() instanceof BillEntityType) || idSetMap.get(mainEntityType.getName()) != null && idSetMap.get(mainEntityType.getName()).contains(row.getPkValue()))) {
            return false;
        }
        if (listField.getSrcFieldProp().getParent() instanceof SubEntryType) {
            return false;
        }
        if (listField.getSrcFieldProp().getParent() instanceof EntryType) {
            String name = listField.getSrcFieldProp().getParent().getName();
            Object id = row.get(listField.getSrcFieldProp().getParent().getName() + "." + listField.getSrcFieldProp().getParent().getPrimaryKey().getName());
            if (idSetMap.get(name) == null || !idSetMap.get(name).contains(id)) {
                return false;
            }
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<Object> formatComplexColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i, boolean stripTrailingZeros) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (KeyValue k : (List)((KeyValue)kv.value).value) {
            Object object = ExportByListConvertWriteData.getDynamicText(listEntityType, formatRowDatas, format, numFormat, zeroShow, k, fieldMapping, row, i, stripTrailingZeros);
            if (object != null) {
                values.add(object);
                continue;
            }
            if (k.value instanceof KeyValue) {
                List<Object> subValues = ExportByListConvertWriteData.formatComplexColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, k, fieldMapping, row, i, stripTrailingZeros);
                values.addAll(subValues);
                continue;
            }
            ExportByListConvertWriteData.convertValue(listEntityType, formatRowDatas, format, numFormat, k, row, fieldMapping, values, zeroShow, i, stripTrailingZeros);
        }
        if (kv.extend != null && ListColumnType.MergeColumn.getValue() == ((Integer)kv.extend[ExtendColTypeIndex]).intValue()) {
            StringBuilder sb = new StringBuilder();
            for (Object e : values) {
                if (!StringUtils.isNotBlank(e)) continue;
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(e);
            }
            return Collections.singletonList(sb.toString());
        }
        return values;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void convertValue(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, KeyValue k, DynamicObject row, Map<String, ListField> fieldMapping, List<Object> values, Set<String> zeroShow, int i, boolean stripTrailingZeros) {
        ListField listField = fieldMapping.get(k.key);
        if (listField == null) {
            return;
        }
        AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), SensitiveFiledUtil.isSpecialFormat((ListField)listField));
        columnDesc.setUserFormat(format);
        Object value = ExportByListConvertWriteData.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(k.key), stripTrailingZeros);
        if (value != null) {
            value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)listField, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
            values.add(value);
            return;
        }
        value = formatRowDatas.get(i).get(k.key).getFieldValue();
        if (StringUtils.isBlank((Object)value)) {
            value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)listField, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
            values.add(value);
            return;
        }
        if (columnDesc instanceof BaseDataColumnDesc) {
            columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
        }
        if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
            if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                value = ((Object[])value)[DecimalValueIndex];
            }
            if (StringUtils.isNotBlank((Object)value) && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(k.key)) {
                value = null;
            }
        } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
            value = ((Object[])value)[DateTimeValueIndex];
        }
        value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)listField, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
        values.add(value);
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatExportValue(DynamicObject dr, AbstractColumnDesc col, NumberFormatProvider numberFormatProvider, boolean zeroShow, boolean stripTrailingZeros) {
        Object value = col.getValue(dr);
        if (value != null) {
            if (col instanceof FlexColumnDesc) {
                FlexColumnDesc flexColumnDesc = (FlexColumnDesc)col;
                List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dr, (FlexProp)((FlexProp)flexColumnDesc.getFieldProp()), (String)flexColumnDesc.getBasePropKey());
                ArrayList<String> displayValues = new ArrayList<String>();
                for (Map item : flexValues) {
                    String alias = (String)item.get("alias");
                    if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                    displayValues.add(alias);
                }
                value = String.join((CharSequence)"; ", displayValues);
            } else if (col instanceof ComboColumnDesc) {
                value = ExportByListConvertWriteData.formatComboItems((ComboColumnDesc)col, value);
            } else if (col instanceof TimeColumnDesc) {
                if (((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            } else if (col instanceof DecimalColumnDesc || col instanceof AmountColumnDesc || col instanceof BigIntColumnDesc || col instanceof IntegerColumnDesc) {
                if (value instanceof Object[] && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[DecimalValueIndex];
                }
                if (StringUtils.isNotBlank((Object)value)) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    if (!zeroShow && BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                        value = "";
                    } else if (numberFormatProvider != null) {
                        NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(((ColumnDesc)col).getFieldProp().getName(), dr);
                        if (numberPrecision != null) {
                            boolean groupingUsed = numberPrecision.isGroupingUsed();
                            numberPrecision.setGroupingUsed(false);
                            String numberString = numberPrecision.toString();
                            if (!ExportByListConvertWriteData.isDecimalTooBig(numberString)) {
                                int currLen = numberString.length();
                                if (stripTrailingZeros) {
                                    numberPrecision.setResult(new BigDecimal(numberString));
                                    numberPrecision.setStripTrailingZeros(stripTrailingZeros);
                                    int diffPrecision = currLen - numberString.length();
                                    numberPrecision.setPrecision(numberPrecision.getPrecision() - diffPrecision);
                                }
                                numberPrecision.setGroupingUsed(groupingUsed);
                                value = numberPrecision;
                            } else if (numberPrecision.getResult().compareTo(new BigDecimal(value.toString())) == 0) {
                                numberPrecision.setStripTrailingZeros(stripTrailingZeros);
                                value = numberString;
                            }
                        }
                    } else if (stripTrailingZeros) {
                        value = new BigDecimal(bigDecimal.stripTrailingZeros().toPlainString());
                    }
                }
            } else if (col instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                if (((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            } else if (col instanceof IconColumnDesc || col instanceof ColumnDesc && ((ColumnDesc)col).getSrcFieldProp() instanceof PictureProp) {
                value = "";
            } else if (col instanceof BooleanColumnDesc) {
                value = ExportByListConvertWriteData.formatBooleanColumn((BooleanColumnDesc)col, value);
            } else if (col instanceof BaseDataColumnDesc) {
                HashMap<String, Object> mapTemp = new HashMap<String, Object>();
                Map<String, Object> lastDynamicObjectAndColumnDesc = ExportByListConvertWriteData.getLastDynamicObject(col, dr, mapTemp);
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)lastDynamicObjectAndColumnDesc.get("columnDesc");
                col = (AbstractColumnDesc)lastDynamicObjectAndColumnDesc.get("col");
                dr = (DynamicObject)lastDynamicObjectAndColumnDesc.get("dr");
                if (columnDesc instanceof ComboColumnDesc) {
                    value = ExportByListConvertWriteData.formatComboItems((ComboColumnDesc)columnDesc, value);
                }
                if (columnDesc instanceof BooleanColumnDesc) {
                    value = ExportByListConvertWriteData.formatBooleanColumn((BooleanColumnDesc)columnDesc, value);
                } else if (columnDesc instanceof ColumnDesc && ((ColumnDesc)columnDesc).getSrcFieldProp() instanceof PictureProp) {
                    value = "";
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                    if (((Object[])value).length >= 2) {
                        value = ((Object[])value)[DateTimeValueIndex];
                    }
                } else if (columnDesc instanceof NumberColumnDesc) {
                    if (col instanceof MulBaseDataColumnDesc) {
                        DynamicObjectCollection basedataObjCol = (DynamicObjectCollection)((MulBaseDataColumnDesc)col).getFieldProp().getValue((Object)dr);
                        value = ExportByListConvertWriteData.formatMulBasedataNumberColumn((NumberColumnDesc)columnDesc, basedataObjCol, zeroShow);
                    } else {
                        DynamicObject basedataObj = (DynamicObject)((BaseDataColumnDesc)col).getFieldProp().getValue((Object)dr);
                        value = ExportByListConvertWriteData.formatBasedataNumberColumn((NumberColumnDesc)columnDesc, basedataObj, zeroShow);
                    }
                }
            }
        }
        return value;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatBasedataNumberColumn(NumberColumnDesc numberCol, DynamicObject dr, boolean zeroShow) {
        IDataEntityProperty prop = numberCol.getFieldProp();
        Object value = "";
        if (prop != null && dr != null) {
            value = prop.getValueFast((Object)dr);
        }
        if (StringUtils.isBlank((Object)value) || !zeroShow && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
            value = "";
        } else if ((value = numberCol.formatCell(dr, value, true)) instanceof Object[] && ((Object[])value).length >= 2) {
            value = ((Object[])value)[DecimalValueIndex];
        }
        return value;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatMulBasedataNumberColumn(NumberColumnDesc numberCol, DynamicObjectCollection basedataObjCol, boolean zeroShow) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < basedataObjCol.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)((DynamicObject)basedataObjCol.get(i)).get("fbasedataid");
            Object result = ExportByListConvertWriteData.formatBasedataNumberColumn(numberCol, dynamicObject, zeroShow);
            if (result instanceof Map) {
                result = ((Map)result).get("result");
            }
            valueBuilder.append(result).append(";");
        }
        if (valueBuilder.length() > 0) {
            valueBuilder = valueBuilder.deleteCharAt(valueBuilder.lastIndexOf(";"));
        }
        return valueBuilder.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<String, Object> getLastDynamicObject(AbstractColumnDesc col, DynamicObject dr, Map<String, Object> map) {
        AbstractColumnDesc columnDesc = ((BaseDataColumnDesc)col).getColumnDesc();
        map.put("dr", dr);
        map.put("col", col);
        map.put("columnDesc", columnDesc);
        Object drTmp = dr.get(((BaseDataColumnDesc)col).getFieldProp());
        if (columnDesc instanceof BaseDataColumnDesc && drTmp instanceof DynamicObject) {
            dr = (DynamicObject)dr.get(((BaseDataColumnDesc)col).getFieldProp());
            col = columnDesc;
            columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
            map.put("dr", dr);
            map.put("col", col);
            map.put("columnDesc", columnDesc);
            ExportByListConvertWriteData.getLastDynamicObject(col, dr, map);
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatBooleanColumn(BooleanColumnDesc columnDesc, Object value) {
        if (value instanceof Boolean) {
            Object xtitle;
            if ((long)columnDesc.getCheckBoxItemShowStyle() == 0L) {
                return Boolean.TRUE.equals(value) ? "\u221a" : "";
            }
            Object otitle = columnDesc.getOTitle();
            if (otitle == null) {
                otitle = ResManager.loadKDString((String)"\u662f", (String)HiesExportRes.ExportByListConvertWriteData_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
            }
            if ((xtitle = columnDesc.getXTitle()) == null) {
                xtitle = ResManager.loadKDString((String)"\u5426", (String)HiesExportRes.ExportByListConvertWriteData_3.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]);
            }
            return Boolean.TRUE.equals(value) ? otitle : xtitle;
        }
        return value;
    }

    public static boolean isDecimalTooBig(String decimalStr) {
        int i = decimalStr.lastIndexOf(46);
        int j = decimalStr.length();
        if (i >= 0) {
            --j;
            while (j > i && decimalStr.charAt(j) == '0') {
                --j;
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return "";
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatComboItems(ComboColumnDesc col, Object value) {
        ArrayList<String> desc = new ArrayList<String>();
        boolean isMulCombo = col.getComboProp() instanceof MulComboProp;
        for (ValueMapItem item : col.getComboProp().getComboItems()) {
            if (!(isMulCombo ? ((String)value).contains(item.getValue()) : item.getValue().equals(value))) continue;
            desc.add(item.getName().toString());
        }
        return !desc.isEmpty() ? String.join((CharSequence)" ", desc) : value;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object getDynamicText(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue keyValue, Map<String, ListField> fieldMapping, DynamicObject row, int i, boolean stripTrailingZeros) {
        if (fieldMapping.containsKey(keyValue.key) && fieldMapping.get(keyValue.key) instanceof DynamicTextListField) {
            String formatExp = ((DynamicTextListField)fieldMapping.get(keyValue.key)).getFormatExpression();
            Object dynamicText = ExportByListConvertWriteData.formatDynamicTextListColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, keyValue, fieldMapping, row, i, formatExp, stripTrailingZeros);
            return dynamicText;
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatNormalColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, ListField f, DynamicObject row, int i, boolean stripTrailingZeros) {
        AbstractColumnDesc columnDesc = null;
        try {
            columnDesc = f.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), SensitiveFiledUtil.isSpecialFormat((ListField)f));
        }
        catch (Throwable e) {
            log.info("ExportByListConvertWriteData.formatNormalColumn_columnDesc key:{},f.key:{}", (Object)kv.key, (Object)f.getKey());
            log.error(e);
            throw e;
        }
        columnDesc.setUserFormat(format);
        Object value = ExportByListConvertWriteData.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(kv.key), stripTrailingZeros);
        FormatRowData formatRow = formatRowDatas.get(i);
        if (formatRow != null) {
            Object fmtval;
            FormatFieldData formatData;
            if (columnDesc instanceof BaseDataColumnDesc) {
                columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
            }
            if ((formatData = formatRow.get(kv.key)) == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.VoucherNo.getValue()) {
                formatData = formatRow.get("$vouchernolistcolumn$");
            }
            Object object = fmtval = formatData != null ? formatData.getFieldValue() : null;
            if (!StringUtils.isBlank((Object)fmtval)) {
                if (columnDesc instanceof TimeColumnDesc) {
                    if (fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        value = ExportByListConvertWriteData.formatTimeStr((Integer)((Object[])fmtval)[1]);
                    }
                } else if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                    if (value == null && fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        value = ((Object[])fmtval)[DecimalValueIndex];
                    }
                } else if (columnDesc instanceof DateTimeColumnDesc && fmtval != null && fmtval.getClass().isArray()) {
                    if (fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        fmtval = ((Object[])fmtval)[DateTimeValueIndex];
                    }
                    value = fmtval;
                } else if (columnDesc instanceof VoucherNoColumnDesc || columnDesc instanceof TextColumnDesc || value == null) {
                    value = fmtval;
                }
            }
        }
        value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)f, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
        return value;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object formatDynamicTextListColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i, String formatExp, boolean stripTrailingZeros) {
        Object value = null;
        String v = formatExp == null ? "" : formatExp;
        for (KeyValue kValue : (List)((KeyValue)kv.value).value) {
            String key = kValue.key;
            ListField listField = fieldMapping.get(key);
            AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), SensitiveFiledUtil.isSpecialFormat((ListField)listField));
            columnDesc.setUserFormat(format);
            value = ExportByListConvertWriteData.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(key), stripTrailingZeros);
            if (value != null) {
                value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)listField, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
                v = v.replace(String.format("{%s}", key), value.toString());
                continue;
            }
            value = formatRowDatas.get(i).get(key).getFieldValue();
            if (StringUtils.isNotBlank((Object)value)) {
                if (columnDesc instanceof BaseDataColumnDesc) {
                    columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
                }
                if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                    if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                        value = ((Object[])value)[DecimalValueIndex];
                    }
                    if (value != null && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(kv.key)) {
                        value = null;
                    }
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            }
            value = SensitiveFiledUtil.checkAndToGetDesensitizeValue((ListField)listField, (Object)value, (DynamicObject)row, (String)listEntityType.getMainOrg());
            v = v.replace(String.format("{%s}", key), value != null ? value.toString() : "");
        }
        String key = kv.key;
        FormatRowData rowData = formatRowDatas.get(i);
        FormatFieldData formatFieldData = rowData.get(key);
        if (Objects.nonNull(formatFieldData) && StringUtils.isEmpty((CharSequence)v)) {
            v = String.valueOf(formatFieldData.getFieldValue());
        }
        return v;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean containsMainOrg(String mainOrg, DynamicObject row) {
        IDataEntityType dataEntityType = row.getDataEntityType();
        return dataEntityType.getProperties().containsKey((Object)mainOrg) && row.getDynamicObject(mainOrg) != null;
    }
}

