/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.AvatarListColumn;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListColumnType;
import kd.bos.list.ListFieldMeta;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MergeListColumn;
import kd.bos.list.SeqColumnType;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.VoucherNoListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.common.enu.HiesExportRes;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.ExcelStyleUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class ExportByListHeaderWriter {
    private static final Log log = LogFactory.getLog(ExportByListHeaderWriter.class);
    private static Pattern DotPattern = Pattern.compile("\\.");
    private static int ExtendColTypeIndex = 0;
    public static final int MAX_ROW_SIZE = 0x100000;
    private WriteDataByListContext context;
    private int totalOffset = 0;
    private int rowCount = 0;

    public ExportByListHeaderWriter(WriteDataByListContext context) {
        this.context = context;
    }

    public void createExcelHeader() {
        BillList billList = this.context.getExportStart().getExportContext().getBillListClone();
        HashSet<String> zeroShow = new HashSet<String>();
        Set<String> columns = this.prepareListColumns(billList);
        EntityType dataEntityType = billList.getListModel().getDataEntityType();
        if (this.context.getFieldCaptions() == null) {
            this.context.setFieldCaptions(this.prepareListHeader(billList, dataEntityType, columns, zeroShow, this.context.getExportStart().getExportContext().getFormView()));
            this.context.setZeroShow(zeroShow);
            KeyValue firstKeyValue = this.context.getFieldCaptions().get(0);
            if (firstKeyValue.key.equalsIgnoreCase("fseq") || firstKeyValue.key.equalsIgnoreCase("seq")) {
                this.context.setShowSeq(true);
            }
        }
        HashMap<Integer, Integer> cellSpanRow = new HashMap<Integer, Integer>();
        BeforeCreateHeaderColumnEventArgs args = new BeforeCreateHeaderColumnEventArgs(this.context.getExportStart().getExportContext());
        args.setFieldCaptions(this.context.getFieldCaptions());
        UserExportPluginEngine.fireUserPluginEvent(this.context.getExportStart(), "beforeCreateHeaderColumn", (AbstractEventArgs)args);
        log.info("getFieldCaptions().count=" + this.context.getFieldCaptions().size());
        this.createHeader(this.context.getFieldCaptions(), 0, cellSpanRow);
        for (Map.Entry entry : cellSpanRow.entrySet()) {
            int rowIndex = (Integer)entry.getValue();
            int col = (Integer)entry.getKey();
            if (this.rowCount - rowIndex <= 0) continue;
            this.mergedRowRegion(rowIndex, this.rowCount, col, col);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private int[] createHeader(List<KeyValue> captions, int rowIndex, Map<Integer, Integer> cellSpanRow) {
        KeyValue colInfo;
        int i;
        CellStyle cellStyle = ExcelStyleUtil.getByListExportCellStyle((SXSSFWorkbook)this.context.getWb());
        int[] span = new int[]{1, 0};
        HashMap<Integer, Integer> newCol = new HashMap<Integer, Integer>();
        for (i = 0; i < captions.size(); ++i) {
            colInfo = captions.get(i);
            if (!(colInfo.value instanceof KeyValue)) {
                newCol.put(i, this.totalOffset);
                this.creatHeaderCell((String)colInfo.value, colInfo.extend, rowIndex, cellStyle);
                ++this.totalOffset;
                span[1] = span[1] + 1;
                continue;
            }
            this.creatHeaderCell(((KeyValue)colInfo.value).key, colInfo.extend, rowIndex, cellStyle);
            if (colInfo.extend != null && (((Integer)colInfo.extend[0]).intValue() == ListColumnType.MergeColumn.getValue() || ((Integer)colInfo.extend[0]).intValue() == ListColumnType.DynamicTextList.getValue())) {
                newCol.put(i, this.totalOffset);
                ++this.totalOffset;
                span[1] = span[1] + 1;
                continue;
            }
            int col = this.totalOffset;
            int[] subSpan = this.createHeader((List)((KeyValue)colInfo.value).value, rowIndex + 1, cellSpanRow);
            if (span[0] < subSpan[0] + 1) {
                span[0] = subSpan[0] + 1;
            }
            span[1] = span[1] + subSpan[1];
            if (subSpan[1] <= 1) continue;
            this.mergedColRegion(rowIndex, rowIndex, col, col + Math.max(0, subSpan[1] - 1));
        }
        for (i = 0; i < captions.size(); ++i) {
            colInfo = captions.get(i);
            if (colInfo.value instanceof KeyValue && (colInfo.extend == null || ((Integer)colInfo.extend[0]).intValue() != ListColumnType.MergeColumn.getValue() && ((Integer)colInfo.extend[0]).intValue() != ListColumnType.DynamicTextList.getValue())) continue;
            cellSpanRow.put((Integer)newCol.get(i), rowIndex);
        }
        if (this.rowCount < rowIndex) {
            this.rowCount = rowIndex;
        }
        return span;
    }

    @ExcludeFromJacocoGeneratedReport
    private void mergedColRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        SXSSFSheet sheet = this.context.getSheet();
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cellRange);
        SXSSFCell cell = sheet.getRow(firstRow).getCell(firstCol);
        String val = cell.getStringCellValue();
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getCellStyle();
        cellStyle = cellStyle.copy();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        SXSSFRow row = this.getRow(sheet, lastRow);
        cell = row.createCell(firstCol);
        cell.setCellValue(val);
        cell.setCellStyle((CellStyle)cellStyle);
    }

    @ExcludeFromJacocoGeneratedReport
    private void mergedRowRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        SXSSFSheet sheet = this.context.getSheet();
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cellRange);
        SXSSFCell cell = sheet.getRow(firstRow).getCell(firstCol);
        String val = cell.getStringCellValue();
        CellStyle cellStyle = cell.getCellStyle();
        SXSSFRow row = this.getRow(sheet, lastRow);
        cell = row.createCell(firstCol);
        cell.setCellValue(val);
        cell.setCellStyle(cellStyle);
    }

    @ExcludeFromJacocoGeneratedReport
    private void creatHeaderCell(String caption, Object[] extend, int r, CellStyle cellStyle) {
        int colWidth = 0;
        String align = "default";
        if (extend != null && extend.length >= 3) {
            colWidth = (Integer)extend[1];
            if (extend[0].equals(3) && colWidth < 80) {
                colWidth = 80;
            }
            align = (String)extend[2];
        }
        if (ObjectUtils.isEmpty((Object)cellStyle)) {
            cellStyle = this.context.getStyles().getTitleStyle(align);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
        }
        SXSSFCell cell = this.createCell(this.context.getWb(), this.getRow(this.context.getSheet(), r), this.totalOffset, cellStyle);
        cell.setCellValue(caption);
        this.context.getSheet().setColumnWidth(this.totalOffset, Math.min(256 * Math.max(colWidth / 8, Math.max(caption.length(), 8)) * 2, 30720));
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        if (r >= 0x100000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)HiesExportRes.ExportByListHeaderWriter_1.resId(), (String)"hrmp-hies-export", (Object[])new Object[0]), 0x100000));
        }
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private Set<String> prepareListColumns(BillList billList) {
        HashSet<String> listColumns = new HashSet<String>();
        for (IListColumn col : billList.getShowListColumns()) {
            if (col instanceof ListOperationColumn) continue;
            if (col instanceof DynamicTextListColumn) {
                listColumns.add(((DynamicTextListColumn)col).getKey());
                continue;
            }
            listColumns.add(col.getListFieldKey());
        }
        return listColumns;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<KeyValue> prepareListHeader(BillList billList, EntityType entityType, Set<String> columns, Set<String> zeroShow, IFormView view) {
        String json = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)view.getFormShowParameter().getSettingKey());
        JSONObject settings = JSON.parseObject((String)json);
        Map<String, Boolean> userConfigColumnSettings = this.parseUserConfigColumnSettings(view);
        boolean hideSeq = billList.getListUserOption().isHideSeq();
        List containers = billList.getItems();
        Container gridView = null;
        String listGridViewKey = billList.getListGridViewKey();
        for (Control c : containers) {
            if (!c.getKey().equals(listGridViewKey)) continue;
            gridView = (Container)c;
        }
        ArrayList<KeyValue> fieldCaptions = new ArrayList<KeyValue>();
        if (null == gridView) {
            return fieldCaptions;
        }
        List items = gridView.getItems();
        LinkedHashMap<String, Control> pluginItems = new LinkedHashMap<String, Control>();
        BeforeCreateListColumnsArgs createColumns = billList.getBeforeCreateListColumnsArgs();
        if (createColumns != null) {
            for (IListColumn col : createColumns.getListColumns()) {
                if (col == null || col.getParent() != null && !col.getParent().getKey().equalsIgnoreCase(listGridViewKey)) continue;
                Control c = (Control)col;
                pluginItems.put(c.getKey(), c);
            }
            for (Control c : items) {
                pluginItems.remove(c.getKey());
            }
            items.addAll(pluginItems.values());
        }
        for (IListColumn col : gridView.getItems()) {
            KeyValue caption;
            List<KeyValue> captions;
            if (col instanceof ListOperationColumn) continue;
            if (col instanceof ListColumnGroup) {
                ListColumnGroup groupColumn = (ListColumnGroup)col;
                if (!ExportByListHeaderWriter.isListColumnVisible(entityType, userConfigColumnSettings, (Control)groupColumn) || (captions = ExportByListHeaderWriter.getContainerCaption(entityType, settings, userConfigColumnSettings, groupColumn.getItems(), columns, zeroShow, hideSeq)).isEmpty()) continue;
                int seq = ExportByListHeaderWriter.getListColumnGroupSeq(groupColumn);
                fieldCaptions.add(new KeyValue(groupColumn.getKey(), (Object)new KeyValue("" + groupColumn.getName(), captions, new Object[]{ListColumnType.ListColumnGroup.getValue()}, Integer.valueOf(seq)), new Object[]{ListColumnType.ListColumnGroup.getValue()}, Integer.valueOf(seq)));
                continue;
            }
            if (col instanceof MergeListColumn) {
                int mLen;
                JSONObject widthObj;
                MergeListColumn mergeColumn = (MergeListColumn)col;
                if (!ExportByListHeaderWriter.isListColumnVisible(entityType, userConfigColumnSettings, (Control)mergeColumn) || (captions = ExportByListHeaderWriter.getContainerCaption(entityType, settings, userConfigColumnSettings, mergeColumn.getItems(), null, zeroShow, hideSeq)).isEmpty()) continue;
                JSONObject jSONObject = widthObj = settings == null || mergeColumn.getParent() == null ? null : settings.getJSONObject(mergeColumn.getParent().getKey());
                if (widthObj != null) {
                    widthObj = widthObj.getJSONObject("cw");
                }
                int n = mLen = widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(mergeColumn.getListFieldKey()).replaceAll("_"));
                if (mLen == 0) {
                    for (KeyValue m : captions) {
                        if (!(m.value instanceof String)) continue;
                        mLen += ((String)m.value).length() * 16;
                    }
                }
                fieldCaptions.add(new KeyValue(mergeColumn.getListFieldKey(), (Object)new KeyValue("" + mergeColumn.getCaption(), captions, new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, Integer.valueOf(mergeColumn.getSeq())), new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, Integer.valueOf(mergeColumn.getSeq())));
                continue;
            }
            if (!(col instanceof IListColumn)) continue;
            String fieldKey = col.getListFieldKey();
            if (col instanceof DynamicTextListColumn) {
                fieldKey = col.getKey();
            }
            if (columns != null && !columns.contains(fieldKey) || (caption = ExportByListHeaderWriter.buildFieldCaption(entityType, col, settings, userConfigColumnSettings, zeroShow, hideSeq)) == null) continue;
            fieldCaptions.add(caption);
        }
        this.sort(fieldCaptions);
        return fieldCaptions;
    }

    private void sort(List<KeyValue> fieldCaptions) {
        fieldCaptions.sort((c1, c2) -> {
            if (c1.seq == null && c2.seq == null) {
                return 0;
            }
            if (c1.seq == null) {
                return 1;
            }
            if (c2.seq == null) {
                return -1;
            }
            return c1.seq.compareTo(c2.seq);
        });
        for (KeyValue sub : fieldCaptions) {
            Object subValue = sub.value;
            if (!(subValue instanceof KeyValue)) continue;
            KeyValue castKeyValue = (KeyValue)subValue;
            if (!(castKeyValue.value instanceof List) || sub.extend != null && ListColumnType.DynamicTextList.getValue() == ((Integer)sub.extend[ExtendColTypeIndex]).intValue()) continue;
            this.sort((List)castKeyValue.value);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static KeyValue buildFieldCaption(EntityType entityType, IListColumn listColumn, JSONObject settings, Map<String, Boolean> userConfigColumnSettings, Set<String> zeroShow, boolean hideSeq) {
        IDataEntityProperty prop;
        JSONObject widthObj;
        if (listColumn.getSeqColType() == SeqColumnType.EntitySeq && hideSeq || listColumn instanceof AvatarListColumn || !ExportByListHeaderWriter.isListColumnVisible(entityType, userConfigColumnSettings, (Control)listColumn)) {
            return null;
        }
        JSONObject jSONObject = widthObj = settings == null || listColumn.getParent() == null ? null : settings.getJSONObject(listColumn.getParent().getKey());
        if (widthObj != null) {
            widthObj = widthObj.getJSONObject("cw");
        }
        if (listColumn instanceof DynamicTextListColumn) {
            DynamicTextListColumn txtListColumn = (DynamicTextListColumn)listColumn;
            ArrayList<KeyValue> items = new ArrayList<KeyValue>(10);
            for (ListFieldMeta listFld : txtListColumn.getListFieldMetas()) {
                KeyValue keyValue = new KeyValue(listFld.getKey(), (Object)"");
                items.add(keyValue);
            }
            return new KeyValue(txtListColumn.getKey(), (Object)new KeyValue("" + txtListColumn.getCaption(), items, new Object[]{ListColumnType.DynamicTextList.getValue()}, Integer.valueOf(txtListColumn.getSeq())), new Object[]{ListColumnType.DynamicTextList.getValue()}, Integer.valueOf(txtListColumn.getSeq()));
        }
        if (listColumn instanceof TemplateTextListColumn) {
            TemplateTextListColumn templateTextColumn = (TemplateTextListColumn)listColumn;
            if (templateTextColumn.getListFieldKey() == null) {
                templateTextColumn.setListFieldKey("templatetext");
            }
            if (templateTextColumn.getCaption() == null) {
                templateTextColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u5f0f\u6587\u672c\u5217", (String)HiesExportRes.ExportByListHeaderWriter_2.resId(), (String)"hrmp-hies-export", (Object[])new Object[0])));
            }
            Object[] extend = new Object[]{templateTextColumn.getColType(), widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(templateTextColumn.getListFieldKey()).replaceAll("_")), templateTextColumn.getTextAlign()};
            return new KeyValue(templateTextColumn.getListFieldKey(), (Object)("" + templateTextColumn.getCaption()), extend, Integer.valueOf(templateTextColumn.getSeq()));
        }
        if (listColumn instanceof VoucherNoListColumn) {
            VoucherNoListColumn voucherNo = (VoucherNoListColumn)listColumn;
            return new KeyValue(voucherNo.getKey(), (Object)("" + voucherNo.getCaption()), new Object[]{ListColumnType.VoucherNo.getValue(), widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(voucherNo.getKey()).replaceAll("_")), voucherNo.getTextAlign()}, Integer.valueOf(voucherNo.getSeq()));
        }
        if (listColumn instanceof DecimalListColumn && ((DecimalListColumn)listColumn).isZeroShow()) {
            zeroShow.add(listColumn.getListFieldKey());
        }
        int colType = listColumn.getColType();
        if (listColumn instanceof ListColumn && (prop = ((ListColumn)listColumn).getSrcFieldProp()) != null && (prop instanceof FieldProp && "number".equals(((FieldProp)prop).getClientType()) || prop instanceof BasedataProp && "number".equals(((BasedataProp)prop).getClientType(listColumn.getListFieldKey())))) {
            colType = 2;
        }
        return new KeyValue(listColumn.getListFieldKey(), (Object)("" + listColumn.getCaption()), new Object[]{colType, widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(listColumn.getListFieldKey()).replaceAll("_")), ExportByListHeaderWriter.getAlign(listColumn)}, Integer.valueOf(listColumn.getSeq()));
    }

    private static String getAlign(IListColumn listColumn) {
        String align = listColumn.getTextAlign();
        if ((StringUtils.isBlank((CharSequence)align) || "default".equalsIgnoreCase(align)) && listColumn instanceof ListColumn) {
            if (((ListColumn)listColumn).getSrcFieldProp() instanceof ComboProp) {
                align = "center";
            } else if (((ListColumn)listColumn).getSrcFieldProp() instanceof DateTimeProp) {
                align = "left";
            } else if (((ListColumn)listColumn).getSrcFieldProp() instanceof DecimalProp) {
                align = "right";
            }
        }
        return align;
    }

    @ExcludeFromJacocoGeneratedReport
    private static int getListColumnGroupSeq(ListColumnGroup groupColumn) {
        List groupColumnItems = groupColumn.getItems();
        if (CollectionUtils.isEmpty((Collection)groupColumnItems)) {
            return Integer.MAX_VALUE;
        }
        Control control = (Control)groupColumnItems.get(0);
        if (control instanceof IListColumn) {
            IListColumn cItem = (IListColumn)control;
            return cItem.getSeq();
        }
        if (control instanceof ListColumnGroup) {
            ListColumnGroup listItem = (ListColumnGroup)control;
            return ExportByListHeaderWriter.getListColumnGroupSeq(listItem);
        }
        return Integer.MAX_VALUE;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<KeyValue> getContainerCaption(EntityType entityType, JSONObject settings, Map<String, Boolean> userConfigColumnSettings, List<Control> items, Set<String> columns, Set<String> zeroShow, boolean hideSeq) {
        ArrayList<KeyValue> itemCaptions = new ArrayList<KeyValue>();
        for (Control c : items) {
            KeyValue caption;
            List<KeyValue> captions;
            if (c instanceof ListOperationColumn) continue;
            if (c instanceof ListColumnGroup) {
                ListColumnGroup groupColumn = (ListColumnGroup)c;
                if (!ExportByListHeaderWriter.isListColumnVisible(entityType, userConfigColumnSettings, (Control)groupColumn) || (captions = ExportByListHeaderWriter.getContainerCaption(entityType, settings, userConfigColumnSettings, groupColumn.getItems(), columns, zeroShow, hideSeq)).isEmpty()) continue;
                int seq = ExportByListHeaderWriter.getListColumnGroupSeq(groupColumn);
                KeyValue groupCaption = new KeyValue(groupColumn.getKey(), (Object)new KeyValue("" + groupColumn.getName(), captions, Integer.valueOf(seq)), new Object[]{ListColumnType.ListColumnGroup.getValue()}, Integer.valueOf(seq));
                itemCaptions.add(groupCaption);
                continue;
            }
            if (c instanceof MergeListColumn) {
                int mLen;
                JSONObject widthObj;
                MergeListColumn mergeColumn = (MergeListColumn)c;
                if (!ExportByListHeaderWriter.isListColumnVisible(entityType, userConfigColumnSettings, (Control)mergeColumn) || !columns.contains(((IListColumn)c).getListFieldKey()) || (captions = ExportByListHeaderWriter.getContainerCaption(entityType, settings, userConfigColumnSettings, mergeColumn.getItems(), null, zeroShow, hideSeq)).isEmpty()) continue;
                JSONObject jSONObject = widthObj = settings == null || mergeColumn.getParent() == null ? null : settings.getJSONObject(mergeColumn.getParent().getKey());
                if (widthObj != null) {
                    widthObj = widthObj.getJSONObject("cw");
                }
                int n = mLen = widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(mergeColumn.getListFieldKey()).replaceAll("_"));
                if (mLen == 0) {
                    for (KeyValue m : captions) {
                        if (!(m.value instanceof String)) continue;
                        mLen += ((String)m.value).length() * 16;
                    }
                }
                KeyValue mergeCaption = new KeyValue(mergeColumn.getListFieldKey(), (Object)new KeyValue("" + mergeColumn.getCaption(), captions, new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, Integer.valueOf(mergeColumn.getSeq())), new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, Integer.valueOf(mergeColumn.getSeq()));
                itemCaptions.add(mergeCaption);
                continue;
            }
            if (!(c instanceof IListColumn)) continue;
            IListColumn listColumn = (IListColumn)c;
            String fieldKey = listColumn.getListFieldKey();
            if (c instanceof DynamicTextListColumn) {
                fieldKey = c.getKey();
            }
            if (columns != null && !columns.contains(fieldKey) || (caption = ExportByListHeaderWriter.buildFieldCaption(entityType, (IListColumn)c, settings, userConfigColumnSettings, zeroShow, hideSeq)) == null) continue;
            itemCaptions.add(caption);
        }
        return itemCaptions;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean isListColumnVisible(EntityType entityType, Map<String, Boolean> userConfigColumnSettings, Control listColumn) {
        Boolean configColumnVisible;
        String listFieldKey = null;
        int visibleValue = 0;
        if (listColumn instanceof IListColumn) {
            listFieldKey = ((IListColumn)listColumn).getListFieldKey();
            if (listFieldKey == null) {
                listFieldKey = listColumn.getKey();
            }
            visibleValue = ((IListColumn)listColumn).getVisible();
        } else if (listColumn instanceof MergeListColumn) {
            listFieldKey = ((MergeListColumn)listColumn).getListFieldKey();
            visibleValue = ((MergeListColumn)listColumn).getVisible();
        } else if (listColumn instanceof ListColumnGroup) {
            listFieldKey = ((ListColumnGroup)listColumn).getKey();
            visibleValue = ((ListColumnGroup)listColumn).getVisible();
        }
        Boolean bl = configColumnVisible = userConfigColumnSettings != null ? userConfigColumnSettings.get(listFieldKey) : null;
        if (configColumnVisible != null) {
            return configColumnVisible;
        }
        boolean listColumnVisible = ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)false, (int)visibleValue);
        if (!listColumnVisible) {
            return false;
        }
        boolean lisColumnHidden = false;
        if (listColumn instanceof IListColumn) {
            lisColumnHidden = ((IListColumn)listColumn).isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof MergeListColumn) {
            lisColumnHidden = ((MergeListColumn)listColumn).isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof ListColumnGroup) {
            // empty if block
        }
        return listColumnVisible && !lisColumnHidden;
    }

    private static boolean isLookup(IFormView view) {
        IListView listView = (IListView)view;
        ListShowParameter listShowParameter = (ListShowParameter)listView.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<Map<String, Object>> getListFieldsControlColumns(IFormView view) {
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)((IListView)view).getBillFormId());
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            return SerializationUtils.fromJsonStringToList((String)setting, Map.class);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Boolean> parseUserConfigColumnSettings(IFormView view) {
        LinkedHashMap<String, Boolean> userConfigColumnSettings = new LinkedHashMap<String, Boolean>();
        for (Map<String, Object> listFieldsControlColumn : ExportByListHeaderWriter.getListFieldsControlColumns(view)) {
            this.parseUserConfigColumnSetting(userConfigColumnSettings, listFieldsControlColumn, view);
        }
        return userConfigColumnSettings;
    }

    @ExcludeFromJacocoGeneratedReport
    private void parseUserConfigColumnSetting(Map<String, Boolean> userConfigColumnSettings, Map<String, Object> listFieldsControlColumn, IFormView view) {
        int visibleValue = Integer.parseInt(listFieldsControlColumn.get("visible").toString());
        userConfigColumnSettings.put(listFieldsControlColumn.get("listFieldKey").toString(), ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)ExportByListHeaderWriter.isLookup(view), (int)visibleValue));
        if (listFieldsControlColumn.containsKey("items") && listFieldsControlColumn.get("items") instanceof List) {
            List items = (List)listFieldsControlColumn.get("items");
            for (Map item : items) {
                this.parseUserConfigColumnSetting(userConfigColumnSettings, item, view);
            }
        }
    }
}

