/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.business.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataByTplContext;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.business.export.GenExportTplHeaderWriter;
import kd.hr.hies.business.impt.GenImportTplHeaderWriter;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.template.ExcelTemplateGenerate;
import kd.hr.impt.business.template.ExportWriterBuilder;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportByTplHeaderWriter {
    private WriteDataByTplContext context;

    public ExportByTplHeaderWriter(WriteDataByTplContext context) {
        this.context = context;
    }

    @ExcludeFromJacocoGeneratedReport
    public void createExcelHeader() {
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        DynamicObject tpl = exportContext.getTpl();
        String tmpltype = tpl.getString("tmpltype");
        SXSSFWorkbook wb = this.context.getWb();
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        ExportWriterBuilder builder = new ExportWriterBuilder();
        HashMap mapParam = Maps.newHashMapWithExpectedSize((int)3);
        mapParam.put("appId", exportContext.getAppId());
        mapParam.put("userPlugins", exportContext.getUserPluginInstances());
        mapParam.put("tmpltype", OprType.EXPORT.getValue());
        mapParam.put("source", OprType.EXPORT.getValue());
        List headerWriterFormats = builder.build(tpl, sysparam, (Map)mapParam);
        BeforeCreateHeaderColumnEventArgs args = new BeforeCreateHeaderColumnEventArgs(exportContext);
        args.setHeaderWriterFormats(headerWriterFormats);
        UserExportPluginEngine.fireUserPluginEvent(this.context.getExportStart(), "beforeCreateHeaderColumn", (AbstractEventArgs)args);
        this.context.setHeaderWriterFormats(headerWriterFormats);
        String entitytype = tpl.getString("entitytype");
        ArrayList<ExportDataWriterFormat> dataWriterFormats = new ArrayList<ExportDataWriterFormat>(headerWriterFormats.size());
        this.context.setDataWriterFormats(dataWriterFormats);
        boolean existMergeCol = false;
        if ("SE".equals(entitytype) || "MESS".equals(entitytype)) {
            WriteDataByTplContext sect;
            int headerOffset = 0;
            String name = this.context instanceof WriteDataBySEContext ? ((WriteDataBySEContext)this.context).getMainEntitySheetName() : ((WriteDataByMESSContext)this.context).getMainEntitySheetName();
            SXSSFSheet sheet = wb.getSheet(name);
            SXSSFSheet dropdownSheet = null;
            if ("IMPT".equalsIgnoreCase(tmpltype)) {
                Object dropdownSheetName = name.replace("-", "");
                dropdownSheetName = MethodUtil.checkSheetRepeatName((String)dropdownSheetName, (String)dropdownSheetName, (int)0, (SXSSFWorkbook)wb) + "DDM";
                dropdownSheetName = HIESUtil.getLegalSheetName((String)dropdownSheetName, (String)tmpltype);
                dropdownSheet = wb.createSheet((String)dropdownSheetName);
            }
            if ("MESS".equals(entitytype) && "IMPT".equalsIgnoreCase(tmpltype)) {
                ExcelTemplateGenerate.dealHasFieldimportdesc((List)headerWriterFormats);
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                if (!this.context.getStyles().isExistMergeCol(format.getEnityName())) continue;
                existMergeCol = true;
                break;
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                ExportDataWriterFormat dataWriterFormat = new ExportDataWriterFormat();
                dataWriterFormat.setEnityName(format.getEnityName());
                dataWriterFormat.setMainEntity(format.isMainEntity());
                dataWriterFormat.setEntryentity(format.isEntryentity());
                headerOffset = "IMPT".equalsIgnoreCase(tmpltype) ? GenImportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (SXSSFSheet)dropdownSheet, (ExportSheetStyle)this.context.getStyles(), (ExportHeaderWriterFormat)format, (int)headerOffset, (DynamicObject)tpl, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol) : GenExportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)this.context.getStyles(), (ExportHeaderWriterFormat)format, (int)headerOffset, (DynamicObject)tpl, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                dataWriterFormats.add(dataWriterFormat);
                String entityDisplayName = "MESS".equals(entitytype) ? format.getDisplayName() : null;
                GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)entityDisplayName, (List)format.getF7BdWriteFormats(), (ExportSheetStyle)this.context.getStyles());
                for (ExportHeaderWriterFormat subEntryWriteFormat : format.getNext()) {
                    GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)entityDisplayName, (List)subEntryWriteFormat.getF7BdWriteFormats(), (ExportSheetStyle)this.context.getStyles());
                }
            }
            if (this.context instanceof WriteDataBySEContext) {
                sect = (WriteDataBySEContext)this.context;
                ((WriteDataBySEContext)sect).setColumCount(headerOffset);
            } else if (this.context instanceof WriteDataByMESSContext) {
                sect = (WriteDataByMESSContext)this.context;
                ((WriteDataByMESSContext)sect).setColumCount(headerOffset);
            }
            if ("IMPT".equalsIgnoreCase(tmpltype)) {
                wb.setSheetHidden(wb.getSheetIndex((Sheet)dropdownSheet), true);
            }
        } else if ("MEMS".equals(entitytype)) {
            WriteDataByMEMSContext sect = (WriteDataByMEMSContext)this.context;
            HashMap sheetColumCountMap = Maps.newHashMapWithExpectedSize((int)sect.getSheetMap().size());
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                int headerOffset = 0;
                if (this.context.getStyles().isExistMergeCol(format.getEnityName())) {
                    existMergeCol = true;
                }
                String displayName = sect.getSheetNameMap().get(format.getEnityName());
                SXSSFSheet sheet = wb.getSheet(sect.getSheetNameMap().get(format.getEnityName()));
                SXSSFSheet dropdownSheet = null;
                if ("IMPT".equalsIgnoreCase(tmpltype)) {
                    String dropdownSheetName = displayName.replace("-", "");
                    dropdownSheetName = MethodUtil.checkSheetRepeatName((String)dropdownSheetName, (String)dropdownSheetName, (int)0, (SXSSFWorkbook)wb) + "DDM";
                    dropdownSheetName = HIESUtil.getLegalSheetName((String)dropdownSheetName, (String)tmpltype);
                    dropdownSheet = wb.createSheet(dropdownSheetName);
                }
                ExportDataWriterFormat dataWriterFormat = new ExportDataWriterFormat();
                dataWriterFormat.setEnityName(format.getEnityName());
                dataWriterFormat.setMainEntity(format.isMainEntity());
                dataWriterFormat.setEntryentity(format.isEntryentity());
                headerOffset = "IMPT".equalsIgnoreCase(tmpltype) ? GenImportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (SXSSFSheet)dropdownSheet, (ExportSheetStyle)this.context.getStyles(), (ExportHeaderWriterFormat)format, (int)headerOffset, (DynamicObject)tpl, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol) : GenExportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)this.context.getStyles(), (ExportHeaderWriterFormat)format, (int)headerOffset, (DynamicObject)tpl, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                dataWriterFormats.add(dataWriterFormat);
                if ("IMPT".equalsIgnoreCase(tmpltype)) {
                    wb.setSheetHidden(wb.getSheetIndex((Sheet)dropdownSheet), true);
                }
                sheetColumCountMap.put(sheet.getSheetName(), headerOffset);
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)format.getDisplayName(), (List)format.getF7BdWriteFormats(), (ExportSheetStyle)this.context.getStyles());
                for (ExportHeaderWriterFormat subEntryWriteFormat : format.getNext()) {
                    GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)format.getDisplayName(), (List)subEntryWriteFormat.getF7BdWriteFormats(), (ExportSheetStyle)this.context.getStyles());
                }
            }
            sect.setSheetColumCountMap(sheetColumCountMap);
        }
        if (ObjectUtils.isEmpty(this.context.getAdminDivisionMap())) {
            this.context.setAdminDivisionMap(this.isNeedAdminDivision(headerWriterFormats));
        }
    }

    private Map<Long, String> isNeedAdminDivision(List<ExportHeaderWriterFormat> headerWriterFormats) {
        Map adminDivisionMap = Maps.newHashMapWithExpectedSize((int)16);
        AtomicBoolean hasAdminDivisionField = new AtomicBoolean(false);
        for (ExportHeaderWriterFormat format : headerWriterFormats) {
            boolean ret0 = this.hasAdminDivisionField(format);
            hasAdminDivisionField.set(ret0);
            if (hasAdminDivisionField.get()) break;
            format.getNext().forEach(child -> {
                boolean ret1 = this.hasAdminDivisionField((ExportHeaderWriterFormat)child);
                hasAdminDivisionField.set(ret1);
            });
        }
        if (hasAdminDivisionField.get()) {
            adminDivisionMap = HIESUtil.getAllAdminDivision();
        }
        return adminDivisionMap;
    }

    private boolean hasAdminDivisionField(ExportHeaderWriterFormat format) {
        AtomicBoolean hasAdminDivisionField = new AtomicBoolean(false);
        format.getProperties().values().forEach(val -> {
            Object prop = val.get("Prop");
            if (prop instanceof AdminDivisionProp) {
                hasAdminDivisionField.set(true);
                return;
            }
        });
        return hasAdminDivisionField.get();
    }
}

