/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.business.DefaultExportPluginService;
import kd.hr.expt.common.plugin.AfterLoadUserPluginEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;

public class UserExportPluginUtil {
    private static final Log logger = LogFactory.getLog(UserExportPluginUtil.class);

    public static List<HRExportPlugin> getHRExportPlugin(String opPlugins, String tplPlugins, List<HRExportPlugin> listPlugins, String extParams, ConcurrentHashMap<String, Object> customParams, List<String> entitys) {
        List<String> defaultPlugins = DefaultExportPluginService.getDefaultPlugins(entitys);
        logger.info("getHRExportPlugin_entitys:{} defaultPlugins:{}", entitys, defaultPlugins);
        List<HRExportPlugin> userPluginInstances = UserExportPluginUtil.initPlugin(HIESUtil.getGlobalPlugins(), defaultPlugins, opPlugins, tplPlugins, listPlugins, HRExportPlugin.class);
        if (CollectionUtils.isNotEmpty(userPluginInstances)) {
            List<HRExportPlugin> copyUserPluginInstances = userPluginInstances.stream().collect(Collectors.toList());
            AfterLoadUserPluginEventArgs args = new AfterLoadUserPluginEventArgs(extParams, customParams);
            args.setUserPlugin(userPluginInstances);
            UserExportPluginEngine.fireUserPluginEvent(copyUserPluginInstances, "afterLoadUserPlugin", (AbstractEventArgs)args);
        }
        MethodUtil.printPlugins(userPluginInstances);
        return userPluginInstances;
    }

    public static List<HRExportPlugin> getListPlugin(List<String> plugins) {
        if (CollectionUtils.isEmpty(plugins)) {
            return null;
        }
        ArrayList<HRExportPlugin> list = new ArrayList<HRExportPlugin>(plugins.size());
        plugins.forEach(classPath -> {
            Object instance = TypesContainer.createInstance((String)classPath);
            if (instance instanceof HRExportPlugin) {
                list.add((HRExportPlugin)instance);
            }
        });
        return list;
    }

    private static <T> List<T> initPlugin(String globalPlugins, List<String> defaultPlugins, String opPlugins, String tplPlugins, List<T> listPlugins, Class<T> cls) {
        JSONArray jsonArray;
        LinkedList userPluginInstances = new LinkedList();
        LinkedList userPluginClassList = new LinkedList();
        if (StringUtils.isNotEmpty((CharSequence)globalPlugins)) {
            jsonArray = JSONObject.parseArray((String)globalPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (CollectionUtils.isNotEmpty(defaultPlugins)) {
            defaultPlugins.forEach(classPath -> UserExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)opPlugins)) {
            Arrays.stream(opPlugins.split(",")).distinct().forEach(classPath -> UserExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (HRCollUtil.isNotEmpty(listPlugins)) {
            listPlugins.forEach(plugin -> {
                String className = plugin.getClass().getCanonicalName();
                if (userPluginClassList.contains(className)) {
                    return;
                }
                userPluginClassList.add(className);
                userPluginInstances.add(plugin);
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)tplPlugins)) {
            jsonArray = JSONObject.parseArray((String)tplPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserExportPluginUtil.setPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        return userPluginInstances;
    }

    private static <T> void setPluginInstance(List<T> userPluginInstances, List<String> userPluginClassList, String classPath, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return;
        }
        if (userPluginClassList.contains(classPath)) {
            return;
        }
        userPluginClassList.add(classPath);
        try {
            Object instance = TypesContainer.createInstance((String)classPath);
            if (cls.getSimpleName().equalsIgnoreCase(HRExportPlugin.class.getSimpleName()) && instance instanceof HRExportPlugin) {
                userPluginInstances.add(instance);
            }
        }
        catch (Throwable ex) {
            logger.error("setPluginInstances {} createInstance error.", (Object)classPath, (Object)ex);
        }
    }
}

