/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.FinishedDataPackage;
import kd.hr.expt.core.ExportQueue;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.util.MethodUtil;

public class ExportWorker
implements Callable<Object> {
    private static Log log = LogFactory.getLog(ExportWorker.class);
    protected String name;
    protected ExportStart exportStart;
    private Thread parentThread;
    protected ExportQueue<BaseExportBillData> inQueue;
    protected ExportQueue<BaseExportBillData> outQueue;
    protected ThreadPool pool;
    protected boolean isEnd = false;
    protected AtomicInteger childThreadMonitor = new AtomicInteger(0);
    protected Semaphore childThreadSemaphore;

    public ExportWorker(String name, ExportStart exportStart, ExportQueue<BaseExportBillData> inQueue, ExportQueue<BaseExportBillData> outQueue, boolean needThreadPool, int workerMaxThread) {
        this.name = name;
        this.exportStart = exportStart;
        this.inQueue = inQueue;
        this.outQueue = outQueue;
        this.parentThread = Thread.currentThread();
        if (needThreadPool) {
            this.pool = ThreadPools.newCachedThreadPool((String)(this.name + RequestContext.get().getTraceId()), (int)1, (int)workerMaxThread);
            this.childThreadSemaphore = new Semaphore(workerMaxThread);
        }
    }

    public ExportWorker(String name, ExportStart exportStart) {
        this.name = name;
        this.exportStart = exportStart;
        this.parentThread = Thread.currentThread();
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public ExportStart getExportStart() {
        return this.exportStart;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public String getName() {
        return this.name;
    }

    public AtomicInteger getChildThreadMonitor() {
        return this.childThreadMonitor;
    }

    public Semaphore getChildThreadSemaphore() {
        return this.childThreadSemaphore;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                List<BaseExportBillData> tempBilldatas = this.getBatchData(1000);
                this.putToOutQueue(tempBilldatas);
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
        this.exportStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        this.end();
        return null;
    }

    protected void end() {
        this.end(MCConfigConstant.getWorkerMaxThread());
    }

    @ExcludeFromJacocoGeneratedReport
    protected void end(int workerMaxThread) {
        this.isEnd = true;
        if (this.childThreadSemaphore != null) {
            try {
                boolean result = this.childThreadSemaphore.tryAcquire(workerMaxThread, 20L, TimeUnit.MINUTES);
                if (!result) {
                    throw new KDException(new ErrorCode("901", "waiteThreadPoolFinished_timeout."), new Object[0]);
                }
                this.childThreadSemaphore.release(workerMaxThread);
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        if (this.outQueue != null) {
            int count = 100;
            this.putToOutQueue(new FinishedDataPackage(), count);
        }
        if (this.pool != null) {
            this.pool.close();
        }
        log.info(this.name.concat("_normally_finished!"));
    }

    public void waiteChildFinished() {
        this.waiteChildFinished(MCConfigConstant.getWorkerMaxThread());
    }

    @ExcludeFromJacocoGeneratedReport
    protected void waiteChildFinished(int workerMaxThread) {
        if (this.childThreadSemaphore != null) {
            try {
                boolean result = this.childThreadSemaphore.tryAcquire(workerMaxThread, 20L, TimeUnit.MINUTES);
                if (!result) {
                    throw new KDException(new ErrorCode("901", "waiteThreadPoolFinished_timeout."), new Object[0]);
                }
                this.childThreadSemaphore.release(workerMaxThread);
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<BaseExportBillData> getBatchData(int size) {
        ArrayList<BaseExportBillData> tempBilldatas = new ArrayList<BaseExportBillData>(size);
        if (this.exportStart.isStoped() || this.isEnd) {
            return tempBilldatas;
        }
        int count = this.inQueue.getQueue().drainTo(tempBilldatas, size);
        if (count == 0) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
            }
            return tempBilldatas;
        }
        if (tempBilldatas.get(tempBilldatas.size() - 1) instanceof FinishedDataPackage) {
            tempBilldatas.remove(tempBilldatas.size() - 1);
            this.isEnd = true;
        }
        return tempBilldatas;
    }

    protected <T extends BaseExportBillData> void putToOutQueue(List<T> dataList) {
        for (BaseExportBillData data : dataList) {
            int count = 100;
            this.putToOutQueue(data, count);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public <T extends BaseExportBillData> void putToOutQueue(T data, int count) {
        try {
            boolean result = this.outQueue.getQueue().offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.exportStart.getMonitor().addQueueStatistics(this.outQueue.getName(), 0, -1);
                if (count < 10) {
                    this.exportStart.getMonitor().addQueueStatistics(this.name + "_timeOut", 1, null);
                }
                if (count < 1) {
                    throw new KDBizException(new ErrorCode("906", this.name + "'s outQueue has full.and no retry times"), new Object[0]);
                }
                if (!this.exportStart.isStoped()) {
                    this.putToOutQueue(data, --count);
                }
            } else {
                this.exportStart.getMonitor().addQueueStatistics(this.outQueue.getName(), 1, this.outQueue.getQueue().size());
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.getExportStart().writeErrorLog(e);
        }
    }

    public <T extends BaseExportBillData> void putToInQueue(List<T> dataList) {
        for (BaseExportBillData data : dataList) {
            this.putToInQueue(data);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected <T extends BaseExportBillData> void putToInQueue(T data) {
        try {
            boolean result = this.inQueue.getQueue().offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.exportStart.getMonitor().addQueueStatistics(this.inQueue.getName(), 0, -1);
                if (!this.exportStart.isStoped()) {
                    this.putToInQueue(data);
                }
            } else {
                this.exportStart.getMonitor().addQueueStatistics(this.inQueue.getName(), 1, this.inQueue.getQueue().size());
            }
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    public synchronized void interruptMainThread() {
        if (!this.exportStart.isMainThreadInterrupt()) {
            if (!this.exportStart.getExportContext().isUserHasTerminator()) {
                this.exportStart.getExportContext().setSysTerminator(true);
            }
            this.getParentThread().interrupt();
            this.exportStart.setMainThreadInterrupt(true);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected void submitWithTimeOut(Callable<Object> task) {
        try {
            long start = System.currentTimeMillis();
            if (!this.childThreadSemaphore.tryAcquire(20L, TimeUnit.MINUTES)) {
                throw new KDException(new ErrorCode("900", "waiteHasFreePoolThread_timeout."), new Object[0]);
            }
            this.exportStart.getMonitor().addExpenseStatistics(this.getName() + "_submitWithTimeOut", (Long)(System.currentTimeMillis() - start), false);
            this.pool.submit(task);
        }
        catch (Throwable e) {
            this.exportStart.writeErrorLog(e);
            this.interruptMainThread();
        }
    }
}

