/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.convert;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.MEMSExportBillData;
import kd.hr.expt.common.dto.MESSExportBillData;
import kd.hr.expt.common.dto.SingleExportBillData;
import kd.hr.expt.common.dto.TplExportConvertData;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataContext;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.core.convert.ConvertDataDispatcher;
import kd.hr.expt.core.convert.ExportTplDataConverter;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.template.ExportTplDataConvertParam;
import org.apache.poi.ss.usermodel.CellStyle;

public class ConvertDataByTplTask
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(ConvertDataByTplTask.class);
    private AtomicInteger childThreadMonitor;
    private WriteDataContext context;
    private List<BaseExportBillData> tempBilldatas;
    private ConvertDataDispatcher dispatcher;

    @ExcludeFromJacocoGeneratedReport
    public ConvertDataByTplTask(List<BaseExportBillData> tempBilldatas, WriteDataContext context, ConvertDataDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.context = context;
        this.tempBilldatas = tempBilldatas;
        this.dispatcher = dispatcher;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void dealEmptyEntry(List<Map<Integer, Map<String, Object>>> tempDatas, ExportSheetStyle styles, ExportDataWriterFormat dataWriterFormat) {
        int mainEntityColSize;
        List entrys = dataWriterFormat.getNext();
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        int colSize = mainEntityColSize = dataWriterFormat.getFields().size();
        String mainEntityName = dataWriterFormat.getMainEntityName();
        HashMap<Integer, HashMap> entryInfoMapping = new HashMap<Integer, HashMap>(8);
        for (ExportDataWriterFormat exportDataWriterFormat : entrys) {
            for (Map.Entry item : exportDataWriterFormat.getFields().entrySet()) {
                String fieldName = (String)item.getKey();
                int index = fieldName.indexOf(46);
                if (index > 0) {
                    fieldName = fieldName.substring(0, index);
                }
                int col = colSize++;
                HashMap map = Maps.newHashMapWithExpectedSize((int)3);
                CellStyle style = styles.getContentTextStyle(mainEntityName, fieldName);
                map.put("key", item.getKey());
                map.put("style", style);
                map.put("val", "");
                map.put("col", col);
                entryInfoMapping.put(col, map);
            }
        }
        for (Map map : tempDatas) {
            for (int i = mainEntityColSize; i < colSize; ++i) {
                Map val = (Map)map.get(i);
                if (val != null) continue;
                map.put(i, entryInfoMapping.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        MethodUtil.syncRequestTraceId((Object)exportContext.getRc());
        log.info("ConvertDataByTplTask_started.");
        try {
            DynamicObject tpl = exportContext.getTpl();
            LinkedList<Map<Integer, Map<String, Object>>> tempDatas = new LinkedList<Map<Integer, Map<String, Object>>>();
            HashMap rowDataPkIds = Maps.newHashMapWithExpectedSize((int)16);
            ExportSheetStyle styles = this.context.getStyles();
            if (this.context instanceof WriteDataBySEContext) {
                WriteDataBySEContext ct = (WriteDataBySEContext)this.context;
                ArrayList objects = new ArrayList(this.tempBilldatas.size());
                HashMap hrVirtualFieldValMap = Maps.newHashMapWithExpectedSize((int)this.tempBilldatas.size());
                this.tempBilldatas.forEach(xx -> {
                    SingleExportBillData billData = (SingleExportBillData)xx;
                    DynamicObject data = billData.getData();
                    objects.add(data);
                    if (!ObjectUtils.isEmpty(exportContext.getTplHRVirtualFields())) {
                        Object personId = ExportUtil.getDynamicObjectHrPersonId(data, exportContext.getHrVirtualFieldRegister());
                        hrVirtualFieldValMap.put(personId, billData.getHrVirtualFieldVal());
                    }
                });
                ExportDataWriterFormat dataWriterFormat = ct.getDataWriterFormats().get(0);
                dataWriterFormat.setMainEntityName(dataWriterFormat.getEnityName());
                ExportTplDataConvertParam param = new ExportTplDataConvertParam(objects.toArray(new DynamicObject[0]), dataWriterFormat, styles, tpl, this.context.getFieldControlRules(), exportContext.getMainEntityType().getMainOrg(), exportContext.isFillParent());
                param.setSensitiveArgs(ct.getSensitiveArgs());
                param.setParentBillColSize(dataWriterFormat.getFields().size());
                param.setEntityData(true);
                param.setHrVirtualFieldRegister(exportContext.getHrVirtualFieldRegister());
                param.setTplHRVirtualFields(exportContext.getTplHRVirtualFieldAliasMap());
                ExportTplDataConverter.convert(param, tempDatas, rowDataPkIds, this.context.getAdminDivisionMap(), hrVirtualFieldValMap);
                ConvertDataByTplTask.dealEmptyEntry(tempDatas, styles, dataWriterFormat);
                TplExportConvertData convertData = new TplExportConvertData();
                convertData.setDataRows(tempDatas);
                convertData.setRowDataPkIds(rowDataPkIds);
                convertData.setBillDataCount(objects.size());
                int retryCount = 100;
                this.dispatcher.putToOutQueue(convertData, retryCount);
            } else if (this.context instanceof WriteDataByMESSContext) {
                WriteDataByMESSContext ct = (WriteDataByMESSContext)this.context;
                int batchBaseIndex = 0;
                for (BaseExportBillData data : this.tempBilldatas) {
                    MESSExportBillData messData = (MESSExportBillData)data;
                    Map existRowDataMap = null;
                    Map parentRowData = null;
                    LinkedList<Map<Integer, Map<String, Object>>> tempDatas2 = new LinkedList<Map<Integer, Map<String, Object>>>();
                    int maxCurrentIndex = 0;
                    for (ExportDataWriterFormat format : ct.getDataWriterFormats()) {
                        DynamicObject[] dynamicObjects = messData.getEntityData().get(format.getEnityName());
                        if (dynamicObjects == null) continue;
                        format.setMainEntityName(format.getEnityName());
                        ExportTplDataConvertParam param = new ExportTplDataConvertParam(dynamicObjects, format, styles, tpl, this.context.getFieldControlRules(), exportContext.getMainEntityType().getMainOrg(), exportContext.isFillParent());
                        if (existRowDataMap != null) {
                            param.setExistRowDataMap(existRowDataMap);
                        }
                        param.setSensitiveArgs(ct.getSensitiveArgs());
                        param.setParentRowData(parentRowData);
                        param.setEntityData(true);
                        param.setBatchBaseIndex(batchBaseIndex);
                        ExportTplDataConverter.convert(param, tempDatas2, rowDataPkIds, this.context.getAdminDivisionMap(), null);
                        if (param.getCurrentIndex() > maxCurrentIndex) {
                            maxCurrentIndex = param.getCurrentIndex();
                        }
                        ConvertDataByTplTask.dealEmptyEntry(tempDatas2, styles, format);
                        existRowDataMap = param.getExistRowDataMap();
                        if (!format.isMainEntity()) continue;
                        parentRowData = (Map)tempDatas2.get(0);
                    }
                    batchBaseIndex += maxCurrentIndex;
                    tempDatas.addAll(tempDatas2);
                }
                TplExportConvertData convertData = new TplExportConvertData();
                convertData.setDataRows(tempDatas);
                convertData.setRowDataPkIds(rowDataPkIds);
                convertData.setBillDataCount(this.tempBilldatas.size());
                int retryCount = 100;
                this.dispatcher.putToOutQueue(convertData, retryCount);
            } else if (this.context instanceof WriteDataByMEMSContext) {
                WriteDataByMEMSContext ct = (WriteDataByMEMSContext)this.context;
                String currentEntityId = "";
                LinkedList<Object> tDatas = new LinkedList<DynamicObject>();
                for (BaseExportBillData data : this.tempBilldatas) {
                    MEMSExportBillData messData = (MEMSExportBillData)data;
                    if (StringUtils.isBlank((CharSequence)currentEntityId)) {
                        currentEntityId = data.getEntityId();
                    }
                    if (StringUtils.isNotBlank((CharSequence)currentEntityId) && !currentEntityId.equals(data.getEntityId())) {
                        this.convertOnece(ct, currentEntityId, tDatas, tpl, this.context.getAdminDivisionMap());
                        currentEntityId = data.getEntityId();
                        tDatas = new LinkedList();
                    }
                    tDatas.add(messData.getData());
                }
                this.convertOnece(ct, currentEntityId, tDatas, tpl, this.context.getAdminDivisionMap());
            }
        }
        catch (Throwable e) {
            log.error("ConvertDataByTplTask_call", e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            if (this.dispatcher.getExportStart().getExportContext().isSerialModel()) {
                this.dispatcher.getSerialModelSemaphore().release();
            }
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(ConvertDataByTplTask.class, (Long)(System.currentTimeMillis() - start), false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private void convertOnece(WriteDataByMEMSContext ct, String currentEntityId, List<DynamicObject> tDatas, DynamicObject tpl, Map<Long, String> adminDivisionMap) throws ParseException {
        ExportDataWriterFormat formatResult = null;
        LinkedList<Map<Integer, Map<String, Object>>> tempDatas = new LinkedList<Map<Integer, Map<String, Object>>>();
        HashMap rowDataPkIds = Maps.newHashMapWithExpectedSize((int)16);
        for (ExportDataWriterFormat format : ct.getDataWriterFormats()) {
            String entityName = format.getEnityName();
            if (!entityName.equalsIgnoreCase(currentEntityId)) continue;
            format.setMainEntityName(entityName);
            formatResult = format;
            break;
        }
        if (formatResult == null) {
            return;
        }
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        String sheetName = ct.getEntitySheetMap().get(currentEntityId);
        ExportTplDataConvertParam param = new ExportTplDataConvertParam(tDatas.toArray(new DynamicObject[0]), formatResult, this.context.getStyles(), tpl, this.context.getFieldControlRules(), exportContext.getMainEntityType().getMainOrg(), exportContext.isFillParent());
        param.setSensitiveArgs(ct.getSensitiveArgs());
        if (formatResult != null) {
            param.setParentBillColSize(formatResult.getFields().size());
        }
        param.setEntityData(true);
        ExportTplDataConverter.convert(param, tempDatas, rowDataPkIds, adminDivisionMap, null);
        if (formatResult != null) {
            ConvertDataByTplTask.dealEmptyEntry(tempDatas, this.context.getStyles(), formatResult);
        }
        TplExportConvertData convertData = new TplExportConvertData();
        convertData.setDataRows(tempDatas);
        convertData.setRowDataPkIds(rowDataPkIds);
        convertData.setEntityId(currentEntityId);
        convertData.setSheetName(sheetName);
        convertData.setBillDataCount(tDatas.size());
        int retryCount = 100;
        this.dispatcher.putToOutQueue(convertData, retryCount);
    }
}

