/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.convert;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListGridView;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.expt.business.template.ExportByListHeaderWriter;
import kd.hr.expt.business.template.ExportByTplHeaderWriter;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ListExportBillData;
import kd.hr.expt.common.dto.WriteDataByListContext;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataByTplContext;
import kd.hr.expt.common.dto.WriteDataCommonInfo;
import kd.hr.expt.common.dto.WriteDataContext;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.convert.ConvertDataByListTask;
import kd.hr.expt.core.convert.ConvertDataByTplTask;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.SensitiveFiledUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ConvertDataDispatcher
extends ExportWorker {
    private static final Log log = LogFactory.getLog(ConvertDataDispatcher.class);
    private Semaphore serialModelSemaphore = new Semaphore(1);
    private WriteDataCommonInfo commonInfo;
    private List<WriteDataContext> contextList = new ArrayList<WriteDataContext>(2);

    public ConvertDataDispatcher(ExportStart exportStart) {
        super(ConvertDataDispatcher.class.getSimpleName(), exportStart, exportStart.getDataQueue(), exportStart.getConvertQueue(), true, MCConfigConstant.getWorkerMaxThread());
    }

    public Semaphore getSerialModelSemaphore() {
        return this.serialModelSemaphore;
    }

    public WriteDataCommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    public List<WriteDataContext> getContextList() {
        return this.contextList;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info("ConvertDataDispatcher_started.");
        ExportContext exportContext = this.exportStart.getExportContext();
        try {
            this.initCommonInfo();
        }
        catch (Throwable e) {
            log.error(e);
            this.exportStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                WriteDataContext currentContext = null;
                for (WriteDataContext ctx : this.contextList) {
                    if (ctx.isHasDataFinished()) continue;
                    currentContext = ctx;
                }
                if ("ByList".equalsIgnoreCase(exportContext.getExportModle())) {
                    WriteDataByListContext listCurrentContext = (WriteDataByListContext)currentContext;
                    List<BaseExportBillData> tempBilldatas = this.getBatchData(1);
                    if (tempBilldatas.size() == 0) continue;
                    ListExportBillData data = (ListExportBillData)tempBilldatas.get(0);
                    if (this.exportStart.getExportContext().isSerialModel()) {
                        this.serialModelSemaphore.acquire();
                    }
                    super.submitWithTimeOut(new ConvertDataByListTask(data, listCurrentContext, this));
                    continue;
                }
                List<BaseExportBillData> tempBilldatas = this.getBatchData(1000);
                if (tempBilldatas.size() == 0) continue;
                if (this.exportStart.getExportContext().isSerialModel()) {
                    this.serialModelSemaphore.acquire();
                }
                super.submitWithTimeOut(new ConvertDataByTplTask(tempBilldatas, currentContext, this));
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
                super.interruptMainThread();
            }
        }
        this.end();
        this.exportStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private void initCommonInfo() throws Exception {
        ExportContext exportContext = this.exportStart.getExportContext();
        this.commonInfo = new WriteDataCommonInfo();
        this.commonInfo.setBillList(exportContext.getBillList());
        this.commonInfo.setView(exportContext.getFormView());
        if (exportContext.getBillList() != null) {
            ListUserOption listUserOption = exportContext.getBillList().getListUserOption();
            if (listUserOption == null) {
                listUserOption = new ListUserOption();
            }
            boolean stripTrailingZeros = !listUserOption.isShowZero();
            this.commonInfo.setStripTrailingZeros(stripTrailingZeros);
            FormatObject format = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            this.commonInfo.setFormat(format);
            ListUserOption providerListUserOption = exportContext.getBillList().getListModel().getProvider().getListUserOption();
            if (providerListUserOption == null) {
                providerListUserOption = new ListUserOption();
            }
            this.commonInfo.setProviderListUserOption(providerListUserOption);
            this.commonInfo.setExistFSeq(exportContext.isExistFSeq());
            this.commonInfo.setExistSeq(exportContext.isExistSeq());
            this.initSensitiveArgs();
        }
        this.intFieldControlRules();
        this.initContextList();
    }

    private void initSensitiveArgs() {
        SensitiveArgs sensitiveArgs = new SensitiveArgs((Object)this);
        AbstractListViewPluginProxy proxy = this.getListPluginProxy();
        if (proxy != null) {
            proxy.fireBeforeDesensitive(sensitiveArgs);
        }
        this.commonInfo.setSensitiveArgs(sensitiveArgs);
    }

    private void intFieldControlRules() {
        ExportContext exportContext = this.exportStart.getExportContext();
        this.commonInfo.setFieldControlRules(SensitiveFiledUtil.getFieldControlRulesByForm((String)exportContext.getAppId(), (String)exportContext.getMainFormId()));
    }

    private void initContextList() throws Exception {
        WriteDataContext ctx = this.createContext(null);
        if ("ByList".equalsIgnoreCase(this.exportStart.getExportContext().getExportModle())) {
            WriteDataByListContext context = (WriteDataByListContext)ctx;
            context.setProviderListUserOption(this.commonInfo.getProviderListUserOption());
            context.setShowSeq(this.commonInfo.isShowSeq());
            context.setExistFSeq(this.commonInfo.isExistFSeq());
            context.setExistSeq(this.commonInfo.isExistSeq());
            if (this.hasColumnGroup()) {
                context.setCurrentWriteRowIndex(1);
            }
        }
        this.contextList.add(ctx);
        WriteDataDispatcher writeDataDispatcher = (WriteDataDispatcher)this.exportStart.getWorkers().get(WriteDataDispatcher.class.getSimpleName());
        writeDataDispatcher.getContextSemaphore().release();
    }

    private AbstractListViewPluginProxy getListPluginProxy() {
        IFormView view = this.exportStart.getExportContext().getFormView();
        if (view instanceof ListView) {
            return (AbstractListViewPluginProxy)view.getService(FormViewPluginProxy.class);
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public WriteDataContext createContext(Integer seq) throws Exception {
        WriteDataByTplContext context;
        String seqStr;
        ExportContext exportContext = this.exportStart.getExportContext();
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        wb.setCompressTempFiles(true);
        String string = seqStr = seq == null ? "" : "(" + seq + ")";
        if ("ByList".equalsIgnoreCase(exportContext.getExportModle())) {
            WriteDataByListContext context2 = new WriteDataByListContext();
            context2.setWb(wb);
            String caption = exportContext.getFormView().getFormShowParameter().getCaption();
            caption = HIESConstant.SpecCharPattern.matcher(caption).replaceAll("");
            context2.setFileName(exportContext.getFileName().concat(seqStr).concat(".xlsx"));
            context2.setSheet(context2.getWb().createSheet(caption));
            context2.setFieldCaptions(this.commonInfo.getFieldCaptions());
            ExportSheetStyle exportSheetStyle = ExcelStyleUtil.getByListExportSheetStyle(null, (SXSSFWorkbook)wb);
            context2.setStyles(exportSheetStyle);
            context2.setSensitiveArgs(this.commonInfo.getSensitiveArgs());
            context2.setFieldControlRules(this.getCommonInfo().getFieldControlRules());
            context2.setExportStart(this.getExportStart());
            context2.setStripTrailingZeros(this.commonInfo.isStripTrailingZeros());
            context2.setFormat(this.commonInfo.getFormat());
            if (this.hasColumnGroup()) {
                context2.setCurrentWriteRowIndex(1);
            }
            context2.setProviderListUserOption(this.commonInfo.getProviderListUserOption());
            context2.setShowSeq(this.commonInfo.isShowSeq());
            context2.setExistFSeq(this.commonInfo.isExistFSeq());
            context2.setExistSeq(this.commonInfo.isExistSeq());
            this.createTpl(context2);
            return context2;
        }
        DynamicObject tplDy = exportContext.getTpl();
        String tmplType = tplDy.getString("tmpltype");
        String mainEnityName = tplDy.getString("entity.name");
        mainEnityName = HIESUtil.getLegalSheetName((String)mainEnityName, (String)tmplType);
        mainEnityName = MethodUtil.checkSheetRepeatName((String)mainEnityName, (String)mainEnityName, (int)0, (SXSSFWorkbook)wb);
        String mainEnityId = tplDy.getString("entity.id");
        String entitytype = tplDy.getString("entitytype");
        DynamicObjectCollection templateEntry = tplDy.getDynamicObjectCollection("tpltreeentryentity");
        HashBasedTable basedataImpttrTable = HashBasedTable.create();
        templateEntry.stream().filter(dy -> StringUtils.isNotEmpty((String)dy.getString("imptattr"))).forEach(dy2 -> {
            String cfr_ignored_0 = (String)basedataImpttrTable.put((Object)dy2.getString("childentity"), (Object)dy2.getString("fieldnumber"), (Object)dy2.getString("imptattr"));
        });
        String localPath = null;
        XSSFWorkbook wb0 = null;
        List localAttachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)exportContext.getTpl().getPkValue(), (String)"attpanelapcustomtpl");
        if (CollectionUtils.isNotEmpty((Collection)localAttachments)) {
            return this.getLocalTplWriteDataContext(exportContext, tplDy, entitytype, (HashBasedTable<String, String, String>)basedataImpttrTable, localAttachments);
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)exportContext.getTpl().getPkValue(), (String)"attpanelapdescsheet");
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            localPath = ImportFileUtil.downloadAttachPanelFileToDisk((String)((String)((Map)attachments.get(0)).get("url")));
            wb0 = new XSSFWorkbook(localPath);
        }
        wb = wb0 != null ? new SXSSFWorkbook(wb0, 5000, true) : wb;
        ExportSheetStyle styles = ExcelStyleUtil.getExportSheetStyle((DynamicObject)exportContext.getTpl(), (SXSSFWorkbook)wb);
        boolean needMerge = styles.isExistMergeCol(mainEnityId);
        switch (entitytype) {
            case "MEMS": {
                context = new WriteDataByMEMSContext();
                context.setWb(wb);
                DynamicObjectCollection entityrelation = exportContext.getTpl().getDynamicObjectCollection("entityrelation");
                HashMap sheetMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
                HashMap sheetNameMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
                HashMap sheetRowIndexMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
                HashMap entitySheetMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
                SXSSFSheet mainSheet = context.getWb().createSheet(mainEnityName);
                sheetMap.put(mainEnityName, mainSheet);
                sheetNameMap.put(mainEnityId, mainEnityName);
                if ("IMPT".equalsIgnoreCase(tmplType)) {
                    sheetRowIndexMap.put(mainEnityName, needMerge ? 6 : 5);
                } else {
                    sheetRowIndexMap.put(mainEnityName, needMerge ? 1 : 0);
                }
                entitySheetMap.put(mainEnityId, mainEnityName);
                for (DynamicObject child : entityrelation) {
                    String childName = child.getString("rentity.name");
                    String childId = child.getString("rentity.id");
                    childName = HIESUtil.getLegalSheetName((String)childName, (String)tmplType);
                    childName = MethodUtil.checkSheetRepeatName((String)childName, (String)childName, (int)0, (SXSSFWorkbook)wb);
                    sheetMap.put(childName, context.getWb().createSheet(childName));
                    sheetNameMap.put(childId, childName);
                    needMerge = styles.isExistMergeCol(childId);
                    if ("IMPT".equalsIgnoreCase(tmplType)) {
                        sheetRowIndexMap.put(childName, needMerge ? 5 : 4);
                    } else {
                        sheetRowIndexMap.put(childName, needMerge ? 1 : 0);
                    }
                    entitySheetMap.put(childId, childName);
                }
                WriteDataByMEMSContext ctmems = (WriteDataByMEMSContext)context;
                ctmems.setEntitySheetMap(entitySheetMap);
                ctmems.setSheetMap(sheetMap);
                ctmems.setSheetNameMap(sheetNameMap);
                ctmems.setSheetCurrentWriteRowIndexMap(sheetRowIndexMap);
                break;
            }
            case "MESS": {
                context = new WriteDataByMESSContext();
                WriteDataByMESSContext ctmess = (WriteDataByMESSContext)context;
                ctmess.setMainEntitySheetName(mainEnityName);
                SXSSFSheet sheet1 = wb.createSheet(mainEnityName);
                ctmess.setSheet(sheet1);
                if ("IMPT".equalsIgnoreCase(tmplType)) {
                    ctmess.setCurrentWriteRowIndex(needMerge ? 6 : 5);
                    break;
                }
                ctmess.setCurrentWriteRowIndex(needMerge ? 1 : 0);
                break;
            }
            default: {
                context = new WriteDataBySEContext();
                WriteDataBySEContext ctse = (WriteDataBySEContext)context;
                context.setWb(wb);
                ctse.setMainEntitySheetName(mainEnityName);
                SXSSFSheet sheet = wb.createSheet(mainEnityName);
                ctse.setSheet(sheet);
                if ("IMPT".equalsIgnoreCase(tmplType)) {
                    ctse.setCurrentWriteRowIndex(needMerge ? 6 : 5);
                    break;
                }
                ctse.setCurrentWriteRowIndex(needMerge ? 1 : 0);
            }
        }
        context.setCusSheetfileLocalPath(localPath);
        context.setWb(wb);
        context.setStyles(styles);
        context.setSensitiveArgs(this.commonInfo.getSensitiveArgs());
        context.setFieldControlRules(this.commonInfo.getFieldControlRules());
        context.setAdminDivisionMap(this.commonInfo.getAdminDivisionMap());
        context.setExportStart(this.getExportStart());
        context.setFileName(exportContext.getFileName().concat(seqStr).concat(".xlsx"));
        this.createTpl(context);
        return context;
    }

    @ExcludeFromJacocoGeneratedReport
    private WriteDataContext getLocalTplWriteDataContext(ExportContext exportContext, DynamicObject tplDy, String entitytype, HashBasedTable<String, String, String> basedataImpttrTable, List<Map<String, Object>> localAttachments) throws IOException {
        WriteDataByTplContext context;
        String localPath = ImportFileUtil.downloadAttachPanelFileToDisk((String)((String)localAttachments.get(0).get("url")));
        XSSFWorkbook wb0 = new XSSFWorkbook(localPath);
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(wb0, 5000, true);
        ExportSheetStyle styles = ExcelStyleUtil.getExportSheetStyle((DynamicObject)exportContext.getTpl(), (SXSSFWorkbook)sxssfWorkbook);
        HashMap sheetMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap sheetStartRowIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityToSheetMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList dataWriterFormats = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection collection = tplDy.getDynamicObjectCollection("entryentity");
        HashMap sheetColumCountMap = Maps.newHashMapWithExpectedSize((int)16);
        String mainEntityNum = "";
        for (int index = 0; index < collection.size(); ++index) {
            String curShhetEntityNum;
            XSSFRow entityRow;
            DynamicObject dy = (DynamicObject)collection.get(index);
            String sheetName = dy.getString("sheetname");
            SXSSFSheet sheet = sxssfWorkbook.getSheet(sheetName);
            XSSFSheet xssfSheet = sheet.getWorkbook().getXSSFWorkbook().getSheet(sheetName);
            sheetMap.put(sheetName, sheet);
            sheetStartRowIndexMap.put(sheetName, dy.getInt("sheetreadrow") - 2);
            HashMap entityRowData = Maps.newHashMap();
            if (index == 0) {
                entityRow = xssfSheet.getRow(1);
                mainEntityNum = curShhetEntityNum = HIESUtil.getSplitValue((String)entityRow.getCell(0).getStringCellValue());
            } else {
                entityRow = xssfSheet.getRow(0);
                curShhetEntityNum = HIESUtil.getSplitValue((String)entityRow.getCell(0).getStringCellValue());
            }
            entityToSheetMap.put(curShhetEntityNum, sheetName);
            Iterator entityIterator = entityRow.cellIterator();
            while (entityIterator.hasNext()) {
                Cell cell = (Cell)entityIterator.next();
                String value2 = HIESUtil.getSplitValue((String)cell.getStringCellValue());
                if (StringUtils.isBlank((String)value2)) continue;
                entityRowData.put(cell.getColumnIndex(), value2);
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)curShhetEntityNum);
            Map allEntities = entityType.getAllEntities();
            XSSFRow fieldRow = xssfSheet.getRow(index == 0 ? 4 : 3);
            sheetColumCountMap.put(sheetName, Integer.valueOf(fieldRow.getLastCellNum()));
            Map<Integer, Set<Integer>> integerSetMap = this.getIntegerSetMap(entityRowData, Integer.valueOf(fieldRow.getLastCellNum()));
            HashMap entryToColNum = new HashMap();
            entityRowData.forEach((key, value) -> {
                String splitValue = HIESUtil.getSplitValue((String)value);
                Set integers = (Set)integerSetMap.get(key);
                if (entryToColNum.get(splitValue) != null) {
                    integers.addAll((Collection)entryToColNum.get(splitValue));
                }
                entryToColNum.put(splitValue, integers);
            });
            ExportDataWriterFormat mainDataWriterFormat = new ExportDataWriterFormat();
            mainDataWriterFormat.setEnityName(curShhetEntityNum);
            mainDataWriterFormat.setMainEntityName(mainEntityNum);
            mainDataWriterFormat.setMainEntity(curShhetEntityNum.equals(mainEntityNum));
            mainDataWriterFormat.setEntryentity(false);
            dataWriterFormats.add(mainDataWriterFormat);
            Iterator cellIterator = fieldRow.cellIterator();
            int colIndex = 0;
            while (cellIterator.hasNext()) {
                String fieldKey;
                String fieldKeyTemp;
                List last;
                Cell cell = (Cell)cellIterator.next();
                Optional<Map.Entry> findFirst = entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(cell.getColumnIndex())).findFirst();
                if (!findFirst.isPresent()) continue;
                String entityKey = (String)findFirst.get().getKey();
                EntityType entityType1 = (EntityType)allEntities.get(entityKey);
                if (entityType1 == null) {
                    MainEntityType entityType2 = MetadataServiceHelper.getDataEntityType((String)entityKey);
                    allEntities.putAll(entityType2.getAllEntities());
                    entityType1 = (EntityType)allEntities.get(entityKey);
                    ExportDataWriterFormat relateDataWriterFormat = new ExportDataWriterFormat();
                    relateDataWriterFormat.setEnityName(entityKey);
                    relateDataWriterFormat.setMainEntityName(mainEntityNum);
                    relateDataWriterFormat.setMainEntity(false);
                    relateDataWriterFormat.setEntryentity(false);
                    dataWriterFormats.add(relateDataWriterFormat);
                }
                if (entityType1 instanceof EntryType && ((last = ((ExportDataWriterFormat)dataWriterFormats.get(dataWriterFormats.size() - 1)).getNext()).size() == 0 || !((ExportDataWriterFormat)last.get(last.size() - 1)).getEnityName().equals(entityKey))) {
                    ExportDataWriterFormat entryDataWriterFormat = new ExportDataWriterFormat();
                    entryDataWriterFormat.setEnityName(entityKey);
                    entryDataWriterFormat.setMainEntityName(mainEntityNum);
                    entryDataWriterFormat.setMainEntity(curShhetEntityNum.equals(mainEntityNum));
                    entryDataWriterFormat.setEntryentity(true);
                    ((ExportDataWriterFormat)dataWriterFormats.get(dataWriterFormats.size() - 1)).getNext().add(entryDataWriterFormat);
                }
                fieldKeyTemp = (fieldKeyTemp = (fieldKey = cell.getStringCellValue()).replace(entityKey + "_", "").replace(entityKey + "\\.", "")).contains(".") ? fieldKeyTemp.split("\\.")[0] : fieldKey;
                DynamicProperty property = entityType1.getProperty(fieldKeyTemp);
                HashMap<String, Object> field = new HashMap<String, Object>(16);
                field.put("Prop", property);
                field.put("ColumnSeq", colIndex);
                if (property instanceof DecimalProp) {
                    field.put("InputType", "decimal");
                } else if (property instanceof TimeProp) {
                    field.put("InputType", "time");
                } else if (property instanceof DateTimeProp) {
                    field.put("InputType", "datetime");
                } else if (property instanceof DateProp) {
                    field.put("InputType", "date");
                } else if (property instanceof BooleanProp) {
                    field.put("InputType", "boolean");
                } else if (property instanceof LargeTextProp) {
                    field.put("InputType", "largetext");
                } else if (property instanceof MuliLangTextProp) {
                    field.put("InputType", "multilang");
                } else if (property instanceof MulComboProp) {
                    field.put("PropType", "MulComboProp");
                    field.put("InputType", "dropdownList");
                } else if (property instanceof MulBasedataProp) {
                    field.put("PropType", "MulBasedataProp");
                    field.put("InputType", "basedata");
                    if (entityType1 instanceof EntryType) {
                        field.put("imptattr", basedataImpttrTable.get((Object)entityType1.getParent().getName(), (Object)property.getName()));
                    } else {
                        field.put("imptattr", basedataImpttrTable.get((Object)entityKey, (Object)property.getName()));
                    }
                } else if (property instanceof BasedataProp) {
                    field.put("PropType", "basedata");
                    field.put("InputType", "basedata");
                    if (entityType1 instanceof EntryType) {
                        field.put("imptattr", basedataImpttrTable.get((Object)entityType1.getParent().getName(), (Object)property.getName()));
                    } else {
                        field.put("imptattr", basedataImpttrTable.get((Object)entityKey, (Object)property.getName()));
                    }
                } else if (fieldKeyTemp.equals("id")) {
                    field.put("InputType", "id");
                } else if (fieldKeyTemp.equals("pid")) {
                    field.put("InputType", "pid");
                } else {
                    field.put("InputType", "varchar");
                }
                ExportDataWriterFormat last2 = (ExportDataWriterFormat)dataWriterFormats.get(dataWriterFormats.size() - 1);
                if (last2.getNext().size() > 0) {
                    ((ExportDataWriterFormat)last2.getNext().get(last2.getNext().size() - 1)).getFields().put(fieldKey, field);
                } else {
                    last2.getFields().put(fieldKey, field);
                }
                ++colIndex;
            }
        }
        switch (entitytype) {
            case "MEMS": {
                WriteDataByTplContext ctmems = context = new WriteDataByMEMSContext();
                ((WriteDataByMEMSContext)ctmems).setEntitySheetMap(entityToSheetMap);
                ((WriteDataByMEMSContext)ctmems).setSheetMap(sheetMap);
                ((WriteDataByMEMSContext)ctmems).setSheetCurrentWriteRowIndexMap(sheetStartRowIndexMap);
                ((WriteDataByMEMSContext)ctmems).setSheetColumCountMap(sheetColumCountMap);
                break;
            }
            case "MESS": {
                context = new WriteDataByMESSContext();
                ((WriteDataByMESSContext)context).setSheet((SXSSFSheet)sheetMap.values().stream().findFirst().get());
                ((WriteDataByMESSContext)context).setCurrentWriteRowIndex((Integer)sheetStartRowIndexMap.values().stream().findFirst().get());
                break;
            }
            default: {
                context = new WriteDataBySEContext();
                ((WriteDataBySEContext)context).setSheet((SXSSFSheet)sheetMap.values().stream().findFirst().get());
                ((WriteDataBySEContext)context).setCurrentWriteRowIndex((Integer)sheetStartRowIndexMap.values().stream().findFirst().get());
            }
        }
        context.setCusSheetfileLocalPath(localPath);
        context.setStyles(styles);
        context.setWb(sxssfWorkbook);
        context.setSensitiveArgs(this.commonInfo.getSensitiveArgs());
        context.setFieldControlRules(this.commonInfo.getFieldControlRules());
        context.setExportStart(this.getExportStart());
        context.setFileName(exportContext.getFileName().concat(".xlsx"));
        context.setDataWriterFormats(dataWriterFormats);
        return context;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<Integer, Set<Integer>> getIntegerSetMap(Map<Integer, String> rowData, Integer totalColCount) {
        HashMap<Integer, Set<Integer>> int2Range = new HashMap<Integer, Set<Integer>>(rowData.size());
        Object[] integers = rowData.keySet().toArray(new Integer[0]);
        Arrays.sort(integers);
        for (int index = 0; index < integers.length; ++index) {
            int end = (Integer)(index + 1 < integers.length ? integers[index + 1] : totalColCount);
            HashSet<Integer> range = new HashSet<Integer>(rowData.size());
            for (int count = ((Integer)integers[index]).intValue(); count < end; ++count) {
                range.add(count);
            }
            int2Range.put((Integer)integers[index], range);
        }
        return int2Range;
    }

    private void createTpl(WriteDataContext context) throws InterruptedException {
        long start1 = System.currentTimeMillis();
        if ("Tpl".equalsIgnoreCase(this.exportStart.getExportContext().getExportModle())) {
            WriteDataByTplContext ccontext = (WriteDataByTplContext)context;
            ExportByTplHeaderWriter writer = new ExportByTplHeaderWriter(ccontext);
            writer.createExcelHeader();
            this.commonInfo.setAdminDivisionMap(ccontext.getAdminDivisionMap());
        } else if ("ByList".equalsIgnoreCase(this.exportStart.getExportContext().getExportModle())) {
            WriteDataByListContext ccontext = (WriteDataByListContext)context;
            ExportByListHeaderWriter headerWriter = new ExportByListHeaderWriter(ccontext);
            headerWriter.createExcelHeader();
            this.commonInfo.setFieldCaptions(ccontext.getFieldCaptions());
            this.commonInfo.setShowSeq(ccontext.isShowSeq());
            this.commonInfo.setZeroShow(ccontext.getZeroShow());
        }
        this.exportStart.getMonitor().addExpenseStatistics("createTpl", (Long)(System.currentTimeMillis() - start1), true);
    }

    private boolean hasColumnGroup() {
        AtomicBoolean has = new AtomicBoolean(false);
        List containers = this.exportStart.getExportContext().getBillList().getItems();
        containers.forEach(control -> {
            if (control.getKey().equals("gridview")) {
                ListGridView gridView = (ListGridView)control;
                gridView.getItems().forEach(item -> {
                    if (item instanceof ListColumnGroup) {
                        has.set(true);
                    }
                });
            }
        });
        log.info("hasColumnGroup_ret=" + has.get());
        return has.get();
    }
}

