/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.convert;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.PriceProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.common.enu.TemplateTypeEnum;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.SensitiveFiledUtil;
import kd.hr.impt.business.template.ExportTplDataConvertParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExportTplDataConverter {
    private static final Log log = LogFactory.getLog(ExportTplDataConverter.class);

    public static void convert(ExportTplDataConvertParam param, List<Map<Integer, Map<String, Object>>> tempDatas, Map<Integer, Map<String, Object>> rowDataPkIds, Map<Long, String> adminDivisionMap, Map<Object, Map<String, Object>> hrVirtualFieldValMap) throws ParseException {
        DynamicObject[] datas = param.getDatas();
        ExportDataWriterFormat dataWriterFormat = param.getDataWriterFormat();
        int colSize = dataWriterFormat.getFields().size();
        String mainEntityName = dataWriterFormat.getMainEntityName();
        ExportSheetStyle styles = param.getStyles();
        DynamicObject templateData = param.getTemplateData();
        String tmpltype = param.getTemplateData().getString("tmpltype");
        HashMap dropdownList = Maps.newHashMapWithExpectedSize((int)10);
        long mainOrgId = 0L;
        for (DynamicObject data : datas) {
            ExportTplDataConverter.addRowDataPkIds(param, rowDataPkIds, data);
            DataEntityPropertyCollection properties = data.getDynamicObjectType().getProperties();
            int newBillStartIndex = 0;
            if (param.getParentRowData() == null) {
                newBillStartIndex = tempDatas.size();
            }
            param.setCurrentIndex(newBillStartIndex + param.getCurrentIndex() + 1);
            Map<Integer, Map<String, Object>> rowData = ExportTplDataConverter.dealChildOrEntryCopy(param, colSize);
            if (StringUtils.isNotEmpty((CharSequence)param.getMainOrg()) && ExportTplDataConverter.containsMainOrg(param.getMainOrg(), data)) {
                mainOrgId = (Long)data.getDynamicObject(param.getMainOrg()).getPkValue();
            }
            FieldControlRule fieldControlRule = SensitiveFiledUtil.getFieldControlRule((long)mainOrgId, (FieldControlRules)param.getFieldControlRules());
            for (Map.Entry next : dataWriterFormat.getFields().entrySet()) {
                Object val;
                Map<String, Object> map;
                String[] split;
                Map value = (Map)next.getValue();
                Object prop = value.get("Prop");
                int col = (Integer)value.get("ColumnSeq");
                String propType = (String)value.get("PropType");
                String inputType = (String)value.get("InputType");
                String baseinfoformat = (String)value.get(TemplateTypeEnum.IMPT.getCode().equalsIgnoreCase(tmpltype) ? "imptattr" : "baseDataFormat");
                String key = (String)next.getKey();
                if ("MulBasedataProp".equalsIgnoreCase(propType) && key.contains(".")) {
                    String[] split2 = StringUtils.split((String)key, (String)".");
                    key = split2[0];
                    if (TemplateTypeEnum.IMPT.getCode().equalsIgnoreCase(tmpltype)) {
                        if ("name".equalsIgnoreCase(split2[1])) {
                            baseinfoformat = "name";
                        } else if ("number".equalsIgnoreCase(split2[1])) {
                            baseinfoformat = "number";
                        }
                    }
                }
                if (dataWriterFormat.isEntryentity() && "id".equalsIgnoreCase(inputType)) {
                    key = "id";
                }
                if (dataWriterFormat.isEntryentity() && "pid".equalsIgnoreCase(inputType)) {
                    key = "pid";
                }
                if (prop instanceof IQueryProp) {
                    key = ExportTplDataConverter.getHrPersonFieldKey(key, prop);
                }
                if (properties.containsKey((Object)(split = key.split("\\."))[0])) {
                    DynamicObject currencyDyn;
                    String controlPropName;
                    Object dataObj = data.get(key);
                    IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)split[0]);
                    if (TemplateTypeEnum.EXPT.getCode().equalsIgnoreCase(tmpltype) && split.length > 1 && iDataEntityProperty instanceof IBasedataField) {
                        String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        iDataEntityProperty = (IDataEntityProperty)dataEntityType.getAllFields().get(split[1]);
                    }
                    if ("dropdownList".equalsIgnoreCase(inputType) && !dropdownList.containsKey(key)) {
                        dropdownList.put(key, ExportTplDataConverter.parseDropdownListVal(data, key));
                    }
                    int relScale = 2;
                    if (prop instanceof PriceProp) {
                        controlPropName = ((DecimalProp)prop).getControlPropName();
                        if (properties.containsKey((Object)controlPropName)) {
                            DynamicObject currencyDyn2 = data.getDynamicObject(controlPropName);
                            if (ObjectUtils.isNotEmpty((Object)currencyDyn2)) {
                                relScale = currencyDyn2.getInt("priceprecision");
                            }
                        } else {
                            relScale = 4;
                        }
                    } else if (prop instanceof AmountProp && properties.containsKey((Object)(controlPropName = ((DecimalProp)prop).getControlPropName())) && ObjectUtils.isNotEmpty((Object)(currencyDyn = data.getDynamicObject(controlPropName)))) {
                        relScale = currencyDyn.getInt("amtprecision");
                    }
                    map = ExportTplDataConverter.formatValue(mainEntityName, key, dataObj, data, inputType, (Integer)value.get("ColumnSeq"), (String)next.getKey(), styles, (Map)dropdownList.get(key), baseinfoformat, tmpltype, iDataEntityProperty, relScale, adminDivisionMap);
                    val = (String)map.get("val");
                    if (!StringUtils.isBlank((CharSequence)val) && param.getSensitiveArgs() != null) {
                        boolean canExport = SensitiveFiledUtil.isCanExport((FieldControlRule)fieldControlRule, (String)key);
                        ListField listField = new ListField(key);
                        listField.setSrcFieldProp((IDataEntityProperty)value.get("Prop"));
                        KeyValue kv = new KeyValue(key, dataObj);
                        val = (String)SensitiveFiledUtil.tryDeSensitiveValue((DynamicObject)data, (KeyValue)kv, (ListField)listField, (Object)val, (boolean)canExport, (SensitiveArgs)param.getSensitiveArgs(), (String)dataWriterFormat.getEnityName());
                        map.put("val", val);
                    }
                } else {
                    Object personId;
                    Map<String, Object> objectMap;
                    map = ExportTplDataConverter.formatValue(mainEntityName, key, null, data, inputType, col, (String)next.getKey(), styles, (Map)dropdownList.get(key), baseinfoformat, tmpltype, null, 0, adminDivisionMap);
                    if (ObjectUtils.isNotEmpty(hrVirtualFieldValMap) && ObjectUtils.isNotEmpty(objectMap = hrVirtualFieldValMap.get(personId = ExportUtil.getDynamicObjectHrPersonId(data, param.getHrVirtualFieldRegister())))) {
                        String aliga = (String)param.getTplHRVirtualFields().get(key);
                        val = objectMap.get(aliga);
                        val = ExportTplDataConverter.getHRVirtualFieldDisplayName(aliga, val);
                        map.put("val", val);
                        map.put("col", col);
                        map.put("key", key);
                    }
                }
                rowData.put(col, map);
            }
            if (!param.getExistRowDataMap().containsKey(param.getCurrentIndex())) {
                tempDatas.add(rowData);
                param.getExistRowDataMap().put(param.getCurrentIndex(), rowData);
            }
            for (ExportDataWriterFormat format : dataWriterFormat.getNext()) {
                DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection(format.getEnityName());
                format.setMainEntityName(mainEntityName);
                ExportTplDataConvertParam param2 = new ExportTplDataConvertParam((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0]), format, styles, templateData, param.getFieldControlRules(), param.getMainOrg(), param.isFillParentDta());
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                    param2.setCurrentIndex(param.getCurrentIndex() - 1);
                }
                param2.setParentRowData(rowData);
                param2.setExistRowDataMap(param.getExistRowDataMap());
                param2.setParentBillColSize(param.getParentBillColSize());
                param2.setLastPkId(param.getLastPkId());
                ExportTplDataConverter.convert(param2, tempDatas, rowDataPkIds, adminDivisionMap, null);
            }
        }
    }

    public static List<ExportDataWriterFormat> filterFillField(List<ExportDataWriterFormat> dataWriterFormats, DynamicObject templateData) {
        DynamicObjectCollection templateEntry = templateData.getDynamicObjectCollection("tpltreeentryentity");
        Map roleIdAndParentsList = templateEntry.stream().collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        String entityNumber = "";
        HashMap needFillFields = Maps.newHashMapWithExpectedSize((int)roleIdAndParentsList.size());
        for (Map.Entry next : roleIdAndParentsList.entrySet()) {
            HashMap fields = Maps.newHashMapWithExpectedSize((int)next.getValue().size());
            for (DynamicObject row : next.getValue()) {
                String attr = row.getString("fieldnumber");
                if (row.get("pid") != null && row.getLong("pid") != 0L && row.getBoolean("isimport") && row.getBoolean("iscondgetdata")) {
                    fields.put(attr, null);
                    continue;
                }
                if (row.get("pid") == null || row.getLong("pid") != 0L) continue;
                entityNumber = attr;
                needFillFields.put(entityNumber, fields);
            }
        }
        for (ExportDataWriterFormat format : dataWriterFormats) {
            Map needFields = (Map)needFillFields.get(format.getEnityName());
            Iterator iterator1 = format.getFields().entrySet().iterator();
            while (iterator1.hasNext()) {
                String prop;
                Map.Entry next = iterator1.next();
                if (needFields.size() == 0) {
                    format.getFields().clear();
                    format.getNext().clear();
                    break;
                }
                if (needFields.containsKey(next.getKey())) continue;
                boolean canRemove = false;
                String type = (String)((Map)next.getValue()).get("InputType");
                if ("multilang".equalsIgnoreCase(type)) {
                    String[] split = ((String)next.getKey()).split("\\.");
                    if (split.length > 1 && !needFields.containsKey(split[0])) {
                        canRemove = true;
                    }
                } else if ("largetext".equalsIgnoreCase(type) && ((String)next.getKey()).endsWith("_tag") && !needFields.containsKey(prop = StringUtils.substringBeforeLast((String)((String)next.getKey()), (String)"_tag"))) {
                    canRemove = true;
                }
                if (!canRemove) continue;
                iterator1.remove();
            }
            ExportTplDataConverter.filterNextFillField(format.getNext(), needFields);
        }
        return dataWriterFormats;
    }

    private static Map<String, String> parseDropdownListVal(DynamicObject data, String fieldKey) {
        String[] split = fieldKey.split("\\.");
        if (split.length == 1) {
            ComboProp comboProp = (ComboProp)data.getDynamicObjectType().getProperty(fieldKey);
            HashMap map = Maps.newHashMapWithExpectedSize((int)comboProp.getComboItems().size());
            for (ValueMapItem item : comboProp.getComboItems()) {
                map.put(item.getValue(), item.getName().toString());
            }
            return map;
        }
        BasedataProp property = (BasedataProp)data.getDynamicObjectType().getProperty(split[0]);
        ComboProp comboProp = (ComboProp)property.getDynamicComplexPropertyType().getProperty(split[1]);
        HashMap map = Maps.newHashMapWithExpectedSize((int)comboProp.getComboItems().size());
        for (ValueMapItem item : comboProp.getComboItems()) {
            map.put(item.getValue(), item.getName().toString());
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void filterNextFillField(List<ExportDataWriterFormat> nextFormats, Map<String, Object> needFields) {
        for (ExportDataWriterFormat format : nextFormats) {
            Iterator iterator1 = format.getFields().entrySet().iterator();
            while (iterator1.hasNext()) {
                String[] split;
                Map.Entry next = iterator1.next();
                if (needFields.containsKey(next.getKey()) || (split = ((String)next.getKey()).split("\\.")).length <= 0 || needFields.containsKey(split[0])) continue;
                iterator1.remove();
            }
            ExportTplDataConverter.filterNextFillField(format.getNext(), needFields);
        }
    }

    private static Map<String, Object> formatValue(String mainEntityName, String fieldName, Object dataObj, DynamicObject data, String inputType, int col, String key, ExportSheetStyle styles, Map<String, String> dropdownList, String baseinfoformat, String tmpltype, IDataEntityProperty iDataEntityProperty, int relScale, Map<Long, String> adminDivisionMap) throws ParseException {
        CellStyle style;
        String val = "";
        int index = fieldName.indexOf(".");
        if (index > 0) {
            fieldName = fieldName.substring(0, index);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if (ObjectUtils.isEmpty((Object)inputType)) {
            log.info("formatValue_inputType is null.mainEntityName:{},fieldName:{},col:{},key:{}", new Object[]{mainEntityName, fieldName, col, key});
        }
        if (dataObj != null && inputType.equals("id") || inputType.equals("pid")) {
            dataObj = String.valueOf(dataObj);
        }
        if (dataObj == null) {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            val = "";
        } else if (dataObj instanceof Boolean) {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            val = Boolean.TRUE.equals(dataObj) ? ResManager.loadKDString((String)"\u662f", (String)"ExportWriterBuilder_13", (String)"hrmp-hies-import", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExportWriterBuilder_14", (String)"hrmp-hies-import", (Object[])new Object[0]);
        } else if (dataObj instanceof Integer || dataObj instanceof Long) {
            if ("time".equals(inputType)) {
                style = styles.getContentDateStyle(mainEntityName, fieldName);
                val = MethodUtil.formatTimeStr((int)((Integer)dataObj));
                if (StringUtils.isNotEmpty((CharSequence)val)) {
                    val = HRDateTimeUtils.format((Date)new SimpleDateFormat("HH:mm:ss").parse(MethodUtil.formatTimeStr((int)((Integer)dataObj))), (String)style.getDataFormatString());
                }
            } else if (iDataEntityProperty instanceof BasedataProp) {
                style = styles.getContentTextStyle(mainEntityName, fieldName);
                val = dataObj.toString();
            } else {
                boolean decimalTooBig;
                FieldProp fieldProp = (FieldProp)iDataEntityProperty;
                String tempval = String.valueOf(dataObj);
                boolean isZero = "0".equals(tempval);
                HashMap dataMap = Maps.newHashMap();
                dataMap.put("isZero", "N");
                style = styles.getContentDecimalStyle(mainEntityName, fieldName, (Map)dataMap);
                boolean zeroShow = fieldProp.isZeroShow();
                if (zeroShow || !"0".equals(tempval)) {
                    val = tempval;
                }
                if (decimalTooBig = ListDataExporter.isDecimalTooBig((String)dataObj.toString())) {
                    String dataFormatString = style.getDataFormatString();
                    if ("General".equals(dataFormatString)) {
                        dataFormatString = "#";
                    }
                    if (dataFormatString.equals("#,##0")) {
                        dataFormatString = "#";
                    }
                    style = styles.getContentTextStyle(mainEntityName, fieldName);
                    val = styles.parseDecimal(dataFormatString, new BigDecimal(val));
                } else {
                    String displayFormatString = styles.getDisplayFormatString(mainEntityName, fieldName);
                    boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
                    if (displayFormatStrExist) {
                        if (!isZero) {
                            val = styles.parseDecimal(displayFormatString, new BigDecimal(val));
                        }
                    } else {
                        map.put("isNumber", "Y");
                    }
                }
            }
        } else if (dataObj instanceof BigDecimal) {
            DecimalProp decimalProp = (DecimalProp)iDataEntityProperty;
            BigDecimal dataVal = (BigDecimal)dataObj;
            boolean isZero = "0".equals(dataVal.stripTrailingZeros().toString());
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("isZero", "N");
            int scale = iDataEntityProperty instanceof AmountProp || iDataEntityProperty instanceof PriceProp ? relScale : decimalProp.getScale();
            dataMap.put("scale", scale);
            String displayFormatString = styles.getDisplayFormatString(mainEntityName, fieldName);
            boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
            style = styles.getContentDecimalStyle(mainEntityName, fieldName, (Map)dataMap);
            boolean zeroShow = decimalProp.isZeroShow();
            if (isZero) {
                if (zeroShow) {
                    val = "0";
                }
                if (!displayFormatStrExist) {
                    map.put("isNumber", "Y");
                }
            } else if (displayFormatStrExist) {
                style = styles.getContentTextStyle(mainEntityName, fieldName);
                int dotInx = displayFormatString.indexOf(".");
                if (dotInx < 0) {
                    displayFormatString = displayFormatString.concat(".00").replaceAll("\\.00", scale > 0 ? String.format(".%0" + scale + "d", 0) : "");
                } else {
                    int length = displayFormatString.length();
                    int scaleCur = length - dotInx - 1;
                    if (scaleCur > scale) {
                        displayFormatString = displayFormatString.substring(0, length - (scaleCur - scale));
                    }
                }
                String parseDecimalVal = styles.parseDecimal(displayFormatString, dataVal);
                if (styles.getNoDisplayScaleZero(mainEntityName, fieldName) && parseDecimalVal.indexOf(".") > 0) {
                    parseDecimalVal = parseDecimalVal.replaceAll("0+?$", "");
                    parseDecimalVal = parseDecimalVal.replaceAll("[.]$", "");
                }
                val = parseDecimalVal;
            } else if (ListDataExporter.isDecimalTooBig((String)dataObj.toString())) {
                String dataFormatString = style.getDataFormatString();
                if (dataFormatString.startsWith("#,##0.")) {
                    dataFormatString = dataFormatString.substring(4);
                }
                style = styles.getContentTextStyle(mainEntityName, fieldName);
                String parseDecimalVal = styles.parseDecimal(dataFormatString, dataVal);
                if (styles.getNoDisplayScaleZero(mainEntityName, fieldName) && parseDecimalVal.indexOf(".") > 0) {
                    parseDecimalVal = parseDecimalVal.replaceAll("0+?$", "");
                    parseDecimalVal = parseDecimalVal.replaceAll("[.]$", "");
                }
                val = parseDecimalVal;
            } else {
                int scaleCur;
                String parseDecimalVal = styles.parseDecimal(style.getDataFormatString(), dataVal);
                dataVal = new BigDecimal(parseDecimalVal.replaceAll(",", ""));
                if (styles.getNoDisplayScaleZero(mainEntityName, fieldName) && (scaleCur = (dataVal = dataVal.stripTrailingZeros()).scale()) < scale) {
                    dataMap.put("scale", scaleCur);
                    style = styles.getContentDecimalStyle(mainEntityName, fieldName, (Map)dataMap);
                }
                map.put("isNumber", "Y");
                val = dataVal.toPlainString();
            }
        } else if (dataObj instanceof Timestamp) {
            String displayFormatString;
            boolean displayFormatStrExist;
            long timestamp = ((Timestamp)dataObj).getTime();
            if (!(iDataEntityProperty instanceof DateProp)) {
                timestamp = HIESUtil.tranExptDateTimeProp((Date)new Date(timestamp), (DateTimeProp)((DateTimeProp)iDataEntityProperty), (DynamicObject)data).getTime();
            }
            if (displayFormatStrExist = StringUtils.isNotBlank((CharSequence)(displayFormatString = styles.getDisplayFormatString(mainEntityName, fieldName)))) {
                style = styles.getContentTextStyle(mainEntityName, fieldName);
                val = HRDateTimeUtils.format((Date)new Date(timestamp), (String)displayFormatString);
            } else {
                style = "date".equals(inputType) ? styles.getContentDateStyle(mainEntityName, fieldName) : ("datetime".equals(inputType) ? styles.getContentDatetimeStyle(mainEntityName, fieldName) : styles.getContentTextStyle(mainEntityName, fieldName));
                val = HRDateTimeUtils.format((Date)new Date(timestamp), (String)style.getDataFormatString());
                String mask = styles.getMask(mainEntityName, fieldName);
                if ("yyyy".equalsIgnoreCase(mask)) {
                    style = styles.getContentDecimalStyle(mainEntityName, fieldName, "#");
                    map.put("isNumber", "Y");
                }
            }
        } else if (dataObj instanceof Date) {
            String displayFormatString = styles.getDisplayFormatString(mainEntityName, fieldName);
            boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
            if (displayFormatStrExist) {
                style = styles.getContentTextStyle(mainEntityName, fieldName);
                val = HRDateTimeUtils.format((Date)((Date)dataObj), (String)displayFormatString);
            } else {
                style = styles.getContentDateStyle(mainEntityName, fieldName);
                val = HRDateTimeUtils.format((Date)((Date)dataObj), (String)style.getDataFormatString());
                String mask = styles.getMask(mainEntityName, fieldName);
                if ("yyyy".equalsIgnoreCase(mask)) {
                    style = styles.getContentDecimalStyle(mainEntityName, fieldName, "#");
                    map.put("isNumber", "Y");
                }
            }
        } else if (dataObj instanceof DynamicObject) {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            DynamicObject dy = (DynamicObject)dataObj;
            if ("basedata".equals(inputType)) {
                val = ExportTplDataConverter.assembleBasedataDisplayName(dy, baseinfoformat, key);
            } else if ("varchar".equals(inputType)) {
                val = dy.getString("billno");
            }
            map.put("id", dy.getPkValue());
        } else if (dataObj instanceof MulBasedataDynamicObjectCollection) {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            MulBasedataDynamicObjectCollection dynamicObjects = (MulBasedataDynamicObjectCollection)dataObj;
            ArrayList<String> temp = new ArrayList<String>(dynamicObjects.size());
            for (DynamicObject dy : dynamicObjects) {
                DynamicObject dynamicObject = (DynamicObject)dy.get(1);
                if (dynamicObject == null) continue;
                if (TemplateTypeEnum.IMPT.getCode().equalsIgnoreCase(tmpltype)) {
                    temp.add(ExportTplDataConverter.assembleBasedataDisplayName(dynamicObject, baseinfoformat, key));
                    continue;
                }
                String[] split = StringUtils.split((String)key, (String)".");
                if (StringUtils.isEmpty((CharSequence)baseinfoformat) && split.length > 1) {
                    String datakey = null;
                    String entityId = dynamicObject.getDataEntityType().getName();
                    if ("hrpi_depempf7query".equalsIgnoreCase(entityId) || "hrpi_employeef7query".equalsIgnoreCase(entityId)) {
                        if ("name".equalsIgnoreCase(split[1])) {
                            datakey = "person.name";
                        } else if ("number".equalsIgnoreCase(split[1])) {
                            datakey = "person.number";
                        }
                    } else {
                        datakey = split[1];
                    }
                    Object dataObj2 = dynamicObject.get(datakey);
                    IDataEntityProperty property = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)entityId).getAllFields().get(datakey);
                    Map<String, Object> result = ExportTplDataConverter.formatValue(mainEntityName, fieldName, dataObj2, data, inputType, col, key, styles, dropdownList, baseinfoformat, tmpltype, property, 0, adminDivisionMap);
                    temp.add((String)result.get("val"));
                    style = (CellStyle)result.get("style");
                    continue;
                }
                temp.add(ExportTplDataConverter.assembleBasedataDisplayName(dynamicObject, baseinfoformat, key));
            }
            val = String.join((CharSequence)",", temp);
        } else if (dataObj instanceof String) {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            String strv = (String)dataObj;
            if ("dropdownList".equalsIgnoreCase(inputType)) {
                String[] split = strv.split(",");
                ArrayList<String> buildList = new ArrayList<String>(split.length);
                for (String va : split) {
                    String vv = dropdownList.get(va);
                    if (!StringUtils.isNotBlank((CharSequence)vv)) continue;
                    buildList.add(vv);
                }
                val = String.join((CharSequence)",", buildList);
            } else if ("largetext".equalsIgnoreCase(inputType)) {
                style = styles.getContentTextStyle(mainEntityName, fieldName.replace("_tag", ""));
                val = dataObj.toString();
            } else if (iDataEntityProperty instanceof AdminDivisionProp) {
                if (StringUtils.isNotBlank((Object)dataObj)) {
                    val = adminDivisionMap.getOrDefault(Long.valueOf(dataObj.toString()), dataObj.toString());
                }
            } else {
                val = dataObj.toString();
            }
        } else {
            style = styles.getContentTextStyle(mainEntityName, fieldName);
            val = dataObj.toString();
        }
        map.put("style", style);
        map.put("val", val);
        map.put("col", col);
        map.put("key", key);
        return map;
    }

    private static String assembleBasedataDisplayName(DynamicObject dy, String baseinfoformat, String key) {
        if (StringUtils.isEmpty((CharSequence)baseinfoformat)) {
            log.info("assembleBasedataDisplayName_key:{},baseinfoformat is null", (Object)key);
        }
        String valtemp = "";
        String nameField = null;
        String numberField = null;
        String entityId = dy.getDataEntityType().getName();
        if ("hrpi_depempf7query".equalsIgnoreCase(entityId) || "hrpi_employeef7query".equalsIgnoreCase(entityId)) {
            if ("name".equalsIgnoreCase(baseinfoformat)) {
                nameField = "person.name";
            } else if ("number".equalsIgnoreCase(baseinfoformat)) {
                numberField = "person.number";
            } else if ("number_name".equalsIgnoreCase(baseinfoformat)) {
                nameField = "person.name";
                numberField = "person.number";
            }
        } else {
            Map bdMainProp = MethodUtil.getBdMainProp((String)entityId);
            nameField = (String)bdMainProp.get("name");
            numberField = (String)bdMainProp.get("number");
        }
        switch (baseinfoformat) {
            case "name": {
                valtemp = dy.getString(nameField);
                break;
            }
            case "number": {
                valtemp = dy.getString(numberField);
                break;
            }
            case "number_name": {
                valtemp = dy.getString(numberField) + "##" + dy.getString(nameField);
                break;
            }
        }
        return valtemp;
    }

    private static boolean containsMainOrg(String mainOrg, DynamicObject row) {
        IDataEntityType dataEntityType = row.getDataEntityType();
        return dataEntityType.getProperties().containsKey((Object)mainOrg) && row.getDynamicObject(mainOrg) != null;
    }

    private static Map<Integer, Map<String, Object>> dealChildOrEntryCopy(ExportTplDataConvertParam param, int colSize) {
        Map rowData = null;
        Map mainEntityRow = (Map)param.getExistRowDataMap().get(param.getCurrentIndex());
        rowData = mainEntityRow != null ? mainEntityRow : Maps.newHashMapWithExpectedSize((int)colSize);
        if (param.isFillParentDta() && param.getParentRowData() != null) {
            Iterator iterator = param.getParentRowData().entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (index < param.getParentBillColSize()) {
                    rowData.put(next.getKey(), next.getValue());
                }
                ++index;
            }
        }
        return rowData;
    }

    @ExcludeFromJacocoGeneratedReport
    private static String getHrPersonFieldKey(String key, Object prop) {
        String baseEntityId = ((IQueryProp)prop).getBaseEntityId();
        if ("hrpi_depempf7query".equalsIgnoreCase(baseEntityId) || "hrpi_employeef7query".equalsIgnoreCase(baseEntityId)) {
            String[] split = key.split("\\.");
            if (split.length != 2) {
                log.error("getHrPersonFieldKey_key=" + key);
                return key;
            }
            if ("name".equalsIgnoreCase(split[1])) {
                key = split[0] + ".person.name";
            } else if ("number".equalsIgnoreCase(split[1])) {
                key = split[0] + ".person.number";
            }
        }
        return key;
    }

    private static void addRowDataPkIds(ExportTplDataConvertParam param, Map<Integer, Map<String, Object>> rowDataPkIds, DynamicObject data) {
        Map entityMap = rowDataPkIds.computeIfAbsent(param.getCurrentIndex() + param.getBatchBaseIndex() + 1, val -> Maps.newHashMapWithExpectedSize((int)6));
        if (param.isEntityData()) {
            entityMap.put(data.getDataEntityType().getName(), data.getPkValue());
            param.setLastPkId(data.getPkValue());
        } else {
            String parentName = data.getDataEntityType().getParent().getName();
            entityMap.put(parentName, param.getLastPkId());
        }
    }

    private static Object getHRVirtualFieldDisplayName(String aliga, Object val) {
        Map keyValue;
        String[] split = StringUtils.split((String)aliga, (String)".");
        if (split.length == 2 && ObjectUtils.isNotEmpty((Object)(keyValue = MethodUtil.getComboKeyValue((String)split[0], (String)split[1])))) {
            return keyValue.get(val);
        }
        return val;
    }
}

