/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.monitor;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.hr.expt.common.dto.BaseExportBillData;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.ExportPerformance;
import kd.hr.expt.common.dto.ExportSampling;
import kd.hr.expt.common.dto.ExportTrace;
import kd.hr.expt.core.ExportQueue;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.convert.ConvertDataDispatcher;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.query.DataFlowSuggester;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.util.MethodUtil;

public class Monitor
extends ExportWorker {
    private static Log log = LogFactory.getLog(Monitor.class);
    private long lastRunTimeStap = System.currentTimeMillis();
    private ReentrantLock expenseLock = new ReentrantLock();
    private ReentrantLock queueLock = new ReentrantLock();
    private ReentrantLock otherLock = new ReentrantLock();
    private ExportPerformance exportPerformance = new ExportPerformance();
    private ExportSampling exportSampling = new ExportSampling();
    private ExportTrace exportTrace = new ExportTrace();

    public Monitor(ExportStart exportStart) {
        super(Monitor.class.getSimpleName(), exportStart);
    }

    public ExportPerformance getExportPerformance() {
        return this.exportPerformance;
    }

    public void setExportPerformance(ExportPerformance exportPerformance) {
        this.exportPerformance = exportPerformance;
    }

    public ExportSampling getExportSampling() {
        return this.exportSampling;
    }

    public void setExportSampling(ExportSampling exportSampling) {
        this.exportSampling = exportSampling;
    }

    public ExportTrace getExportTrace() {
        return this.exportTrace;
    }

    public void setExportTrace(ExportTrace exportTrace) {
        this.exportTrace = exportTrace;
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info("Monitor_started.");
        while (!this.exportStart.isStoped() && !this.isEnd) {
            try {
                ExportWorker exportWorker3;
                ExportWorker exportWorker2;
                TimeUnit.MILLISECONDS.sleep(2000L);
                ExportQueue<BaseExportBillData> dataQueue = this.exportStart.getDataQueue();
                this.addSamplingData(dataQueue.getName(), dataQueue.getQueue().size());
                ExportQueue<BaseExportBillData> convertQueue = this.exportStart.getConvertQueue();
                this.addSamplingData(convertQueue.getName(), convertQueue.getQueue().size());
                ExportWorker exportWorker = this.exportStart.getWorkers().get(QueryDispatcher.class.getSimpleName());
                if (exportWorker != null) {
                    QueryDispatcher queryDispatcher = (QueryDispatcher)exportWorker;
                    DataFlowSuggester suggester = queryDispatcher.getSuggester();
                    this.addSamplingData("suggestBatchSize", suggester.getSuggestBatchSize());
                    this.addSamplingData("suggestThreads", suggester.getSuggestThreads());
                    this.addSamplingData(queryDispatcher.getName() + "_workingThreadCount", queryDispatcher.getChildThreadMonitor().get());
                }
                if ((exportWorker2 = this.exportStart.getWorkers().get(ConvertDataDispatcher.class.getSimpleName())) != null) {
                    ConvertDataDispatcher convertDataDispatcher = (ConvertDataDispatcher)exportWorker2;
                    this.addSamplingData(convertDataDispatcher.getName() + "_workingThreadCount", convertDataDispatcher.getChildThreadMonitor().get());
                }
                if ((exportWorker3 = this.exportStart.getWorkers().get(WriteDataDispatcher.class.getSimpleName())) != null) {
                    WriteDataDispatcher writeDataDispatcher = (WriteDataDispatcher)exportWorker3;
                    this.addSamplingData(writeDataDispatcher.getName() + "_workingThreadCount", writeDataDispatcher.getChildThreadMonitor().get());
                }
                Map samplingCpuMem = MethodUtil.samplingCpuMem();
                this.addSamplingData("memory", samplingCpuMem.get("memory"));
                this.addSamplingData("cpu", samplingCpuMem.get("cpu"));
                if (!"true".equals(MCConfigConstant.isPrintMonitorLog()) || System.currentTimeMillis() - this.lastRunTimeStap <= 30000L) continue;
                TaskService.updateTaskPerformance((Long)this.exportStart.getExportContext().getTaskPkId(), (String)this.getPerformancelog());
                this.lastRunTimeStap = System.currentTimeMillis();
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
            }
        }
        log.info(this.name + "_timeOut_started.");
        Date start = new Date();
        while (!this.isEnd) {
            LinkedList alives = new LinkedList();
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
                Map<String, ExportWorker> workers = this.exportStart.getWorkers();
                workers.values().forEach(worker -> {
                    if (!worker.isEnd() && !this.name.equalsIgnoreCase(worker.getName())) {
                        alives.add(worker);
                    }
                });
                if (System.currentTimeMillis() - start.getTime() <= 600000L) continue;
                alives.forEach(worker -> {
                    worker.setEnd(true);
                    try {
                        MethodUtil.shutdownNowThreadPool((ThreadPool)worker.getPool());
                    }
                    catch (Throwable e) {
                        log.error(e);
                    }
                });
                List names = alives.stream().map(de -> de.getName()).collect(Collectors.toList());
                this.exportTrace.getOther().put("timeOutWorkers", names);
                this.updatePerformancelog();
                this.isEnd = true;
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.end();
        return null;
    }

    public synchronized void computeAverageExpense() {
        for (Map.Entry<String, Integer> next : this.exportPerformance.getTotalExpense().entrySet()) {
            Integer count = this.exportPerformance.getTotalExcuteCount().get(next.getKey());
            if (ObjectUtils.isEmpty((Object)count)) continue;
            int avg = next.getValue() / count;
            this.exportPerformance.getAverageExpense().put(next.getKey(), avg);
        }
    }

    public void addExpenseStatistics(Class obj, Long value, boolean isSingle) {
        String simpleName = obj.getSimpleName();
        this.addExpenseStatistics(simpleName, value, isSingle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpenseStatistics(String key, Long value, boolean isSingle) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.expenseLock.lock();
            ConcurrentHashMap<String, Integer> totalExpense = this.exportPerformance.getTotalExpense();
            Integer oldValue = (Integer)totalExpense.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalExpense.put(key, Math.toIntExact(value));
            } else {
                totalExpense.put(key, Math.toIntExact((long)oldValue.intValue() + value));
            }
            if (isSingle) {
                return;
            }
            this.addMaxExpense(key, value);
            this.addTotalExcuteCount(key);
        }
        finally {
            this.expenseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueStatistics(String key, Integer value, Integer total) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.queueLock.lock();
            ConcurrentHashMap<String, Integer> totalQueueCount = this.exportPerformance.getTotalQueueCount();
            Integer oldValue = (Integer)totalQueueCount.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalQueueCount.put(key, value);
            } else {
                totalQueueCount.put(key, oldValue + value);
            }
            this.addMaxQueueCount(key, total);
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherTotalCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.exportTrace.getOther();
            Integer oldValue = (Integer)other.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                other.put(key, value);
            } else {
                other.put(key, oldValue + value);
            }
        }
        finally {
            this.otherLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherListData(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.exportTrace.getOther();
            List logs = (List)other.computeIfAbsent(key, val -> new LinkedList());
            logs.add(value);
        }
        finally {
            this.otherLock.unlock();
        }
    }

    public void addSamplingData(String key, Object value) {
        Map<String, List<Object>> sampling = this.exportSampling.getSampling();
        List logs = sampling.computeIfAbsent(key, val -> new LinkedList());
        logs.add(value);
    }

    public String getPerformancelog() {
        HashMap jsonMap = Maps.newHashMapWithExpectedSize((int)3);
        jsonMap.put("performance", this.exportStart.getMonitor().getExportPerformance());
        jsonMap.put("trace", this.exportStart.getMonitor().getExportTrace());
        jsonMap.put("sampling", this.exportStart.getMonitor().getExportSampling());
        return JSONObject.toJSONString((Object)jsonMap);
    }

    private void updatePerformancelog() {
        TaskInfo info = new TaskInfo();
        ExportContext importContext = this.exportStart.getExportContext();
        info.setId(importContext.getTaskPkId());
        this.exportStart.getMonitor().computeAverageExpense();
        info.setPerformancelog(this.getPerformancelog());
        info.setSystemerrlog(SerializationUtils.toJsonString(importContext.getExportLog().getErrorLogs()));
        TaskInfoHelper.doUpdate((TaskInfo)info);
    }

    private void addMaxExpense(String key, Long value) {
        ConcurrentHashMap<String, Integer> maxExpense = this.exportPerformance.getMaxExpense();
        Integer oldValue = (Integer)maxExpense.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1L)) {
            maxExpense.put(key, Math.toIntExact(value));
        } else if (value > (long)oldValue.intValue()) {
            maxExpense.put(key, Math.toIntExact(value));
        }
    }

    private void addTotalExcuteCount(String key) {
        ConcurrentHashMap<String, Integer> totalExcuteCount = this.exportPerformance.getTotalExcuteCount();
        Integer count = (Integer)totalExcuteCount.get(key);
        if (ObjectUtils.isEmpty((Object)count)) {
            totalExcuteCount.put(key, 1);
        } else {
            count = count + 1;
            totalExcuteCount.put(key, count);
        }
    }

    private void addMaxQueueCount(String key, Integer value) {
        ConcurrentHashMap<String, Integer> maxQueueCount = this.exportPerformance.getMaxQueueCount();
        Integer oldValue = (Integer)maxQueueCount.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1)) {
            maxQueueCount.put(key, value);
        } else if (!oldValue.equals(-1) && value > oldValue) {
            maxQueueCount.put(key, value);
        }
    }
}

