/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.MEMSExportBillData;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.query.DataLoadByTplTask;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;

public class DataLoadByChildEntityTask
extends DataLoadByTplTask {
    private static Log log = LogFactory.getLog(DataLoadByChildEntityTask.class);
    private AtomicInteger childThreadMonitor;
    private String childEntityId;

    @ExcludeFromJacocoGeneratedReport
    public DataLoadByChildEntityTask(String childEntityId, List<Object> subPkids, QueryDispatcher dispatcher) {
        super(subPkids, dispatcher);
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.childEntityId = childEntityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        log.info(DataLoadByChildEntityTask.class.getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ExportContext exportContext = this.getDispatcher().getExportStart().getExportContext();
        MethodUtil.syncRequestTraceId((Object)exportContext.getRc());
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.childEntityId);
            long start1 = System.currentTimeMillis();
            DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])this.getSubPkids().toArray(), (DynamicObjectType)dataEntityType);
            AfterQueryDataEventArgs args = new AfterQueryDataEventArgs(exportContext);
            args.setDataList(Arrays.asList(datas));
            UserExportPluginEngine.fireUserPluginEvent(this.getDispatcher().getExportStart(), "afterQueryData", (AbstractEventArgs)args);
            long spense = System.currentTimeMillis() - start1;
            this.getDispatcher().getSuggester().addExpenseTimes(spense);
            if (args.getDataList() == null) {
                args.setDataList(new ArrayList<DynamicObject>(0));
            }
            for (DynamicObject data : args.getDataList()) {
                MEMSExportBillData billData = new MEMSExportBillData();
                billData.setData(data);
                billData.setEntityId(this.childEntityId);
                int retryCount = 100;
                this.getDispatcher().putToOutQueue(billData, retryCount);
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.getDispatcher().getExportStart().writeErrorLog(e);
            this.getDispatcher().interruptMainThread();
        }
        finally {
            this.getDispatcher().getExportStart().getMonitor().addExpenseStatistics(DataLoadByChildEntityTask.class, (Long)(System.currentTimeMillis() - start), false);
            if (super.getDispatcher().getExportStart().getExportContext().isSerialModel()) {
                super.getDispatcher().getSerialModelSemaphore().release();
            }
            this.getChildThreadMonitor().getAndDecrement();
            this.childThreadMonitor.getAndDecrement();
            this.getDispatcher().getChildThreadSemaphore().release();
        }
        return null;
    }
}

