/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IBasedataField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.business.HRVirtualFieldService;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.MEMSExportBillData;
import kd.hr.expt.common.dto.MEMSQueryRecord;
import kd.hr.expt.common.dto.MESSExportBillData;
import kd.hr.expt.common.dto.SingleExportBillData;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.core.query.QueryDispatcher;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;

public class DataLoadByTplTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(DataLoadByTplTask.class);
    private List<Object> subPkids;
    private AtomicInteger childThreadMonitor;
    private QueryDispatcher dispatcher;

    public DataLoadByTplTask(List<Object> subPkids, QueryDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.subPkids = subPkids;
        this.dispatcher = dispatcher;
    }

    public List<Object> getSubPkids() {
        return this.subPkids;
    }

    public AtomicInteger getChildThreadMonitor() {
        return this.childThreadMonitor;
    }

    public QueryDispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.dispatcher.getExportStart().getExportContext().getRc());
        log.info("DataLoadByTplTask_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ExportContext exportContext = this.dispatcher.getExportStart().getExportContext();
        DynamicObject tpl = exportContext.getTpl();
        try {
            MainEntityType mainEntityType = exportContext.getMainEntityType();
            long start1 = System.currentTimeMillis();
            Object[] mainDatas = BusinessDataServiceHelper.load((Object[])this.subPkids.toArray(), (DynamicObjectType)mainEntityType);
            AfterQueryDataEventArgs args = new AfterQueryDataEventArgs(exportContext);
            args.setDataList(MethodUtil.arrayToList((Object[])mainDatas));
            HashMap personIdMap = Maps.newHashMapWithExpectedSize((int)mainDatas.length);
            if (!ObjectUtils.isEmpty(exportContext.getTplHRVirtualFields())) {
                args.setHrVirtualFieldValList(this.queryHRVirtualFieldValue((DynamicObject[])mainDatas, personIdMap));
            }
            UserExportPluginEngine.fireUserPluginEvent(this.dispatcher.getExportStart(), "afterQueryData", (AbstractEventArgs)args);
            long spense = System.currentTimeMillis() - start1;
            this.dispatcher.getSuggester().addExpenseTimes(spense);
            String entitytype = tpl.getString("entitytype");
            if ("SE".equalsIgnoreCase(entitytype)) {
                for (DynamicObject data : args.getDataList()) {
                    SingleExportBillData billData = new SingleExportBillData();
                    billData.setData(data);
                    if (!ObjectUtils.isEmpty(args.getHrVirtualFieldValList())) {
                        Object personId = ExportUtil.getDynamicObjectHrPersonId(data, exportContext.getHrVirtualFieldRegister());
                        billData.setHrVirtualFieldVal(args.getHrVirtualFieldValList().get(personIdMap.get(personId)));
                    }
                    billData.setEntityId(mainEntityType.getName());
                    int retryCount = 100;
                    this.dispatcher.putToOutQueue(billData, retryCount);
                }
            } else if ("MESS".equalsIgnoreCase(entitytype)) {
                HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)6);
                Map<String, Map<Object, List<DynamicObject>>> childMap = this.loadChildRelateData(tpl, args.getDataList(), fieldMap);
                for (DynamicObject mainData : args.getDataList()) {
                    HashMap enitytDataMap = Maps.newHashMapWithExpectedSize((int)3);
                    enitytDataMap.put(mainEntityType.getName(), new DynamicObject[]{mainData});
                    for (Map.Entry<String, Map<Object, List<DynamicObject>>> next : childMap.entrySet()) {
                        Object mainVal = mainData.get((String)fieldMap.get(next.getKey()));
                        List<DynamicObject> childVals = next.getValue().get(mainVal);
                        if (!CollectionUtils.isNotEmpty(childVals)) continue;
                        enitytDataMap.put(next.getKey(), childVals.toArray(new DynamicObject[0]));
                    }
                    MESSExportBillData billData = new MESSExportBillData();
                    billData.setEntityData(enitytDataMap);
                    billData.setEntityId(mainEntityType.getName());
                    int retryCount = 100;
                    this.dispatcher.putToOutQueue(billData, retryCount);
                }
            } else if ("MEMS".equalsIgnoreCase(entitytype)) {
                MEMSQueryRecord record = (MEMSQueryRecord)this.dispatcher.getExtObject();
                for (DynamicObject data : args.getDataList()) {
                    if (record != null) {
                        Map<String, Set<Object>> childRelateValus = record.getChildRelateValus();
                        for (Map.Entry<String, String> next : record.getFieldMap().entrySet()) {
                            MEMSQueryRecord mEMSQueryRecord = record;
                            synchronized (mEMSQueryRecord) {
                                String fileds;
                                String[] split;
                                Object val;
                                Set<Object> vals = childRelateValus.get(next.getKey());
                                if (vals == null) {
                                    vals = new HashSet<Object>(16);
                                    childRelateValus.put(next.getKey(), vals);
                                }
                                if ((val = data.get((split = (fileds = record.getFieldMap().get(next.getKey())).split(","))[1])) instanceof ILocaleString) {
                                    ILocaleString tem = (ILocaleString)val;
                                    val = tem.getLocaleValue();
                                }
                                vals.add(val);
                            }
                        }
                    }
                    MEMSExportBillData billData = new MEMSExportBillData();
                    billData.setData(data);
                    billData.setEntityId(mainEntityType.getName());
                    int retryCount = 100;
                    this.dispatcher.putToOutQueue(billData, retryCount);
                }
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(DataLoadByTplTask.class, (Long)(System.currentTimeMillis() - start), false);
            if (this.dispatcher.getExportStart().getExportContext().isSerialModel()) {
                this.dispatcher.getSerialModelSemaphore().release();
            }
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Map<Object, List<DynamicObject>>> loadChildRelateData(DynamicObject tpl, List<DynamicObject> mainDatas, Map<String, String> fieldMap) {
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        HashMap childMap = Maps.newHashMapWithExpectedSize((int)entityrelation.size());
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            String relationleftprop = child.getString("relationleftprop");
            String relationrightprop = child.getString("relationrightprop");
            if (!StringUtils.isNotEmpty((CharSequence)relationleftprop) || !StringUtils.isNotEmpty((CharSequence)relationrightprop)) continue;
            relationleftprop = relationleftprop.substring(relationleftprop.indexOf(46) + 1);
            relationrightprop = relationrightprop.substring(relationrightprop.indexOf(46) + 1);
            fieldMap.put(childId, relationrightprop);
            ArrayList<Object> list = new ArrayList<Object>(mainDatas.size());
            for (DynamicObject data : mainDatas) {
                Object val = data.get(relationrightprop);
                if (val instanceof ILocaleString) {
                    ILocaleString tem = (ILocaleString)val;
                    val = tem.getLocaleValue();
                }
                list.add(val);
            }
            QFilter qFilter = new QFilter(relationleftprop, "in", list);
            List<DynamicObject> childArrs = this.smartLoadChildEntityData(childId, qFilter);
            AfterQueryDataEventArgs args = new AfterQueryDataEventArgs(this.dispatcher.getExportStart().getExportContext());
            args.setDataList(childArrs);
            UserExportPluginEngine.fireUserPluginEvent(this.getDispatcher().getExportStart(), "afterQueryData", (AbstractEventArgs)args);
            if (args.getDataList() == null) {
                args.setDataList(new ArrayList<DynamicObject>(0));
            }
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)args.getDataList().size());
            for (DynamicObject childData : args.getDataList()) {
                Object relationVal = childData.get(relationleftprop);
                LinkedList<DynamicObject> objectList = (LinkedList<DynamicObject>)tempMap.get(relationVal);
                if (CollectionUtils.isEmpty((Collection)objectList)) {
                    objectList = new LinkedList<DynamicObject>();
                    tempMap.put(relationVal, objectList);
                }
                objectList.add(childData);
            }
            childMap.put(childId, tempMap);
        }
        return childMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<DynamicObject> smartLoadChildEntityData(String childEntityId, QFilter qFilter) {
        QFilter dataRuleFilter = DataValidateServiceHelper.getDataRule((String)childEntityId, (String)"47150e89000000ac", null);
        QFilter mainBUFilter = DataValidateServiceHelper.getPermMainBUQFilter((String)childEntityId);
        boolean hasHis = ImportServiceHelper.hasHis((String)childEntityId);
        if (hasHis) {
            qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        List objects = QueryServiceHelper.queryPrimaryKeys((String)childEntityId, (QFilter[])new QFilter[]{qFilter, dataRuleFilter, mainBUFilter}, null, (int)-1);
        log.info("DataLoadByTplTask#smartLoadChildEntityData dataRuleFilter:{} mainBUFilter:{}", (Object)dataRuleFilter, (Object)mainBUFilter);
        int count = objects.size();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(count);
        int startIndex = 0;
        int endIndex = 0;
        while (true) {
            if ((endIndex = startIndex + this.dispatcher.getSuggester().getSuggestBatchSize()) > count) {
                endIndex = count;
            }
            List subPkIds = objects.subList(startIndex, endIndex);
            startIndex = endIndex;
            if (CollectionUtils.isEmpty(subPkIds)) break;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(childEntityId);
            DynamicObject[] dys = helper.loadDynamicObjectArray(subPkIds.toArray());
            list.addAll(Arrays.asList(dys));
        }
        return list;
    }

    private Map<Object, Map<String, Object>> queryHRVirtualFieldValue(DynamicObject[] dys, Map<Object, Object> personIdMap) {
        ExportContext exportContext = this.dispatcher.getExportStart().getExportContext();
        String persionField = "";
        DynamicObjectCollection entryentity = exportContext.getHrVirtualFieldRegister().getDynamicObjectCollection("entryentity");
        for (DynamicObject[] item : entryentity) {
            persionField = item.getString("leftalias");
            String string = item.getString("leftparentalias");
        }
        persionField = StringUtils.substring((String)persionField, (int)0, (int)persionField.lastIndexOf("."));
        HashSet<Object> personIds = new HashSet<Object>(dys.length);
        for (DynamicObject dy : dys) {
            Object id = dy.get(persionField + ".id");
            if (ObjectUtils.isEmpty((Object)id)) continue;
            personIds.add(id);
        }
        String personType = this.findPersonType(exportContext.getHrVirtualFieldRegister(), persionField);
        Map<Object, Object> relateFieldDataByPerson = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((CharSequence)personType) && !ObjectUtils.isEmpty(personIds)) {
            relateFieldDataByPerson = HRVirtualFieldService.findRelateFieldDataByPerson(personIds, personType, this.dispatcher.getHrComplexObjContext(), personIdMap);
        }
        return relateFieldDataByPerson;
    }

    private String findPersonType(DynamicObject registerDy, String persionField) {
        String entityNumber = registerDy.getString("entity.number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String[] splitPerson = StringUtils.split((String)persionField, (String)".");
        IDataEntityProperty property = null;
        if (splitPerson.length == 2) {
            IDataEntityProperty property0 = (IDataEntityProperty)dataEntityType.getAllFields().get(splitPerson[0]);
            String baseEntityId = ((IBasedataField)property0).getBaseEntityId();
            MainEntityType dataEntityType2 = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
            property = (IDataEntityProperty)dataEntityType2.getAllFields().get(splitPerson[1]);
        } else if (splitPerson.length == 1) {
            property = (IDataEntityProperty)dataEntityType.getAllFields().get(persionField);
        }
        if (property == null) {
            return null;
        }
        String baseEntityId = ((IBasedataField)property).getBaseEntityId();
        String personType = null;
        switch (baseEntityId) {
            case "hrpi_employeef7query": {
                personType = "hrpi_employee";
                break;
            }
            case "hrpi_depempf7query": {
                personType = "hrpi_depemp";
                break;
            }
            case "hrpi_personf7query": {
                personType = "hrpi_person";
                break;
            }
        }
        return personType;
    }
}

