/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.query;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.expt.business.HRVirtualFieldService;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.MEMSQueryRecord;
import kd.hr.expt.common.util.ExportUtil;
import kd.hr.expt.core.ExportWorker;
import kd.hr.expt.core.init.ExportStart;
import kd.hr.expt.core.query.DataFlowSuggester;
import kd.hr.expt.core.query.DataLoadByChildEntityTask;
import kd.hr.expt.core.query.DataLoadByListTask;
import kd.hr.expt.core.query.DataLoadByQueryCfgTask;
import kd.hr.expt.core.query.DataLoadByTplTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;

public class QueryDispatcher
extends ExportWorker {
    private static Log log = LogFactory.getLog(QueryDispatcher.class);
    private Semaphore serialModelSemaphore = new Semaphore(1);
    private List<Object> allPkIds;
    private Object extObject;
    private int startIndex = 0;
    private int workerMaxThread;
    private DataFlowSuggester suggester;
    private HRComplexObjContext hrComplexObjContext;

    public Semaphore getSerialModelSemaphore() {
        return this.serialModelSemaphore;
    }

    public Object getExtObject() {
        return this.extObject;
    }

    public void setExtObject(Object extObject) {
        this.extObject = extObject;
    }

    public DataFlowSuggester getSuggester() {
        return this.suggester;
    }

    public void setSuggester(DataFlowSuggester suggester) {
        this.suggester = suggester;
    }

    public HRComplexObjContext getHrComplexObjContext() {
        return this.hrComplexObjContext;
    }

    public QueryDispatcher(ExportStart exportStart, int workerMaxThread) {
        super(QueryDispatcher.class.getSimpleName(), exportStart, null, exportStart.getDataQueue(), true, workerMaxThread);
        this.allPkIds = exportStart.getExportContext().getAllPkIds();
        this.suggester = new DataFlowSuggester(exportStart, workerMaxThread);
        this.workerMaxThread = workerMaxThread;
    }

    @Override
    public Object call() throws Exception {
        String entitytype;
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.exportStart.getExportContext().getRc());
        log.info(QueryDispatcher.class.getSimpleName() + "_started.");
        ExportContext exportContext = this.getExportStart().getExportContext();
        try {
            this.initDataFlowSuggestParam();
            this.initExtObject();
            this.initSelectRowsByFilter();
            if (!ObjectUtils.isEmpty(exportContext.getTplHRVirtualFields())) {
                this.initHRComplexObjContext();
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.getExportStart().writeErrorLog(e);
            super.interruptMainThread();
        }
        this.dispatch();
        super.waiteChildFinished(this.workerMaxThread);
        if ("Tpl".equalsIgnoreCase(this.getExportStart().getExportContext().getExportModle()) && "MEMS".equalsIgnoreCase(entitytype = exportContext.getTpl().getString("entitytype"))) {
            this.dealMemsChildEntity(exportContext);
        }
        this.exportStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        this.end(this.workerMaxThread);
        return null;
    }

    private void initDataFlowSuggestParam() {
        if ("ByList".equalsIgnoreCase(this.getExportStart().getExportContext().getExportModle())) {
            Map<String, Object> byListParam = this.exportStart.getExportContext().getByListParam();
            if ("Select".equalsIgnoreCase(this.exportStart.getExportContext().getExportType())) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)byListParam.get("selectedRows");
                this.suggester.initDataFlowSuggest(selectedRows.size());
            }
        }
        this.suggester.initDataFlowSuggest(this.exportStart.getExportContext().getAllPkIds().size());
    }

    private void initExtObject() {
        ExportContext exportContext = this.getExportStart().getExportContext();
        if ("Tpl".equalsIgnoreCase(exportContext.getExportModle())) {
            DynamicObject tpl = exportContext.getTpl();
            String entitytype = tpl.getString("entitytype");
            if ("MEMS".equalsIgnoreCase(entitytype)) {
                DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
                HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)entityrelation.size());
                for (DynamicObject child : entityrelation) {
                    String childId = child.getString("rentity.id");
                    String relationleftprop = child.getString("relationleftprop");
                    String relationrightprop = child.getString("relationrightprop");
                    if (!StringUtils.isNotEmpty((CharSequence)relationleftprop) || !StringUtils.isNotEmpty((CharSequence)relationrightprop)) continue;
                    relationleftprop = relationleftprop.substring(relationleftprop.indexOf(46) + 1);
                    relationrightprop = relationrightprop.substring(relationrightprop.indexOf(46) + 1);
                    fieldMap.put(childId, relationleftprop + ',' + relationrightprop);
                }
                if (fieldMap.size() > 0) {
                    MEMSQueryRecord memsQueryRecord = new MEMSQueryRecord();
                    memsQueryRecord.setFieldMap(fieldMap);
                    HashMap childRelateValus = Maps.newHashMapWithExpectedSize((int)fieldMap.size());
                    memsQueryRecord.setChildRelateValus(childRelateValus);
                    this.extObject = memsQueryRecord;
                }
            }
        } else if ("ByList".equalsIgnoreCase(exportContext.getExportModle()) && !this.exportStart.getExportContext().isSerialModel()) {
            LinkedBlockingQueue<BillList> queue = new LinkedBlockingQueue<BillList>(this.workerMaxThread);
            queue.add(exportContext.getBillListClone());
            for (int i = 0; i < this.workerMaxThread - 1; ++i) {
                try {
                    BillList clone = ExportUtil.cloneBillList(exportContext.getBillList());
                    queue.add(clone);
                    continue;
                }
                catch (Throwable e) {
                    log.error(e);
                    this.exportStart.writeErrorLog(e);
                }
            }
            this.extObject = queue;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void dispatch() {
        while (!this.exportStart.isStoped() && !this.isEnd) {
            ExportContext exportContext = this.exportStart.getExportContext();
            try {
                int suggestBatchSize = this.suggester.getSuggestBatchSize();
                if ("ByList".equalsIgnoreCase(this.getExportStart().getExportContext().getExportModle())) {
                    int realCount;
                    ListSelectedRowCollection selectedRows;
                    Map<String, Object> byListParam = exportContext.getByListParam();
                    Boolean fts = (Boolean)exportContext.getExtOption().get("isFilterToSelectByList");
                    if ("Select".equalsIgnoreCase(exportContext.getExportType()) || Boolean.TRUE == fts ? this.startIndex >= (selectedRows = (ListSelectedRowCollection)byListParam.get("selectedRows")).size() : this.startIndex >= (realCount = ((Integer)byListParam.get("realCount")).intValue())) break;
                    BillList billList = this.exportStart.getExportContext().getBillListClone();
                    if (this.exportStart.getExportContext().isSerialModel()) {
                        this.serialModelSemaphore.acquire();
                    } else {
                        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.extObject;
                        billList = (BillList)queue.take();
                    }
                    super.submitWithTimeOut(new DataLoadByListTask(this.startIndex, suggestBatchSize, this, billList));
                    this.startIndex += suggestBatchSize;
                } else {
                    int endIndex = this.startIndex + suggestBatchSize;
                    int size = this.allPkIds.size();
                    if (endIndex > size) {
                        endIndex = size;
                        this.isEnd = true;
                    }
                    List<Object> subPkIds = this.allPkIds.subList(this.startIndex, endIndex);
                    String entitytype = this.exportStart.getExportContext().getTpl().getString("entitytype");
                    MEMSQueryRecord memsQueryRecord = (MEMSQueryRecord)this.extObject;
                    if (this.exportStart.getExportContext().isSerialModel()) {
                        this.serialModelSemaphore.acquire();
                    }
                    if (exportContext.getTplQueryEntityType() != null) {
                        super.submitWithTimeOut(new DataLoadByQueryCfgTask(subPkIds, this));
                    } else if (memsQueryRecord != null && memsQueryRecord.isMainEntityHasFinished() && "MEMS".equals(entitytype)) {
                        super.submitWithTimeOut(new DataLoadByChildEntityTask(memsQueryRecord.getCurrentChildEnitytId(), subPkIds, this));
                    } else {
                        super.submitWithTimeOut(new DataLoadByTplTask(subPkIds, this));
                    }
                    this.startIndex = endIndex;
                }
                this.suggester.runDataFlowSuggest();
            }
            catch (Throwable e) {
                log.error(e);
                this.exportStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        this.isEnd = false;
    }

    @ExcludeFromJacocoGeneratedReport
    private void waiteMainEntityQueryFinished() {
        while (this.childThreadMonitor != null && this.childThreadMonitor.get() > 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private void dealMemsChildEntity(ExportContext exportContext) {
        block8: {
            try {
                this.waiteMainEntityQueryFinished();
                if (this.extObject == null) break block8;
                MEMSQueryRecord memsQueryRecord = (MEMSQueryRecord)this.extObject;
                memsQueryRecord.setMainEntityHasFinished(true);
                HashMap entityQueryedCountMap = Maps.newHashMapWithExpectedSize((int)(memsQueryRecord.getChildRelateValus().size() + 1));
                entityQueryedCountMap.put(exportContext.getMainFormId(), this.allPkIds.size());
                for (Map.Entry<String, Set<Object>> next : memsQueryRecord.getChildRelateValus().entrySet()) {
                    String fields = memsQueryRecord.getFieldMap().get(next.getKey());
                    String[] split = fields.split(",");
                    DataSet ds = null;
                    ArrayList<Object> subEntityIds = new ArrayList<Object>();
                    QFilter dataRuleFilter = DataValidateServiceHelper.getDataRule((String)next.getKey(), (String)"47150e89000000ac", null);
                    QFilter mainBUFilter = DataValidateServiceHelper.getPermMainBUQFilter((String)next.getKey());
                    log.info("QueryDispatcher#dealMemsChildEntity dataRuleFilter:{} mainBUFilter:{}", (Object)dataRuleFilter, (Object)mainBUFilter);
                    QFilter qFilter = new QFilter(split[0], "in", next.getValue());
                    boolean hasHis = ImportServiceHelper.hasHis((String)next.getKey());
                    if (hasHis) {
                        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
                    }
                    try {
                        ds = QueryServiceHelper.queryDataSet((String)"dealMemsChildEntity", (String)next.getKey(), (String)"id", (QFilter[])new QFilter[]{qFilter, dataRuleFilter, mainBUFilter}, null);
                        ds.forEach(row -> subEntityIds.add(row.get(0)));
                    }
                    finally {
                        if (ds != null) {
                            ds.close();
                        }
                    }
                    entityQueryedCountMap.put(next.getKey(), subEntityIds.size());
                    this.allPkIds = subEntityIds;
                    exportContext.getTotalBillCount().getAndAdd(this.allPkIds.size());
                    this.startIndex = 0;
                    memsQueryRecord.setCurrentChildEnitytId(next.getKey());
                    this.dispatch();
                }
                this.traceEntityQueryedCount(entityQueryedCountMap, memsQueryRecord.getChildRelateValus());
            }
            catch (Throwable e) {
                log.error(e);
                this.getExportStart().writeErrorLog(e);
                super.interruptMainThread();
            }
        }
    }

    private void initSelectRowsByFilter() {
        ExportContext exportContext = this.exportStart.getExportContext();
        Object fiToSel = exportContext.getExtOption().get("isFilterToSelectByList");
        if ("ByList".equalsIgnoreCase(this.getExportStart().getExportContext().getExportModle()) && "Filter".equalsIgnoreCase(exportContext.getExportType()) && Boolean.TRUE == fiToSel) {
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            List pkFields = exportContext.getBillList().getListModel().getProvider().getPKFields();
            ArrayList conditions = new ArrayList(pkFields.size());
            pkFields.forEach(key -> conditions.add(key.getFieldName()));
            String entityId = exportContext.getMainFormId();
            if (StringUtils.isNotEmpty((CharSequence)exportContext.getQueryEntityId())) {
                entityId = exportContext.getQueryEntityId();
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
            List<Object> allPkIds = this.exportStart.getExportContext().getAllPkIds();
            String maxsize = System.getProperty("orm.opt.in.maxsize", "500000");
            int split = (int)Math.ceil((double)allPkIds.size() / Double.parseDouble(maxsize));
            List subLists = MethodUtil.averageAssign(allPkIds, (int)split);
            if (StringUtils.isEmpty((CharSequence)exportContext.getQueryEntityId())) {
                DynamicObjectCollection collection = new DynamicObjectCollection();
                subLists.forEach(list -> {
                    DynamicObjectCollection cols = helper.queryOriginalCollection(String.join((CharSequence)",", conditions), new QFilter[]{new QFilter("id", "in", list)});
                    collection.addAll((Collection)cols);
                });
                for (DynamicObject dy : collection) {
                    ListSelectedRow row = new ListSelectedRow(dy.get("id"));
                    if (pkFields.size() >= 2) {
                        row.setEntryPrimaryKeyValue(dy.get(((ListField)pkFields.get(1)).getFieldName()));
                    }
                    if (pkFields.size() >= 3) {
                        row.setSubEntryPrimaryKeyValue(dy.get(((ListField)pkFields.get(2)).getFieldName()));
                    }
                    listSelectedRows.add((Object)row);
                }
            } else {
                allPkIds.forEach(id -> {
                    ListSelectedRow row = new ListSelectedRow(id);
                    row.setQueryEntityPrimayKeyValue(id);
                    listSelectedRows.add((Object)row);
                });
            }
            this.exportStart.getExportContext().getByListParam().put("selectedRows", listSelectedRows);
            this.exportStart.getExportContext().getByListParam().remove("realCount");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void traceEntityQueryedCount(Map<String, Integer> entityQueryedCountMap, Map<String, Set<Object>> childRelateValus) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        HashMap childRelateValusMap = Maps.newHashMapWithExpectedSize((int)childRelateValus.size());
        for (Map.Entry<String, Set<Object>> next : childRelateValus.entrySet()) {
            childRelateValusMap.put(next.getKey(), next.getValue().size());
        }
        map.put("childRelateValusCount", childRelateValusMap);
        map.put("entityQueryedCount", entityQueryedCountMap);
        this.exportStart.getMonitor().getExportTrace().getBillCount().put("mems", map);
    }

    private void initHRComplexObjContext() {
        this.hrComplexObjContext = HRVirtualFieldService.getHRComplexObjContext();
    }
}

