/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.core.write;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.dto.ExportContext;
import kd.hr.expt.common.dto.TplExportConvertData;
import kd.hr.expt.common.dto.WriteDataByMEMSContext;
import kd.hr.expt.common.dto.WriteDataByMESSContext;
import kd.hr.expt.common.dto.WriteDataBySEContext;
import kd.hr.expt.common.dto.WriteDataContext;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.core.write.WriteDataDispatcher;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hies.business.excel.SheetStyle;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.template.ExportByTplDataWriter;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExcelWriteByTplTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(ExcelWriteByTplTask.class);
    private AtomicInteger childThreadMonitor;
    private WriteDataContext context;
    private WriteDataDispatcher dispatcher;
    private TplExportConvertData data;

    @ExcludeFromJacocoGeneratedReport
    public ExcelWriteByTplTask(TplExportConvertData data, WriteDataContext context, WriteDataDispatcher dispatcher) {
        this.childThreadMonitor = dispatcher.getChildThreadMonitor();
        this.context = context;
        this.dispatcher = dispatcher;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeFromJacocoGeneratedReport
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        ExportContext exportContext = this.context.getExportStart().getExportContext();
        MethodUtil.syncRequestTraceId((Object)exportContext.getRc());
        log.info("ExcelWriteByListTask_started.");
        try {
            String entitytype;
            BeforeWriteDataEventArgs args = new BeforeWriteDataEventArgs(exportContext);
            args.setSheetStyle((SheetStyle)ReflectUtil.newInstance(SheetStyle.class, (Object[])new Object[]{this.context.getWb()}));
            args.setTplDataRows(this.data.getDataRows());
            args.setRowDataPkIds(this.data.getRowDataPkIds());
            HashMap entityIdStartIndex = Maps.newHashMapWithExpectedSize((int)6);
            entityIdStartIndex.put(this.data.getEntityId(), 0);
            args.setEntityIdStartIndex(entityIdStartIndex);
            UserExportPluginEngine.fireUserPluginEvent(this.context.getExportStart(), "beforeWriteData", (AbstractEventArgs)args);
            switch (entitytype = exportContext.getTpl().getString("entitytype")) {
                case "SE": {
                    WriteDataBySEContext ctse = (WriteDataBySEContext)this.context;
                    ExportByTplDataWriter dataWriter = new ExportByTplDataWriter(ctse.getSheet(), this.data.getDataRows());
                    int rowNumber = dataWriter.write(ctse.getCurrentWriteRowIndex());
                    ctse.setCurrentWriteRowIndex(rowNumber);
                    entityIdStartIndex.put(this.data.getEntityId(), 0);
                    break;
                }
                case "MESS": {
                    WriteDataByMESSContext ctmess = (WriteDataByMESSContext)this.context;
                    ExportByTplDataWriter dataWriter2 = new ExportByTplDataWriter(ctmess.getSheet(), this.data.getDataRows());
                    int rowNumber2 = dataWriter2.write(ctmess.getCurrentWriteRowIndex());
                    ctmess.setCurrentWriteRowIndex(rowNumber2);
                    break;
                }
                case "MEMS": {
                    WriteDataByMEMSContext ct = (WriteDataByMEMSContext)this.context;
                    SXSSFSheet sheet = ct.getSheetMap().get(this.data.getSheetName());
                    ExportByTplDataWriter dataWriter3 = new ExportByTplDataWriter(sheet, this.data.getDataRows());
                    Integer rowNumber3 = ct.getSheetCurrentWriteRowIndexMap().get(this.data.getSheetName());
                    rowNumber3 = dataWriter3.write(rowNumber3.intValue());
                    ct.getSheetCurrentWriteRowIndexMap().put(this.data.getSheetName(), rowNumber3);
                    entityIdStartIndex.put(this.data.getEntityId(), 0);
                }
            }
            exportContext.getFinishedBillCount().getAndAdd(this.data.getBillDataCount());
        }
        catch (Throwable e) {
            log.error("ExcelWriteByListTask_call", e);
            this.dispatcher.getExportStart().writeErrorLog(e);
            this.dispatcher.interruptMainThread();
        }
        finally {
            this.dispatcher.getExportStart().getMonitor().addExpenseStatistics(ExcelWriteByTplTask.class, (Long)(System.currentTimeMillis() - start), false);
            this.context.getSemaphore().release();
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }
}

