/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.expt.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.expt.common.plugin.UserExportPluginEngine;
import kd.hr.expt.common.util.UserExportPluginUtil;
import kd.hr.expt.core.init.ExportTaskDispatcher;
import kd.hr.expt.mservice.api.IExportService;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.dto.Result;

public class ExportServiceImpl
implements IExportService {
    private static Log log = LogFactory.getLog(ExportServiceImpl.class);

    @Override
    public Result submitNewTask(Map<String, Object> params) {
        Result result = new Result();
        try {
            result = ExportTaskDispatcher.getInstance().receivedNewTask(params);
            return result;
        }
        catch (Throwable e) {
            log.error(e);
            result.setSuccess(false);
            result.setMsg(e.getMessage());
            result.setCode("999");
            return result;
        }
    }

    @Override
    public Result recoveryTask(Long taskPkid) {
        return ExportTaskDispatcher.getInstance().recoveryTask(taskPkid);
    }

    @Override
    public Result runConfirmPlugin(Map<String, Object> mapParam) {
        Result result = new Result();
        result.setSuccess(true);
        try {
            String pageId = (String)mapParam.get("pageId");
            String opPlugins = (String)mapParam.get("opPlugins");
            String listPlugins = (String)mapParam.get("listPlugins");
            String[] splitPl = new String[]{};
            String formId = (String)mapParam.get("formId");
            if (StringUtils.isNotBlank((CharSequence)listPlugins)) {
                splitPl = StringUtils.split((String)listPlugins, (String)",");
            }
            List<HRExportPlugin> hrExportPlugins = UserExportPluginUtil.getHRExportPlugin(opPlugins, null, UserExportPluginUtil.getListPlugin(Arrays.asList(splitPl)), null, null, Collections.singletonList(formId));
            BeforeShowConfirmMessageEventArgs args = new BeforeShowConfirmMessageEventArgs(null);
            args.setEntityNameDesc((String)mapParam.get("displayName"));
            args.setTips((String)mapParam.get("content"));
            args.setPageId(pageId);
            UserExportPluginEngine.fireUserPluginEvent(hrExportPlugins, "beforeShowConfirmMessage", (AbstractEventArgs)args);
            HashMap data = Maps.newHashMapWithExpectedSize((int)2);
            data.put("content", args.getTips());
            data.put("displayName", args.getEntityNameDesc());
            data.put("extParam", args.getExtParams());
            data.put("formId", args.getFormId());
            data.put("queryEntityId", args.getQueryEntityId());
            result.setData((Object)data);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.setSuccess(false);
            result.setCode("999");
            result.setMsg(e.getMessage());
        }
        return result;
    }
}

