/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.hr.expt.business.ExportCallBack;
import kd.hr.expt.business.ExportTaskClick;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.enu.EntityType;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportTaskClick;
import kd.sdk.annotation.SdkService;
import org.apache.commons.collections4.MapUtils;

@SdkService(name="HR\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1\u57fa\u7840SDK\u670d\u52a1")
public class HRImExptTaskServiceHelper {
    public static boolean terminatorTask(String taskId, String type) {
        return TaskService.terminatorTask((String)taskId, (String)type);
    }

    public static boolean isTaskStoped(String taskId, String type) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String status = (String)cache.get(MethodUtil.getTaskCachePath((String)String.valueOf(taskId), (String)type, (String)"status"), String.class);
        return "stop".equals(status);
    }

    public static boolean createBallTask(String taskId, String type, String filename, IFormView view) {
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            String key = MethodUtil.getTaskCachePath((String)taskId, (String)type, (String)"ball");
            IHRAppCache appCache = HRAppCache.get((String)"hies");
            TaskInfo taskInfo = (TaskInfo)appCache.get(key, TaskInfo.class);
            IHRAppCache cache = HRAppCache.get((String)"hies");
            Map result = (Map)cache.get(MethodUtil.getTaskCachePath((String)taskId, (String)type, (String)"result"), Map.class);
            if (taskInfo == null && result == null) {
                if ("import".equalsIgnoreCase(type)) {
                    IEGlobalTaskUtil.createNewGlobalTask((String)type, (IFormView)view, (String)taskId, (String)filename, (String)ImportTaskClick.class.getName(), null);
                } else if ("export".equalsIgnoreCase(type)) {
                    IEGlobalTaskUtil.createNewGlobalTask((String)type, (IFormView)view, (String)taskId, (String)filename, (String)ExportTaskClick.class.getName(), (String)ExportCallBack.class.getName());
                }
                return true;
            }
        }
        return false;
    }

    public static void feedbackProgress(String taskId, int progress, String type) {
        String key = MethodUtil.getTaskCachePath((String)taskId, (String)type, (String)"processing");
        IHRAppCache appCache = HRAppCache.get((String)"hies");
        HashMap customData = Maps.newHashMapWithExpectedSize((int)6);
        customData.put("progress", progress);
        appCache.put(key, (Object)customData);
        IEGlobalTaskUtil.feedbackProgress((String)taskId, (int)progress, (String)type);
    }

    public static long createTask(Map<String, Object> params) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setEntityid(MapUtils.getString(params, (Object)"formId"));
        taskInfo.setAppid(MapUtils.getString(params, (Object)"appId"));
        taskInfo.setServiceAppId(MapUtils.getString(params, (Object)"serviceAppId"));
        taskInfo.setOprtype(OprType.tranEnum((String)MapUtils.getString(params, (Object)"oprType")));
        taskInfo.setOprcategory(OprCategory.tranEnum((String)MapUtils.getString(params, (Object)"oprCategory")));
        taskInfo.setEntitytype(EntityType.tranEnum((String)MapUtils.getString(params, (Object)"entityType")));
        taskInfo.setUploadfileurl(MapUtils.getString(params, (Object)"uploadFileUrl"));
        taskInfo.setStime(new Date(MapUtils.getLong(params, (Object)"startTime")));
        taskInfo.setFilesize(MapUtils.getLong(params, (Object)"fileSize"));
        taskInfo.setExtparam(MapUtils.getString(params, (Object)"extParam"));
        taskInfo.setReqparam(JSONObject.toJSONString(params));
        taskInfo.setStatus(TaskState.AFOOT);
        taskInfo.setPerformancelog(RequestContext.get().getTraceId());
        long id = RequestContext.get().getCurrUserId();
        Date now = new Date();
        taskInfo.setCreator(Long.valueOf(id));
        taskInfo.setCreatetime(now);
        taskInfo.setModifier(Long.valueOf(id));
        taskInfo.setModifytime(now);
        return TaskInfoHelper.doInsert((TaskInfo)taskInfo);
    }

    public static boolean updateFileUrl(Long taskPkid, String alldatafileurl, String errdatafileurl, String systemErrLog) {
        HRAssert.notNull((Object)taskPkid, (String)"taskPkid must not be null", (Object[])new Object[0]);
        HRAssert.isFalse((StringUtils.isBlank((CharSequence)alldatafileurl) && StringUtils.isBlank((CharSequence)errdatafileurl) ? 1 : 0) != 0, (String)"alldatafileurl and errdatafileurl cannot be empty at the same time", (Object[])new Object[0]);
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        if (StringUtils.isNotBlank((CharSequence)alldatafileurl)) {
            info.setAlldatafileurl(alldatafileurl);
        }
        if (StringUtils.isNotBlank((CharSequence)errdatafileurl)) {
            info.setErrdatafileurl(errdatafileurl);
        }
        if (StringUtils.isNotBlank((CharSequence)systemErrLog)) {
            info.setSystemerrlog(systemErrLog);
        }
        return TaskInfoHelper.doUpdate((TaskInfo)info);
    }

    public static boolean dealTaskResult(Long taskPkid, Map<String, Object> params, boolean isTerminator) {
        String systemErrLog;
        HRAssert.notNull((Object)taskPkid, (String)"taskPkid must not be null", (Object[])new Object[0]);
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setTotalamount(MapUtils.getInteger(params, (Object)"totalAmount"));
        info.setSucamount(MapUtils.getInteger(params, (Object)"sucAmount"));
        info.setFailamount(Integer.valueOf(info.getTotalamount() - info.getSucamount()));
        Long startTime = MapUtils.getLong(params, (Object)"startTime");
        Long endTime = MapUtils.getLong(params, (Object)"endTime");
        info.setEtime(new Date(endTime));
        info.setTotalcost(Integer.valueOf((int)(endTime - startTime)));
        info.setProgress(Integer.valueOf(100));
        String downloadFileUrl = MapUtils.getString(params, (Object)"downloadFileUrl");
        if (StringUtils.isNotBlank((CharSequence)downloadFileUrl)) {
            info.setDownloadfileurl(downloadFileUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(systemErrLog = MapUtils.getString(params, (Object)"systemErrLog")))) {
            info.setSystemerrlog(systemErrLog);
        }
        if (isTerminator) {
            info.setStatus(TaskState.TERMINATED);
            info.setInttime(new Date());
        } else {
            info.setStatus(TaskState.FINISHED);
            if (info.getFailamount() == 0) {
                info.setResult(TaskResult.SUCCESS);
            } else {
                info.setResult(TaskResult.FAIL);
            }
        }
        return TaskInfoHelper.doUpdate((TaskInfo)info);
    }
}

